/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.util;

import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.util.ProcessPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class ToolRun
extends AppFrame {
    private String windowTitle;
    private ProcessPanel processPanel;
    private JButton killButton;
    private JButton saveButton;
    private JButton okButton;
    private JMenuItem killMenuItem;
    private JMenuItem saveMenuItem;
    private static final int TIMER_INTERVAL = 200;
    private Timer checkTimer;

    public ToolRun(String string, ArrayList<String> arrayList) {
        super("Run " + string);
        this.windowTitle = "Run " + string;
        this.processPanel = new ProcessPanel(string, arrayList, null, null);
        this.killButton = new JButton("Cancel");
        this.killButton.setFocusable(false);
        this.killButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolRun.this.doCancel();
            }
        });
        this.saveButton = new JButton("Save Output");
        this.saveButton.setFocusable(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolRun.this.doSaveOutput();
            }
        });
        this.saveButton.setEnabled(false);
        this.okButton = new JButton("Close");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolRun.this.doOK();
            }
        });
        this.okButton.setEnabled(false);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.killButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.saveButton);
        jPanel2.add(this.okButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.processPanel, "Center");
        container.add((Component)jPanel3, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        Dimension dimension = new Dimension(600, 400);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.fileMenu.removeAll();
        this.killMenuItem = new JMenuItem("Cancel");
        this.killMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolRun.this.doCancel();
            }
        });
        this.fileMenu.add(this.killMenuItem);
        this.fileMenu.addSeparator();
        this.saveMenuItem = new JMenuItem("Save Output...");
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, AppManager.MENU_SHORTCUT_KEY_MASK));
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolRun.this.doSaveOutput();
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.updateControls();
        this.checkTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolRun.this.doUpdate();
            }
        });
    }

    @Override
    public String getFileMenuName() {
        return "Run";
    }

    private void updateControls() {
        if (this.processPanel.isProcessRunning()) {
            this.killButton.setEnabled(true);
            if (null != this.killMenuItem) {
                this.killMenuItem.setEnabled(true);
            }
            this.saveButton.setEnabled(false);
            if (null != this.saveMenuItem) {
                this.saveMenuItem.setEnabled(false);
            }
            this.okButton.setEnabled(false);
        } else {
            this.killButton.setEnabled(false);
            if (null != this.killMenuItem) {
                this.killMenuItem.setEnabled(false);
            }
            if (this.processPanel.hasOutput()) {
                this.saveButton.setEnabled(true);
                if (null != this.saveMenuItem) {
                    this.saveMenuItem.setEnabled(true);
                }
            }
            this.okButton.setEnabled(true);
        }
    }

    private void doUpdate() {
        if (this.processPanel.pollProcess()) {
            return;
        }
        this.checkTimer.stop();
        this.updateControls();
    }

    private void doCancel() {
        if (this.processPanel.isProcessRunning()) {
            this.processPanel.killProcess(true);
        }
    }

    private void doSaveOutput() {
        if (this.processPanel.hasOutput()) {
            this.processPanel.saveOutput();
        }
    }

    private void doOK() {
        if (!this.processPanel.isProcessRunning()) {
            AppManager.hideWindow(this);
        }
    }

    @Override
    public void windowWillOpen() {
        if (!this.checkTimer.isRunning()) {
            this.checkTimer.start();
        }
    }

    @Override
    public boolean windowShouldClose() {
        if (this.processPanel.isProcessRunning()) {
            AppManager.showMessage(this, "This window can't be closed while the process is running.", this.windowTitle, 1);
            return false;
        }
        return true;
    }
}

