/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.util;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import javax.swing.Timer;

public abstract class QueryWorker<ReturnType>
extends SwingWorker<ReturnType, String> {
    private static final int DIALOG_DELAY_TIME = 500;
    private static final int DIALOG_DISPLAY_TIME = 2000;
    private Window parent;
    private String title;
    private DbConnection workerDb;
    private boolean workerDbIsCopy;
    private ErrorReporter workerErrors;
    private JDialog statusDialog;
    private JLabel statusLabel;
    private boolean canCloseDialog;

    public QueryWorker(Window window, String string) {
        this.parent = window;
        this.title = string;
        this.workerErrors = new ErrorReporter(new StringBuilder());
    }

    public QueryWorker(Window window, String string, DbConnection dbConnection) {
        this.parent = window;
        this.title = string;
        this.workerDb = dbConnection.copy();
        this.workerDbIsCopy = true;
        this.workerErrors = new ErrorReporter(new StringBuilder());
    }

    public QueryWorker(Window window, String string, DbConnection dbConnection, boolean bl) {
        this.parent = window;
        this.title = string;
        if (bl) {
            this.workerDb = dbConnection.copy();
            this.workerDbIsCopy = true;
        } else {
            this.workerDb = dbConnection;
        }
        this.workerErrors = new ErrorReporter(new StringBuilder());
    }

    public ReturnType runQuery(String string, ErrorReporter errorReporter) {
        this.execute();
        ReturnType ReturnType = null;
        boolean bl = false;
        try {
            ReturnType = (ReturnType)this.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            bl = true;
        }
        catch (Exception exception) {
            this.workerErrors.reportError("An unexpected error occurred:\n" + exception, 0);
        }
        if (bl) {
            this.statusDialog = new JDialog(this.parent, this.title, Dialog.ModalityType.DOCUMENT_MODAL);
            this.statusDialog.setResizable(false);
            this.statusLabel = new JLabel(string);
            this.statusLabel.setPreferredSize(AppManager.getLabelSize(40));
            Box box = Box.createVerticalBox();
            box.add(Box.createVerticalStrut(20));
            box.add(this.statusLabel);
            box.add(Box.createVerticalStrut(20));
            Box box2 = Box.createHorizontalBox();
            box2.add(Box.createHorizontalStrut(20));
            box2.add(box);
            box2.add(Box.createHorizontalStrut(20));
            this.statusDialog.getContentPane().add(box2);
            this.statusDialog.pack();
            this.statusDialog.setLocationRelativeTo(this.parent);
            Timer timer = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (QueryWorker.this.canCloseDialog) {
                        QueryWorker.this.statusDialog.setVisible(false);
                    } else {
                        QueryWorker.this.canCloseDialog = true;
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
            this.statusDialog.setVisible(true);
            try {
                ReturnType = (ReturnType)this.get();
            }
            catch (Exception exception) {
                this.workerErrors.reportError("An unexpected error occurred:\n" + exception, 0);
            }
        }
        if (this.workerErrors.hasErrors()) {
            errorReporter.reportError(this.workerErrors.getErrorLog().toString(), this.workerErrors.getLastErrorType());
        }
        if (this.workerErrors.hasMessages()) {
            errorReporter.logMessage(this.workerErrors.getMessages());
        }
        return ReturnType;
    }

    @Override
    protected ReturnType doInBackground() throws Exception {
        ReturnType ReturnType = this.doBackgroundQuery(this.workerDb, this.workerErrors);
        if (this.workerDbIsCopy) {
            this.workerDb.close(false);
        }
        return ReturnType;
    }

    protected abstract ReturnType doBackgroundQuery(DbConnection var1, ErrorReporter var2);

    public void setWaitMessage(String string) {
        this.publish(string);
    }

    @Override
    protected void process(List<String> list) {
        if (null != this.statusLabel) {
            this.statusLabel.setText(list.get(list.size() - 1));
        }
    }

    @Override
    protected void done() {
        if (this.canCloseDialog) {
            this.statusDialog.setVisible(false);
        } else {
            this.canCloseDialog = true;
        }
    }
}

