/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.util;

import gov.fcc.tvstudy.AppManager;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.DefaultCaret;

public class ProcessPanel
extends JPanel {
    private String processName;
    private ArrayList<String> argumentList;
    private String password;
    private Process process;
    private boolean processStarted;
    private boolean processRunning;
    private boolean processFailed;
    private StringBuilder output;
    private int outputPosition;
    private boolean skipNextLine;
    private JTextArea outputArea;
    private ArrayList<String> mergeLineStrings;
    private int lastOutputLineType;
    private int lastOutputLineStart;
    private int lastOutputLineEnd;
    private JViewport outputViewport;
    private int autoScrollState;
    private boolean autoScrollLock;
    private JLabel statusLabel;

    public ProcessPanel(String string, ArrayList<String> arrayList, String string2, ArrayList<String> arrayList2) {
        super(new BorderLayout());
        this.processName = null == string ? "Process" : string;
        this.argumentList = arrayList;
        this.password = string2;
        if (null != arrayList2 && !arrayList2.isEmpty()) {
            this.mergeLineStrings = arrayList2;
        }
        this.output = new StringBuilder();
        this.outputArea = new JTextArea(10, 50);
        AppManager.fixKeyBindings(this.outputArea);
        this.outputArea.setEditable(false);
        ((DefaultCaret)this.outputArea.getCaret()).setUpdatePolicy(1);
        JScrollPane jScrollPane = AppManager.createScrollPane(this.outputArea);
        this.outputViewport = jScrollPane.getViewport();
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                boolean bl;
                if (ProcessPanel.this.autoScrollLock) {
                    return;
                }
                if (((ProcessPanel)ProcessPanel.this).outputViewport.getViewSize().height <= ((ProcessPanel)ProcessPanel.this).outputViewport.getExtentSize().height) {
                    ProcessPanel.this.autoScrollState = 0;
                }
                if (0 == ProcessPanel.this.autoScrollState) {
                    return;
                }
                Adjustable adjustable = adjustmentEvent.getAdjustable();
                boolean bl2 = bl = adjustable.getMaximum() - adjustable.getVisibleAmount() - adjustmentEvent.getValue() < 10;
                if (1 == ProcessPanel.this.autoScrollState) {
                    if (!bl) {
                        ProcessPanel.this.autoScrollState = 2;
                    }
                } else if (bl) {
                    ProcessPanel.this.autoScrollState = 1;
                }
            }
        });
        this.statusLabel = new JLabel(this.processName + " is starting");
        this.statusLabel.setPreferredSize(AppManager.getLabelSize(30));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.statusLabel);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "South");
    }

    public boolean pollProcess() {
        if (!this.processStarted) {
            this.processStarted = true;
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(this.argumentList);
                processBuilder.redirectErrorStream(true);
                this.process = processBuilder.start();
                this.processRunning = true;
            }
            catch (Throwable throwable) {
                AppManager.log(Level.SEVERE, "Could not start process", throwable);
            }
            if (this.processRunning) {
                this.statusLabel.setText(this.processName + " is running");
            } else {
                this.processFailed = true;
                this.statusLabel.setText("*** " + this.processName + " failed to start ***");
                return false;
            }
        }
        if (!this.processRunning) {
            return false;
        }
        this.collectOutput();
        boolean bl = false;
        int n = this.output.length();
        int n2 = this.outputPosition;
        int n3 = 0;
        String string = null;
        while (n2 < n) {
            while (n2 < n && '\n' != this.output.charAt(n2) && '\r' != this.output.charAt(n2)) {
                ++n2;
            }
            if (n2 >= n) continue;
            n3 = 0;
            if ('\r' == this.output.charAt(n2)) {
                n3 = -1;
                this.output.setCharAt(n2, '\n');
            }
            string = this.output.substring(this.outputPosition, ++n2);
            this.outputPosition = n2;
            if (0 == n3 && null != this.mergeLineStrings) {
                for (int i = 0; i < this.mergeLineStrings.size(); ++i) {
                    if (!string.contains(this.mergeLineStrings.get(i))) continue;
                    n3 = i + 1;
                    break;
                }
            }
            if (n3 != 0 && n3 == this.lastOutputLineType) {
                this.outputArea.replaceRange(string, this.lastOutputLineStart, this.lastOutputLineEnd);
            } else {
                this.outputArea.append(string);
                this.lastOutputLineStart = this.lastOutputLineEnd;
            }
            this.lastOutputLineType = n3;
            this.lastOutputLineEnd = this.lastOutputLineStart + string.length();
            bl = true;
        }
        if (bl) {
            this.autoScrollLock = true;
            this.outputViewport.validate();
            if (this.outputViewport.getViewSize().height <= this.outputViewport.getExtentSize().height) {
                this.autoScrollState = 0;
            } else {
                if (0 == this.autoScrollState) {
                    this.autoScrollState = 1;
                }
                if (1 == this.autoScrollState) {
                    this.outputViewport.scrollRectToVisible(new Rectangle(0, this.outputViewport.getViewSize().height - 1, 1, 1));
                }
            }
            this.autoScrollLock = false;
        }
        try {
            if (this.process.exitValue() != 0) {
                this.processFailed = true;
            }
            this.processRunning = false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        if (!this.processRunning) {
            this.finishOutput();
            if (this.processFailed) {
                this.statusLabel.setText("*** " + this.processName + " exited with an error ***");
            } else {
                this.statusLabel.setText(this.processName + " complete");
            }
            return false;
        }
        if (null != this.password && this.output.toString().toLowerCase().contains("password")) {
            OutputStream outputStream = this.process.getOutputStream();
            try {
                outputStream.write(this.password.getBytes());
                outputStream.write(13);
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.password = null;
            this.output.setLength(0);
            this.outputPosition = 0;
            this.skipNextLine = true;
            this.outputArea.setText("");
            this.lastOutputLineType = 0;
            this.lastOutputLineStart = 0;
            this.lastOutputLineEnd = 0;
        }
        return true;
    }

    private void collectOutput() {
        if (null == this.process) {
            return;
        }
        InputStream inputStream = this.process.getInputStream();
        try {
            byte[] byArray;
            int n = inputStream.available();
            if (n > 0 && (n = inputStream.read(byArray = new byte[n])) > 0) {
                String string = new String(byArray);
                if (this.skipNextLine) {
                    int n2 = string.indexOf(10);
                    if (n2 >= 0) {
                        if ((string = string.substring(n2 + 1)).length() > 0) {
                            this.output.append(string);
                        }
                        this.skipNextLine = false;
                    }
                } else {
                    this.output.append(string);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void finishOutput() {
        this.collectOutput();
        int n = this.output.length();
        if (this.outputPosition < n) {
            this.outputArea.append(this.output.substring(this.outputPosition, n));
            this.outputPosition = n;
        }
        this.outputViewport.validate();
        this.outputViewport.scrollRectToVisible(new Rectangle(0, this.outputViewport.getViewSize().height - 1, 1, 1));
    }

    public boolean killProcess(boolean bl) {
        if (this.processStarted && !this.processRunning) {
            return true;
        }
        if (this.processStarted) {
            if (bl) {
                AppManager.beep();
                Object[] objectArray = new String[]{"No", "Yes"};
                if (0 == JOptionPane.showOptionDialog(this, "This will forcibly terminate the running process.  Output\nfiles may be incomplete and databases may be left in an\ninvalid state.  Are you sure you want to do this?", "Kill " + this.processName, 0, 2, null, objectArray, objectArray[0])) {
                    return false;
                }
            }
            this.process.destroy();
            this.processRunning = false;
            this.finishOutput();
        } else {
            this.processStarted = true;
        }
        this.processFailed = true;
        this.statusLabel.setText("*** " + this.processName + " was killed ***");
        return true;
    }

    public boolean isProcessRunning() {
        if (this.processStarted) {
            return this.processRunning;
        }
        return true;
    }

    public boolean didProcessFail() {
        return this.processFailed;
    }

    public void setStatusMessage(String string) {
        this.statusLabel.setText(string);
    }

    public String getStatusMessage() {
        return this.statusLabel.getText();
    }

    public boolean hasOutput() {
        return !this.processRunning && this.output.length() > 0;
    }

    public String getOutput() {
        if (!this.processRunning && this.output.length() > 0) {
            return this.output.toString();
        }
        return null;
    }

    public void saveOutput() {
        if (this.processRunning || 0 == this.output.length()) {
            return;
        }
        String string = "Save " + this.processName + " Output";
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        File file = null;
        do {
            if (0 != jFileChooser.showDialog(this, "Save")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            if (!file.exists()) continue;
            AppManager.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            AppManager.showMessage(this, "Could not open the file:\n" + iOException.getMessage(), string, 0);
            return;
        }
        try {
            fileWriter.write(this.output.toString());
        }
        catch (IOException iOException) {
            AppManager.showMessage(this, "Could not write to the file:\n" + iOException.getMessage(), string, 0);
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

