/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.util;

import gov.fcc.tvstudy.data.KeyedRecord;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComboBox;

public class KeyedRecordMenu
extends JComboBox
implements ItemListener {
    private HashMap<Integer, KeyedRecord> permanentItems = new HashMap();
    private KeyedRecord temporaryItem;
    private boolean stopListener = false;

    public KeyedRecordMenu() {
        this.addItemListener(this);
        this.setMaximumRowCount(30);
    }

    public KeyedRecordMenu(ArrayList<KeyedRecord> arrayList) {
        for (KeyedRecord keyedRecord : arrayList) {
            Integer n = new Integer(keyedRecord.key);
            if (this.permanentItems.containsKey(n)) continue;
            super.addItem(keyedRecord);
            this.permanentItems.put(n, keyedRecord);
        }
        this.addItemListener(this);
        this.setMaximumRowCount(30);
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(false);
    }

    public void addAllItems(ArrayList<KeyedRecord> arrayList) {
        for (KeyedRecord keyedRecord : arrayList) {
            this.addItem(keyedRecord);
        }
    }

    public void addItem(KeyedRecord keyedRecord) {
        Integer n;
        if (keyedRecord instanceof KeyedRecord && !this.permanentItems.containsKey(n = new Integer(keyedRecord.key))) {
            if (keyedRecord.equals(this.temporaryItem)) {
                this.permanentItems.put(n, this.temporaryItem);
                this.temporaryItem = null;
            } else {
                super.addItem(keyedRecord);
                this.permanentItems.put(n, keyedRecord);
            }
        }
    }

    @Override
    public void removeAllItems() {
        this.stopListener = true;
        super.removeAllItems();
        this.permanentItems.clear();
        this.temporaryItem = null;
        this.stopListener = false;
    }

    public void removeItem(KeyedRecord keyedRecord) {
        if (keyedRecord instanceof KeyedRecord) {
            Integer n = new Integer(keyedRecord.key);
            if (this.permanentItems.containsKey(n)) {
                keyedRecord = this.permanentItems.remove(n);
                super.removeItem(keyedRecord);
            } else if (keyedRecord.equals(this.temporaryItem)) {
                this.stopListener = true;
                super.removeItem(this.temporaryItem);
                this.temporaryItem = null;
                this.stopListener = false;
            }
        }
    }

    public void setSelectedItem(KeyedRecord keyedRecord) {
        if (keyedRecord instanceof KeyedRecord) {
            Integer n = new Integer(keyedRecord.key);
            if (this.permanentItems.containsKey(n)) {
                keyedRecord = this.permanentItems.get(n);
            } else if (keyedRecord.equals(this.temporaryItem)) {
                keyedRecord = this.temporaryItem;
            } else {
                if (null != this.temporaryItem) {
                    this.stopListener = true;
                    super.removeItem(this.temporaryItem);
                    this.temporaryItem = null;
                    this.stopListener = false;
                }
                this.temporaryItem = keyedRecord;
                super.addItem(keyedRecord);
            }
            super.setSelectedItem(keyedRecord);
        }
    }

    public void setSelectedKey(int n) {
        this.setSelectedItem(new KeyedRecord(n, "(unknown)"));
    }

    @Override
    public KeyedRecord getSelectedItem() {
        return (KeyedRecord)super.getSelectedItem();
    }

    public int getSelectedKey() {
        KeyedRecord keyedRecord = (KeyedRecord)super.getSelectedItem();
        if (null != keyedRecord) {
            return keyedRecord.key;
        }
        return 0;
    }

    public String getSelectedName() {
        KeyedRecord keyedRecord = (KeyedRecord)super.getSelectedItem();
        if (null != keyedRecord) {
            return keyedRecord.name;
        }
        return "";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.stopListener) {
            return;
        }
        if (1 == itemEvent.getStateChange()) {
            KeyedRecord keyedRecord = (KeyedRecord)itemEvent.getItem();
            if (null != this.temporaryItem && !keyedRecord.equals(this.temporaryItem)) {
                this.stopListener = true;
                super.removeItem(this.temporaryItem);
                this.temporaryItem = null;
                this.stopListener = false;
            }
        }
    }
}

