/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.util;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.editor.RootEditor;
import java.awt.Window;
import java.io.PrintStream;

public class ErrorReporter {
    private RootEditor editor;
    private Window parent;
    private String title;
    private PrintStream errorStream;
    private StringBuilder errorLog;
    private boolean errorsReported;
    private int lastErrorType = 1;
    private StringBuilder messageLog;

    public ErrorReporter(RootEditor rootEditor, Window window, String string) {
        this.editor = rootEditor;
        this.parent = window;
        this.title = string;
    }

    public ErrorReporter(Window window, String string) {
        this.parent = window;
        this.title = string;
    }

    public ErrorReporter(PrintStream printStream) {
        this.errorStream = printStream;
    }

    public ErrorReporter(StringBuilder stringBuilder) {
        this.errorLog = stringBuilder;
    }

    public ErrorReporter(RootEditor rootEditor, Window window, String string, PrintStream printStream, StringBuilder stringBuilder) {
        this.editor = rootEditor;
        this.parent = window;
        this.title = string;
        this.errorStream = printStream;
        this.errorLog = stringBuilder;
    }

    public void reportValidationError(String string) {
        this.reportValidationError(this.title, string);
    }

    public void reportValidationError(String string, String string2) {
        if (null == this.title) {
            string = null;
        }
        if (null != this.editor) {
            this.editor.reportValidationError(this.parent, string, string2, 2);
        } else if (null != string && string.length() > 0) {
            AppManager.showMessage(this.parent, string2, string, 2);
        }
        if (null != this.errorStream || null != this.errorLog) {
            StringBuilder stringBuilder = new StringBuilder();
            if (null != string && string.length() > 0) {
                stringBuilder.append(string + ": ");
            }
            stringBuilder.append(string2);
            stringBuilder.append('\n');
            if (null != this.errorStream) {
                this.errorStream.append(stringBuilder);
            }
            if (null != this.errorLog) {
                this.errorLog.append((CharSequence)stringBuilder);
            }
        }
        this.errorsReported = true;
        this.lastErrorType = 2;
    }

    public void reportError(String string, int n) {
        this.reportError(this.title, string, n);
    }

    public void reportError(String string, String string2, int n) {
        if (null == this.title) {
            string = null;
        }
        if (null != string && string.length() > 0) {
            AppManager.showMessage(this.parent, string2, string, n);
        }
        if (null != this.errorStream || null != this.errorLog) {
            StringBuilder stringBuilder = new StringBuilder();
            if (null != string && string.length() > 0) {
                stringBuilder.append(string + ": ");
            }
            switch (n) {
                case 0: {
                    stringBuilder.append("ERROR: ");
                    break;
                }
                case 2: {
                    stringBuilder.append("Warning: ");
                }
            }
            stringBuilder.append(string2);
            stringBuilder.append('\n');
            if (null != this.errorStream) {
                this.errorStream.append(stringBuilder);
            }
            if (null != this.errorLog) {
                this.errorLog.append((CharSequence)stringBuilder);
            }
        }
        this.errorsReported = true;
        this.lastErrorType = n;
    }

    public void reportError(String string) {
        this.reportError(this.title, string, 0);
    }

    public void reportError(String string, String string2) {
        this.reportError(string, string2, 0);
    }

    public void reportWarning(String string) {
        this.reportError(this.title, string, 2);
    }

    public void reportWarning(String string, String string2) {
        this.reportError(string, string2, 2);
    }

    public void reportMessage(String string) {
        this.reportError(this.title, string, 1);
    }

    public void reportMessage(String string, String string2) {
        this.reportError(string, string2, 1);
    }

    public StringBuilder getErrorLog() {
        return this.errorLog;
    }

    public void clearErrors() {
        this.errorsReported = false;
        this.lastErrorType = 1;
    }

    public boolean hasErrors() {
        return this.errorsReported;
    }

    public int getLastErrorType() {
        return this.lastErrorType;
    }

    public void logMessage(String string) {
        if (null == this.messageLog) {
            this.messageLog = new StringBuilder(string);
        } else {
            this.messageLog.append('\n');
            this.messageLog.append(string);
        }
    }

    public boolean hasMessages() {
        return null != this.messageLog;
    }

    public String getMessages() {
        if (null == this.messageLog) {
            return "";
        }
        return this.messageLog.toString();
    }

    public void clearMessages() {
        this.messageLog = null;
    }
}

