/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.util;

import gov.fcc.tvstudy.AppManager;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class EditMenu
extends JMenu {
    private KeyStroke cutKeyStroke = KeyStroke.getKeyStroke(88, AppManager.MENU_SHORTCUT_KEY_MASK);
    private KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, AppManager.MENU_SHORTCUT_KEY_MASK);
    private KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, AppManager.MENU_SHORTCUT_KEY_MASK);
    private KeyStroke selectAllKeyStroke = KeyStroke.getKeyStroke(65, AppManager.MENU_SHORTCUT_KEY_MASK);
    private JTable targetTable;

    public EditMenu() {
        super("Edit");
        JMenuItem jMenuItem = new JMenuItem("Cut");
        jMenuItem.setAccelerator(this.cutKeyStroke);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditMenu.this.runAction(actionEvent, EditMenu.this.cutKeyStroke);
            }
        });
        this.add(jMenuItem);
        jMenuItem = new JMenuItem("Copy");
        jMenuItem.setAccelerator(this.copyKeyStroke);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditMenu.this.runAction(actionEvent, EditMenu.this.copyKeyStroke);
            }
        });
        this.add(jMenuItem);
        jMenuItem = new JMenuItem("Paste");
        jMenuItem.setAccelerator(this.pasteKeyStroke);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditMenu.this.runAction(actionEvent, EditMenu.this.pasteKeyStroke);
            }
        });
        this.add(jMenuItem);
        jMenuItem = new JMenuItem("Select All");
        jMenuItem.setAccelerator(this.selectAllKeyStroke);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditMenu.this.runAction(actionEvent, EditMenu.this.selectAllKeyStroke);
            }
        });
        this.add(jMenuItem);
    }

    public void setTargetTable(JTable jTable) {
        this.targetTable = jTable;
    }

    private void runAction(ActionEvent actionEvent, KeyStroke keyStroke) {
        Object object;
        Action action = null;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component instanceof JComponent && null != (object = ((JComponent)component).getInputMap().get(keyStroke)) && null != (action = ((JComponent)component).getActionMap().get(object))) {
            action.actionPerformed(actionEvent);
            return;
        }
        if (null == this.targetTable) {
            AppManager.beep();
            return;
        }
        if (keyStroke == this.cutKeyStroke || keyStroke == this.pasteKeyStroke) {
            AppManager.beep();
            return;
        }
        if (keyStroke == this.copyKeyStroke) {
            object = this.targetTable.getSelectedRows();
            if (0 == ((Object)object).length) {
                AppManager.beep();
                return;
            }
            int n = this.targetTable.getColumnCount();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < ((Object)object).length; ++i) {
                String string = "";
                for (int j = 0; j < n; ++j) {
                    Object object2 = this.targetTable.getValueAt((int)object[i], j);
                    String string2 = null == object2 ? "" : object2.toString();
                    if ((string2 = string2.replace('\"', '\'')).contains("\t")) {
                        string2 = "\"" + string2 + "\"";
                    }
                    stringBuilder.append(string + string2);
                    string = "\t";
                }
                stringBuilder.append("\n");
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            return;
        }
        if (keyStroke == this.selectAllKeyStroke) {
            this.targetTable.setRowSelectionInterval(0, this.targetTable.getRowCount() - 1);
            return;
        }
        AppManager.beep();
    }
}

