/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.util;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.swing.Timer;

public class DbConnection {
    public static final String ERROR_TEXT_PREFIX = "An operation cannot be completed due to a database error:\n";
    private static final int IDLE_CLOSE_TIME = 30000;
    public final String driverURL;
    public final String hostname;
    public final String username;
    public final String password;
    private Connection connection;
    private Statement statement;
    private boolean connected;
    private ResultSet resultSet;
    private Thread inTransactionForThread;
    private boolean canLinger;
    private Timer closeTimer;

    public DbConnection(String string, String string2, String string3, String string4) {
        this.driverURL = string;
        this.hostname = string2;
        this.username = string3;
        this.password = string4;
        this.closeTimer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbConnection.this.close(false);
            }
        });
        this.closeTimer.setRepeats(false);
    }

    public DbConnection copy() {
        return new DbConnection(this.driverURL, this.hostname, this.username, this.password);
    }

    public boolean connect() {
        return this.connect(null, true);
    }

    public boolean connect(ErrorReporter errorReporter) {
        return this.connect(errorReporter, true);
    }

    public boolean connect(boolean bl) {
        return this.connect(null, bl);
    }

    public synchronized boolean connect(ErrorReporter errorReporter, boolean bl) {
        block11: {
            if (this.connected) {
                if (null != errorReporter) {
                    errorReporter.reportError("An operation cannot be completed because the\ndatabase server connection is already in use.");
                }
                return false;
            }
            this.closeTimer.stop();
            if (null == this.connection && this.hostname.length() > 0) {
                try {
                    this.connection = DriverManager.getConnection(this.driverURL + "//" + this.hostname, this.username, this.password);
                    this.canLinger = true;
                }
                catch (SQLException sQLException) {
                    if (!bl) break block11;
                    AppManager.log(Level.SEVERE, "Database connection failed", sQLException);
                }
            }
        }
        if (null != this.connection) {
            try {
                this.setUpdatable(false);
                this.connected = true;
            }
            catch (SQLException sQLException) {
                this.close(false);
                AppManager.log(Level.SEVERE, "Could not create statement object", sQLException);
            }
        }
        if (!this.connected && null != errorReporter) {
            if (0 == this.hostname.length()) {
                errorReporter.reportError("An operation cannot be completed because connections\nto the requested database server have been disabled.");
            } else {
                errorReporter.reportError("An operation cannot be completed because a connection to\nthe database server cannot be established.  The server may\nbe off-line or there may be a problem with the network.");
            }
        }
        return this.connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (null != this.connection) {
            return this.connection.getMetaData();
        }
        return null;
    }

    public synchronized void setUpdatable(boolean bl) throws SQLException {
        if (null == this.connection) {
            throw new SQLException("DbConnection.setUpdatable(): connection is not open");
        }
        this.resultSet = null;
        if (null != this.statement) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.statement = null;
        }
        this.statement = bl ? this.connection.createStatement(1005, 1008) : this.connection.createStatement(1005, 1007);
    }

    public synchronized void query(String string) throws SQLException {
        if (null == this.statement) {
            throw new SQLException("DbConnection.query(): no statement object");
        }
        if (null != this.inTransactionForThread && Thread.currentThread() != this.inTransactionForThread) {
            throw new SQLException("DbConnection.query(): transaction was opened on a different thread");
        }
        try {
            this.resultSet = this.statement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            this.canLinger = false;
            throw sQLException;
        }
    }

    public synchronized int update(String string) throws SQLException {
        if (null == this.statement) {
            throw new SQLException("DbConnection.update(): no statement object");
        }
        if (null != this.inTransactionForThread && Thread.currentThread() != this.inTransactionForThread) {
            throw new SQLException("DbConnection.update(): transaction was opened on a different thread");
        }
        int n = 0;
        try {
            n = this.statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            this.canLinger = false;
            throw sQLException;
        }
        return n;
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    public String getString(int n) throws SQLException {
        return this.resultSet.getString(n);
    }

    public String getString(String string) throws SQLException {
        return this.resultSet.getString(string);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.resultSet.getBoolean(n);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.resultSet.getBoolean(string);
    }

    public int getInt(int n) throws SQLException {
        return this.resultSet.getInt(n);
    }

    public int getInt(String string) throws SQLException {
        return this.resultSet.getInt(string);
    }

    public long getLong(int n) throws SQLException {
        return this.resultSet.getLong(n);
    }

    public long getLong(String string) throws SQLException {
        return this.resultSet.getLong(string);
    }

    public float getFloat(int n) throws SQLException {
        return this.resultSet.getFloat(n);
    }

    public float getFloat(String string) throws SQLException {
        return this.resultSet.getFloat(string);
    }

    public double getDouble(int n) throws SQLException {
        return this.resultSet.getDouble(n);
    }

    public double getDouble(String string) throws SQLException {
        return this.resultSet.getDouble(string);
    }

    public Date getDate(int n) throws SQLException {
        return this.resultSet.getDate(n);
    }

    public Date getDate(String string) throws SQLException {
        return this.resultSet.getDate(string);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.resultSet.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.resultSet.getTimestamp(string);
    }

    public synchronized void begin() throws SQLException {
        if (null == this.connection) {
            throw new SQLException("DbConnection.begin(): connection is not open");
        }
        if (null != this.inTransactionForThread) {
            throw new SQLException("DbConnection.begin(): a transaction is already open");
        }
        this.inTransactionForThread = Thread.currentThread();
        this.connection.setAutoCommit(false);
    }

    public synchronized void commit() throws SQLException {
        if (null == this.inTransactionForThread) {
            throw new SQLException("DbConnection.commit(): no transaction is open");
        }
        if (Thread.currentThread() != this.inTransactionForThread) {
            throw new SQLException("DbConnection.commit(): transaction was opened on a different thread");
        }
        this.connection.commit();
        this.connection.setAutoCommit(true);
        this.inTransactionForThread = null;
    }

    public synchronized void rollback() throws SQLException {
        if (null == this.inTransactionForThread) {
            throw new SQLException("DbConnection.rollback(): no transaction is open");
        }
        if (Thread.currentThread() != this.inTransactionForThread) {
            throw new SQLException("DbConnection.rollback(): transaction was opened on a different thread");
        }
        this.connection.rollback();
        this.connection.setAutoCommit(true);
        this.inTransactionForThread = null;
    }

    public synchronized void abort() {
        if (null != this.inTransactionForThread) {
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                this.canLinger = false;
            }
            this.inTransactionForThread = null;
        }
        this.resultSet = null;
        if (null != this.statement) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                this.canLinger = false;
            }
            this.statement = null;
        }
    }

    public void close() {
        this.close(true);
    }

    public synchronized void close(boolean bl) {
        if (null == this.connection) {
            return;
        }
        this.abort();
        if (bl && this.canLinger) {
            this.closeTimer.start();
        } else {
            if (this.closeTimer.isRunning()) {
                this.closeTimer.stop();
            }
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
            this.canLinger = false;
        }
        this.connected = false;
    }

    public void reportWarnings(ErrorReporter errorReporter, boolean bl) {
        String string = this.getWarnings();
        if (null == string) {
            if (!bl) {
                return;
            }
            string = "A database operation may have failed, but no details are available.";
        } else {
            string = "A database operation returned the following message:" + string;
        }
        errorReporter.reportWarning(string);
    }

    public synchronized String getWarnings() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            SQLWarning sQLWarning;
            if (null != this.resultSet) {
                this.resultSet.clearWarnings();
                for (sQLWarning = this.resultSet.getWarnings(); null != sQLWarning; sQLWarning = sQLWarning.getNextWarning()) {
                    stringBuilder.append("\n");
                    stringBuilder.append(sQLWarning.getMessage());
                }
            }
            if (null != this.statement) {
                this.statement.clearWarnings();
                for (sQLWarning = this.statement.getWarnings(); null != sQLWarning; sQLWarning = sQLWarning.getNextWarning()) {
                    stringBuilder.append("\n");
                    stringBuilder.append(sQLWarning.getMessage());
                }
            }
            if (null != this.connection) {
                this.connection.clearWarnings();
                for (sQLWarning = this.connection.getWarnings(); null != sQLWarning; sQLWarning = sQLWarning.getNextWarning()) {
                    stringBuilder.append("\n");
                    stringBuilder.append(sQLWarning.getMessage());
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    public void reportError(ErrorReporter errorReporter, SQLException sQLException) {
        this.reportError(sQLException);
        if (null != errorReporter) {
            errorReporter.reportError(ERROR_TEXT_PREFIX + sQLException);
        }
    }

    public void reportError(SQLException sQLException) {
        AppManager.log(Level.SEVERE, "Database error", sQLException);
    }

    public String clean(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    stringBuilder.append("''");
                    continue block4;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

