/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateCounter {
    private SimpleDateFormat dateFormat;
    private Date latestDate;
    private int latestDateCount;

    public DateCounter(String string) {
        this.dateFormat = new SimpleDateFormat(string);
        this.reset();
    }

    public void reset() {
        this.latestDate = new Date(0L);
        this.latestDateCount = 0;
    }

    public void add(String string) {
        Date date = null;
        try {
            date = this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (null != date && !date.before(this.latestDate)) {
            if (date.after(this.latestDate)) {
                this.latestDate.setTime(date.getTime());
                this.latestDateCount = 1;
            } else {
                ++this.latestDateCount;
            }
        }
    }

    public String toString() {
        return this.dateFormat.format(this.latestDate) + " (" + this.latestDateCount + ")";
    }

    public Date getDate() {
        return this.latestDate;
    }

    public int getCount() {
        return this.latestDateCount;
    }
}

