/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.data.Study;
import gov.fcc.tvstudy.editor.StudyRun;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.KeyedRecordMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class StudyRunStart
extends AppDialog {
    public static final String WINDOW_TITLE = "Start Study Run";
    private AppFrame parent;
    private int studyKey;
    private String studyName;
    private int studyLock;
    private int lockCount;
    private ScenarioListTableModel scenarioListModel;
    private JTable scenarioListTable;
    private KeyedRecordMenu reportOutputMenu;
    private KeyedRecordMenu csvOutputMenu;
    private KeyedRecordMenu cellOutputMenu;
    private KeyedRecordMenu mapOutputMenu;
    private KeyedRecordMenu pointsOutputMenu;
    private KeyedRecordMenu paramsOutputMenu;
    private JComboBox memoryFractionMenu;
    private JTextArea runCommentArea;
    private StudyRun runWindow;
    public boolean canceled;

    public StudyRunStart(AppFrame appFrame) {
        super((Window)appFrame, WINDOW_TITLE, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDisposeOnClose(false);
        this.parent = appFrame;
        this.scenarioListModel = new ScenarioListTableModel();
        this.scenarioListTable = this.scenarioListModel.createTable();
        this.scenarioListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = StudyRunStart.this.scenarioListTable.getSelectedRowCount() > 0;
                AppManager.setComponentEnabled(StudyRunStart.this.reportOutputMenu, bl);
                AppManager.setComponentEnabled(StudyRunStart.this.csvOutputMenu, bl);
                AppManager.setComponentEnabled(StudyRunStart.this.cellOutputMenu, bl);
                AppManager.setComponentEnabled(StudyRunStart.this.mapOutputMenu, bl);
                AppManager.setComponentEnabled(StudyRunStart.this.pointsOutputMenu, bl);
                AppManager.setComponentEnabled(StudyRunStart.this.paramsOutputMenu, bl);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Select scenario(s) to study"));
        jPanel.add((Component)AppManager.createScrollPane(this.scenarioListTable), "Center");
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        arrayList.add(new KeyedRecord(0, "No"));
        arrayList.add(new KeyedRecord(1, "Yes"));
        this.reportOutputMenu = new KeyedRecordMenu(arrayList);
        this.reportOutputMenu.setSelectedIndex(1);
        this.mapOutputMenu = new KeyedRecordMenu(arrayList);
        this.pointsOutputMenu = new KeyedRecordMenu(arrayList);
        arrayList = new ArrayList();
        arrayList.add(new KeyedRecord(0, "No"));
        arrayList.add(new KeyedRecord(1, "Detail"));
        arrayList.add(new KeyedRecord(2, "Summary"));
        this.csvOutputMenu = new KeyedRecordMenu(arrayList);
        this.cellOutputMenu = new KeyedRecordMenu(arrayList);
        arrayList = new ArrayList();
        arrayList.add(new KeyedRecord(0, "No"));
        arrayList.add(new KeyedRecord(1, "Desired only"));
        arrayList.add(new KeyedRecord(2, "All stations"));
        this.paramsOutputMenu = new KeyedRecordMenu(arrayList);
        JLabel jLabel = new JLabel("Report");
        JLabel jLabel2 = new JLabel("Report CSV");
        JLabel jLabel3 = new JLabel("Parameters");
        JLabel jLabel4 = new JLabel("Cell");
        JLabel jLabel5 = new JLabel("Map");
        JLabel jLabel6 = new JLabel("Points");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Choose output file options"));
        GroupLayout groupLayout = new GroupLayout(jPanel2);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel).addComponent(jLabel2).addComponent(jLabel3)).addGroup(groupLayout.createParallelGroup().addComponent(this.reportOutputMenu).addComponent(this.csvOutputMenu).addComponent(this.paramsOutputMenu)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel4).addComponent(jLabel5).addComponent(jLabel6)).addGroup(groupLayout.createParallelGroup().addComponent(this.cellOutputMenu).addComponent(this.mapOutputMenu).addComponent(this.pointsOutputMenu)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.reportOutputMenu).addComponent(jLabel4).addComponent(this.cellOutputMenu)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.csvOutputMenu).addComponent(jLabel5).addComponent(this.mapOutputMenu)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.paramsOutputMenu).addComponent(jLabel6).addComponent(this.pointsOutputMenu)));
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 2) {
            n = 2;
        }
        this.memoryFractionMenu = new JComboBox();
        for (int i = 1; i <= n; ++i) {
            if (1 == i) {
                this.memoryFractionMenu.addItem("All");
                continue;
            }
            this.memoryFractionMenu.addItem("1/" + String.valueOf(i));
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Set portion of maximum memory to allocate"));
        jPanel3.add(this.memoryFractionMenu);
        this.runCommentArea = new JTextArea(4, 46);
        AppManager.fixKeyBindings(this.runCommentArea);
        this.runCommentArea.setLineWrap(true);
        this.runCommentArea.setWrapStyleWord(true);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder("Comment (appears in output files)"));
        jPanel4.add(AppManager.createScrollPane(this.runCommentArea));
        JButton jButton = new JButton("Reset");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRunStart.this.doReset();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRunStart.this.doCancel();
            }
        });
        JButton jButton3 = new JButton("Run");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRunStart.this.doOK();
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(jPanel2);
        jPanel5.add(jPanel3);
        jPanel5.add(jPanel4);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel, "Center");
        jPanel6.add((Component)jPanel5, "South");
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.add(jButton);
        JPanel jPanel8 = new JPanel(new FlowLayout(2));
        jPanel8.add(jButton2);
        jPanel8.add(jButton3);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        jPanel9.add(jPanel7);
        jPanel9.add(jPanel8);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel6, "Center");
        container.add((Component)jPanel9, "South");
        this.getRootPane().setDefaultButton(jButton3);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.height = 480;
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.setResizable(true);
        this.setLocationSaved(true);
    }

    @Override
    public String getDbID() {
        return this.parent.getDbID();
    }

    @Override
    public void updateDocumentName() {
        String string = 0 != this.studyKey ? this.parent.getDocumentName() + "/" + this.studyName : this.parent.getDocumentName();
        this.setDocumentName(string);
    }

    public boolean setStudy(int n, ErrorReporter errorReporter) {
        if (this.isVisible()) {
            return false;
        }
        this.runWindow = null;
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        if (!dbConnection.connect(errorReporter)) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        String string2 = String.valueOf(n);
        String string3 = "";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ArrayList<ScenarioListItem> arrayList = null;
        try {
            dbConnection.update("LOCK TABLES tvstudy.study WRITE, tvstudy.version WRITE");
            dbConnection.query("SELECT study.name, version.version, study.study_lock, study.needs_update, study.lock_count, study.share_count FROM tvstudy.study JOIN tvstudy.version WHERE study_key = " + n);
            if (dbConnection.next()) {
                string3 = dbConnection.getString(1);
                string2 = "'" + string3 + "'";
                if (103000 == dbConnection.getInt(2)) {
                    n2 = dbConnection.getInt(3);
                    if (0 == n2 || 3 == n2) {
                        if (!dbConnection.getBoolean(4)) {
                            n3 = dbConnection.getInt(5);
                            n4 = dbConnection.getInt(6);
                            if (0 == n2) {
                                dbConnection.update("UPDATE tvstudy.study SET study_lock = 2, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
                                bl2 = true;
                                n2 = 2;
                                ++n3;
                            } else {
                                dbConnection.update("UPDATE tvstudy.study SET share_count = share_count + 1 WHERE study_key = " + n);
                                bl2 = true;
                                ++n4;
                            }
                            dbConnection.update("UNLOCK TABLES");
                            dbConnection.query("SELECT scenario_key, name, description FROM tvstudy_" + n + ".scenario " + "ORDER BY 1");
                            arrayList = new ArrayList<ScenarioListItem>();
                            while (dbConnection.next()) {
                                ScenarioListItem scenarioListItem = new ScenarioListItem();
                                scenarioListItem.key = dbConnection.getInt(1);
                                scenarioListItem.name = dbConnection.getString(2);
                                scenarioListItem.description = dbConnection.getString(3);
                                arrayList.add(scenarioListItem);
                            }
                        } else {
                            bl = true;
                            string = "The study needs update, it must be opened and saved.";
                            n5 = 2;
                        }
                    } else {
                        bl = true;
                        string = "The study is in use by another application.";
                        n5 = 2;
                    }
                } else {
                    bl = true;
                    string = "The database version is incorrect.";
                }
            } else {
                bl = true;
                string = "The study does not exist.";
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
            dbConnection.reportError(sQLException);
        }
        try {
            if (bl && bl2) {
                if (2 == n2 || --n4 <= 0) {
                    dbConnection.update("UPDATE tvstudy.study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
                } else {
                    dbConnection.update("UPDATE tvstudy.study SET share_count = share_count - 1 WHERE study_key = " + n);
                }
            }
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
        }
        dbConnection.close();
        if (bl) {
            if (null != errorReporter) {
                errorReporter.reportError("Could not run study " + string2 + ":\n" + string, n5);
            }
            return false;
        }
        this.studyKey = n;
        this.studyName = string3;
        this.studyLock = n2;
        this.lockCount = n3;
        this.scenarioListModel.setItems(arrayList);
        this.updateDocumentName();
        AppManager.setComponentEnabled(this.reportOutputMenu, false);
        AppManager.setComponentEnabled(this.csvOutputMenu, false);
        AppManager.setComponentEnabled(this.cellOutputMenu, false);
        AppManager.setComponentEnabled(this.mapOutputMenu, false);
        AppManager.setComponentEnabled(this.pointsOutputMenu, false);
        AppManager.setComponentEnabled(this.paramsOutputMenu, false);
        return true;
    }

    private void doReset() {
        this.scenarioListTable.clearSelection();
        this.reportOutputMenu.setSelectedIndex(1);
        this.csvOutputMenu.setSelectedIndex(0);
        this.cellOutputMenu.setSelectedIndex(0);
        this.mapOutputMenu.setSelectedIndex(0);
        this.pointsOutputMenu.setSelectedIndex(0);
        this.paramsOutputMenu.setSelectedIndex(0);
        this.memoryFractionMenu.setSelectedIndex(0);
        this.runCommentArea.setText("");
    }

    private void doOK() {
        if (!this.isVisible()) {
            return;
        }
        if (this.studyKey > 0) {
            int n = this.memoryFractionMenu.getSelectedIndex() + 1;
            if (DbManager.getTotalMemoryFraction() + 1.0 / (double)n > 1.001) {
                AppManager.beep();
                if (0 != JOptionPane.showConfirmDialog(this, "There are other studies running and starting this one could exceed available\nmemory, severely degrading performance for all runs.  You should wait until\nsome other runs are done, or reduce the memory allocation for the new run.\n\nDo you want to start the new run anyway?", WINDOW_TITLE, 0, 2)) {
                    return;
                }
            }
            DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
            String string = System.getProperty("user.dir");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string + File.separator + "lib" + File.separator + "tvstudy");
            if (AppManager.Debug) {
                arrayList.add("-d");
            }
            arrayList.add("-w");
            arrayList.add(string);
            arrayList.add("-h");
            arrayList.add(dbConnection.hostname);
            arrayList.add("-u");
            arrayList.add(dbConnection.username);
            arrayList.add("-l");
            arrayList.add(String.valueOf(this.lockCount));
            arrayList.add("-m");
            arrayList.add(String.valueOf(n));
            arrayList.add("-f");
            arrayList.add(String.valueOf(this.reportOutputMenu.getSelectedKey()) + String.valueOf(this.csvOutputMenu.getSelectedKey()) + String.valueOf(this.cellOutputMenu.getSelectedKey()) + String.valueOf(this.mapOutputMenu.getSelectedKey()) + String.valueOf(this.pointsOutputMenu.getSelectedKey()) + String.valueOf(this.paramsOutputMenu.getSelectedKey()));
            String string2 = this.runCommentArea.getText().trim();
            if (string2.length() > 0) {
                arrayList.add("-c");
                arrayList.add(string2);
            }
            arrayList.add(String.valueOf(this.studyKey));
            for (int n2 : this.scenarioListTable.getSelectedRows()) {
                arrayList.add(String.valueOf(this.scenarioListModel.get(this.scenarioListTable.convertRowIndexToModel(n2)).key));
            }
            this.runWindow = new StudyRun(this.parent.getDbID(), this.studyKey, this.studyName, this.studyLock, this.lockCount, arrayList, n);
        } else {
            this.runWindow = null;
        }
        this.studyKey = 0;
        this.studyName = null;
        this.studyLock = 0;
        this.lockCount = 0;
        this.scenarioListModel.setItems(null);
        this.canceled = false;
        AppManager.hideWindow(this);
    }

    public StudyRun getRunWindow() {
        StudyRun studyRun = this.runWindow;
        this.runWindow = null;
        return studyRun;
    }

    public boolean cancel() {
        this.doCancel();
        return this.canceled;
    }

    private void doCancel() {
        if (!this.isVisible()) {
            this.canceled = true;
            return;
        }
        if (this.studyKey > 0) {
            Study.unlockStudy(DbManager.getDb(this.parent.getDbID()), new ErrorReporter(this, WINDOW_TITLE), this.studyKey, this.lockCount);
        }
        this.runWindow = null;
        this.studyKey = 0;
        this.studyName = null;
        this.studyLock = 0;
        this.lockCount = 0;
        this.scenarioListModel.setItems(null);
        this.canceled = true;
        AppManager.hideWindow(this);
    }

    @Override
    public void windowWillOpen() {
        this.setLocationRelativeTo(this.parent);
        this.canceled = false;
    }

    @Override
    public boolean windowShouldClose() {
        this.doCancel();
        return true;
    }

    private class ScenarioListTableModel
    extends AbstractTableModel {
        private static final String SCENARIO_NAME_COLUMN = "Name";
        private static final String SCENARIO_DESCRIPTION_COLUMN = "Description";
        private String[] columnNames = new String[]{"Name", "Description"};
        private static final int SCENARIO_NAME_INDEX = 0;
        private static final int SCENARIO_DESCRIPTION_INDEX = 1;
        private ArrayList<ScenarioListItem> modelRows = new ArrayList();

        private ScenarioListTableModel() {
        }

        private JTable createTable() {
            JTable jTable = new JTable(this);
            AppManager.configureTable(jTable);
            jTable.setSelectionMode(2);
            jTable.setAutoCreateRowSorter(true);
            int n = AppManager.getTextFieldWidth(5);
            TableColumn tableColumn = jTable.getColumn(SCENARIO_NAME_COLUMN);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(AppManager.getTextFieldWidth(15));
            tableColumn = jTable.getColumn(SCENARIO_DESCRIPTION_COLUMN);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(AppManager.getTextFieldWidth(30));
            return jTable;
        }

        private void setItems(ArrayList<ScenarioListItem> arrayList) {
            this.modelRows.clear();
            if (null != arrayList) {
                this.modelRows.addAll(arrayList);
            }
            this.fireTableDataChanged();
        }

        private ScenarioListItem get(int n) {
            return this.modelRows.get(n);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.modelRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ScenarioListItem scenarioListItem = this.modelRows.get(n);
            switch (n2) {
                case 0: {
                    return scenarioListItem.name;
                }
                case 1: {
                    return scenarioListItem.description;
                }
            }
            return "";
        }
    }

    private class ScenarioListItem {
        private int key;
        private String name;
        private String description;

        private ScenarioListItem() {
        }
    }
}

