/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.Country;
import gov.fcc.tvstudy.data.EmissionMask;
import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.editdata.IxRuleEditData;
import gov.fcc.tvstudy.editdata.ScenarioEditData;
import gov.fcc.tvstudy.editdata.SourceEditData;
import gov.fcc.tvstudy.editdata.SourceTableModel;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.editor.StudyRun;
import gov.fcc.tvstudy.editor.StudyWindow;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.KeyedRecordMenu;
import gov.fcc.tvstudy.util.ProcessPanel;
import gov.fcc.tvstudy.util.QueryWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class StudyRunPair
extends AppFrame
implements StudyWindow {
    public static final String WINDOW_TITLE = "Pair Study Run";
    private StudyEditData study;
    private ScenarioEditData baselineScenario;
    private KeyedRecordMenu studyCountryMenu;
    private static final int ALL_COUNTRIES = -1;
    private JTextField studyChannelsField;
    private JComboBox runCountMenu;
    private KeyedRecordMenu reportOutputMenu;
    private KeyedRecordMenu csvOutputMenu;
    private KeyedRecordMenu mapOutputMenu;
    private KeyedRecordMenu pointsOutputMenu;
    private KeyedRecordMenu paramsOutputMenu;
    private JTextArea runCommentArea;
    private static final int INFO_LINE_COUNT = 4;
    private String[] infoDescriptions;
    private String[] infoValues;
    private JLabel[] infoDescriptionLabels;
    private JLabel[] infoValueLabels;
    private JTabbedPane tabPane;
    private JLabel statusLabel;
    private JButton advanceButton;
    private JButton cancelButton;
    private JMenuItem advanceMenuItem;
    private JMenuItem cancelMenuItem;
    private static final int MIN_SCENARIOS_PER_RUN = 5;
    private int studyCountry;
    private int[] studyChannels;
    private int runCount;
    private ArrayList<ArrayList<Integer>> scenarioRunLists;
    private String filePath;
    private ArrayList<File> runFiles;
    private ArrayList<File> outFiles;
    private static final int RUN_STATE_SETUP = 0;
    private static final int RUN_STATE_PRERUN = 1;
    private static final int RUN_STATE_RUNNING = 2;
    private static final int RUN_STATE_POSTRUN = 3;
    private static final int RUN_STATE_CLEANUP = 4;
    private static final int RUN_STATE_EXIT = 5;
    private static final int TIMER_INTERVAL = 200;
    private Timer checkRunTimer;
    private int studyRunState;
    private boolean runFailed;
    private ArrayList<ProcessPanel> studyRuns;
    private boolean inQuery;

    public StudyRunPair(StudyEditData studyEditData) {
        super(WINDOW_TITLE);
        this.study = studyEditData;
        this.baselineScenario = this.study.scenarioModel.get(0);
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        this.scenarioRunLists = new ArrayList();
        this.filePath = "out" + File.separator + DbManager.getDbHost(this.study.dbID) + File.separator + this.study.name;
        this.runFiles = new ArrayList();
        this.outFiles = new ArrayList();
        this.studyRuns = new ArrayList();
        this.studyCountryMenu = new KeyedRecordMenu(Country.getCountries(dbConnection));
        this.studyCountryMenu.addItem(new KeyedRecord(-1, "All countries"));
        this.studyChannelsField = new JTextField(20);
        AppManager.fixKeyBindings(this.studyChannelsField);
        this.runCount = Runtime.getRuntime().availableProcessors();
        if (this.runCount < 2) {
            this.runCount = 2;
        }
        this.runCountMenu = new JComboBox();
        for (int i = 1; i <= this.runCount; ++i) {
            this.runCountMenu.addItem(String.valueOf(i));
        }
        JLabel jLabel = new JLabel("Study country");
        JLabel jLabel2 = new JLabel("Study channel(s)");
        JLabel jLabel3 = new JLabel("Maximum number of engine processes");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Pair study settings"));
        GroupLayout groupLayout = new GroupLayout(jPanel);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        jPanel.setLayout(groupLayout);
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup parallelGroup2 = groupLayout.createParallelGroup();
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        parallelGroup.addComponent(jLabel);
        parallelGroup2.addComponent(this.studyCountryMenu);
        sequentialGroup.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.studyCountryMenu));
        parallelGroup.addComponent(jLabel2);
        parallelGroup2.addComponent(this.studyChannelsField);
        sequentialGroup.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.studyChannelsField));
        parallelGroup.addComponent(jLabel3);
        parallelGroup2.addComponent(this.runCountMenu);
        sequentialGroup.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.runCountMenu));
        this.infoDescriptions = new String[4];
        this.infoValues = new String[4];
        this.infoDescriptionLabels = new JLabel[4];
        this.infoValueLabels = new JLabel[4];
        for (int i = 0; i < 4; ++i) {
            this.infoDescriptions[i] = " ";
            this.infoValues[i] = " ";
            this.infoDescriptionLabels[i] = new JLabel(this.infoDescriptions[i]);
            this.infoValueLabels[i] = new JLabel(this.infoValues[i]);
            parallelGroup.addComponent(this.infoDescriptionLabels[i]);
            parallelGroup2.addComponent(this.infoValueLabels[i]);
            sequentialGroup.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.infoDescriptionLabels[i]).addComponent(this.infoValueLabels[i]));
        }
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(parallelGroup).addGroup(parallelGroup2));
        groupLayout.setVerticalGroup(sequentialGroup);
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        arrayList.add(new KeyedRecord(0, "No"));
        arrayList.add(new KeyedRecord(1, "Yes"));
        this.reportOutputMenu = new KeyedRecordMenu(arrayList);
        this.reportOutputMenu.setSelectedIndex(1);
        this.mapOutputMenu = new KeyedRecordMenu(arrayList);
        this.pointsOutputMenu = new KeyedRecordMenu(arrayList);
        arrayList = new ArrayList();
        arrayList.add(new KeyedRecord(0, "No"));
        arrayList.add(new KeyedRecord(1, "Detail"));
        arrayList.add(new KeyedRecord(2, "Summary"));
        this.csvOutputMenu = new KeyedRecordMenu(arrayList);
        arrayList = new ArrayList();
        arrayList.add(new KeyedRecord(0, "No"));
        arrayList.add(new KeyedRecord(1, "Desired only"));
        arrayList.add(new KeyedRecord(2, "All stations"));
        this.paramsOutputMenu = new KeyedRecordMenu(arrayList);
        JLabel jLabel4 = new JLabel("Report");
        JLabel jLabel5 = new JLabel("Report CSV");
        JLabel jLabel6 = new JLabel("Parameters");
        JLabel jLabel7 = new JLabel("Map");
        JLabel jLabel8 = new JLabel("Points");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Baseline study output file options"));
        groupLayout = new GroupLayout(jPanel2);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel4).addComponent(jLabel5).addComponent(jLabel6)).addGroup(groupLayout.createParallelGroup().addComponent(this.reportOutputMenu).addComponent(this.csvOutputMenu).addComponent(this.paramsOutputMenu)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel7).addComponent(jLabel8)).addGroup(groupLayout.createParallelGroup().addComponent(this.mapOutputMenu).addComponent(this.pointsOutputMenu)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(this.reportOutputMenu).addComponent(jLabel7).addComponent(this.mapOutputMenu)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(this.csvOutputMenu).addComponent(jLabel8).addComponent(this.pointsOutputMenu)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel6).addComponent(this.paramsOutputMenu)));
        this.runCommentArea = new JTextArea(4, 46);
        AppManager.fixKeyBindings(this.runCommentArea);
        this.runCommentArea.setLineWrap(true);
        this.runCommentArea.setWrapStyleWord(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Comment (appears in output files)"));
        jPanel3.add(AppManager.createScrollPane(this.runCommentArea));
        this.statusLabel = new JLabel();
        this.statusLabel.setPreferredSize(AppManager.getLabelSize(30));
        this.advanceButton = new JButton("Start");
        this.advanceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRunPair.this.doAdvance();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRunPair.this.doCancel();
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Settings", jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel5.add(this.statusLabel);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)this.tabPane, "Center");
        jPanel6.add((Component)jPanel5, "South");
        JPanel jPanel7 = new JPanel(new FlowLayout(2));
        jPanel7.add(this.cancelButton);
        jPanel7.add(this.advanceButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel6, "Center");
        container.add((Component)jPanel7, "South");
        this.getRootPane().setDefaultButton(this.advanceButton);
        this.pack();
        Dimension dimension = new Dimension(620, 620);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.fileMenu.removeAll();
        this.advanceMenuItem = new JMenuItem("Start");
        this.advanceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRunPair.this.doAdvance();
            }
        });
        this.fileMenu.add(this.advanceMenuItem);
        this.fileMenu.addSeparator();
        this.cancelMenuItem = new JMenuItem("Cancel");
        this.cancelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRunPair.this.doCancel();
            }
        });
        this.fileMenu.add(this.cancelMenuItem);
        this.checkRunTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRunPair.this.checkRuns();
            }
        });
        this.updateDocumentName();
        this.setRunState(0);
    }

    @Override
    public String getFileMenuName() {
        return "Run";
    }

    @Override
    public String getKeyTitle() {
        return "Study " + this.study.study.key + "." + super.getKeyTitle();
    }

    @Override
    public String getDbID() {
        return this.study.dbID;
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(DbManager.getDbHost(this.study.dbID) + "/" + this.study.name);
    }

    @Override
    public int getStudyKey() {
        return this.study.study.key;
    }

    @Override
    public int getStudyLock() {
        return this.study.study.studyLock;
    }

    @Override
    public int getLockCount() {
        return this.study.study.lockCount;
    }

    @Override
    public void toFront() {
        super.toFront();
    }

    private void setRunState(int n) {
        this.studyRunState = n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (n) {
            case 0: {
                bl = true;
                bl2 = true;
                this.advanceButton.setText("Start");
                this.advanceMenuItem.setText("Start");
                bl3 = true;
                break;
            }
            case 1: {
                bl3 = true;
                break;
            }
            case 2: {
                bl3 = true;
                break;
            }
            case 3: {
                bl3 = true;
                break;
            }
            case 4: {
                bl2 = true;
                this.advanceButton.setText("Close");
                this.advanceMenuItem.setText("Close");
                break;
            }
            default: {
                this.studyRunState = 5;
                this.study.invalidate();
                bl2 = true;
                this.advanceButton.setText("Close");
                this.advanceMenuItem.setText("Close");
            }
        }
        AppManager.setComponentEnabled(this.studyCountryMenu, bl);
        AppManager.setComponentEnabled(this.studyChannelsField, bl);
        AppManager.setComponentEnabled(this.runCountMenu, bl);
        AppManager.setComponentEnabled(this.reportOutputMenu, bl);
        AppManager.setComponentEnabled(this.csvOutputMenu, bl);
        AppManager.setComponentEnabled(this.mapOutputMenu, bl);
        AppManager.setComponentEnabled(this.pointsOutputMenu, bl);
        AppManager.setComponentEnabled(this.paramsOutputMenu, bl);
        AppManager.setComponentEnabled(this.runCommentArea, bl);
        this.advanceButton.setEnabled(bl2);
        this.advanceMenuItem.setEnabled(bl2);
        this.cancelButton.setEnabled(bl3);
        this.cancelMenuItem.setEnabled(bl3);
    }

    @Override
    public double getMemoryFraction() {
        switch (this.studyRunState) {
            case 0: 
            case 4: 
            case 5: {
                return 0.0;
            }
        }
        return 1.0;
    }

    private void doAdvance() {
        if (this.inQuery) {
            return;
        }
        ErrorReporter errorReporter = new ErrorReporter(this, WINDOW_TITLE);
        switch (this.studyRunState) {
            case 0: {
                this.doSetup(errorReporter);
                break;
            }
            case 4: {
                this.doCleanup(errorReporter);
            }
            case 5: {
                if (!this.windowShouldClose()) break;
                AppManager.hideWindow(this);
            }
        }
    }

    private void doSetup(ErrorReporter errorReporter) {
        int n;
        Object object;
        if (this.inQuery) {
            return;
        }
        if (!this.study.setStudyParameters(errorReporter)) {
            this.statusLabel.setText("*** Error during study setup ***");
            this.runFailed = true;
            this.setRunState(5);
            return;
        }
        boolean bl = false;
        this.studyCountry = this.studyCountryMenu.getSelectedKey();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        String string = this.studyChannelsField.getText().trim();
        if (string.length() > 0) {
            object = string.split(",");
            n = 0;
            for (String n3 : object) {
                try {
                    n = Integer.parseInt(n3.trim());
                    if (n < this.study.minimumChannel || n > this.study.maximumChannel) {
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                if (!bl) {
                    hashSet.add(new Integer(n));
                    continue;
                }
                break;
            }
        } else {
            bl = true;
        }
        if (bl || hashSet.isEmpty()) {
            errorReporter.reportWarning("Please enter valid channel numbers, use commas to separate multiple channels.");
            return;
        }
        this.studyChannels = new int[hashSet.size()];
        object = hashSet.iterator();
        n = 0;
        while (object.hasNext()) {
            this.studyChannels[n++] = (Integer)object.next();
        }
        this.runCount = this.runCountMenu.getSelectedIndex() + 1;
        if (this.runCount < 1) {
            this.runCount = 1;
        }
        if (DbManager.getTotalMemoryFraction() > 0.0) {
            AppManager.beep();
            if (0 != JOptionPane.showConfirmDialog(this, "There are other studies running and starting this one could\nexceed available memory, severely degrading performance for\nall runs.  You should wait until all other runs are done.\n\nDo you want to start the new run anyway?", WINDOW_TITLE, 0, 2)) {
                return;
            }
        }
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        QueryWorker<Integer> queryWorker = new QueryWorker<Integer>((Window)this, WINDOW_TITLE, dbConnection){

            @Override
            protected Integer doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                int n = StudyRunPair.this.createStudyScenarios(dbConnection, errorReporter);
                if (n <= 0) {
                    return new Integer(n);
                }
                StudyRunPair.this.study.isDataChanged();
                if (!StudyRunPair.this.study.save(dbConnection, errorReporter)) {
                    return new Integer(-1);
                }
                return new Integer(n);
            }
        };
        this.inQuery = true;
        Integer n2 = (Integer)queryWorker.runQuery("Configuring study, please wait...", errorReporter);
        int n3 = -1;
        if (null != n2) {
            n3 = n2;
        }
        this.inQuery = false;
        if (n3 <= 0) {
            if (0 == n3) {
                errorReporter.reportWarning("No station pairs found.");
                this.statusLabel.setText("*** No station pairs found ***");
            } else {
                this.statusLabel.setText("*** Error during study setup ***");
            }
            this.runFailed = true;
            this.setRunState(5);
            return;
        }
        this.checkRunTimer.start();
        this.startPrerun();
    }

    private int createStudyScenarios(DbConnection dbConnection, ErrorReporter errorReporter) {
        ScenarioSortItem scenarioSortItem2;
        ScenarioEditData scenarioEditData;
        SourceEditData sourceEditData;
        IxRuleEditData ixRuleEditData;
        int n;
        int n2;
        boolean bl;
        double d;
        int n3;
        int n4;
        int n5;
        SourceEditData sourceEditData2;
        boolean bl2;
        int n6;
        int n7;
        int n8;
        SourceEditData sourceEditData3;
        SourceEditData sourceEditData4;
        int n9;
        if (null == this.studyChannels) {
            return -1;
        }
        ArrayList<SourceEditData> arrayList = this.baselineScenario.sourceModel.getDesiredSources();
        ArrayList<IxRuleEditData> arrayList2 = new ArrayList<IxRuleEditData>();
        for (IxRuleEditData ixRuleEditData2 : this.study.ixRuleModel.getRows()) {
            if (!ixRuleEditData2.isActive || !ixRuleEditData2.serviceType.digital || !ixRuleEditData2.undesiredServiceType.digital || ixRuleEditData2.channelDelta.delta < -1 || ixRuleEditData2.channelDelta.delta > 1) continue;
            arrayList2.add(ixRuleEditData2);
        }
        this.scenarioRunLists.clear();
        double d2 = 999.0;
        double d3 = -999.0;
        double d4 = 999.0;
        double d5 = -999.0;
        for (SourceEditData object22 : arrayList) {
            if (object22.latitude < d2) {
                d2 = object22.latitude;
            }
            if (object22.latitude > d3) {
                d3 = object22.latitude;
            }
            if (object22.longitude < d4) {
                d4 = object22.longitude;
            }
            if (!(object22.longitude > d5)) continue;
            d5 = object22.longitude;
        }
        boolean bl3 = false;
        if (d3 - d2 > d5 - d4) {
            bl3 = true;
        }
        TreeSet<ScenarioSortItem> treeSet = new TreeSet<ScenarioSortItem>();
        int n10 = this.study.maximumChannel - this.study.minimumChannel + 1;
        ArrayList arrayList3 = new ArrayList(n10);
        for (n9 = 0; n9 < n10; ++n9) {
            arrayList3.add(new HashMap());
        }
        n9 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        ArrayList<SourceTableModel.SourceItem> arrayList4 = new ArrayList<SourceTableModel.SourceItem>();
        for (SourceEditData n17 : arrayList) {
            if (this.studyCountry != n17.country.key && -1 != this.studyCountry) continue;
            if (null == n17.originalSourceKey) {
                sourceEditData4 = n17;
            } else {
                sourceEditData4 = this.study.getSource(n17.originalSourceKey);
                if (null == sourceEditData4) {
                    errorReporter.reportError("An original record needed for replication does not exist.\nThis should never happen; the study database is damaged.");
                    return -1;
                }
            }
            boolean bl4 = true;
            for (int n14 : this.studyChannels) {
                if (n14 == sourceEditData4.channel && sourceEditData4.service.serviceType.digital) {
                    sourceEditData3 = sourceEditData4;
                } else {
                    sourceEditData3 = null;
                    sourceEditData3 = sourceEditData4.isLocked && null != sourceEditData4.application_id ? this.study.findSharedReplicationSource(sourceEditData4.application_id, n14) : (SourceEditData)((HashMap)arrayList3.get(n14 - this.study.minimumChannel)).get(sourceEditData4.key);
                    if (null == sourceEditData3) {
                        sourceEditData3 = sourceEditData4.replicate(n14, errorReporter);
                        if (null == sourceEditData3) {
                            return -1;
                        }
                        this.study.addOrReplaceSource(sourceEditData3);
                        if (!sourceEditData4.isLocked || null == sourceEditData4.application_id) {
                            ((HashMap)arrayList3.get(n14 - this.study.minimumChannel)).put(sourceEditData4.key, sourceEditData3);
                        }
                    }
                }
                arrayList4.add(new SourceTableModel.SourceItem(sourceEditData3, true, false));
                n8 = sourceEditData3.service.serviceType.key;
                n7 = sourceEditData3.country.key;
                n6 = sourceEditData3.frequencyOffset.key;
                bl2 = bl4;
                for (SourceEditData sourceEditData5 : arrayList) {
                    if (sourceEditData5.facility_id == sourceEditData3.facility_id) continue;
                    if (null == sourceEditData5.originalSourceKey) {
                        sourceEditData2 = sourceEditData5;
                    } else {
                        sourceEditData2 = this.study.getSource(sourceEditData5.originalSourceKey);
                        if (null == sourceEditData2) {
                            errorReporter.reportError("An original record needed for replication does not exist.\nThis should never happen; the study database is damaged.");
                            return -1;
                        }
                    }
                    if (sourceEditData2.service.serviceType.digital) {
                        n5 = sourceEditData2.service.serviceType.key;
                        n4 = sourceEditData2.frequencyOffset.key;
                        n3 = sourceEditData2.emissionMask.key;
                    } else {
                        n5 = sourceEditData2.service.digitalService.serviceType.key;
                        n4 = 0;
                        n3 = sourceEditData2.service.digitalService.serviceType.needsEmissionMask ? EmissionMask.getDefaultObject((DbConnection)dbConnection).key : 0;
                    }
                    d = this.distanceBetween(sourceEditData3, sourceEditData2);
                    bl = bl4;
                    for (n2 = -1; n2 <= 1; ++n2) {
                        n = n14 + n2;
                        if (n < this.study.minimumChannel || n > this.study.maximumChannel || (n14 < 5 ? n > 4 : (n14 < 7 ? n < 5 || n > 6 : n14 < 14 && (n < 7 || n > 13)))) continue;
                        ixRuleEditData = null;
                        for (IxRuleEditData ixRuleEditData3 : arrayList2) {
                            if (ixRuleEditData3.country.key != n7 || ixRuleEditData3.serviceType.key != n8 || ixRuleEditData3.undesiredServiceType.key != n5 || n2 != ixRuleEditData3.channelDelta.delta || n14 < ixRuleEditData3.channelBand.firstChannel || n14 > ixRuleEditData3.channelBand.lastChannel || 2 == ixRuleEditData3.frequencyOffset && (0 == n6 || 0 == n4 || n6 == n4) || 1 == ixRuleEditData3.frequencyOffset && 0 != n6 && 0 != n4 && n6 != n4 || 0 != ixRuleEditData3.emissionMask.key && (0 == n3 || ixRuleEditData3.emissionMask.key != n3)) continue;
                            ixRuleEditData = ixRuleEditData3;
                            break;
                        }
                        if (null == ixRuleEditData || d > ixRuleEditData.distance + this.study.ruleExtraDistance) continue;
                        if (bl2) {
                            ++n9;
                            bl2 = false;
                        }
                        if (bl) {
                            ++n11;
                            bl = false;
                        }
                        if (n == sourceEditData2.channel && sourceEditData2.service.serviceType.digital) {
                            sourceEditData = sourceEditData2;
                        } else {
                            sourceEditData = null;
                            sourceEditData = sourceEditData2.isLocked && null != sourceEditData2.application_id ? this.study.findSharedReplicationSource(sourceEditData2.application_id, n) : (SourceEditData)((HashMap)arrayList3.get(n - this.study.minimumChannel)).get(sourceEditData2.key);
                            if (null == sourceEditData) {
                                sourceEditData = sourceEditData2.replicate(n, errorReporter);
                                if (null == sourceEditData) {
                                    return -1;
                                }
                                this.study.addOrReplaceSource(sourceEditData);
                                if (!sourceEditData2.isLocked || null == sourceEditData2.application_id) {
                                    ((HashMap)arrayList3.get(n - this.study.minimumChannel)).put(sourceEditData2.key, sourceEditData);
                                }
                            }
                        }
                        arrayList4.add(new SourceTableModel.SourceItem(sourceEditData, false, true));
                    }
                }
                if (arrayList4.size() > 1) {
                    scenarioEditData = new ScenarioEditData(this.study, "Pair", "Pair study", arrayList4);
                    this.study.scenarioModel.addOrReplace(scenarioEditData);
                    scenarioSortItem2 = new ScenarioSortItem(scenarioEditData, sourceEditData3, bl3);
                    treeSet.add(scenarioSortItem2);
                    ++n12;
                    n13 += scenarioSortItem2.sourceCount;
                }
                arrayList4.clear();
                bl4 = false;
            }
        }
        for (SourceEditData n17 : arrayList) {
            if (this.studyCountry == n17.country.key || -1 == this.studyCountry) continue;
            int arrayList5 = n17.channel;
            if (n17.service.serviceType.digital) {
                sourceEditData3 = n17;
            } else {
                if (null == n17.originalSourceKey) {
                    sourceEditData4 = n17;
                } else {
                    sourceEditData4 = this.study.getSource(n17.originalSourceKey);
                    if (null == sourceEditData4) {
                        errorReporter.reportError("An original record needed for replication does not exist.\nThis should never happen; the study database is damaged.");
                        return -1;
                    }
                }
                sourceEditData3 = null;
                sourceEditData3 = sourceEditData4.isLocked && null != sourceEditData4.application_id ? this.study.findSharedReplicationSource(sourceEditData4.application_id, arrayList5) : (SourceEditData)((HashMap)arrayList3.get(arrayList5 - this.study.minimumChannel)).get(sourceEditData4.key);
                if (null == sourceEditData3) {
                    sourceEditData3 = sourceEditData4.replicate(arrayList5, errorReporter);
                    if (null == sourceEditData3) {
                        return -1;
                    }
                    this.study.addOrReplaceSource(sourceEditData3);
                    if (!sourceEditData4.isLocked || null == sourceEditData4.application_id) {
                        ((HashMap)arrayList3.get(arrayList5 - this.study.minimumChannel)).put(sourceEditData4.key, sourceEditData3);
                    }
                }
            }
            arrayList4.add(new SourceTableModel.SourceItem(sourceEditData3, true, false));
            n8 = sourceEditData3.service.serviceType.key;
            n7 = sourceEditData3.country.key;
            n6 = sourceEditData3.frequencyOffset.key;
            bl2 = true;
            for (SourceEditData sourceEditData6 : arrayList) {
                if (this.studyCountry != sourceEditData6.country.key) continue;
                if (null == sourceEditData6.originalSourceKey) {
                    sourceEditData2 = sourceEditData6;
                } else {
                    sourceEditData2 = this.study.getSource(sourceEditData6.originalSourceKey);
                    if (null == sourceEditData2) {
                        errorReporter.reportError("An original record needed for replication does not exist.\nThis should never happen; the study database is damaged.");
                        return -1;
                    }
                }
                if (sourceEditData2.service.serviceType.digital) {
                    n5 = sourceEditData2.service.serviceType.key;
                    n4 = sourceEditData2.frequencyOffset.key;
                    n3 = sourceEditData2.emissionMask.key;
                } else {
                    n5 = sourceEditData2.service.digitalService.serviceType.key;
                    n4 = 0;
                    n3 = sourceEditData2.service.digitalService.serviceType.needsEmissionMask ? EmissionMask.getDefaultObject((DbConnection)dbConnection).key : 0;
                }
                d = this.distanceBetween(sourceEditData3, sourceEditData2);
                bl = true;
                for (n2 = -1; n2 <= 1; ++n2) {
                    n = arrayList5 + n2;
                    if (n < this.study.minimumChannel || n > this.study.maximumChannel || (arrayList5 < 5 ? n > 4 : (arrayList5 < 7 ? n < 5 || n > 6 : arrayList5 < 14 && (n < 7 || n > 13)))) continue;
                    ixRuleEditData = null;
                    for (IxRuleEditData ixRuleEditData4 : arrayList2) {
                        if (ixRuleEditData4.country.key != n7 || ixRuleEditData4.serviceType.key != n8 || ixRuleEditData4.undesiredServiceType.key != n5 || n2 != ixRuleEditData4.channelDelta.delta || arrayList5 < ixRuleEditData4.channelBand.firstChannel || arrayList5 > ixRuleEditData4.channelBand.lastChannel || 2 == ixRuleEditData4.frequencyOffset && (0 == n6 || 0 == n4 || n6 == n4) || 1 == ixRuleEditData4.frequencyOffset && 0 != n6 && 0 != n4 && n6 != n4 || 0 != ixRuleEditData4.emissionMask.key && (0 == n3 || ixRuleEditData4.emissionMask.key != n3)) continue;
                        ixRuleEditData = ixRuleEditData4;
                        break;
                    }
                    if (null == ixRuleEditData || d > ixRuleEditData.distance + this.study.ruleExtraDistance) continue;
                    if (bl2) {
                        ++n9;
                        bl2 = false;
                    }
                    if (bl) {
                        ++n11;
                        bl = false;
                    }
                    if (n == sourceEditData2.channel && sourceEditData2.service.serviceType.digital) {
                        sourceEditData = sourceEditData2;
                    } else {
                        sourceEditData = null;
                        sourceEditData = sourceEditData2.isLocked && null != sourceEditData2.application_id ? this.study.findSharedReplicationSource(sourceEditData2.application_id, n) : (SourceEditData)((HashMap)arrayList3.get(n - this.study.minimumChannel)).get(sourceEditData2.key);
                        if (null == sourceEditData) {
                            sourceEditData = sourceEditData2.replicate(n, errorReporter);
                            if (null == sourceEditData) {
                                return -1;
                            }
                            this.study.addOrReplaceSource(sourceEditData);
                            if (!sourceEditData2.isLocked || null == sourceEditData2.application_id) {
                                ((HashMap)arrayList3.get(n - this.study.minimumChannel)).put(sourceEditData2.key, sourceEditData);
                            }
                        }
                    }
                    arrayList4.add(new SourceTableModel.SourceItem(sourceEditData, false, true));
                }
            }
            if (arrayList4.size() > 1) {
                scenarioEditData = new ScenarioEditData(this.study, "Pair", "Pair study", arrayList4);
                this.study.scenarioModel.addOrReplace(scenarioEditData);
                scenarioSortItem2 = new ScenarioSortItem(scenarioEditData, sourceEditData3, bl3);
                treeSet.add(scenarioSortItem2);
                ++n12;
                n13 += scenarioSortItem2.sourceCount;
            }
            arrayList4.clear();
        }
        if (n12 > 0) {
            int n15 = n12 / 5;
            if (n15 < 1) {
                n15 = 1;
            }
            if (n15 < this.runCount) {
                this.runCount = n15;
            }
            int n16 = 0;
            ArrayList<Integer> arrayList5 = null;
            for (ScenarioSortItem scenarioSortItem2 : treeSet) {
                if (n16 <= 0) {
                    arrayList5 = new ArrayList<Integer>();
                    this.scenarioRunLists.add(arrayList5);
                    n16 = this.scenarioRunLists.size() < this.runCount ? n13 / this.runCount : n13;
                }
                arrayList5.add(scenarioSortItem2.key);
                n16 -= scenarioSortItem2.sourceCount;
            }
        }
        this.infoDescriptions[0] = "Stations in baseline scenario";
        this.infoValues[0] = AppManager.formatCount(arrayList.size());
        this.infoDescriptions[1] = "Stations involved in pairs";
        this.infoValues[1] = AppManager.formatCount(n9);
        this.infoDescriptions[2] = "Unique pairs to be studied";
        this.infoValues[2] = AppManager.formatCount(n11);
        this.infoDescriptions[3] = "Pair study scenarios";
        this.infoValues[3] = AppManager.formatCount(n12);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 4; ++i) {
                    StudyRunPair.this.infoDescriptionLabels[i].setText(StudyRunPair.this.infoDescriptions[i]);
                    StudyRunPair.this.infoValueLabels[i].setText(StudyRunPair.this.infoValues[i]);
                }
            }
        });
        return n12;
    }

    private double distanceBetween(SourceEditData sourceEditData, SourceEditData sourceEditData2) {
        double d;
        if (sourceEditData.isParent && this.study.checkIndividualDTSDistance) {
            d = 9999.0;
            for (SourceEditData sourceEditData3 : sourceEditData.getDTSSources()) {
                double d2;
                if (sourceEditData2.isParent) {
                    for (SourceEditData sourceEditData4 : sourceEditData2.getDTSSources()) {
                        d2 = AppManager.computeDistance(sourceEditData3.latitude, sourceEditData3.longitude, sourceEditData4.latitude, sourceEditData4.longitude, this.study.kilometersPerDegree);
                        if (!(d2 < d)) continue;
                        d = d2;
                    }
                    continue;
                }
                d2 = AppManager.computeDistance(sourceEditData3.latitude, sourceEditData3.longitude, sourceEditData2.latitude, sourceEditData2.longitude, this.study.kilometersPerDegree);
                if (!(d2 < d)) continue;
                d = d2;
            }
        } else if (sourceEditData2.isParent && this.study.checkIndividualDTSDistance) {
            d = 9999.0;
            for (SourceEditData sourceEditData5 : sourceEditData2.getDTSSources()) {
                double d3 = AppManager.computeDistance(sourceEditData.latitude, sourceEditData.longitude, sourceEditData5.latitude, sourceEditData5.longitude, this.study.kilometersPerDegree);
                if (!(d3 < d)) continue;
                d = d3;
            }
        } else {
            d = AppManager.computeDistance(sourceEditData.latitude, sourceEditData.longitude, sourceEditData2.latitude, sourceEditData2.longitude, this.study.kilometersPerDegree);
        }
        return d;
    }

    private void checkRuns() {
        Iterator<ProcessPanel> iterator = this.studyRuns.iterator();
        while (iterator.hasNext()) {
            ProcessPanel processPanel = iterator.next();
            if (processPanel.pollProcess()) continue;
            iterator.remove();
            if (!processPanel.didProcessFail()) continue;
            this.runFailed = true;
        }
        if (!this.studyRuns.isEmpty()) {
            return;
        }
        if (!this.runFailed) {
            switch (this.studyRunState) {
                case 1: {
                    this.startRunning();
                    return;
                }
                case 2: {
                    this.startPostrun();
                    return;
                }
            }
        }
        this.setRunState(4);
        this.checkRunTimer.stop();
        if (this.runFailed) {
            this.statusLabel.setText("*** Study failed ***");
        } else {
            this.statusLabel.setText("Study complete");
        }
        for (File file : this.runFiles) {
            file.delete();
        }
        for (File file : this.outFiles) {
            file.delete();
        }
    }

    private void startPrerun() {
        this.setRunState(1);
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        boolean bl = false;
        String string = "";
        if (dbConnection.connect()) {
            try {
                dbConnection.update("LOCK TABLES tvstudy.study WRITE");
                dbConnection.query("SELECT study_lock, lock_count FROM tvstudy.study WHERE study_key = " + this.study.study.key);
                if (dbConnection.next()) {
                    if (dbConnection.getInt(1) == this.study.study.studyLock && dbConnection.getInt(2) == this.study.study.lockCount) {
                        dbConnection.update("UPDATE tvstudy.study SET study_lock = 2, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + this.study.study.key);
                        this.study.study.studyLock = 2;
                        ++this.study.study.lockCount;
                    } else {
                        bl = true;
                        string = "*** The study lock was modified ***";
                    }
                } else {
                    bl = true;
                    string = "*** The study was deleted ***";
                }
            }
            catch (SQLException sQLException) {
                bl = true;
                string = "*** Error - " + sQLException + " ***";
                dbConnection.reportError(sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close();
        } else {
            bl = true;
            string = "*** Could not open database connection ***";
        }
        if (bl) {
            this.runFailed = true;
            this.setRunState(4);
            this.checkRunTimer.stop();
            this.statusLabel.setText(string);
            return;
        }
        String string2 = String.valueOf(this.study.study.lockCount);
        this.outFiles.add(new File(this.filePath, "outtemp_" + string2 + "_0"));
        String string3 = System.getProperty("user.dir");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3 + File.separator + "lib" + File.separator + "tvstudy");
        if (AppManager.Debug) {
            arrayList.add("-d");
        }
        arrayList.add("-w");
        arrayList.add(string3);
        arrayList.add("-h");
        arrayList.add(dbConnection.hostname);
        arrayList.add("-u");
        arrayList.add(dbConnection.username);
        arrayList.add("-l");
        arrayList.add(string2);
        arrayList.add("-k");
        arrayList.add("-n");
        arrayList.add(string2);
        arrayList.add("-f");
        arrayList.add(String.valueOf(this.reportOutputMenu.getSelectedKey()) + String.valueOf(this.csvOutputMenu.getSelectedKey()) + "3" + String.valueOf(this.mapOutputMenu.getSelectedKey()) + String.valueOf(this.pointsOutputMenu.getSelectedKey()) + String.valueOf(this.paramsOutputMenu.getSelectedKey()));
        String string4 = this.runCommentArea.getText().trim();
        if (string4.length() > 0) {
            string4 = "\n" + string4;
        }
        string4 = "Pair study baseline run\nStudy country: " + this.studyCountryMenu.getSelectedName() + "\nStudy channels: " + this.studyChannelsField.getText().trim() + string4;
        arrayList.add("-c");
        arrayList.add(string4);
        arrayList.add(String.valueOf(this.study.study.key));
        arrayList.add(String.valueOf(this.baselineScenario.key));
        ProcessPanel processPanel = new ProcessPanel("Study", arrayList, dbConnection.password, StudyRun.mergeLineStrings);
        this.studyRuns.add(processPanel);
        this.tabPane.add("Baseline", processPanel);
        this.statusLabel.setText("Running baseline scenario");
        DbManager.getStudyListEditor(this.study.dbID).studyWasChanged(this.study.study.key);
    }

    private void startRunning() {
        this.setRunState(2);
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        boolean bl = false;
        String string = "";
        if (dbConnection.connect()) {
            try {
                dbConnection.update("LOCK TABLES tvstudy.study WRITE");
                dbConnection.query("SELECT study_lock, lock_count FROM tvstudy.study WHERE study_key = " + this.study.study.key);
                if (dbConnection.next()) {
                    if (dbConnection.getInt(1) == this.study.study.studyLock && dbConnection.getInt(2) == this.study.study.lockCount) {
                        dbConnection.update("UPDATE tvstudy.study SET study_lock = 3, lock_count = lock_count + 1, share_count = 1 WHERE study_key = " + this.study.study.key);
                        this.study.study.studyLock = 3;
                        ++this.study.study.lockCount;
                    } else {
                        bl = true;
                        string = "*** The study lock was modified ***";
                    }
                } else {
                    bl = true;
                    string = "*** The study was deleted ***";
                }
            }
            catch (SQLException sQLException) {
                bl = true;
                string = "*** Error - " + sQLException + " ***";
                dbConnection.reportError(sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close();
        } else {
            bl = true;
            string = "*** Could not open database connection ***";
        }
        if (!bl) {
            String string2 = System.getProperty("user.dir");
            String object = String.valueOf(this.study.study.lockCount);
            String string3 = String.valueOf(this.runCount);
            for (int i = 0; i < this.runCount; ++i) {
                ArrayList<Integer> arrayList = this.scenarioRunLists.get(i);
                if (arrayList.isEmpty()) continue;
                String string4 = String.valueOf(this.study.study.lockCount * this.runCount + i);
                String string5 = this.filePath + File.separator + "runfile_" + string4;
                File file = new File(string5);
                this.runFiles.add(file);
                this.outFiles.add(new File(this.filePath, "outtemp_" + string4 + "_0"));
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                    bufferedWriter.write("study=" + this.study.study.key + "\n");
                    for (Integer n : arrayList) {
                        bufferedWriter.write("scenario=" + n + "\nrun\n");
                    }
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    bl = true;
                    string = "*** Could not create run control file ***";
                    break;
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add((String)string2 + File.separator + "lib" + File.separator + "tvstudy");
                if (AppManager.Debug) {
                    arrayList2.add("-d");
                }
                arrayList2.add("-w");
                arrayList2.add(string2);
                arrayList2.add("-h");
                arrayList2.add(dbConnection.hostname);
                arrayList2.add("-u");
                arrayList2.add(dbConnection.username);
                arrayList2.add("-l");
                arrayList2.add(object);
                arrayList2.add("-k");
                arrayList2.add("-n");
                arrayList2.add(string4);
                arrayList2.add("-x");
                arrayList2.add("-m");
                arrayList2.add(string3);
                arrayList2.add("-f");
                arrayList2.add("003000");
                arrayList2.add("-r");
                arrayList2.add(string5);
                ProcessPanel processPanel = new ProcessPanel("Study", arrayList2, dbConnection.password, StudyRun.mergeLineStrings);
                this.studyRuns.add(processPanel);
            }
        }
        if (bl) {
            this.runFailed = true;
            this.setRunState(4);
            this.checkRunTimer.stop();
            for (ProcessPanel processPanel : this.studyRuns) {
                processPanel.killProcess(false);
            }
            this.studyRuns.clear();
            this.statusLabel.setText(string);
            return;
        }
        int n = 1;
        for (ProcessPanel processPanel : this.studyRuns) {
            this.tabPane.add("Run " + n++, processPanel);
        }
        this.statusLabel.setText("Running pair study scenarios");
        DbManager.getStudyListEditor(this.study.dbID).studyWasChanged(this.study.study.key);
    }

    private void startPostrun() {
        this.setRunState(3);
        boolean bl = false;
        String string = null;
        int n = 0;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.filePath, "stations.csv")));
            for (SourceTableModel.SourceItem object2 : this.baselineScenario.sourceModel.getRows()) {
                if (!object2.isDesired && !object2.isUndesired) continue;
                if (object2.source.facility_id > n) {
                    n = object2.source.facility_id;
                }
                int n2 = object2.isDesired ? 1 : 0;
                int n3 = object2.isUndesired ? 1 : 0;
                bufferedWriter.write(String.format("%d,%d,%d,%d,%s,\"%s\",\"%s\",%s,%s,%s,\"%s\",%f,%f\n", object2.source.facility_id, object2.source.channel, n2, n3, object2.source.service.serviceCode, object2.source.callSign, object2.source.city, object2.source.state, object2.source.country.countryCode, object2.source.status, object2.source.fileNumber, object2.source.latitude, object2.source.longitude));
            }
        }
        catch (IOException iOException) {
            bl = true;
            string = "*** Error - " + iOException + " ***";
        }
        if (null != bufferedWriter) {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl) {
            this.runFailed = true;
            this.setRunState(4);
            this.checkRunTimer.stop();
            this.statusLabel.setText(string);
            return;
        }
        String string2 = System.getProperty("user.dir");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2 + File.separator + "lib" + File.separator + "pair_study_post");
        arrayList.add(string2 + File.separator + this.filePath);
        arrayList.add(String.valueOf(n));
        for (File file : this.outFiles) {
            arrayList.add(file.getName());
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add("Completed ");
        ProcessPanel processPanel = new ProcessPanel("Process", arrayList, null, arrayList2);
        this.studyRuns.add(processPanel);
        this.tabPane.add("Post", processPanel);
        this.statusLabel.setText("Post-processing study results");
        DbManager.getStudyListEditor(this.study.dbID).studyWasChanged(this.study.study.key);
    }

    private void doCleanup(ErrorReporter errorReporter) {
        if (this.inQuery) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        QueryWorker<Boolean> queryWorker = new QueryWorker<Boolean>((Window)this, WINDOW_TITLE, dbConnection){

            @Override
            protected Boolean doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                boolean bl = false;
                String string = "";
                if (dbConnection.connect(errorReporter)) {
                    try {
                        dbConnection.update("LOCK TABLES tvstudy.study WRITE");
                        dbConnection.query("SELECT study_lock, lock_count FROM tvstudy.study WHERE study_key = " + ((StudyRunPair)StudyRunPair.this).study.study.key);
                        if (dbConnection.next()) {
                            if (dbConnection.getInt(1) == ((StudyRunPair)StudyRunPair.this).study.study.studyLock && dbConnection.getInt(2) == ((StudyRunPair)StudyRunPair.this).study.study.lockCount) {
                                dbConnection.update("UPDATE tvstudy.study SET study_lock = 1, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + ((StudyRunPair)StudyRunPair.this).study.study.key);
                                ((StudyRunPair)StudyRunPair.this).study.study.studyLock = 1;
                                ++((StudyRunPair)StudyRunPair.this).study.study.lockCount;
                            } else {
                                bl = true;
                                string = "The study lock was modified.";
                            }
                        } else {
                            bl = true;
                            string = "The study was deleted.";
                        }
                    }
                    catch (SQLException sQLException) {
                        bl = true;
                        string = "An operation cannot be completed due to a database error:\n" + sQLException;
                        dbConnection.reportError(sQLException);
                    }
                    try {
                        dbConnection.update("UNLOCK TABLES");
                    }
                    catch (SQLException sQLException) {
                        dbConnection.reportError(sQLException);
                    }
                    if (!bl) {
                        try {
                            dbConnection.update("USE tvstudy_" + ((StudyRunPair)StudyRunPair.this).study.study.key);
                            dbConnection.update("DELETE FROM scenario_source WHERE scenario_key <> " + ((StudyRunPair)StudyRunPair.this).baselineScenario.key);
                            dbConnection.update("DELETE FROM scenario WHERE scenario_key <> " + ((StudyRunPair)StudyRunPair.this).baselineScenario.key);
                        }
                        catch (SQLException sQLException) {
                            bl = true;
                            string = "An operation cannot be completed due to a database error:\n" + sQLException;
                            dbConnection.reportError(sQLException);
                        }
                    }
                    dbConnection.close();
                    if (bl) {
                        errorReporter.reportError("Could not restore the study database:\n" + string);
                    }
                } else {
                    bl = true;
                }
                return new Boolean(bl);
            }
        };
        this.inQuery = true;
        queryWorker.runQuery("Restoring study database, please wait...", errorReporter);
        this.inQuery = false;
        this.setRunState(5);
        DbManager.getStudyListEditor(this.study.dbID).studyWasChanged(this.study.study.key);
    }

    private void doCancel() {
        if (this.inQuery) {
            return;
        }
        switch (this.studyRunState) {
            case 0: {
                if (!this.windowShouldClose()) break;
                AppManager.hideWindow(this);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                AppManager.beep();
                Object[] objectArray = new String[]{"No", "Yes"};
                if (1 != JOptionPane.showOptionDialog(this, "This will terminate all study runs and cancel all\ndata processing, no output files will be created.\n\nAre you sure you want to cancel the study?", "Cancel Study", 0, 2, null, objectArray, objectArray[0])) break;
                for (ProcessPanel processPanel : this.studyRuns) {
                    processPanel.killProcess(false);
                }
                break;
            }
        }
    }

    @Override
    public boolean closeWithoutSave() {
        if (this.inQuery) {
            return false;
        }
        if (0 != this.studyRunState && 5 != this.studyRunState) {
            return false;
        }
        if (this.studyRunState != 5) {
            this.setRunState(5);
        }
        DbManager.getStudyListEditor(this.study.dbID).studyWindowClosed(this);
        AppManager.hideWindow(this);
        return true;
    }

    @Override
    public void windowWillOpen() {
        this.studyChannelsField.requestFocusInWindow();
    }

    @Override
    public boolean windowShouldClose() {
        if (this.inQuery) {
            return false;
        }
        if (0 != this.studyRunState && 5 != this.studyRunState) {
            AppManager.showMessage(this, "This window can't be closed while the study is running.", WINDOW_TITLE, 1);
            return false;
        }
        if (this.studyRunState != 5) {
            this.setRunState(5);
        }
        DbManager.getStudyListEditor(this.study.dbID).studyWindowClosed(this);
        return true;
    }

    private class ScenarioSortItem
    implements Comparable {
        private Integer key;
        private double coordinate;
        private int sourceCount;

        private ScenarioSortItem(ScenarioEditData scenarioEditData, SourceEditData sourceEditData, boolean bl) {
            this.key = scenarioEditData.key;
            this.coordinate = bl ? sourceEditData.latitude : sourceEditData.longitude;
            this.sourceCount = scenarioEditData.sourceModel.getRowCount();
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            return null != object && this.key.equals(((ScenarioSortItem)object).key);
        }

        public int compareTo(Object object) {
            if (null == object) {
                return 0;
            }
            ScenarioSortItem scenarioSortItem = (ScenarioSortItem)object;
            if (this.coordinate < scenarioSortItem.coordinate) {
                return -1;
            }
            if (this.coordinate > scenarioSortItem.coordinate) {
                return 1;
            }
            return this.key.compareTo(scenarioSortItem.key);
        }
    }
}

