/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.editor.StudyWindow;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ProcessPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class StudyRun
extends AppFrame
implements StudyWindow {
    public static final String WINDOW_TITLE = "Study Run";
    public static ArrayList<String> mergeLineStrings = new ArrayList();
    private String dbID;
    private int studyKey;
    private String studyName;
    private int studyLock;
    private int lockCount;
    private int memoryFraction;
    private ProcessPanel processPanel;
    private JButton killButton;
    private JButton saveButton;
    private JButton okButton;
    private JMenuItem killMenuItem;
    private JMenuItem saveMenuItem;
    private static final int TIMER_INTERVAL = 200;
    private Timer checkTimer;

    public StudyRun(String string, int n, String string2, int n2, int n3, ArrayList<String> arrayList, int n4) {
        super(WINDOW_TITLE);
        this.dbID = string;
        this.studyKey = n;
        this.studyName = string2;
        this.studyLock = n2;
        this.lockCount = n3;
        this.memoryFraction = n4;
        this.processPanel = new ProcessPanel("Study", arrayList, DbManager.getDb((String)this.dbID).password, mergeLineStrings);
        this.killButton = new JButton("Cancel");
        this.killButton.setFocusable(false);
        this.killButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRun.this.doCancel();
            }
        });
        this.saveButton = new JButton("Save Output");
        this.saveButton.setFocusable(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRun.this.doSaveOutput();
            }
        });
        this.saveButton.setEnabled(false);
        this.okButton = new JButton("Close");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRun.this.doOK();
            }
        });
        this.okButton.setEnabled(false);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.killButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.saveButton);
        jPanel2.add(this.okButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.processPanel, "Center");
        container.add((Component)jPanel3, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        Dimension dimension = new Dimension(600, 400);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.fileMenu.removeAll();
        this.killMenuItem = new JMenuItem("Cancel");
        this.killMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRun.this.doCancel();
            }
        });
        this.fileMenu.add(this.killMenuItem);
        this.fileMenu.addSeparator();
        this.saveMenuItem = new JMenuItem("Save Output...");
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, AppManager.MENU_SHORTCUT_KEY_MASK));
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRun.this.doSaveOutput();
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.updateControls();
        this.checkTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyRun.this.doUpdate();
            }
        });
        this.updateDocumentName();
    }

    @Override
    public String getFileMenuName() {
        return "Run";
    }

    @Override
    public String getKeyTitle() {
        return "Study " + this.studyKey + "." + super.getKeyTitle();
    }

    @Override
    public String getDbID() {
        return this.dbID;
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(DbManager.getDbHost(this.dbID) + "/" + this.studyName);
    }

    @Override
    public int getStudyKey() {
        return this.studyKey;
    }

    @Override
    public int getStudyLock() {
        return this.studyLock;
    }

    @Override
    public int getLockCount() {
        return this.lockCount;
    }

    @Override
    public void toFront() {
        super.toFront();
    }

    @Override
    public double getMemoryFraction() {
        if (this.processPanel.isProcessRunning()) {
            return 1.0 / (double)this.memoryFraction;
        }
        return 0.0;
    }

    private void updateControls() {
        if (this.processPanel.isProcessRunning()) {
            this.killButton.setEnabled(true);
            if (null != this.killMenuItem) {
                this.killMenuItem.setEnabled(true);
            }
            this.saveButton.setEnabled(false);
            if (null != this.saveMenuItem) {
                this.saveMenuItem.setEnabled(false);
            }
            this.okButton.setEnabled(false);
        } else {
            this.killButton.setEnabled(false);
            if (null != this.killMenuItem) {
                this.killMenuItem.setEnabled(false);
            }
            if (this.processPanel.hasOutput()) {
                this.saveButton.setEnabled(true);
                if (null != this.saveMenuItem) {
                    this.saveMenuItem.setEnabled(true);
                }
            }
            this.okButton.setEnabled(true);
        }
    }

    private void doUpdate() {
        if (this.processPanel.pollProcess()) {
            return;
        }
        this.checkTimer.stop();
        this.updateControls();
        DbConnection dbConnection = DbManager.getDb(this.dbID);
        boolean bl = false;
        String string = "";
        if (dbConnection.connect()) {
            try {
                dbConnection.update("LOCK TABLES tvstudy.study WRITE, tvstudy.version WRITE");
                dbConnection.query("SELECT study_lock, lock_count, share_count FROM tvstudy.study WHERE study_key=" + this.studyKey);
                if (dbConnection.next()) {
                    int n = dbConnection.getInt(1);
                    int n2 = dbConnection.getInt(2);
                    int n3 = dbConnection.getInt(3);
                    if (n == this.studyLock && n2 == this.lockCount || 2 == this.studyLock && 3 == n && n2 == this.lockCount + 1) {
                        if (2 == n || --n3 <= 0) {
                            dbConnection.update("UPDATE tvstudy.study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + this.studyKey);
                            this.studyLock = 0;
                            this.lockCount = n2 + 1;
                        } else {
                            dbConnection.update("UPDATE tvstudy.study SET share_count = share_count - 1 WHERE study_key = " + this.studyKey);
                            this.studyLock = 3;
                            this.lockCount = n2;
                        }
                    } else {
                        bl = true;
                        string = "*** The study lock was modified. ***";
                    }
                } else {
                    bl = true;
                    string = "*** The study was deleted. ***";
                }
            }
            catch (SQLException sQLException) {
                bl = true;
                string = "An operation cannot be completed due to a database error:\n" + sQLException;
                dbConnection.reportError(sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close();
        } else {
            bl = true;
            string = "*** Could not open database connection. ***";
        }
        if (bl) {
            this.processPanel.setStatusMessage(string);
        }
        DbManager.getStudyListEditor(this.dbID).studyWasChanged(this.studyKey);
    }

    private void doCancel() {
        if (this.processPanel.isProcessRunning()) {
            this.processPanel.killProcess(true);
        }
    }

    private void doSaveOutput() {
        if (this.processPanel.hasOutput()) {
            this.processPanel.saveOutput();
        }
    }

    private void doOK() {
        this.closeWithoutSave();
    }

    @Override
    public void windowWillOpen() {
        if (!this.checkTimer.isRunning()) {
            this.checkTimer.start();
        }
    }

    @Override
    public boolean closeWithoutSave() {
        if (this.processPanel.isProcessRunning()) {
            return false;
        }
        DbManager.getStudyListEditor(this.dbID).studyWindowClosed(this);
        AppManager.hideWindow(this);
        return true;
    }

    @Override
    public boolean windowShouldClose() {
        if (this.processPanel.isProcessRunning()) {
            AppManager.showMessage(this, "This window can't be closed while the study is running.", WINDOW_TITLE, 1);
            return false;
        }
        DbManager.getStudyListEditor(this.dbID).studyWindowClosed(this);
        return true;
    }

    static {
        mergeLineStrings.add("Grid and cell setup for sourceKey");
        mergeLineStrings.add("Cell setup for sourceKey");
        mergeLineStrings.add("Calculating fields in grid cell");
    }
}

