/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.Parameter;
import gov.fcc.tvstudy.data.Scenario;
import gov.fcc.tvstudy.data.Source;
import gov.fcc.tvstudy.data.Study;
import gov.fcc.tvstudy.editdata.ParameterEditData;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.editor.ParameterEditor;
import gov.fcc.tvstudy.editor.RootEditor;
import gov.fcc.tvstudy.editor.StudyCreateNew;
import gov.fcc.tvstudy.editor.StudyEditor;
import gov.fcc.tvstudy.editor.StudyRun;
import gov.fcc.tvstudy.editor.StudyRunPair;
import gov.fcc.tvstudy.editor.StudyRunStart;
import gov.fcc.tvstudy.editor.StudyWindow;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.EditMenu;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.QueryWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class StudyListEditor
extends AppFrame {
    public static final String WINDOW_TITLE = "Study List";
    private String dbID;
    private StudyListTableModel studyListModel;
    private JTable studyListTable;
    private JMenuItem duplicateStudyMenuItem;
    private JMenuItem openStudyMenuItem;
    private JMenuItem deleteStudyMenuItem;
    private JMenuItem runStudyMenuItem;
    private JMenuItem pairStudyMenuItem;
    private JMenuItem clearCacheMenuItem;
    private JMenuItem unlockStudyMenuItem;
    private JButton openStudyButton;
    private JButton runStudyButton;
    private StudyCreateNew studyCreateDialog;
    private StudyRunStart studyStartDialog;
    private static final int TIMER_INTERVAL = 2000;
    private static final int UPDATE_INTERVAL = 60000;
    private static final int CACHE_CHECK_INTERVAL = 600000;
    private Timer updateTimer;
    private long lastListUpdate;
    private Thread updateThread;
    private ArrayDeque<StudyListItem> updateItems;
    private ArrayDeque<StudyListItem> updatedItems;
    private boolean holdStudyLocks;
    private boolean inQuery;

    public StudyListEditor(String string) {
        super(WINDOW_TITLE);
        this.dbID = string;
        this.studyListModel = new StudyListTableModel();
        this.studyListTable = this.studyListModel.createTable(this.editMenu);
        this.studyListTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 == mouseEvent.getClickCount()) {
                    StudyListEditor.this.doOpenStudy();
                }
            }
        });
        this.studyListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StudyListEditor.this.updateControls();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Studies"));
        jPanel.add((Component)AppManager.createScrollPane(this.studyListTable), "Center");
        this.updateTimer = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doUpdates();
            }
        });
        this.updateItems = new ArrayDeque();
        this.updatedItems = new ArrayDeque();
        JButton jButton = new JButton("New");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doNewStudy();
            }
        });
        this.openStudyButton = new JButton("Open");
        this.openStudyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doOpenStudy();
            }
        });
        this.runStudyButton = new JButton("Run");
        this.runStudyButton.setFocusable(false);
        this.runStudyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doRunStudy();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jButton);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.runStudyButton);
        jPanel3.add(this.openStudyButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel4, "South");
        this.getRootPane().setDefaultButton(this.openStudyButton);
        this.pack();
        Dimension dimension = new Dimension(750, 500);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.fileMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Previous");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, AppManager.MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doPrevious();
            }
        });
        this.fileMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Next");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(40, AppManager.MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doNext();
            }
        });
        this.fileMenu.add(jMenuItem2);
        this.fileMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Refresh List");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.updateStudyList(false, true);
            }
        });
        this.fileMenu.add(jMenuItem3);
        this.fileMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("New...");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(78, AppManager.MENU_SHORTCUT_KEY_MASK));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doNewStudy();
            }
        });
        this.fileMenu.add(jMenuItem4);
        this.duplicateStudyMenuItem = new JMenuItem("Duplicate...");
        this.duplicateStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doDuplicateStudy();
            }
        });
        this.fileMenu.add(this.duplicateStudyMenuItem);
        this.fileMenu.addSeparator();
        this.openStudyMenuItem = new JMenuItem("Open");
        this.openStudyMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppManager.MENU_SHORTCUT_KEY_MASK));
        this.openStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doOpenStudy();
            }
        });
        this.fileMenu.add(this.openStudyMenuItem);
        this.deleteStudyMenuItem = new JMenuItem("Delete");
        this.deleteStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doDeleteStudy();
            }
        });
        this.fileMenu.add(this.deleteStudyMenuItem);
        this.fileMenu.addSeparator();
        this.runStudyMenuItem = new JMenuItem("Run...");
        this.runStudyMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, AppManager.MENU_SHORTCUT_KEY_MASK));
        this.runStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doRunStudy();
            }
        });
        this.fileMenu.add(this.runStudyMenuItem);
        this.pairStudyMenuItem = new JMenuItem("Run Pair Study...");
        this.pairStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doRunPairStudy();
            }
        });
        this.fileMenu.add(this.pairStudyMenuItem);
        this.fileMenu.addSeparator();
        this.clearCacheMenuItem = new JMenuItem("Clear Cache");
        this.clearCacheMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doClearCache();
            }
        });
        this.fileMenu.add(this.clearCacheMenuItem);
        this.fileMenu.addSeparator();
        this.unlockStudyMenuItem = new JMenuItem("Unlock");
        this.unlockStudyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyListEditor.this.doUnlockStudy();
            }
        });
        this.fileMenu.add(this.unlockStudyMenuItem);
        this.updateControls();
        this.studyCreateDialog = new StudyCreateNew(this);
        this.studyStartDialog = new StudyRunStart(this);
        this.updateDocumentName();
    }

    private void updateControls() {
        int n = this.studyListTable.getSelectedRowCount();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (1 == n) {
            StudyListItem studyListItem = this.studyListModel.get(this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow()));
            if (null != studyListItem.openWindow) {
                bl = true;
                bl2 = false;
                bl4 = false;
                bl6 = false;
                if (1 == studyListItem.openWindow.getStudyLock()) {
                    bl3 = true;
                    bl5 = true;
                } else {
                    bl3 = false;
                    bl5 = false;
                }
            } else {
                bl = true;
                bl2 = true;
                bl3 = true;
                bl4 = true;
                bl5 = true;
                bl6 = true;
            }
        } else if (n > 1) {
            bl3 = true;
            bl5 = true;
        }
        this.openStudyMenuItem.setEnabled(bl);
        this.openStudyButton.setEnabled(bl);
        this.duplicateStudyMenuItem.setEnabled(bl2);
        this.deleteStudyMenuItem.setEnabled(bl3);
        this.runStudyMenuItem.setEnabled(bl4);
        this.runStudyButton.setEnabled(bl4);
        this.pairStudyMenuItem.setEnabled(bl4);
        this.clearCacheMenuItem.setEnabled(bl5);
        this.unlockStudyMenuItem.setEnabled(bl6);
    }

    @Override
    public void dispose() {
        this.studyCreateDialog.dispose();
        this.studyStartDialog.dispose();
        super.dispose();
    }

    @Override
    public String getDbID() {
        return this.dbID;
    }

    @Override
    protected String getFileMenuName() {
        return "Study";
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(DbManager.getDbHost(this.dbID));
        this.studyCreateDialog.updateDocumentName();
        this.studyStartDialog.updateDocumentName();
    }

    public double getTotalMemoryFraction() {
        return this.studyListModel.getTotalMemoryFraction();
    }

    private void doUpdates() {
        if (System.currentTimeMillis() - this.lastListUpdate > 60000L) {
            this.updateStudyList(true, true);
        } else {
            StudyListItem studyListItem;
            do {
                if (null == (studyListItem = this.getUpdatedItem())) continue;
                this.studyListModel.itemWasChanged(studyListItem);
            } while (studyListItem != null);
        }
        if (this.isUpdateItemsEmpty() || null != this.updateThread && this.updateThread.isAlive()) {
            return;
        }
        this.updateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                StudyListItem studyListItem;
                do {
                    if (null == (studyListItem = StudyListEditor.this.getUpdateItem()) || !studyListItem.isCacheSizeExpired()) continue;
                    studyListItem.updateCacheSize();
                    StudyListEditor.this.addUpdatedItem(studyListItem);
                } while (null != studyListItem);
            }
        });
        this.updateThread.start();
    }

    private synchronized void addUpdateItem(StudyListItem studyListItem) {
        this.updateItems.add(studyListItem);
    }

    private synchronized StudyListItem getUpdateItem() {
        return this.updateItems.poll();
    }

    private synchronized boolean isUpdateItemsEmpty() {
        return this.updateItems.isEmpty();
    }

    private synchronized void clearUpdateItems() {
        this.updateItems.clear();
    }

    private synchronized void addUpdatedItem(StudyListItem studyListItem) {
        this.updatedItems.add(studyListItem);
    }

    private synchronized StudyListItem getUpdatedItem() {
        return this.updatedItems.poll();
    }

    private synchronized void clearUpdatedItems() {
        this.updatedItems.clear();
    }

    private void updateStudyList(boolean bl, boolean bl2) {
        int n;
        String string = "Refresh Study List";
        ErrorReporter errorReporter = null;
        if (!bl) {
            errorReporter = new ErrorReporter(this, string);
        }
        ArrayList<StudyListItem> arrayList = this.getItems(errorReporter);
        this.lastListUpdate = System.currentTimeMillis();
        if (null == arrayList) {
            return;
        }
        int[] nArray = null;
        HashSet<StudyListItem> hashSet = null;
        if (bl2 && this.studyListTable.getSelectedRowCount() > 0) {
            nArray = this.studyListTable.getSelectedRows();
            hashSet = new HashSet<StudyListItem>(nArray.length);
            for (n = 0; n < nArray.length; ++n) {
                hashSet.add(this.studyListModel.get(this.studyListTable.convertRowIndexToModel(nArray[n])));
            }
        }
        this.studyListTable.clearSelection();
        this.studyListModel.setItems(arrayList);
        if (hashSet != null) {
            int n2;
            n = 0;
            for (StudyListItem studyListItem : hashSet) {
                n2 = this.studyListModel.indexOf(studyListItem);
                if (n2 < 0) continue;
                nArray[n++] = this.studyListTable.convertRowIndexToView(n2);
            }
            if (n > 0) {
                int n3;
                for (n2 = 0; n2 < n - 1; ++n2) {
                    n3 = n2;
                    for (int i = n2 + 1; i < n; ++i) {
                        if (nArray[i] >= nArray[n3]) continue;
                        n3 = i;
                    }
                    if (n3 == n2) continue;
                    int n4 = nArray[n2];
                    nArray[n2] = nArray[n3];
                    nArray[n3] = n4;
                }
                n3 = nArray[0];
                for (n2 = 1; n2 < n; ++n2) {
                    if (nArray[n2] <= nArray[n2 - 1] + 1) continue;
                    this.studyListTable.addRowSelectionInterval(n3, nArray[n2 - 1]);
                    n3 = nArray[n2];
                }
                this.studyListTable.addRowSelectionInterval(n3, nArray[n - 1]);
            }
        }
        this.updateControls();
    }

    private ArrayList<StudyListItem> getItems(ErrorReporter errorReporter) {
        ArrayList<StudyListItem> arrayList = new ArrayList<StudyListItem>();
        DbConnection dbConnection = DbManager.getDb(this.dbID);
        if (dbConnection.connect(errorReporter)) {
            try {
                dbConnection.query("SELECT study.study_key, study.name, study.description, study.study_lock, study.lock_count, study.new_study, study.needs_update, template.name, CASE WHEN (LENGTH(cdbs.name) > 0) THEN cdbs.name ELSE cdbs.id END FROM tvstudy.study JOIN tvstudy.template USING (template_key) JOIN tvstudy.cdbs USING (cdbs_key) ORDER BY 1");
                while (dbConnection.next()) {
                    StudyListItem studyListItem = new StudyListItem();
                    studyListItem.key = new Integer(dbConnection.getInt(1));
                    studyListItem.name = dbConnection.getString(2);
                    studyListItem.description = dbConnection.getString(3);
                    studyListItem.studyLock = dbConnection.getInt(4);
                    studyListItem.lockCount = dbConnection.getInt(5);
                    studyListItem.newStudy = dbConnection.getBoolean(6);
                    studyListItem.needsUpdate = dbConnection.getBoolean(7);
                    studyListItem.templateName = dbConnection.getString(8);
                    studyListItem.cdbsName = dbConnection.getString(9);
                    studyListItem.cacheSize = -1L;
                    arrayList.add(studyListItem);
                }
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(errorReporter, sQLException);
            }
            dbConnection.close(false);
        }
        return arrayList;
    }

    private StudyListItem checkStudy(int n, ErrorReporter errorReporter) {
        StudyListItem studyListItem = this.studyListModel.get(n);
        boolean bl = false;
        boolean bl2 = false;
        DbConnection dbConnection = DbManager.getDb(this.dbID);
        if (dbConnection.connect(errorReporter)) {
            try {
                dbConnection.query("SELECT study.name, study.description, study.study_lock, study.lock_count, study.new_study, study.needs_update, template.name, CASE WHEN (LENGTH(cdbs.name) > 0) THEN cdbs.name ELSE cdbs.id END FROM tvstudy.study LEFT JOIN tvstudy.template USING (template_key) LEFT JOIN tvstudy.cdbs USING (cdbs_key) WHERE study.study_key = " + studyListItem.key);
                if (dbConnection.next()) {
                    studyListItem.name = dbConnection.getString(1);
                    studyListItem.description = dbConnection.getString(2);
                    studyListItem.studyLock = dbConnection.getInt(3);
                    studyListItem.lockCount = dbConnection.getInt(4);
                    studyListItem.newStudy = dbConnection.getBoolean(5);
                    studyListItem.needsUpdate = dbConnection.getBoolean(6);
                    studyListItem.templateName = dbConnection.getString(7);
                    studyListItem.cdbsName = dbConnection.getString(8);
                } else {
                    bl2 = true;
                }
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(errorReporter, sQLException);
                bl = true;
            }
        } else {
            return null;
        }
        dbConnection.close();
        if (bl2) {
            if (null != errorReporter) {
                errorReporter.reportError("The study does not exist.");
            }
            this.studyListModel.remove(n);
            return null;
        }
        if (bl) {
            return null;
        }
        this.studyListModel.itemWasChanged(n);
        if (studyListItem.isCacheSizeExpired()) {
            this.addUpdateItem(studyListItem);
        }
        return studyListItem;
    }

    public void studyWasChanged(int n) {
        int n2 = this.studyListModel.indexOfStudy(new Integer(n));
        if (n2 >= 0) {
            this.studyListModel.get(n2).clearCacheSize();
            this.checkStudy(n2, null);
        }
    }

    private void doPrevious() {
        int n = this.studyListTable.getRowCount();
        int n2 = this.studyListTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.studyListTable.setRowSelectionInterval(n2, n2);
        }
    }

    private void doNext() {
        int n = this.studyListTable.getRowCount();
        int n2 = this.studyListTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.studyListTable.setRowSelectionInterval(n2, n2);
        }
    }

    private void doNewStudy() {
        if (this.studyCreateDialog.isVisible() || this.studyStartDialog.isVisible() || this.inQuery) {
            return;
        }
        AppManager.showWindow(this.studyCreateDialog);
        if (this.studyCreateDialog.canceled) {
            return;
        }
        Integer n = this.studyCreateDialog.getStudyKey();
        if (null == n) {
            return;
        }
        this.updateStudyList(false, false);
        int n2 = this.studyListModel.indexOfStudy(n);
        if (n2 < 0) {
            return;
        }
        n2 = this.studyListTable.convertRowIndexToView(n2);
        this.studyListTable.setRowSelectionInterval(n2, n2);
        this.studyListTable.scrollRectToVisible(this.studyListTable.getCellRect(n2, 0, true));
        this.doOpenStudy();
    }

    private void doDuplicateStudy() {
        if (this.studyCreateDialog.isVisible() || this.studyStartDialog.isVisible() || this.inQuery) {
            return;
        }
        if (this.studyListTable.getSelectedRowCount() != 1) {
            return;
        }
        String string = "Duplicate Study";
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        int n = this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow());
        StudyListItem studyListItem = this.checkStudy(n, errorReporter);
        if (null == studyListItem) {
            return;
        }
        if (null != studyListItem.openWindow) {
            studyListItem.openWindow.toFront();
            return;
        }
        if (0 != studyListItem.studyLock) {
            errorReporter.reportWarning("Could not duplicate study '" + studyListItem.name + "':\n" + "The study is in use by another application.");
            return;
        }
        if (studyListItem.newStudy || studyListItem.needsUpdate) {
            errorReporter.reportWarning("Could not duplicate study '" + studyListItem.name + "':\n" + "The study needs to be opened and saved first.");
            return;
        }
        String string2 = "";
        do {
            if (null != (string2 = JOptionPane.showInputDialog(this, "Enter a name for the new study", string, 3))) continue;
            return;
        } while (!DbManager.checkStudyName(string2 = string2.trim(), this.dbID, errorReporter));
        final int n2 = studyListItem.key;
        final String string3 = string2;
        DbConnection dbConnection = DbManager.getDb(this.dbID);
        QueryWorker<Integer> queryWorker = new QueryWorker<Integer>((Window)this, string, dbConnection){

            @Override
            protected Integer doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                return Study.duplicateStudy(dbConnection, errorReporter, n2, string3);
            }
        };
        this.inQuery = true;
        Integer n3 = (Integer)queryWorker.runQuery("Duplicating study, please wait...", errorReporter);
        this.inQuery = false;
        if (null == n3) {
            return;
        }
        this.updateStudyList(false, false);
        n = this.studyListModel.indexOfStudy(n3);
        if (n < 0) {
            return;
        }
        n = this.studyListTable.convertRowIndexToView(n);
        this.studyListTable.setRowSelectionInterval(n, n);
        this.studyListTable.scrollRectToVisible(this.studyListTable.getCellRect(n, 0, true));
        this.doOpenStudy();
    }

    private void doOpenStudy() {
        Object object;
        if (this.studyCreateDialog.isVisible() || this.studyStartDialog.isVisible() || this.inQuery) {
            return;
        }
        if (this.studyListTable.getSelectedRowCount() != 1) {
            return;
        }
        String string = "Open Study";
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        int n = this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow());
        StudyListItem studyListItem = this.checkStudy(n, errorReporter);
        if (null == studyListItem) {
            return;
        }
        if (null != studyListItem.openWindow) {
            studyListItem.openWindow.toFront();
            return;
        }
        final int n2 = studyListItem.key;
        DbConnection dbConnection = DbManager.getDb(this.dbID);
        QueryWorker<Study> queryWorker = new QueryWorker<Study>((Window)this, string, dbConnection){

            @Override
            protected Study doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                return Study.getStudy(dbConnection, errorReporter, n2);
            }
        };
        this.inQuery = true;
        Study study = (Study)queryWorker.runQuery("Opening study, please wait...", errorReporter);
        this.inQuery = false;
        if (null == study) {
            return;
        }
        boolean bl = false;
        if (study.newStudy && !study.templateLocked) {
            for (Parameter object2 : study.parameters) {
                if (!object2.studyFixed) continue;
                bl = true;
                break;
            }
        }
        try {
            if (bl) {
                object = new NewStudyEditor(study, string);
            } else {
                StudyEditData throwable = new StudyEditData(this.dbID, study, null);
                if (!throwable.updateIfNeeded(errorReporter) || !throwable.setStudyParameters(errorReporter)) {
                    Study.unlockStudy(DbManager.getDb(this.dbID), study.key, study.lockCount);
                    return;
                }
                object = new StudyEditor(throwable);
            }
        }
        catch (Throwable throwable) {
            AppManager.log(Level.SEVERE, "Unexpected error", throwable);
            errorReporter.reportError("Unexpected error:\n" + throwable);
            Study.unlockStudy(DbManager.getDb(this.dbID), study.key, study.lockCount);
            return;
        }
        studyListItem.studyLock = study.studyLock;
        studyListItem.lockCount = study.lockCount;
        studyListItem.openWindow = (StudyWindow)object;
        this.studyListModel.itemWasChanged(n);
        this.updateControls();
        AppManager.showWindow((Window)object);
    }

    private void doRunStudy() {
        if (this.studyCreateDialog.isVisible() || this.studyStartDialog.isVisible() || this.inQuery) {
            return;
        }
        if (this.studyListTable.getSelectedRowCount() != 1) {
            return;
        }
        ErrorReporter errorReporter = new ErrorReporter(this, "Start Study Run");
        int n = this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow());
        StudyListItem studyListItem = this.checkStudy(n, errorReporter);
        if (null == studyListItem) {
            return;
        }
        if (null != studyListItem.openWindow) {
            studyListItem.openWindow.toFront();
            return;
        }
        if (studyListItem.newStudy || studyListItem.needsUpdate) {
            errorReporter.reportWarning("Could not run study '" + studyListItem.name + "':\n" + "The study needs to be opened and saved first.");
            return;
        }
        if (!this.studyStartDialog.setStudy(studyListItem.key, errorReporter)) {
            return;
        }
        AppManager.showWindow(this.studyStartDialog);
        if (this.studyStartDialog.canceled) {
            return;
        }
        StudyRun studyRun = this.studyStartDialog.getRunWindow();
        if (null == studyRun) {
            return;
        }
        studyListItem.studyLock = studyRun.getStudyLock();
        studyListItem.lockCount = studyRun.getLockCount();
        studyListItem.openWindow = studyRun;
        this.studyListModel.itemWasChanged(n);
        this.updateControls();
        AppManager.showWindow(studyRun);
    }

    private void doRunPairStudy() {
        Object object;
        if (this.studyCreateDialog.isVisible() || this.studyStartDialog.isVisible() || this.inQuery) {
            return;
        }
        if (this.studyListTable.getSelectedRowCount() != 1) {
            return;
        }
        ErrorReporter errorReporter = new ErrorReporter(this, "Pair Study Run");
        int n = this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow());
        StudyListItem studyListItem = this.checkStudy(n, errorReporter);
        if (null == studyListItem) {
            return;
        }
        if (null != studyListItem.openWindow) {
            studyListItem.openWindow.toFront();
            return;
        }
        if (studyListItem.newStudy || studyListItem.needsUpdate) {
            errorReporter.reportWarning("Pair study cannot run using '" + studyListItem.name + "':\n" + "The study needs to be opened and saved first.");
            return;
        }
        final int n2 = studyListItem.key;
        DbConnection dbConnection = DbManager.getDb(this.dbID);
        QueryWorker<Study> queryWorker = new QueryWorker<Study>((Window)this, "Pair Study Run", dbConnection){

            @Override
            protected Study doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                return Study.getStudy(dbConnection, errorReporter, n2);
            }
        };
        this.inQuery = true;
        Study study = (Study)queryWorker.runQuery("Opening study, please wait...", errorReporter);
        this.inQuery = false;
        if (null == study) {
            return;
        }
        boolean bl = false;
        String string = "";
        Integer n3 = study.getIntegerParameter(2);
        Double d = study.getDecimalParameter(4);
        Double d2 = study.getDecimalParameter(200);
        if (null != n3 && null != d && null != d2) {
            if (2 == n3) {
                if (d >= 0.5) {
                    if (1 == study.scenarios.size()) {
                        object = study.scenarios.get(0);
                        HashSet<Integer> hashSet = new HashSet<Integer>();
                        int n4 = 0;
                        for (Source source : study.sources) {
                            Scenario.SourceListItem sourceListItem = null;
                            for (Scenario.SourceListItem sourceListItem2 : ((Scenario)object).sourceList) {
                                if (sourceListItem2.key != source.key) continue;
                                sourceListItem = sourceListItem2;
                                break;
                            }
                            if (null == sourceListItem || !sourceListItem.isDesired) continue;
                            if (!hashSet.add(new Integer(source.facility_id))) {
                                bl = true;
                                string = "Stations may only appear once in the baseline scenario.";
                                break;
                            }
                            double d3 = 2.0 / Math.cos(source.latitude * (Math.PI / 180));
                            if (source.latitude < 2.0 || source.latitude > 73.0 || source.longitude < d3 || source.longitude > 180.0 - d3) {
                                bl = true;
                                string = "All stations must be in north latitude and west longitude.";
                                break;
                            }
                            ++n4;
                        }
                        if (!bl && n4 < 2) {
                            bl = true;
                            string = "The baseline scenario must include at least two stations.";
                        }
                    } else {
                        bl = true;
                        string = "The study must have exactly one scenario.";
                    }
                } else {
                    bl = true;
                    string = "The study cell size must be 0.5 km or larger.";
                }
            } else {
                bl = true;
                string = "The study must use a global cell grid.";
            }
        } else {
            bl = true;
            string = "Required study parameters not found, the study database is damaged.";
        }
        if (bl) {
            Study.unlockStudy(DbManager.getDb(this.dbID), study.key, study.lockCount);
            errorReporter.reportWarning("Pair study cannot run using '" + study.name + "':\n" + string);
            return;
        }
        try {
            object = new StudyRunPair(new StudyEditData(this.dbID, study, null));
        }
        catch (Throwable throwable) {
            Study.unlockStudy(DbManager.getDb(this.dbID), study.key, study.lockCount);
            AppManager.log(Level.SEVERE, "Unexpected error", throwable);
            errorReporter.reportError("Unexpected error:\n" + throwable);
            return;
        }
        studyListItem.studyLock = study.studyLock;
        studyListItem.lockCount = study.lockCount;
        studyListItem.openWindow = (StudyWindow)object;
        this.studyListModel.itemWasChanged(n);
        this.updateControls();
        AppManager.showWindow((Window)object);
    }

    private void doDeleteStudy() {
        if (this.studyCreateDialog.isVisible() || this.studyStartDialog.isVisible() || this.inQuery) {
            return;
        }
        String string = "Delete Study";
        int n = this.studyListTable.getSelectedRowCount();
        if (0 == n) {
            return;
        }
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        final ArrayList<StudyListItem> arrayList = new ArrayList<StudyListItem>();
        int[] nArray = this.studyListTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            StudyListItem studyListItem = this.studyListModel.get(this.studyListTable.convertRowIndexToModel(nArray[i]));
            AppManager.beep();
            int n2 = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete study '" + studyListItem.name + "'?", string, 1, 2);
            if (0 != n2) {
                if (2 != n2) continue;
                return;
            }
            if (null != studyListItem.openWindow) {
                this.holdStudyLocks = true;
                boolean bl = !studyListItem.openWindow.closeWithoutSave();
                this.holdStudyLocks = false;
                if (bl) {
                    errorReporter.reportWarning("Could not close a window for study '" + studyListItem.name + "'.\n" + "Please close the window manually and try again.");
                    continue;
                }
            }
            arrayList.add(studyListItem);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.dbID);
        QueryWorker<Object> queryWorker = new QueryWorker<Object>((Window)this, string, dbConnection){

            @Override
            protected Object doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                StudyListEditor.this.deleteStudies(dbConnection, errorReporter, arrayList);
                return null;
            }
        };
        this.inQuery = true;
        queryWorker.runQuery("Deleting studies, please wait...", errorReporter);
        this.inQuery = false;
        this.updateStudyList(false, true);
    }

    private void deleteStudies(DbConnection dbConnection, ErrorReporter errorReporter, ArrayList<StudyListItem> arrayList) {
        if (!dbConnection.connect(errorReporter)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (StudyListItem studyListItem : arrayList) {
            bl = false;
            string = "";
            bl2 = false;
            try {
                dbConnection.update("LOCK TABLES tvstudy.study WRITE");
                dbConnection.query("SELECT study_lock, lock_count, template_key, cdbs_key FROM tvstudy.study WHERE study_key = " + studyListItem.key);
                if (dbConnection.next()) {
                    n = dbConnection.getInt(1);
                    n2 = dbConnection.getInt(3);
                    n3 = dbConnection.getInt(4);
                    if (0 == n) {
                        dbConnection.update("UPDATE tvstudy.study SET study_lock = 4, lock_count = lock_count + 1 WHERE study_key = " + studyListItem.key);
                    } else if (null == studyListItem.openWindow || 1 != n || n != studyListItem.studyLock || dbConnection.getInt(2) != studyListItem.lockCount) {
                        bl = true;
                        string = "The study is in use by another application.";
                    }
                } else {
                    bl2 = true;
                }
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
                bl = true;
                string = "An operation cannot be completed due to a database error:\n" + sQLException;
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            if (bl) {
                errorReporter.reportError("Cannot delete study '" + studyListItem.name + "':\n" + string);
                continue;
            }
            if (bl2) continue;
            try {
                dbConnection.update("DELETE FROM tvstudy.study WHERE study_key = " + studyListItem.key);
                dbConnection.update("DROP DATABASE IF EXISTS tvstudy_" + studyListItem.key);
                dbConnection.update("UPDATE tvstudy.template SET use_count = use_count - 1 WHERE template_key = " + n2);
                dbConnection.update("UPDATE tvstudy.cdbs SET use_count = use_count - 1 WHERE cdbs_key = " + n3);
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            Study.deleteStudyCache(this.dbID, studyListItem.key);
            DbManager.deleteProperty(this.dbID, "Study " + studyListItem.key + "%");
            final StudyListItem studyListItem2 = studyListItem;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StudyListEditor.this.studyListModel.remove(studyListItem2);
                }
            });
        }
        dbConnection.close();
    }

    private void doClearCache() {
        if (this.studyCreateDialog.isVisible() || this.studyStartDialog.isVisible() || this.inQuery) {
            return;
        }
        String string = "Clear Cache";
        int n = this.studyListTable.getSelectedRowCount();
        if (0 == n) {
            return;
        }
        final ArrayList<StudyListItem> arrayList = new ArrayList<StudyListItem>();
        int[] nArray = this.studyListTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.studyListModel.get(this.studyListTable.convertRowIndexToModel(nArray[i])));
        }
        DbConnection dbConnection = DbManager.getDb(this.dbID);
        QueryWorker<Object> queryWorker = new QueryWorker<Object>((Window)this, string, dbConnection){

            @Override
            protected Object doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                StudyListEditor.this.clearCaches(dbConnection, errorReporter, arrayList);
                return null;
            }
        };
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        this.inQuery = true;
        queryWorker.runQuery("Deleting cache files, please wait...", errorReporter);
        this.inQuery = false;
        this.updateStudyList(false, true);
    }

    private void clearCaches(DbConnection dbConnection, ErrorReporter errorReporter, ArrayList<StudyListItem> arrayList) {
        if (!dbConnection.connect(errorReporter)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        for (StudyListItem studyListItem : arrayList) {
            bl = false;
            string = "";
            bl2 = false;
            bl3 = false;
            try {
                dbConnection.update("LOCK TABLES tvstudy.study WRITE");
                dbConnection.query("SELECT study_lock, lock_count FROM tvstudy.study WHERE study_key = " + studyListItem.key);
                if (dbConnection.next()) {
                    int n = dbConnection.getInt(1);
                    if (0 == n) {
                        studyListItem.lockCount = dbConnection.getInt(2);
                        dbConnection.update("UPDATE tvstudy.study SET study_lock = 4, lock_count = lock_count + 1 WHERE study_key = " + studyListItem.key);
                        bl3 = true;
                        studyListItem.studyLock = 4;
                        studyListItem.lockCount++;
                        final StudyListItem studyListItem2 = studyListItem;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StudyListEditor.this.studyListModel.itemWasChanged(studyListItem2);
                            }
                        });
                    } else if (null == studyListItem.openWindow || 1 != n || n != studyListItem.studyLock || dbConnection.getInt(2) != studyListItem.lockCount) {
                        bl = true;
                        string = "The study is in use by another application.";
                    }
                } else {
                    bl2 = true;
                }
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
                bl = true;
                string = "An operation cannot be completed due to a database error:\n" + sQLException;
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            if (bl) {
                errorReporter.reportError("Cache cannot be cleared for study '" + studyListItem.name + "':\n" + string);
                continue;
            }
            if (bl2) continue;
            Study.deleteStudyCache(this.dbID, studyListItem.key);
            studyListItem.clearCacheSize();
            if (!bl3) continue;
            try {
                dbConnection.update("UPDATE tvstudy.study SET study_lock = 0, lock_count = lock_count + 1 WHERE study_key = " + studyListItem.key);
                studyListItem.studyLock = 0;
                studyListItem.lockCount++;
                final StudyListItem studyListItem3 = studyListItem;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StudyListEditor.this.studyListModel.itemWasChanged(studyListItem3);
                    }
                });
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
        }
        dbConnection.close();
    }

    private void doUnlockStudy() {
        if (this.studyCreateDialog.isVisible() || this.studyStartDialog.isVisible() || this.inQuery) {
            return;
        }
        String string = "Unlock Study";
        if (this.studyListTable.getSelectedRowCount() != 1) {
            return;
        }
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        int n = this.studyListTable.convertRowIndexToModel(this.studyListTable.getSelectedRow());
        StudyListItem studyListItem = this.checkStudy(n, errorReporter);
        if (null == studyListItem) {
            return;
        }
        if (null != studyListItem.openWindow) {
            studyListItem.openWindow.toFront();
            return;
        }
        AppManager.beep();
        if (0 != JOptionPane.showConfirmDialog(this, "This will clear the lock on the study.  Do this only if the study was\nnot closed properly due to an application crash or network failure;\nif this is done when another application is still using the study,\nthat application will fail and the database could become corrupted.\n\nDo you want to continue?", string, 0, 2)) {
            return;
        }
        Study.unlockStudy(DbManager.getDb(this.dbID), errorReporter, studyListItem.key, 0);
        this.checkStudy(n, null);
    }

    public void studyWindowClosed(Window window) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (!(window instanceof StudyWindow)) {
            return;
        }
        n2 = ((StudyWindow)((Object)window)).getStudyKey();
        n3 = ((StudyWindow)((Object)window)).getStudyLock();
        n4 = ((StudyWindow)((Object)window)).getLockCount();
        boolean bl = false;
        if (0 != n3 && !this.holdStudyLocks) {
            bl = Study.unlockStudy(DbManager.getDb(this.dbID), n2, n4);
        }
        if ((n = this.studyListModel.indexOfStudy(new Integer(n2))) >= 0) {
            StudyListItem studyListItem = this.studyListModel.get(n);
            if (bl) {
                studyListItem.studyLock = 0;
                studyListItem.lockCount = n4 + 1;
            } else {
                studyListItem.studyLock = n3;
                studyListItem.lockCount = n4;
            }
            studyListItem.openWindow = null;
            this.studyListModel.itemWasChanged(n);
            this.updateControls();
        }
    }

    @Override
    public void windowWillOpen() {
        DbManager.restoreColumnWidths(this.dbID, this.getKeyTitle(), this.studyListTable);
        final StudyListEditor studyListEditor = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StudyListEditor.this.studyListModel.setItems(StudyListEditor.this.getItems(new ErrorReporter(studyListEditor, "Load Study List")));
                StudyListEditor.this.lastListUpdate = System.currentTimeMillis();
                StudyListEditor.this.updateTimer.start();
            }
        });
    }

    @Override
    public boolean windowShouldClose() {
        if (this.studyCreateDialog.isVisible() || this.studyStartDialog.isVisible() || this.inQuery) {
            return false;
        }
        String string = "Close Database";
        for (int i = 0; i < this.studyListModel.getRowCount(); ++i) {
            StudyListItem studyListItem = this.studyListModel.get(i);
            if (null == studyListItem.openWindow) continue;
            AppManager.showMessage(this, "All study windows must be closed before closing the database.", string, 1);
            studyListItem.openWindow.toFront();
            return false;
        }
        DbManager.saveColumnWidths(this.dbID, this.getKeyTitle(), this.studyListTable);
        this.updateTimer.stop();
        this.clearUpdateItems();
        if (null != this.updateThread) {
            while (this.updateThread.isAlive()) {
                try {
                    this.updateThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.updateThread = null;
        }
        this.clearUpdatedItems();
        return true;
    }

    private class NewStudyEditor
    extends RootEditor
    implements StudyWindow {
        private Study study;
        private String windowTitle;
        private ArrayList<ParameterEditData> parameters;

        private NewStudyEditor(Study study, String string) {
            super(string);
            this.blockActionsStart();
            this.study = study;
            this.windowTitle = string;
            this.parameters = new ArrayList();
            for (Parameter object2 : study.parameters) {
                if (!object2.studyFixed || !study.newStudy && null != object2.value) continue;
                this.parameters.add(new ParameterEditData(object2, this.study.templateLocked));
            }
            JComponent jComponent = ParameterEditor.createEditorLayout(this, this.parameters, true, null);
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewStudyEditor.this.doOK();
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.setFocusable(false);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewStudyEditor.this.doCancel();
                }
            });
            Box box = Box.createVerticalBox();
            box.add(Box.createVerticalStrut(10));
            box.add(new JLabel("     Please set study parameter values; these cannot be changed later."));
            box.add(Box.createVerticalStrut(10));
            JPanel jPanel = new JPanel(new FlowLayout(2));
            jPanel.add(jButton2);
            jPanel.add(jButton);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)box, "North");
            container.add((Component)jComponent, "Center");
            container.add((Component)jPanel, "South");
            this.getRootPane().setDefaultButton(jButton);
            this.pack();
            Dimension dimension = new Dimension(560, 500);
            this.setMinimumSize(dimension);
            this.setSize(dimension);
            this.blockActionsEnd();
            this.updateDocumentName();
        }

        @Override
        public String getDbID() {
            return StudyListEditor.this.dbID;
        }

        @Override
        protected boolean showsFileMenu() {
            return false;
        }

        @Override
        public void updateDocumentName() {
            this.setDocumentName(DbManager.getDbHost(StudyListEditor.this.dbID) + "/" + this.study.name);
        }

        @Override
        public int getStudyKey() {
            return this.study.key;
        }

        @Override
        public int getStudyLock() {
            return this.study.studyLock;
        }

        @Override
        public int getLockCount() {
            return this.study.lockCount;
        }

        @Override
        public void toFront() {
            super.toFront();
        }

        @Override
        public double getMemoryFraction() {
            return 0.0;
        }

        private void doOK() {
            if (this.windowShouldClose()) {
                AppManager.hideWindow(this);
            }
        }

        private void doCancel() {
            this.closeWithoutSave();
        }

        @Override
        public boolean closeWithoutSave() {
            StudyListEditor.this.studyWindowClosed(this);
            AppManager.hideWindow(this);
            return true;
        }

        @Override
        public boolean windowShouldClose() {
            StudyEditor studyEditor;
            if (!this.saveIfNeeded(this.windowTitle, false)) {
                return false;
            }
            ErrorReporter errorReporter = new ErrorReporter(this, this.windowTitle);
            try {
                StudyEditData studyEditData = new StudyEditData(StudyListEditor.this.dbID, this.study, this.parameters);
                if (!studyEditData.updateIfNeeded(errorReporter) || !studyEditData.setStudyParameters(errorReporter)) {
                    StudyListEditor.this.studyWindowClosed(this);
                    return true;
                }
                studyEditor = new StudyEditor(studyEditData);
            }
            catch (Throwable throwable) {
                AppManager.log(Level.SEVERE, "Unexpected error", throwable);
                errorReporter.reportError("Unexpected error:\n" + throwable);
                StudyListEditor.this.studyWindowClosed(this);
                return true;
            }
            int n = StudyListEditor.this.studyListModel.indexOfStudy(new Integer(this.study.key));
            if (n >= 0) {
                StudyListEditor.this.studyListModel.get(n).openWindow = studyEditor;
            }
            AppManager.showWindow(studyEditor);
            return true;
        }
    }

    private class StudyListTableModel
    extends AbstractTableModel {
        private static final String STUDY_NAME_COLUMN = "Name";
        private static final String STUDY_DESCRIPTION_COLUMN = "Description";
        private static final String STUDY_TEMPLATE_COLUMN = "Template";
        private static final String STUDY_CDBS_NAME_COLUMN = "CDBS Data";
        private static final String STUDY_CACHE_SIZE_COLUMN = "Cache Size";
        private String[] columnNames = new String[]{"Name", "Description", "Template", "CDBS Data", "Cache Size"};
        private static final int STUDY_NAME_INDEX = 0;
        private static final int STUDY_DESCRIPTION_INDEX = 1;
        private static final int STUDY_TEMPLATE_INDEX = 2;
        private static final int STUDY_CDBS_NAME_INDEX = 3;
        private static final int STUDY_CACHE_SIZE_INDEX = 4;
        private ArrayList<StudyListItem> modelRows = new ArrayList();

        private StudyListTableModel() {
        }

        private JTable createTable(EditMenu editMenu) {
            JTable jTable = new JTable(this);
            AppManager.configureTable(jTable, editMenu);
            jTable.setAutoCreateRowSorter(true);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    StudyListItem studyListItem = (StudyListItem)StudyListTableModel.this.modelRows.get(jTable.convertRowIndexToModel(n));
                    if (null != studyListItem.openWindow) {
                        switch (studyListItem.openWindow.getStudyLock()) {
                            default: {
                                jLabel.setForeground(Color.BLACK);
                                break;
                            }
                            case 1: 
                            case 4: {
                                jLabel.setForeground(Color.BLUE);
                                break;
                            }
                            case 2: 
                            case 3: {
                                jLabel.setForeground(Color.RED);
                                break;
                            }
                        }
                    } else if (0 != studyListItem.studyLock) {
                        jLabel.setForeground(Color.GRAY);
                    } else if (studyListItem.newStudy || studyListItem.needsUpdate) {
                        jLabel.setForeground(Color.GREEN.darker());
                    } else {
                        jLabel.setForeground(Color.BLACK);
                    }
                    return jLabel;
                }
            };
            int n = AppManager.getTextFieldWidth(5);
            int n2 = AppManager.getTextFieldWidth(6);
            int n3 = AppManager.getTextFieldWidth(12);
            int n4 = AppManager.getTextFieldWidth(30);
            TableColumn tableColumn = jTable.getColumn(STUDY_NAME_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n3);
            tableColumn = jTable.getColumn(STUDY_DESCRIPTION_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n4);
            tableColumn = jTable.getColumn(STUDY_TEMPLATE_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n3);
            tableColumn = jTable.getColumn(STUDY_CDBS_NAME_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n3);
            tableColumn = jTable.getColumn(STUDY_CACHE_SIZE_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n2);
            return jTable;
        }

        private void setItems(ArrayList<StudyListItem> arrayList) {
            HashMap<Integer, StudyListItem> hashMap = new HashMap<Integer, StudyListItem>();
            for (StudyListItem studyListItem2 : this.modelRows) {
                hashMap.put(studyListItem2.key, studyListItem2);
            }
            this.modelRows.clear();
            StudyListEditor.this.clearUpdateItems();
            StudyListEditor.this.clearUpdatedItems();
            if (null != arrayList && !arrayList.isEmpty()) {
                HashSet hashSet = new HashSet(arrayList.size());
                for (StudyListItem studyListItem : arrayList) {
                    StudyListItem studyListItem2;
                    if (!hashSet.add(studyListItem.key)) continue;
                    studyListItem2 = (StudyListItem)hashMap.remove(studyListItem.key);
                    if (null == studyListItem2) {
                        studyListItem2 = studyListItem;
                    } else {
                        studyListItem2.name = studyListItem.name;
                        studyListItem2.description = studyListItem.description;
                        studyListItem2.studyLock = studyListItem.studyLock;
                        studyListItem2.lockCount = studyListItem.lockCount;
                        studyListItem2.newStudy = studyListItem.newStudy;
                        studyListItem2.needsUpdate = studyListItem.needsUpdate;
                        studyListItem2.templateName = studyListItem.templateName;
                        studyListItem2.cdbsName = studyListItem.cdbsName;
                    }
                    this.modelRows.add(studyListItem2);
                    if (!studyListItem2.isCacheSizeExpired()) continue;
                    StudyListEditor.this.addUpdateItem(studyListItem2);
                }
            }
            this.fireTableDataChanged();
        }

        private void remove(int n) {
            this.modelRows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        private void remove(StudyListItem studyListItem) {
            int n = this.modelRows.indexOf(studyListItem);
            if (n >= 0) {
                this.modelRows.remove(n);
                this.fireTableRowsDeleted(n, n);
            }
        }

        private void itemWasChanged(int n) {
            this.fireTableRowsUpdated(n, n);
        }

        private void itemWasChanged(StudyListItem studyListItem) {
            int n = this.modelRows.indexOf(studyListItem);
            if (n >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
        }

        private int indexOf(StudyListItem studyListItem) {
            return this.modelRows.indexOf(studyListItem);
        }

        private int indexOfStudy(Integer n) {
            int n2 = 0;
            for (StudyListItem studyListItem : this.modelRows) {
                if (studyListItem.key.equals(n)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        private StudyListItem get(int n) {
            return this.modelRows.get(n);
        }

        private double getTotalMemoryFraction() {
            double d = 0.0;
            for (StudyListItem studyListItem : this.modelRows) {
                if (null == studyListItem.openWindow) continue;
                d += studyListItem.openWindow.getMemoryFraction();
            }
            return d;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.modelRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            StudyListItem studyListItem = this.modelRows.get(n);
            switch (n2) {
                case 0: {
                    return studyListItem.name;
                }
                case 1: {
                    return studyListItem.description;
                }
                case 2: {
                    return studyListItem.templateName;
                }
                case 3: {
                    return studyListItem.cdbsName;
                }
                case 4: {
                    return studyListItem.getCacheSize();
                }
            }
            return "";
        }
    }

    private class StudyListItem {
        private Integer key;
        private String name;
        private String description;
        private int studyLock;
        private int lockCount;
        private boolean newStudy;
        private boolean needsUpdate;
        private String templateName;
        private String cdbsName;
        private StudyWindow openWindow;
        private long cacheSize;
        private long lastCacheCheck;

        private StudyListItem() {
        }

        private synchronized String getCacheSize() {
            if (this.cacheSize < 0L) {
                return "-";
            }
            if ((double)this.cacheSize >= 1.0E9) {
                return String.format("%.2f GB", (double)this.cacheSize / 1.0E9);
            }
            if ((double)this.cacheSize >= 1000000.0) {
                return String.format("%.1f MB", (double)this.cacheSize / 1000000.0);
            }
            return String.format("%.0f kB", (double)this.cacheSize / 1000.0);
        }

        private synchronized boolean isCacheSizeExpired() {
            return System.currentTimeMillis() - this.lastCacheCheck > 600000L;
        }

        private void updateCacheSize() {
            this.setCacheSize(Study.getStudyCacheSize(StudyListEditor.this.dbID, this.key));
        }

        private synchronized void setCacheSize(long l) {
            this.cacheSize = l;
            this.lastCacheCheck = System.currentTimeMillis();
        }

        private synchronized void clearCacheSize() {
            this.cacheSize = -1L;
            this.lastCacheCheck = 0L;
        }
    }
}

