/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.editdata.IxRuleEditData;
import gov.fcc.tvstudy.editdata.ParameterEditData;
import gov.fcc.tvstudy.editdata.ScenarioEditData;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.editdata.StudyTemplate;
import gov.fcc.tvstudy.editor.IxRuleEditor;
import gov.fcc.tvstudy.editor.IxRuleEnableDisable;
import gov.fcc.tvstudy.editor.ParameterEditor;
import gov.fcc.tvstudy.editor.RootEditor;
import gov.fcc.tvstudy.editor.ScenarioEditor;
import gov.fcc.tvstudy.editor.StudyWindow;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.QueryWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class StudyEditor
extends RootEditor
implements StudyWindow {
    public static final String WINDOW_TITLE = "Study";
    private StudyEditData study;
    private JTextField studyNameField;
    private JTextArea studyDescriptionArea;
    private ArrayList<ParameterEditor> parameterEditors;
    private boolean hasNewParameters;
    private JTable ixRuleTable;
    private JTable scenarioTable;
    private ArrayList<ScenarioEditor> scenarioEditors;
    private JButton saveButton;
    private JButton editIxRuleButton;
    private JButton enableIxRuleButton;
    private JButton disableIxRuleButton;
    private JMenuItem editIxRuleMenuItem;
    private JMenuItem deleteIxRuleMenuItem;
    private JMenuItem enableIxRuleMenuItem;
    private JMenuItem disableIxRuleMenuItem;
    private JButton openScenarioButton;
    private JMenuItem duplicateScenarioMenuItem;
    private JMenuItem openScenarioMenuItem;
    private JMenuItem deleteScenarioMenuItem;
    private JMenuItem exportScenarioMenuItem;
    private File lastImportExport;
    private JMenuItem revertAllParametersMenuItem;
    private JTabbedPane editorTabPane;
    private int lastSelectedTab = -1;
    private IxRuleEditor ixRuleEditor;
    private IxRuleEnableDisable ixRuleEnableDisableDialog;
    private boolean dataChanged;
    private boolean inQuery;

    public StudyEditor(StudyEditData studyEditData) {
        super(WINDOW_TITLE);
        this.study = studyEditData;
        this.setTitleKey(this.study.study.key);
        this.blockActionsStart();
        this.studyNameField = new JTextField(30);
        AppManager.fixKeyBindings(this.studyNameField);
        final StudyEditor studyEditor = this;
        this.studyNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StudyEditor.this.blockActions()) {
                    String string = StudyEditor.this.studyNameField.getText().trim();
                    if (!((StudyEditor)StudyEditor.this).study.name.equalsIgnoreCase(string) && DbManager.checkStudyName(string, StudyEditor.this.study, new ErrorReporter(studyEditor, studyEditor, "Change Study Name"))) {
                        ((StudyEditor)StudyEditor.this).study.name = string;
                        StudyEditor.this.updateDocumentName();
                    }
                    StudyEditor.this.blockActionsEnd();
                }
                StudyEditor.this.studyNameField.setText(((StudyEditor)StudyEditor.this).study.name);
            }
        });
        this.studyNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    StudyEditor.this.studyNameField.postActionEvent();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Study Name"));
        jPanel.add(this.studyNameField);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel);
        this.studyNameField.setText(this.study.name);
        this.studyDescriptionArea = new JTextArea(6, 40);
        AppManager.fixKeyBindings(this.studyDescriptionArea);
        this.studyDescriptionArea.setLineWrap(true);
        this.studyDescriptionArea.setWrapStyleWord(true);
        this.studyDescriptionArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ((StudyEditor)StudyEditor.this).study.description = StudyEditor.this.studyDescriptionArea.getText().trim();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ((StudyEditor)StudyEditor.this).study.description = StudyEditor.this.studyDescriptionArea.getText().trim();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Study Description"));
        jPanel3.add((Component)AppManager.createScrollPane(this.studyDescriptionArea), "Center");
        this.studyDescriptionArea.setText(this.study.description);
        this.study.description = this.studyDescriptionArea.getText().trim();
        this.parameterEditors = new ArrayList();
        JComponent jComponent = ParameterEditor.createEditorLayout(this, this.study.parameters, false, this.parameterEditors);
        for (ParameterEditData object2 : this.study.parameters) {
            if (null != object2.parameter.value) continue;
            this.hasNewParameters = true;
        }
        JPanel jPanel4 = new JPanel(new BorderLayout());
        if (this.hasNewParameters) {
            jPanel4.setBorder(BorderFactory.createTitledBorder("Study Parameters (new in red)"));
        } else {
            jPanel4.setBorder(BorderFactory.createTitledBorder("Study Parameters"));
        }
        jPanel4.add((Component)jComponent, "Center");
        this.ixRuleTable = this.study.ixRuleModel.createTable(this.editMenu);
        this.ixRuleTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 == mouseEvent.getClickCount()) {
                    StudyEditor.this.doEditIxRule();
                }
            }
        });
        this.ixRuleTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StudyEditor.this.updateRuleControls();
            }
        });
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder("Interference Rules"));
        jPanel5.add((Component)AppManager.createScrollPane(this.ixRuleTable), "Center");
        this.scenarioTable = this.study.scenarioModel.createTable(this.editMenu);
        this.scenarioTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 == mouseEvent.getClickCount()) {
                    StudyEditor.this.doOpenScenario();
                }
            }
        });
        this.scenarioTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StudyEditor.this.updateScenarioControls();
            }
        });
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder("Scenarios"));
        jPanel6.add((Component)AppManager.createScrollPane(this.scenarioTable), "Center");
        this.scenarioEditors = new ArrayList();
        this.blockActionsEnd();
        this.saveButton = new JButton("Save Study");
        this.saveButton.setFocusable(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.saveIfNeeded("Save Study", false);
            }
        });
        JButton jButton = new JButton("New");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doNewIxRule();
            }
        });
        this.editIxRuleButton = !this.study.study.templateLocked ? new JButton("Edit") : new JButton("View");
        this.editIxRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doEditIxRule();
            }
        });
        this.enableIxRuleButton = new JButton("Enable");
        this.enableIxRuleButton.setFocusable(false);
        this.enableIxRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doSetIxRuleActive(true);
            }
        });
        this.disableIxRuleButton = new JButton("Disable");
        this.disableIxRuleButton.setFocusable(false);
        this.disableIxRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doSetIxRuleActive(false);
            }
        });
        JButton jButton2 = new JButton("New");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doNewScenario();
            }
        });
        this.openScenarioButton = new JButton("Open");
        this.openScenarioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doOpenScenario();
            }
        });
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.add(jButton2);
        JPanel jPanel8 = new JPanel(new FlowLayout(2));
        jPanel8.add(this.openScenarioButton);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        jPanel9.add(jPanel7);
        jPanel9.add(jPanel8);
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.add((Component)jPanel6, "Center");
        jPanel10.add((Component)jPanel9, "South");
        JPanel jPanel11 = new JPanel(new FlowLayout(0));
        jPanel11.add(jButton);
        JPanel jPanel12 = new JPanel(new FlowLayout(2));
        jPanel12.add(this.enableIxRuleButton);
        jPanel12.add(this.disableIxRuleButton);
        jPanel12.add(this.editIxRuleButton);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BoxLayout(jPanel13, 0));
        jPanel13.add(jPanel11);
        jPanel13.add(jPanel12);
        JPanel jPanel14 = new JPanel(new BorderLayout());
        jPanel14.add((Component)jPanel5, "Center");
        jPanel14.add((Component)jPanel13, "South");
        JPanel jPanel15 = new JPanel(new BorderLayout());
        jPanel15.add((Component)jPanel2, "North");
        jPanel15.add((Component)jPanel3, "Center");
        JPanel jPanel16 = new JPanel(new BorderLayout());
        jPanel16.add((Component)jPanel15, "North");
        jPanel16.add((Component)jPanel4, "Center");
        this.editorTabPane = new JTabbedPane();
        this.editorTabPane.addTab("Scenarios", jPanel10);
        this.editorTabPane.addTab("Rules", jPanel14);
        this.editorTabPane.addTab(WINDOW_TITLE, jPanel16);
        this.editorTabPane.setSelectedIndex(0);
        this.editorTabPane.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                StudyEditor.this.updateFileMenu();
            }
        });
        JPanel jPanel17 = new JPanel(new FlowLayout(2));
        jPanel17.add(this.saveButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.editorTabPane, "Center");
        container.add((Component)jPanel17, "South");
        this.pack();
        Dimension dimension = new Dimension(960, 650);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.updateFileMenu();
        this.ixRuleEditor = new IxRuleEditor(this, this);
        this.ixRuleEnableDisableDialog = new IxRuleEnableDisable(this, this.study);
        this.updateDocumentName();
    }

    private void updateFileMenu() {
        JMenuItem jMenuItem;
        int n = this.editorTabPane.getSelectedIndex();
        if (n == this.lastSelectedTab) {
            return;
        }
        this.lastSelectedTab = n;
        this.fileMenu.removeAll();
        switch (n) {
            case 0: {
                this.getRootPane().setDefaultButton(this.openScenarioButton);
                this.fileMenu.setText("Scenario");
                jMenuItem = new JMenuItem("Previous");
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, AppManager.MENU_SHORTCUT_KEY_MASK));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doPreviousScenario();
                    }
                });
                this.fileMenu.add(jMenuItem);
                JMenuItem jMenuItem2 = new JMenuItem("Next");
                jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(40, AppManager.MENU_SHORTCUT_KEY_MASK));
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doNextScenario();
                    }
                });
                this.fileMenu.add(jMenuItem2);
                this.fileMenu.addSeparator();
                JMenuItem jMenuItem3 = new JMenuItem("New...");
                jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(78, AppManager.MENU_SHORTCUT_KEY_MASK));
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doNewScenario();
                    }
                });
                this.fileMenu.add(jMenuItem3);
                this.duplicateScenarioMenuItem = new JMenuItem("Duplicate...");
                this.duplicateScenarioMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doDuplicateScenario();
                    }
                });
                this.fileMenu.add(this.duplicateScenarioMenuItem);
                this.fileMenu.addSeparator();
                JMenuItem jMenuItem4 = new JMenuItem("Import...");
                jMenuItem4.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doImportScenarios();
                    }
                });
                this.fileMenu.add(jMenuItem4);
                this.exportScenarioMenuItem = new JMenuItem("Export...");
                this.exportScenarioMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doExportScenarios();
                    }
                });
                this.fileMenu.add(this.exportScenarioMenuItem);
                this.fileMenu.addSeparator();
                this.openScenarioMenuItem = new JMenuItem("Open");
                this.openScenarioMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppManager.MENU_SHORTCUT_KEY_MASK));
                this.openScenarioMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doOpenScenario();
                    }
                });
                this.fileMenu.add(this.openScenarioMenuItem);
                this.deleteScenarioMenuItem = new JMenuItem("Delete");
                this.deleteScenarioMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doDeleteScenarios();
                    }
                });
                this.fileMenu.add(this.deleteScenarioMenuItem);
                this.fileMenu.addSeparator();
                JMenuItem jMenuItem5 = new JMenuItem("Delete Unused Records");
                jMenuItem5.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doDeleteUnusedSources();
                    }
                });
                this.fileMenu.add(jMenuItem5);
                this.fileMenu.addSeparator();
                this.updateScenarioControls();
                break;
            }
            case 1: {
                this.getRootPane().setDefaultButton(this.editIxRuleButton);
                this.fileMenu.setText("Rule");
                jMenuItem = new JMenuItem("Previous");
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, AppManager.MENU_SHORTCUT_KEY_MASK));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doPreviousRule();
                    }
                });
                this.fileMenu.add(jMenuItem);
                JMenuItem jMenuItem6 = new JMenuItem("Next");
                jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(40, AppManager.MENU_SHORTCUT_KEY_MASK));
                jMenuItem6.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doNextRule();
                    }
                });
                this.fileMenu.add(jMenuItem6);
                this.fileMenu.addSeparator();
                JMenuItem jMenuItem7 = new JMenuItem("New...");
                jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(78, AppManager.MENU_SHORTCUT_KEY_MASK));
                if (!this.study.study.templateLocked) {
                    jMenuItem7.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            StudyEditor.this.doNewIxRule();
                        }
                    });
                } else {
                    jMenuItem7.setEnabled(false);
                }
                this.fileMenu.add(jMenuItem7);
                this.fileMenu.addSeparator();
                this.editIxRuleMenuItem = !this.study.study.templateLocked ? new JMenuItem("Edit") : new JMenuItem("View");
                this.editIxRuleMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppManager.MENU_SHORTCUT_KEY_MASK));
                this.editIxRuleMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doEditIxRule();
                    }
                });
                this.fileMenu.add(this.editIxRuleMenuItem);
                this.deleteIxRuleMenuItem = new JMenuItem("Delete");
                if (!this.study.study.templateLocked) {
                    this.deleteIxRuleMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            StudyEditor.this.doDeleteIxRule();
                        }
                    });
                } else {
                    this.deleteIxRuleMenuItem.setEnabled(false);
                }
                this.fileMenu.add(this.deleteIxRuleMenuItem);
                this.fileMenu.addSeparator();
                this.enableIxRuleMenuItem = new JMenuItem("Enable");
                this.enableIxRuleMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, AppManager.MENU_SHORTCUT_KEY_MASK));
                this.enableIxRuleMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doSetIxRuleActive(true);
                    }
                });
                this.fileMenu.add(this.enableIxRuleMenuItem);
                this.disableIxRuleMenuItem = new JMenuItem("Disable");
                this.disableIxRuleMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, AppManager.MENU_SHORTCUT_KEY_MASK));
                this.disableIxRuleMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doSetIxRuleActive(false);
                    }
                });
                this.fileMenu.add(this.disableIxRuleMenuItem);
                JMenuItem jMenuItem8 = new JMenuItem("Enable/Disable by Type...");
                jMenuItem8.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doEnableDisableRules();
                    }
                });
                this.fileMenu.add(jMenuItem8);
                this.fileMenu.addSeparator();
                this.updateRuleControls();
                break;
            }
            case 2: {
                this.getRootPane().setDefaultButton(null);
                this.fileMenu.setText(WINDOW_TITLE);
                this.revertAllParametersMenuItem = new JMenuItem("Revert All Parameters");
                if (this.study.study.templateLocked) {
                    this.revertAllParametersMenuItem.setEnabled(false);
                } else {
                    this.revertAllParametersMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            StudyEditor.this.doRevertAllParameters();
                        }
                    });
                }
                this.fileMenu.add(this.revertAllParametersMenuItem);
                this.fileMenu.addSeparator();
                jMenuItem = new JMenuItem("Save New Template...");
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doSaveNewTemplate();
                    }
                });
                this.fileMenu.add(jMenuItem);
                this.fileMenu.addSeparator();
                break;
            }
        }
        jMenuItem = new JMenuItem("Save Study");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, AppManager.MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.saveIfNeeded("Save Study", false);
            }
        });
        this.fileMenu.add(jMenuItem);
    }

    private void updateRuleControls() {
        int n = this.ixRuleTable.getSelectedRowCount();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (1 == n) {
            bl = true;
            bl2 = !this.study.study.templateLocked;
            IxRuleEditData ixRuleEditData = this.study.ixRuleModel.get(this.ixRuleTable.convertRowIndexToModel(this.ixRuleTable.getSelectedRow()));
            if (ixRuleEditData.isActive) {
                bl4 = true;
            } else {
                bl3 = true;
            }
        } else if (n > 1) {
            int[] nArray = this.ixRuleTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                IxRuleEditData ixRuleEditData = this.study.ixRuleModel.get(this.ixRuleTable.convertRowIndexToModel(nArray[i]));
                if (ixRuleEditData.isActive) {
                    bl4 = true;
                    if (!bl3) continue;
                    break;
                }
                bl3 = true;
                if (bl4) break;
            }
        }
        this.editIxRuleButton.setEnabled(bl);
        this.editIxRuleMenuItem.setEnabled(bl);
        this.deleteIxRuleMenuItem.setEnabled(bl2);
        this.enableIxRuleButton.setEnabled(bl3);
        this.enableIxRuleMenuItem.setEnabled(bl3);
        this.disableIxRuleButton.setEnabled(bl4);
        this.disableIxRuleMenuItem.setEnabled(bl4);
    }

    private void updateScenarioControls() {
        int n = this.scenarioTable.getSelectedRowCount();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (1 == n) {
            bl = true;
            bl2 = true;
            bl3 = true;
            bl4 = true;
        } else if (n > 1) {
            bl2 = true;
            bl4 = true;
        }
        this.openScenarioButton.setEnabled(bl);
        this.openScenarioMenuItem.setEnabled(bl);
        this.deleteScenarioMenuItem.setEnabled(bl2);
        this.duplicateScenarioMenuItem.setEnabled(bl3);
        this.exportScenarioMenuItem.setEnabled(bl4);
    }

    @Override
    public void dispose() {
        this.ixRuleEditor.dispose();
        this.ixRuleEnableDisableDialog.dispose();
        super.dispose();
    }

    @Override
    public String getDbID() {
        return this.study.dbID;
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(DbManager.getDbHost(this.study.dbID) + "/" + this.study.name);
        for (ScenarioEditor scenarioEditor : this.scenarioEditors) {
            scenarioEditor.updateDocumentName();
        }
        this.ixRuleEditor.updateDocumentName();
        this.ixRuleEnableDisableDialog.updateDocumentName();
    }

    @Override
    public int getStudyKey() {
        return this.study.study.key;
    }

    @Override
    public int getStudyLock() {
        return this.study.study.studyLock;
    }

    @Override
    public int getLockCount() {
        return this.study.study.lockCount;
    }

    @Override
    public void toFront() {
        super.toFront();
    }

    @Override
    public double getMemoryFraction() {
        return 0.0;
    }

    @Override
    protected boolean isDataValid(String string) {
        Object object;
        if (!super.isDataValid(string)) {
            return false;
        }
        if (this.inQuery) {
            this.reportValidationError(this, string, "Database operations are in progress.", 2);
            return false;
        }
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible()) {
            this.reportValidationError(this, string, "Please close all editing dialogs before saving.", 2);
            return false;
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (keyboardFocusManager.getFocusedWindow() == this && null != (object = keyboardFocusManager.getFocusOwner()) && object instanceof JTextField) {
            ((JTextField)object).postActionEvent();
        }
        if (this.isValidationErrorPending()) {
            return false;
        }
        for (ScenarioEditor scenarioEditor : this.scenarioEditors) {
            if (scenarioEditor.isDataValid(string)) continue;
            return false;
        }
        return this.study.isDataValid(new ErrorReporter(this, this, string));
    }

    @Override
    protected boolean isDataChanged() {
        this.dataChanged = this.study.isDataChanged();
        return this.dataChanged;
    }

    @Override
    protected boolean save(String string) {
        if (this.inQuery) {
            this.dataChanged = false;
            return false;
        }
        if (!super.save(string)) {
            this.dataChanged = false;
            return false;
        }
        if (!this.dataChanged) {
            return false;
        }
        this.dataChanged = false;
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        QueryWorker<Boolean> queryWorker = new QueryWorker<Boolean>((Window)this, string, dbConnection){

            @Override
            protected Boolean doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                return StudyEditor.this.study.save(dbConnection, errorReporter);
            }
        };
        this.inQuery = true;
        Boolean bl = (Boolean)queryWorker.runQuery("Saving study, please wait...", errorReporter);
        boolean bl2 = false;
        if (null != bl) {
            bl2 = bl;
        }
        this.inQuery = false;
        if (errorReporter.hasMessages()) {
            AppManager.showLongMessage(this, errorReporter.getMessages(), string);
        }
        if (bl2) {
            DbManager.getStudyListEditor(this.study.dbID).studyWasChanged(this.study.study.key);
            return true;
        }
        return false;
    }

    @Override
    public boolean saveIfNeeded(String string, boolean bl) {
        if (this.inQuery) {
            return false;
        }
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        String string2 = null;
        if (dbConnection.connect()) {
            try {
                dbConnection.query("SELECT study_lock, lock_count FROM tvstudy.study WHERE study_key = " + this.study.study.key);
                if (dbConnection.next()) {
                    if (1 != dbConnection.getInt(1) || this.study.study.lockCount != dbConnection.getInt(2)) {
                        string2 = "The study database lock was modified.\n";
                    }
                } else {
                    string2 = "The study does not exist.\n";
                }
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
                string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            }
            dbConnection.close();
        } else {
            string2 = "A connection to the database server cannot be established.";
        }
        if (null != string2) {
            AppManager.beep();
            return 0 != JOptionPane.showConfirmDialog(this, string2 + "\n\nThe study cannot be saved.  You may keep the window open to view data\n" + "or save the study as a template.  Do you want to keep the window open?", string, 0, 0);
        }
        return super.saveIfNeeded(string, bl);
    }

    private void doPreviousRule() {
        int n = this.ixRuleTable.getRowCount();
        int n2 = this.ixRuleTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.ixRuleTable.setRowSelectionInterval(n2, n2);
            this.ixRuleTable.scrollRectToVisible(this.ixRuleTable.getCellRect(n2, 0, true));
        }
    }

    private void doNextRule() {
        int n = this.ixRuleTable.getRowCount();
        int n2 = this.ixRuleTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.ixRuleTable.setRowSelectionInterval(n2, n2);
            this.ixRuleTable.scrollRectToVisible(this.ixRuleTable.getCellRect(n2, 0, true));
        }
    }

    private void doNewIxRule() {
        int n;
        if (this.study.study.templateLocked) {
            return;
        }
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        IxRuleEditData ixRuleEditData = new IxRuleEditData(this.study, null);
        this.ixRuleEditor.setIxRule(ixRuleEditData);
        AppManager.showWindow(this.ixRuleEditor);
        if (this.ixRuleEditor.canceled) {
            return;
        }
        ixRuleEditData = this.ixRuleEditor.getIxRule();
        if (this.study.ixRuleModel.isIxRuleUnique(ixRuleEditData, new ErrorReporter(this, this, "Add Interference Rule")) && (n = this.study.ixRuleModel.addOrReplace(ixRuleEditData)) >= 0) {
            n = this.ixRuleTable.convertRowIndexToView(n);
            this.ixRuleTable.setRowSelectionInterval(n, n);
            this.ixRuleTable.scrollRectToVisible(this.ixRuleTable.getCellRect(n, 0, true));
        }
    }

    private void doEditIxRule() {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        if (this.ixRuleTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.ixRuleTable.convertRowIndexToModel(this.ixRuleTable.getSelectedRow());
        IxRuleEditData ixRuleEditData = this.study.ixRuleModel.get(n);
        this.ixRuleEditor.setIxRule(ixRuleEditData);
        AppManager.showWindow(this.ixRuleEditor);
        if (this.ixRuleEditor.canceled || this.study.study.templateLocked) {
            return;
        }
        ixRuleEditData = this.ixRuleEditor.getIxRule();
        if (this.study.ixRuleModel.isIxRuleUnique(ixRuleEditData, new ErrorReporter(this, this, "Edit Interference Rule"))) {
            this.study.ixRuleModel.addOrReplace(ixRuleEditData);
        }
    }

    private void doDeleteIxRule() {
        if (this.study.study.templateLocked) {
            return;
        }
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        if (0 == this.ixRuleTable.getSelectedRowCount()) {
            return;
        }
        int[] nArray = this.ixRuleTable.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.ixRuleTable.convertRowIndexToModel(nArray[i]);
        }
        this.study.ixRuleModel.remove(nArray2);
    }

    private void doSetIxRuleActive(boolean bl) {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        if (0 == this.ixRuleTable.getSelectedRowCount()) {
            return;
        }
        int[] nArray = this.ixRuleTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            this.study.ixRuleModel.setActive(this.ixRuleTable.convertRowIndexToModel(nArray[i]), bl);
        }
        this.updateRuleControls();
    }

    private void doEnableDisableRules() {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        AppManager.showWindow(this.ixRuleEnableDisableDialog);
        if (this.ixRuleEnableDisableDialog.canceled) {
            return;
        }
        this.updateRuleControls();
    }

    private void doPreviousScenario() {
        int n = this.scenarioTable.getRowCount();
        int n2 = this.scenarioTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.scenarioTable.setRowSelectionInterval(n2, n2);
            this.scenarioTable.scrollRectToVisible(this.scenarioTable.getCellRect(n2, 0, true));
        }
    }

    private void doNextScenario() {
        int n = this.scenarioTable.getRowCount();
        int n2 = this.scenarioTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.scenarioTable.setRowSelectionInterval(n2, n2);
            this.scenarioTable.scrollRectToVisible(this.scenarioTable.getCellRect(n2, 0, true));
        }
    }

    private void doNewScenario() {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        String string = "New Scenario";
        ErrorReporter errorReporter = new ErrorReporter(this, this, string);
        String string2 = "";
        do {
            if (null != (string2 = JOptionPane.showInputDialog(this, "Enter a name for the new scenario", string, 3))) continue;
            return;
        } while (!DbManager.checkScenarioName(string2 = string2.trim(), this.study, errorReporter));
        ScenarioEditData scenarioEditData = new ScenarioEditData(this.study, null);
        scenarioEditData.name = string2;
        scenarioEditData.description = "New scenario";
        int n = this.study.scenarioModel.addOrReplace(scenarioEditData);
        n = this.scenarioTable.convertRowIndexToView(n);
        this.scenarioTable.setRowSelectionInterval(n, n);
        this.scenarioTable.scrollRectToVisible(this.scenarioTable.getCellRect(n, 0, true));
        this.doOpenScenario();
    }

    private void doDuplicateScenario() {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        if (this.scenarioTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.scenarioTable.convertRowIndexToModel(this.scenarioTable.getSelectedRow());
        ScenarioEditData scenarioEditData = this.study.scenarioModel.get(n);
        String string = "Duplicate Scenario";
        ErrorReporter errorReporter = new ErrorReporter(this, this, string);
        String string2 = "";
        do {
            if (null != (string2 = JOptionPane.showInputDialog(this, "Enter a name for the new scenario", string, 3))) continue;
            return;
        } while (!DbManager.checkScenarioName(string2 = string2.trim(), this.study, errorReporter));
        if (null == (scenarioEditData = scenarioEditData.duplicate(string2, errorReporter))) {
            return;
        }
        n = this.study.scenarioModel.addOrReplace(scenarioEditData);
        n = this.scenarioTable.convertRowIndexToView(n);
        this.scenarioTable.setRowSelectionInterval(n, n);
        this.scenarioTable.scrollRectToVisible(this.scenarioTable.getCellRect(n, 0, true));
        this.doOpenScenario();
    }

    private void doImportScenarios() {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        String string = "Import Scenarios";
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        JFileChooser jFileChooser = new JFileChooser(this.lastImportExport);
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XML file", "xml", "XML"));
        if (0 != jFileChooser.showDialog(this, "Import")) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            errorReporter.reportError("Could not open the file:\n" + fileNotFoundException.getMessage());
            return;
        }
        this.lastImportExport = file.getParentFile();
        final BufferedReader bufferedReader = new BufferedReader(fileReader);
        QueryWorker<Object> queryWorker = new QueryWorker<Object>((Window)this, string, dbConnection){

            @Override
            protected Object doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                StudyEditor.this.study.readScenariosFromXML(dbConnection, bufferedReader, errorReporter);
                return null;
            }
        };
        this.inQuery = true;
        queryWorker.runQuery("Importing scenarios, please wait...", errorReporter);
        this.inQuery = false;
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (errorReporter.hasMessages()) {
            AppManager.showLongMessage(this, errorReporter.getMessages(), string);
        }
    }

    private void doExportScenarios() {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        if (0 == this.scenarioTable.getSelectedRowCount()) {
            return;
        }
        String string = "Export Scenarios";
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        JFileChooser jFileChooser = new JFileChooser(this.lastImportExport);
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        File file = null;
        do {
            if (0 != jFileChooser.showDialog(this, "Export")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            if (!file.exists()) continue;
            AppManager.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        String string2 = file.getName();
        if (!string2.endsWith(".xml") && !string2.endsWith(".XML")) {
            file = new File(file.getAbsolutePath() + ".xml");
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return;
        }
        this.lastImportExport = file.getParentFile();
        final BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        final ArrayList<ScenarioEditData> arrayList = new ArrayList<ScenarioEditData>();
        int[] nArray = this.scenarioTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.study.scenarioModel.get(this.scenarioTable.convertRowIndexToModel(nArray[i])));
        }
        QueryWorker<Object> queryWorker = new QueryWorker<Object>((Window)this, string, dbConnection){

            @Override
            protected Object doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                StudyEditor.this.study.writeScenariosToXML(dbConnection, bufferedWriter, arrayList, errorReporter);
                return null;
            }
        };
        this.inQuery = true;
        queryWorker.runQuery("Exporting scenarios, please wait...", errorReporter);
        this.inQuery = false;
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doOpenScenario() {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        if (this.scenarioTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.scenarioTable.convertRowIndexToModel(this.scenarioTable.getSelectedRow());
        ScenarioEditData scenarioEditData = this.study.scenarioModel.get(n);
        ScenarioEditor scenarioEditor = this.findScenarioEditorFor(scenarioEditData);
        if (null != scenarioEditor) {
            scenarioEditor.toFront();
        } else {
            scenarioEditor = new ScenarioEditor(this, this, scenarioEditData);
            this.scenarioEditors.add(scenarioEditor);
            AppManager.showWindow(scenarioEditor);
        }
    }

    private void doDeleteScenarios() {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        if (0 == this.scenarioTable.getSelectedRowCount()) {
            return;
        }
        String string = "Delete Scenarios";
        int[] nArray = this.scenarioTable.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.scenarioTable.convertRowIndexToModel(nArray[i]);
        }
        if (nArray2.length > 1) {
            AppManager.beep();
            if (0 != JOptionPane.showConfirmDialog(this, "Are you sure you want to delete multiple scenarios?", string, 0, 2)) {
                return;
            }
        }
        ArrayList<ScenarioEditor> arrayList = new ArrayList<ScenarioEditor>(this.scenarioEditors);
        for (ScenarioEditor scenarioEditor : arrayList) {
            if (!scenarioEditor.closeWithoutSave()) {
                AppManager.showMessage(this, "A scenario editor window could not be closed.  Please\nclose scenario windows manually and try again.", string, 0);
                return;
            }
            this.scenarioEditors.remove(scenarioEditor);
        }
        this.study.scenarioModel.remove(nArray2);
    }

    private void doDeleteUnusedSources() {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        String string = "Delete Unused Records";
        int n = this.study.getUnusedSourceCount();
        if (0 == n) {
            AppManager.showMessage(this, "There are no unused records in the study.", string, 1);
            return;
        }
        AppManager.beep();
        if (0 != JOptionPane.showConfirmDialog(this, "Station records in the study that do not appear in any existing scenario will be\ndeleted.  The records will be re-created if needed again, however any calculation\nresults for those records currently in cache files will have to be re-computed.\n\nAre you sure you want to delete unused records?", string, 0, 3)) {
            return;
        }
        this.study.removeAllUnusedSources();
        AppManager.showMessage(this, "Deleted " + n + " records from the study.", string, 1);
    }

    private void doRevertAllParameters() {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        if (this.study.study.templateLocked) {
            return;
        }
        AppManager.beep();
        if (0 != JOptionPane.showConfirmDialog(this, "All unlocked study parameters will be set to default values\nfrom the study template.  Are you sure you want to do this?", "Revert All Parameters", 0, 3)) {
            return;
        }
        for (ParameterEditor parameterEditor : this.parameterEditors) {
            parameterEditor.setDefaultValue();
        }
    }

    private void doSaveNewTemplate() {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return;
        }
        String string = "Save New Template";
        ErrorReporter errorReporter = new ErrorReporter(this, this, string);
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        String string2 = "";
        int n = 0;
        do {
            if (null == (string2 = JOptionPane.showInputDialog(this, "Enter a name for the new template", string, 3))) {
                return;
            }
            if ((string2 = string2.trim()).length() <= 0) continue;
            n = StudyTemplate.getTemplateKeyForName(dbConnection, errorReporter, string2);
            if (n < 0) {
                return;
            }
            if (n <= 0) continue;
            errorReporter.reportWarning("A template with that name already exists.");
            string2 = "";
        } while (0 == string2.length());
        boolean bl = 0 == JOptionPane.showConfirmDialog(this, "Should parameters be locked in studies using the new template?", string, 0, 3);
        StudyTemplate.createNewTemplate(dbConnection, errorReporter, string2, bl, this.study);
    }

    public ScenarioEditor findScenarioEditorFor(ScenarioEditData scenarioEditData) {
        for (ScenarioEditor scenarioEditor : this.scenarioEditors) {
            if (!scenarioEditor.getScenario().equals(scenarioEditData)) continue;
            return scenarioEditor;
        }
        return null;
    }

    @Override
    public void otherWindowClosed(Window window) {
        this.scenarioEditors.remove(window);
    }

    @Override
    public boolean closeWithoutSave() {
        if (this.inQuery) {
            return false;
        }
        if (this.ixRuleEditor.isVisible() && !this.ixRuleEditor.cancel()) {
            return false;
        }
        if (this.ixRuleEnableDisableDialog.isVisible() && !this.ixRuleEnableDisableDialog.cancel()) {
            return false;
        }
        ArrayList<ScenarioEditor> arrayList = new ArrayList<ScenarioEditor>(this.scenarioEditors);
        for (ScenarioEditor scenarioEditor : arrayList) {
            if (scenarioEditor.closeWithoutSave()) continue;
            return false;
        }
        this.study.invalidate();
        DbManager.getStudyListEditor(this.study.dbID).studyWindowClosed(this);
        AppManager.hideWindow(this);
        return true;
    }

    @Override
    public void windowWillOpen() {
        DbManager.restoreColumnWidths(this.study.dbID, this.getKeyTitle() + ".Rules", this.ixRuleTable);
        DbManager.restoreColumnWidths(this.study.dbID, this.getKeyTitle() + ".Scenarios", this.scenarioTable);
        if (this.hasNewParameters) {
            final StudyEditor studyEditor = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String string = "New Parameters";
                    AppManager.beep();
                    AppManager.showMessage(studyEditor, "New parameters have been added to the study.", string, 1);
                }
            });
        }
    }

    @Override
    public boolean windowShouldClose() {
        if (this.ixRuleEditor.isVisible() || this.ixRuleEnableDisableDialog.isVisible() || this.inQuery) {
            return false;
        }
        ArrayList<ScenarioEditor> arrayList = new ArrayList<ScenarioEditor>(this.scenarioEditors);
        for (ScenarioEditor scenarioEditor : arrayList) {
            if (!scenarioEditor.windowShouldClose()) {
                return false;
            }
            AppManager.hideWindow(scenarioEditor);
        }
        String string = "Close Study";
        if (!this.saveIfNeeded(string, true)) {
            return false;
        }
        this.study.invalidate();
        DbManager.saveColumnWidths(this.study.dbID, this.getKeyTitle() + ".Rules", this.ixRuleTable);
        DbManager.saveColumnWidths(this.study.dbID, this.getKeyTitle() + ".Scenarios", this.scenarioTable);
        DbManager.getStudyListEditor(this.study.dbID).studyWindowClosed(this);
        return true;
    }
}

