/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.Study;
import gov.fcc.tvstudy.editdata.CDBSDatabase;
import gov.fcc.tvstudy.editdata.StudyTemplate;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.QueryWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class StudyCreateNew
extends AppDialog {
    public static final String WINDOW_TITLE = "Create New Study";
    private AppFrame parent;
    private JTextField nameField;
    private TemplateListModel templateModel;
    private JList templateList;
    private CDBSListModel cdbsModel;
    private JList cdbsList;
    private JButton exportTemplateButton;
    private JButton deleteTemplateButton;
    private File lastImportExport;
    private JButton deleteCDBSButton;
    private JButton okButton;
    private Integer studyKey;
    public boolean canceled;
    private boolean inQuery;

    public StudyCreateNew(AppFrame appFrame) {
        super((Window)appFrame, WINDOW_TITLE, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDisposeOnClose(false);
        this.parent = appFrame;
        this.nameField = new JTextField(20);
        AppManager.fixKeyBindings(this.nameField);
        this.templateModel = new TemplateListModel();
        this.templateList = this.templateModel.createList();
        this.templateList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                int n = StudyCreateNew.this.templateList.getSelectedIndex();
                if (n >= 0) {
                    StudyTemplate studyTemplate = StudyCreateNew.this.templateModel.get(n);
                    if (!studyTemplate.isLocked) {
                        bl = true;
                        if (0 == studyTemplate.useCount) {
                            bl2 = true;
                        }
                    }
                    if ((n = StudyCreateNew.this.cdbsList.getSelectedIndex()) >= 0) {
                        bl3 = true;
                    }
                }
                StudyCreateNew.this.exportTemplateButton.setEnabled(bl);
                StudyCreateNew.this.deleteTemplateButton.setEnabled(bl2);
                StudyCreateNew.this.okButton.setEnabled(bl3);
            }
        });
        this.cdbsModel = new CDBSListModel();
        this.cdbsList = this.cdbsModel.createList();
        this.cdbsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = false;
                boolean bl2 = false;
                int n = StudyCreateNew.this.cdbsList.getSelectedIndex();
                if (n >= 0) {
                    CDBSDatabase cDBSDatabase = StudyCreateNew.this.cdbsModel.get(n);
                    if (0 == cDBSDatabase.useCount) {
                        bl = true;
                    }
                    if ((n = StudyCreateNew.this.templateList.getSelectedIndex()) >= 0) {
                        bl2 = true;
                    }
                }
                StudyCreateNew.this.deleteCDBSButton.setEnabled(bl);
                StudyCreateNew.this.okButton.setEnabled(bl2);
            }
        });
        JButton jButton = new JButton("Import");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyCreateNew.this.doImportTemplate();
            }
        });
        this.exportTemplateButton = new JButton("Export");
        this.exportTemplateButton.setFocusable(false);
        this.exportTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyCreateNew.this.doExportTemplate();
            }
        });
        this.exportTemplateButton.setEnabled(false);
        this.deleteTemplateButton = new JButton("Delete");
        this.deleteTemplateButton.setFocusable(false);
        this.deleteTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyCreateNew.this.doDeleteTemplate();
            }
        });
        this.deleteTemplateButton.setEnabled(false);
        JButton jButton2 = new JButton("Add");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyCreateNew.this.doAddCDBS();
            }
        });
        this.deleteCDBSButton = new JButton("Delete");
        this.deleteCDBSButton.setFocusable(false);
        this.deleteCDBSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyCreateNew.this.doDeleteCDBS();
            }
        });
        this.deleteCDBSButton.setEnabled(false);
        this.okButton = new JButton("Create");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyCreateNew.this.doOK();
            }
        });
        this.okButton.setEnabled(false);
        JButton jButton3 = new JButton("Cancel");
        jButton3.setFocusable(false);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyCreateNew.this.doCancel();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Study Name"));
        jPanel.add(this.nameField);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.deleteTemplateButton);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.exportTemplateButton);
        jPanel3.add(jButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder("Template"));
        jPanel5.add((Component)AppManager.createScrollPane(this.templateList), "Center");
        jPanel5.add((Component)jPanel4, "South");
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        jPanel6.add(this.deleteCDBSButton);
        JPanel jPanel7 = new JPanel(new FlowLayout(2));
        jPanel7.add(jButton2);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.add(jPanel6);
        jPanel8.add(jPanel7);
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.setBorder(BorderFactory.createTitledBorder("CDBS Data"));
        jPanel9.add((Component)AppManager.createScrollPane(this.cdbsList), "Center");
        jPanel9.add((Component)jPanel8, "South");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BoxLayout(jPanel10, 0));
        jPanel10.add(jPanel5);
        jPanel10.add(jPanel9);
        JPanel jPanel11 = new JPanel(new FlowLayout(2));
        jPanel11.add(jButton3);
        jPanel11.add(this.okButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel10, "Center");
        container.add((Component)jPanel11, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setResizable(true);
        this.setLocationSaved(true);
    }

    @Override
    public String getDbID() {
        return this.parent.getDbID();
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
    }

    private void reload() {
        ArrayList<CDBSDatabase> arrayList;
        ErrorReporter errorReporter;
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        ArrayList<StudyTemplate> arrayList2 = StudyTemplate.getStudyTemplates(dbConnection, errorReporter = new ErrorReporter(this, "Load CDBS List"));
        if (null != arrayList2) {
            this.templateModel.setTemplates(arrayList2);
        }
        if (null != (arrayList = CDBSDatabase.getCDBSDatabases(dbConnection, errorReporter))) {
            this.cdbsModel.setDatabases(arrayList);
        }
    }

    private void doImportTemplate() {
        if (this.inQuery) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        String string = "Import Study Template";
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        JFileChooser jFileChooser = new JFileChooser(this.lastImportExport);
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XML file", "xml", "XML"));
        if (0 != jFileChooser.showDialog(this, "Import")) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            errorReporter.reportError("Could not open the file:\n" + fileNotFoundException.getMessage());
            return;
        }
        this.lastImportExport = file.getParentFile();
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        Integer n = StudyTemplate.readTemplateFromXML(dbConnection, bufferedReader, errorReporter);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null == n) {
            return;
        }
        this.reload();
        int n2 = this.templateModel.indexOfKey(n);
        if (n2 >= 0) {
            this.templateList.setSelectedIndex(n2);
            this.templateList.scrollRectToVisible(this.templateList.getCellBounds(n2, n2));
        }
    }

    private void doExportTemplate() {
        if (this.inQuery) {
            return;
        }
        int n = this.templateList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        String string = "Export Study Template";
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        StudyTemplate studyTemplate = this.templateModel.get(n);
        if (studyTemplate.isLocked) {
            errorReporter.reportMessage("That template is locked and cannot be exported.");
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(this.lastImportExport);
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        File file = null;
        do {
            if (0 != jFileChooser.showDialog(this, "Export")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            if (!file.exists()) continue;
            AppManager.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        String string2 = file.getName();
        if (!string2.endsWith(".xml") && !string2.endsWith(".XML")) {
            file = new File(file.getAbsolutePath() + ".xml");
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return;
        }
        this.lastImportExport = file.getParentFile();
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        StudyTemplate.writeTemplateToXML(dbConnection, errorReporter, studyTemplate.key, bufferedWriter);
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doDeleteTemplate() {
        if (this.inQuery) {
            return;
        }
        int n = this.templateList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        ErrorReporter errorReporter = new ErrorReporter(this, "Delete Study Template");
        StudyTemplate studyTemplate = this.templateModel.get(n);
        if (studyTemplate.isLocked) {
            errorReporter.reportMessage("That template is locked and cannot be deleted.");
            return;
        }
        if (studyTemplate.useCount > 0) {
            errorReporter.reportMessage("That template is used by studies and cannot be deleted.");
            return;
        }
        if (StudyTemplate.deleteTemplate(dbConnection, errorReporter, studyTemplate.key)) {
            this.templateModel.remove(n);
        }
    }

    private void doAddCDBS() {
        String string;
        if (this.inQuery) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        String string2 = "Create CDBS Database";
        ErrorReporter errorReporter = new ErrorReporter(this, string2);
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle("Choose a directory containing CDBS data files");
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        if (0 != jFileChooser.showDialog(this, "Choose")) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if (null == (string = JOptionPane.showInputDialog(this, "Enter a name for the CDBS data (optional)", string2, 3))) {
            return;
        }
        string = string.trim();
        final File file2 = file;
        final String string3 = string;
        QueryWorker<Integer> queryWorker = new QueryWorker<Integer>((Window)this, string2, dbConnection){

            @Override
            protected Integer doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                return CDBSDatabase.createNewDatabase(dbConnection, file2, string3, errorReporter);
            }
        };
        this.inQuery = true;
        Integer n = (Integer)queryWorker.runQuery("Importing CDBS data files, please wait...", errorReporter);
        this.inQuery = false;
        if (null == n) {
            return;
        }
        if (errorReporter.hasMessages()) {
            AppManager.showLongMessage(this, errorReporter.getMessages(), string2, 1);
        }
        this.reload();
        int n2 = this.cdbsModel.indexOfKey(n);
        if (n2 >= 0) {
            this.cdbsList.setSelectedIndex(n2);
            this.cdbsList.scrollRectToVisible(this.cdbsList.getCellBounds(n2, n2));
        }
    }

    private void doDeleteCDBS() {
        if (this.inQuery) {
            return;
        }
        int n = this.cdbsList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        ErrorReporter errorReporter = new ErrorReporter(this, "Delete CDBS Database");
        CDBSDatabase cDBSDatabase = this.cdbsModel.get(n);
        if (cDBSDatabase.useCount > 0) {
            errorReporter.reportMessage("That database is used by studies and cannot be deleted.");
            return;
        }
        if (CDBSDatabase.deleteDatabase(dbConnection, errorReporter, cDBSDatabase.key)) {
            this.cdbsModel.remove(n);
        }
    }

    private void doOK() {
        if (this.inQuery) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        ErrorReporter errorReporter = new ErrorReporter(this, WINDOW_TITLE);
        final String string = this.nameField.getText().trim();
        if (!DbManager.checkStudyName(string, this.parent.getDbID(), errorReporter)) {
            return;
        }
        int n = this.templateList.getSelectedIndex();
        if (n < 0) {
            errorReporter.reportWarning("Please select a study template.");
            return;
        }
        final int n2 = ((TemplateListModel)this.templateModel).get((int)n).key;
        n = this.cdbsList.getSelectedIndex();
        if (n < 0) {
            errorReporter.reportWarning("Please select a CDBS database.");
            return;
        }
        final int n3 = ((CDBSListModel)this.cdbsModel).get((int)n).key;
        QueryWorker<Integer> queryWorker = new QueryWorker<Integer>((Window)this, WINDOW_TITLE, dbConnection){

            @Override
            protected Integer doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                return Study.createNewStudy(dbConnection, errorReporter, string, n2, n3);
            }
        };
        this.inQuery = true;
        this.studyKey = (Integer)queryWorker.runQuery("Creating new study, please wait...", errorReporter);
        this.inQuery = false;
        if (null == this.studyKey) {
            return;
        }
        if (errorReporter.hasMessages()) {
            AppManager.showLongMessage(this, errorReporter.getMessages(), WINDOW_TITLE, 1);
        }
        this.canceled = false;
        AppManager.hideWindow(this);
    }

    public Integer getStudyKey() {
        return this.studyKey;
    }

    private void doCancel() {
        if (this.inQuery) {
            return;
        }
        this.canceled = true;
        AppManager.hideWindow(this);
    }

    @Override
    public void windowWillOpen() {
        this.studyKey = null;
        this.nameField.setText("");
        this.nameField.requestFocusInWindow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StudyCreateNew.this.reload();
            }
        });
        this.setLocationRelativeTo(this.parent);
        this.canceled = false;
    }

    @Override
    public boolean windowShouldClose() {
        if (this.inQuery) {
            return false;
        }
        this.canceled = true;
        return true;
    }

    private class CDBSListModel
    extends AbstractListModel {
        private ArrayList<CDBSDatabase> modelRows = new ArrayList();

        private CDBSListModel() {
        }

        private JList createList() {
            JList jList = new JList(this);
            jList.setSelectionMode(0);
            return jList;
        }

        private void setDatabases(ArrayList<CDBSDatabase> arrayList) {
            int n = this.modelRows.size();
            if (n > 0) {
                this.modelRows.clear();
                this.fireIntervalRemoved(this, 0, n - 1);
            }
            this.modelRows.addAll(arrayList);
            n = this.modelRows.size();
            if (n > 0) {
                this.fireIntervalAdded(this, 0, n - 1);
            }
        }

        private void remove(int n) {
            this.modelRows.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }

        private int indexOfKey(int n) {
            for (int i = 0; i < this.modelRows.size(); ++i) {
                if (n != this.modelRows.get((int)i).key) continue;
                return i;
            }
            return -1;
        }

        private CDBSDatabase get(int n) {
            return this.modelRows.get(n);
        }

        @Override
        public int getSize() {
            return this.modelRows.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.modelRows.get((int)n).name;
        }
    }

    private class TemplateListModel
    extends AbstractListModel {
        private ArrayList<StudyTemplate> modelRows = new ArrayList();

        private TemplateListModel() {
        }

        private JList createList() {
            JList jList = new JList(this);
            jList.setSelectionMode(0);
            return jList;
        }

        private void setTemplates(ArrayList<StudyTemplate> arrayList) {
            int n = this.modelRows.size();
            if (n > 0) {
                this.modelRows.clear();
                this.fireIntervalRemoved(this, 0, n - 1);
            }
            this.modelRows.addAll(arrayList);
            n = this.modelRows.size();
            if (n > 0) {
                this.fireIntervalAdded(this, 0, n - 1);
            }
        }

        private void remove(int n) {
            this.modelRows.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }

        private int indexOfKey(int n) {
            for (int i = 0; i < this.modelRows.size(); ++i) {
                if (n != this.modelRows.get((int)i).key) continue;
                return i;
            }
            return -1;
        }

        private StudyTemplate get(int n) {
            return this.modelRows.get(n);
        }

        @Override
        public int getSize() {
            return this.modelRows.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.modelRows.get((int)n).name;
        }
    }
}

