/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.editdata.CDBSRecord;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.QueryWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;

public class SourceFindCDBS
extends AppDialog {
    public static final String WINDOW_TITLE = "Add Station";
    private AppFrame parent;
    private int cdbsKey;
    private int minimumChannel;
    private int maximumChannel;
    private JTextField facility_idField;
    private JTextField callSignField;
    private JTextField fileNumberField;
    private JTextField channelField;
    private JTextField cityField;
    private JCheckBox includeArchivedCheckBox;
    private RecordListTableModel listModel;
    private JTable listTable;
    private JTextArea recordDisplayArea;
    private JPanel recordDisplayPanel;
    private JButton previousButton;
    private JButton nextButton;
    private JCheckBox editableCheckBox;
    private JCheckBox replicateCheckBox;
    private JTextField replicationChannelField;
    private JButton okButton;
    public boolean canceled;
    private CDBSRecord record;
    private boolean isLocked;
    private boolean replicate;
    private int replicationChannel;
    boolean inQuery;

    public SourceFindCDBS(AppFrame appFrame, int n) {
        super((Window)appFrame, WINDOW_TITLE, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDisposeOnClose(false);
        this.parent = appFrame;
        this.cdbsKey = n;
        this.minimumChannel = 2;
        this.maximumChannel = 69;
        this.facility_idField = new JTextField(8);
        AppManager.fixKeyBindings(this.facility_idField);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Facility ID"));
        jPanel.add(this.facility_idField);
        this.callSignField = new JTextField(8);
        AppManager.fixKeyBindings(this.callSignField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Call Sign"));
        jPanel2.add(this.callSignField);
        this.fileNumberField = new JTextField(18);
        AppManager.fixKeyBindings(this.fileNumberField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("File Number"));
        jPanel3.add(this.fileNumberField);
        this.channelField = new JTextField(8);
        AppManager.fixKeyBindings(this.channelField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder("Channel"));
        jPanel4.add(this.channelField);
        this.cityField = new JTextField(18);
        AppManager.fixKeyBindings(this.cityField);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder("City"));
        jPanel5.add(this.cityField);
        this.includeArchivedCheckBox = new JCheckBox("Include archived records");
        this.listModel = new RecordListTableModel();
        this.listTable = this.listModel.createTable();
        this.listTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SourceFindCDBS.this.updateDisplay();
                }
            }
        });
        this.recordDisplayArea = new JTextArea(3, 50);
        AppManager.setComponentEnabled(this.recordDisplayArea, false);
        this.recordDisplayPanel = new JPanel(new BorderLayout());
        this.recordDisplayPanel.setBorder(BorderFactory.createTitledBorder("Search results"));
        this.recordDisplayPanel.add((Component)AppManager.createScrollPane(this.listTable), "Center");
        this.recordDisplayPanel.add((Component)this.recordDisplayArea, "South");
        this.editableCheckBox = new JCheckBox("Allow editing");
        this.editableCheckBox.setToolTipText("<HTML>Allow the station record to be edited.  Changes apply only in the current scenario.  Select<BR>only when necessary, cached results for editable records will not be used for other scenarios.</HTML>");
        this.editableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceFindCDBS.this.editableCheckBox.isSelected()) {
                    AppManager.setComponentEnabled(SourceFindCDBS.this.replicateCheckBox, false);
                    SourceFindCDBS.this.replicateCheckBox.setSelected(false);
                    AppManager.setComponentEnabled(SourceFindCDBS.this.replicationChannelField, false);
                } else {
                    AppManager.setComponentEnabled(SourceFindCDBS.this.replicateCheckBox, true);
                    AppManager.setComponentEnabled(SourceFindCDBS.this.replicationChannelField, SourceFindCDBS.this.replicateCheckBox.isSelected());
                }
            }
        });
        this.replicateCheckBox = new JCheckBox("Replicate");
        this.replicateCheckBox.setToolTipText("<HTML>Study the station on a different channel using a derived<BR>ERP and azimuth pattern replicating the original coverage.</HTML>");
        this.replicateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceFindCDBS.this.replicateCheckBox.isSelected()) {
                    AppManager.setComponentEnabled(SourceFindCDBS.this.editableCheckBox, false);
                    SourceFindCDBS.this.editableCheckBox.setSelected(false);
                    AppManager.setComponentEnabled(SourceFindCDBS.this.replicationChannelField, true);
                } else {
                    AppManager.setComponentEnabled(SourceFindCDBS.this.editableCheckBox, true);
                    AppManager.setComponentEnabled(SourceFindCDBS.this.replicationChannelField, false);
                }
            }
        });
        this.replicationChannelField = new JTextField(10);
        AppManager.fixKeyBindings(this.replicationChannelField);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder("Replication Channel"));
        jPanel6.add(this.replicationChannelField);
        AppManager.setComponentEnabled(this.editableCheckBox, false);
        AppManager.setComponentEnabled(this.replicateCheckBox, false);
        AppManager.setComponentEnabled(this.replicationChannelField, false);
        JButton jButton = new JButton("Search");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceFindCDBS.this.doSearch();
            }
        });
        this.previousButton = new JButton("Previous");
        this.previousButton.setFocusable(false);
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceFindCDBS.this.doPrevious();
            }
        });
        this.previousButton.setEnabled(false);
        this.nextButton = new JButton("Next");
        this.nextButton.setFocusable(false);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceFindCDBS.this.doNext();
            }
        });
        this.nextButton.setEnabled(false);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceFindCDBS.this.doCancel();
            }
        });
        this.okButton = new JButton("Use");
        this.okButton.setFocusable(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceFindCDBS.this.doOK();
            }
        });
        this.okButton.setEnabled(false);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(jPanel);
        jPanel7.add(jPanel2);
        jPanel7.add(jPanel3);
        JPanel jPanel8 = new JPanel();
        jPanel8.add(jPanel4);
        jPanel8.add(jPanel5);
        jPanel8.add(this.includeArchivedCheckBox);
        JPanel jPanel9 = new JPanel();
        jPanel9.add(jButton);
        JPanel jPanel10 = new JPanel();
        jPanel10.add(this.previousButton);
        jPanel10.add(this.nextButton);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 1));
        jPanel11.add(jPanel9);
        jPanel11.add(jPanel10);
        JPanel jPanel12 = new JPanel();
        jPanel12.add(this.editableCheckBox);
        jPanel12.add(this.replicateCheckBox);
        jPanel12.add(jPanel6);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BoxLayout(jPanel13, 0));
        jPanel13.add(jPanel11);
        jPanel13.add(jPanel12);
        JPanel jPanel14 = new JPanel(new FlowLayout(2));
        jPanel14.add(jButton2);
        jPanel14.add(this.okButton);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(jPanel7);
        container.add(jPanel8);
        container.add(jPanel13);
        container.add(this.recordDisplayPanel);
        container.add(jPanel14);
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.height = 530;
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.setResizable(true);
        this.setLocationSaved(true);
    }

    @Override
    public String getDbID() {
        return this.parent.getDbID();
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
    }

    public void setChannelRange(int n, int n2) {
        this.minimumChannel = n;
        this.maximumChannel = n2;
    }

    private void doSearch() {
        int n;
        if (this.inQuery) {
            return;
        }
        this.listModel.setRecords(null);
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        ErrorReporter errorReporter = new ErrorReporter(this, WINDOW_TITLE);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        String string = this.facility_idField.getText().trim();
        if (string.length() > 0) {
            n = 0;
            try {
                n = Integer.parseInt(string);
                if (n <= 0) {
                    errorReporter.reportWarning("The facility ID must be greater than 0.");
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                errorReporter.reportWarning("The facility ID must be a number.");
                return;
            }
            stringBuilder.append("(tv_eng_data.facility_id = " + n + ")");
            bl = true;
        }
        if ((string = this.callSignField.getText().trim().toUpperCase()).length() > 0) {
            string = dbConnection.clean(string).replace('*', '%');
            if (bl) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("(UPPER(facility.fac_callsign) LIKE '%" + string + "%')");
            bl = true;
        }
        if ((string = this.cityField.getText().trim().toUpperCase()).length() > 0) {
            string = dbConnection.clean(string).replace('*', '%');
            if (bl) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("(UPPER(facility.comm_city) LIKE '%" + string + "%')");
            bl = true;
        }
        if ((string = this.fileNumberField.getText().trim().toUpperCase()).length() > 0) {
            string = dbConnection.clean(string).replace('*', '%');
            if (bl) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("(UPPER(CONCAT(application.file_prefix, application.app_arn)) LIKE '%" + string + "%')");
            bl = true;
        }
        if ((string = this.cityField.getText().trim().toUpperCase()).length() > 0) {
            string = dbConnection.clean(string).replace('*', '%');
            if (bl) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("(UPPER(facility.comm_city) LIKE '%" + string + "%')");
            bl = true;
        }
        if (bl) {
            stringBuilder.append(" AND ");
        }
        if ((string = this.channelField.getText().trim()).length() > 0) {
            n = 0;
            try {
                n = Integer.parseInt(string);
                if (n < this.minimumChannel || n > this.maximumChannel) {
                    errorReporter.reportWarning("The channel must be in the range " + this.minimumChannel + " to " + this.maximumChannel + ".");
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                errorReporter.reportWarning("The channel must be a number.");
                return;
            }
            stringBuilder.append("(tv_eng_data.station_channel = " + n + ")");
            bl = true;
        } else {
            stringBuilder.append("(tv_eng_data.station_channel BETWEEN " + this.minimumChannel + " AND " + this.maximumChannel + ")");
        }
        if (!this.includeArchivedCheckBox.isSelected()) {
            stringBuilder.append(" AND (tv_eng_data.eng_record_type NOT IN ('A','R'))");
        }
        if (!bl) {
            errorReporter.reportWarning("At least one search criteria must be provided.");
            return;
        }
        final String string2 = stringBuilder.toString();
        QueryWorker<LinkedList<CDBSRecord>> queryWorker = new QueryWorker<LinkedList<CDBSRecord>>((Window)this, WINDOW_TITLE, dbConnection){

            @Override
            protected LinkedList<CDBSRecord> doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                return CDBSRecord.findRecords(dbConnection, SourceFindCDBS.this.parent.getDbID(), SourceFindCDBS.this.cdbsKey, string2, 0.0, 0.0, 0.0, 0.0, false, errorReporter);
            }
        };
        this.inQuery = true;
        LinkedList linkedList = (LinkedList)queryWorker.runQuery("Searching for records, please wait...", errorReporter);
        this.inQuery = false;
        if (null == linkedList) {
            return;
        }
        if (linkedList.size() > 0) {
            this.listModel.setRecords(linkedList);
            this.listTable.setRowSelectionInterval(0, 0);
            if (errorReporter.hasMessages()) {
                AppManager.showLongMessage(this, errorReporter.getMessages(), WINDOW_TITLE, 1);
            }
        } else {
            errorReporter.reportMessage("No matching records were found.");
        }
    }

    private void doPrevious() {
        int n = this.listTable.getRowCount();
        int n2 = this.listTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.listTable.setRowSelectionInterval(n2, n2);
            this.listTable.scrollRectToVisible(this.listTable.getCellRect(n2, 0, true));
        }
    }

    private void doNext() {
        int n = this.listTable.getRowCount();
        int n2 = this.listTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.listTable.setRowSelectionInterval(n2, n2);
            this.listTable.scrollRectToVisible(this.listTable.getCellRect(n2, 0, true));
        }
    }

    private void updateDisplay() {
        this.recordDisplayArea.setText("");
        if (this.listTable.getSelectedRowCount() != 1) {
            this.previousButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            AppManager.setComponentEnabled(this.editableCheckBox, false);
            AppManager.setComponentEnabled(this.replicateCheckBox, false);
            AppManager.setComponentEnabled(this.replicationChannelField, false);
            this.okButton.setEnabled(false);
        } else {
            int n = this.listTable.getSelectedRow();
            int n2 = this.listTable.convertRowIndexToModel(n);
            CDBSRecord cDBSRecord = this.listModel.get(n2);
            this.recordDisplayArea.append("  Facility ID " + cDBSRecord.facility_id + "   ");
            this.recordDisplayArea.append(String.format("%s %d-%02d-%04.1f  %s %d-%02d-%04.1f   ", cDBSRecord.latitudeDirection, cDBSRecord.latitudeDegrees, cDBSRecord.latitudeMinutes, cDBSRecord.latitudeSeconds, cDBSRecord.longitudeDirection, cDBSRecord.longitudeDegrees, cDBSRecord.longitudeMinutes, cDBSRecord.longitudeSeconds));
            this.recordDisplayArea.append(AppManager.formatHeight(cDBSRecord.heightAMSL) + " m   ");
            this.recordDisplayArea.append(AppManager.formatERP(cDBSRecord.peakERP) + " kW");
            if (cDBSRecord.isArchived) {
                this.recordDisplayArea.append("\n  ** Archived record");
            }
            this.previousButton.setEnabled(n > 0);
            this.nextButton.setEnabled(n < this.listTable.getRowCount() - 1);
            AppManager.setComponentEnabled(this.editableCheckBox, !this.replicateCheckBox.isSelected());
            AppManager.setComponentEnabled(this.replicateCheckBox, true);
            AppManager.setComponentEnabled(this.replicationChannelField, this.replicateCheckBox.isSelected());
            this.okButton.setEnabled(true);
        }
    }

    private void doOK() {
        if (this.inQuery) {
            return;
        }
        if (this.listTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.listTable.convertRowIndexToModel(this.listTable.getSelectedRow());
        CDBSRecord cDBSRecord = this.listModel.get(n);
        boolean bl = this.replicateCheckBox.isSelected();
        int n2 = 0;
        if (bl) {
            String string = this.replicationChannelField.getText().trim();
            if (0 == string.length()) {
                AppManager.showMessage(this, "Please enter a replication channel.", WINDOW_TITLE, 2);
                return;
            }
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                AppManager.showMessage(this, "The replication channel must be a number.", WINDOW_TITLE, 2);
                return;
            }
            if (n2 < this.minimumChannel || n2 > this.maximumChannel) {
                AppManager.showMessage(this, "The replication channel must be in the range " + this.minimumChannel + " to " + this.maximumChannel + ".", WINDOW_TITLE, 2);
                return;
            }
            if (cDBSRecord.service.serviceType.digital && n2 == cDBSRecord.channel) {
                AppManager.showMessage(this, "The replication channel must be different than the original channel.", WINDOW_TITLE, 2);
                return;
            }
        }
        this.record = cDBSRecord;
        this.isLocked = !this.editableCheckBox.isSelected();
        this.replicate = bl;
        this.replicationChannel = n2;
        this.listModel.setRecords(null);
        this.canceled = false;
        AppManager.hideWindow(this);
    }

    public CDBSRecord getRecord() {
        return this.record;
    }

    public boolean getIsLocked() {
        return this.isLocked;
    }

    public boolean getReplicate() {
        return this.replicate;
    }

    public int getReplicationChannel() {
        return this.replicationChannel;
    }

    public boolean cancel() {
        this.doCancel();
        return this.canceled;
    }

    private void doCancel() {
        if (this.inQuery) {
            return;
        }
        this.listModel.setRecords(null);
        this.canceled = true;
        AppManager.hideWindow(this);
    }

    @Override
    public void windowWillOpen() {
        this.record = null;
        this.isLocked = false;
        this.replicate = false;
        this.replicationChannel = 0;
        this.facility_idField.setText("");
        this.callSignField.setText("");
        this.fileNumberField.setText("");
        this.channelField.setText("");
        this.cityField.setText("");
        this.editableCheckBox.setSelected(false);
        this.replicateCheckBox.setSelected(false);
        this.replicationChannelField.setText("");
        this.listModel.setRecords(null);
        this.facility_idField.requestFocusInWindow();
        this.setLocationRelativeTo(this.parent);
        this.canceled = false;
    }

    @Override
    public boolean windowShouldClose() {
        if (this.inQuery) {
            return false;
        }
        this.listModel.setRecords(null);
        this.canceled = true;
        return true;
    }

    private class RecordListTableModel
    extends AbstractTableModel {
        private static final String RECORD_CALLSIGN_COLUMN = "Call Sign";
        private static final String RECORD_CHANNEL_COLUMN = "Channel";
        private static final String RECORD_STATUS_COLUMN = "Status";
        private static final String RECORD_SERVICE_COLUMN = "Svc";
        private static final String RECORD_FILE_COLUMN = "File Number";
        private static final String RECORD_CITY_COLUMN = "City";
        private static final String RECORD_STATE_COLUMN = "State";
        private String[] columnNames = new String[]{"Call Sign", "Channel", "Status", "Svc", "File Number", "City", "State"};
        private static final int RECORD_CALLSIGN_INDEX = 0;
        private static final int RECORD_CHANNEL_INDEX = 1;
        private static final int RECORD_STATUS_INDEX = 2;
        private static final int RECORD_SERVICE_INDEX = 3;
        private static final int RECORD_FILE_INDEX = 4;
        private static final int RECORD_CITY_INDEX = 5;
        private static final int RECORD_STATE_INDEX = 6;
        private ArrayList<CDBSRecord> modelRows = new ArrayList();

        private RecordListTableModel() {
        }

        private JTable createTable() {
            JTable jTable = new JTable(this);
            AppManager.configureTable(jTable);
            TableRowSorter<RecordListTableModel> tableRowSorter = new TableRowSorter<RecordListTableModel>(this){

                @Override
                public void setSortKeys(List<? extends RowSorter.SortKey> list) {
                    Object object;
                    int n = 0;
                    SortOrder sortOrder = SortOrder.ASCENDING;
                    if (null != list && list.size() > 0) {
                        object = list.get(0);
                        n = ((RowSorter.SortKey)object).getColumn();
                        sortOrder = ((RowSorter.SortKey)object).getSortOrder();
                    }
                    object = new ArrayList<RowSorter.SortKey>();
                    switch (n) {
                        default: {
                            ((ArrayList)object).add(new RowSorter.SortKey(0, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(1, sortOrder));
                            break;
                        }
                        case 1: {
                            ((ArrayList)object).add(new RowSorter.SortKey(1, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            break;
                        }
                        case 2: {
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(1, sortOrder));
                            break;
                        }
                        case 3: {
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(1, sortOrder));
                            break;
                        }
                        case 4: {
                            ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(1, sortOrder));
                            break;
                        }
                        case 5: {
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(1, sortOrder));
                            break;
                        }
                        case 6: {
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(1, sortOrder));
                        }
                    }
                    super.setSortKeys((List<RowSorter.SortKey>)object);
                }
            };
            TableStringConverter tableStringConverter = new TableStringConverter(){

                @Override
                public String toString(TableModel tableModel, int n, int n2) {
                    CDBSRecord cDBSRecord = (CDBSRecord)RecordListTableModel.this.modelRows.get(n);
                    switch (n2) {
                        case 0: {
                            return cDBSRecord.callSign;
                        }
                        case 1: {
                            return String.format("%02d%c", cDBSRecord.channel, Character.valueOf(cDBSRecord.service.serviceType.digital ? (char)'D' : 'N'));
                        }
                        case 2: {
                            return String.valueOf(cDBSRecord.statusType);
                        }
                        case 3: {
                            return cDBSRecord.service.serviceCode;
                        }
                        case 4: {
                            return cDBSRecord.appARN;
                        }
                        case 5: {
                            return cDBSRecord.city;
                        }
                        case 6: {
                            return cDBSRecord.state;
                        }
                    }
                    return "";
                }
            };
            tableRowSorter.setStringConverter(tableStringConverter);
            jTable.setRowSorter((RowSorter<? extends TableModel>)tableRowSorter);
            tableRowSorter.setSortKeys(null);
            int n = AppManager.getTextFieldWidth(3);
            int n2 = AppManager.getTextFieldWidth(4);
            int n3 = AppManager.getTextFieldWidth(5);
            int n4 = AppManager.getTextFieldWidth(8);
            int n5 = AppManager.getTextFieldWidth(20);
            int n6 = AppManager.getTextFieldWidth(23);
            TableColumn tableColumn = jTable.getColumn(RECORD_CALLSIGN_COLUMN);
            tableColumn.setMinWidth(n3);
            tableColumn.setPreferredWidth(n4);
            tableColumn = jTable.getColumn(RECORD_CHANNEL_COLUMN);
            tableColumn.setMinWidth(n3);
            tableColumn.setPreferredWidth(n3);
            tableColumn = jTable.getColumn(RECORD_STATUS_COLUMN);
            tableColumn.setMinWidth(n2);
            tableColumn.setPreferredWidth(n2);
            tableColumn = jTable.getColumn(RECORD_SERVICE_COLUMN);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n);
            tableColumn = jTable.getColumn(RECORD_FILE_COLUMN);
            tableColumn.setMinWidth(n3);
            tableColumn.setPreferredWidth(n6);
            tableColumn = jTable.getColumn(RECORD_CITY_COLUMN);
            tableColumn.setMinWidth(n3);
            tableColumn.setPreferredWidth(n5);
            tableColumn = jTable.getColumn(RECORD_STATE_COLUMN);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n);
            return jTable;
        }

        private void setRecords(LinkedList<CDBSRecord> linkedList) {
            this.modelRows.clear();
            if (null != linkedList) {
                this.modelRows.addAll(linkedList);
                SourceFindCDBS.this.recordDisplayPanel.setBorder(BorderFactory.createTitledBorder("Search results - " + this.modelRows.size() + " records"));
            } else {
                SourceFindCDBS.this.recordDisplayPanel.setBorder(BorderFactory.createTitledBorder("Search results"));
            }
            this.fireTableDataChanged();
        }

        private CDBSRecord get(int n) {
            return this.modelRows.get(n);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: 
                case 3: 
                case 5: 
                case 6: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public int getRowCount() {
            return this.modelRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CDBSRecord cDBSRecord = this.modelRows.get(n);
            switch (n2) {
                case 0: {
                    return cDBSRecord.callSign + (cDBSRecord.isArchived ? " **" : "");
                }
                case 1: {
                    return (cDBSRecord.service.serviceType.digital ? "D" : "N") + cDBSRecord.channel;
                }
                case 2: {
                    return cDBSRecord.status;
                }
                case 3: {
                    return cDBSRecord.service.serviceCode;
                }
                case 4: {
                    return cDBSRecord.filePrefix + cDBSRecord.appARN;
                }
                case 5: {
                    return cDBSRecord.city;
                }
                case 6: {
                    return cDBSRecord.state;
                }
            }
            return "";
        }
    }
}

