/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.EmissionMask;
import gov.fcc.tvstudy.data.FrequencyOffset;
import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.data.Zone;
import gov.fcc.tvstudy.editdata.CDBSRecord;
import gov.fcc.tvstudy.editdata.SourceEditData;
import gov.fcc.tvstudy.editor.CoordinatePanel;
import gov.fcc.tvstudy.editor.PatternEditor;
import gov.fcc.tvstudy.editor.RootEditor;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.KeyedRecordMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SourceEditor
extends AppDialog {
    public static final String WINDOW_TITLE = "Station Data";
    private RootEditor rootEditor;
    private AppFrame parent;
    private ErrorReporter errorReporter;
    private SourceEditData source;
    private boolean canEdit;
    private boolean canEditCallCityState;
    private boolean canEditChanZoneStatFile;
    private boolean canEditSite;
    private JLabel facility_idLabel;
    private JLabel serviceLabel;
    private JTextField callSignField;
    private JTextField channelField;
    private JLabel replicationLabel;
    private JTextField cityField;
    private JTextField stateField;
    private JLabel countryLabel;
    private KeyedRecordMenu zoneMenu;
    private KeyedRecordMenu statusMenu;
    private KeyedRecord statusItem;
    private JTextField fileNumberField;
    private KeyedRecordMenu frequencyOffsetMenu;
    private KeyedRecordMenu emissionMaskMenu;
    private CoordinatePanel latitudePanel;
    private CoordinatePanel longitudePanel;
    private JTextField heightAMSLField;
    private JLabel actualHeightAMSLLabel;
    private JTextField overallHAATField;
    private JTextField peakERPField;
    private JLabel horizontalPatternLabel;
    private JButton editHorizontalPatternButton;
    private JTextField horizontalPatternOrientationField;
    private JLabel verticalPatternLabel;
    private JButton editVerticalPatternButton;
    private JTextField verticalPatternElectricalTiltField;
    private JTextField verticalPatternMechanicalTiltField;
    private JTextField verticalPatternMechanicalTiltOrientationField;
    private JCheckBox useGenericVerticalPatternCheckBox;
    private JTextField siteNumberField;
    private JLabel application_idLabel;
    private PatternEditor patternEditor;
    private JButton okButton;
    private JButton cancelButton;
    private String documentNameSuffix;
    public boolean canceled;

    public SourceEditor(RootEditor rootEditor, AppFrame appFrame) {
        super((Window)appFrame, WINDOW_TITLE, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDisposeOnClose(false);
        this.rootEditor = rootEditor;
        this.parent = appFrame;
        this.errorReporter = new ErrorReporter(this.rootEditor, this, "Edit Station Data");
        this.rootEditor.blockActionsStart();
        this.facility_idLabel = new JLabel();
        this.facility_idLabel.setPreferredSize(AppManager.getLabelSize(8));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Facility ID"));
        jPanel.add(this.facility_idLabel);
        this.serviceLabel = new JLabel();
        this.serviceLabel.setPreferredSize(AppManager.getLabelSize(18));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Service"));
        jPanel2.add(this.serviceLabel);
        this.callSignField = new JTextField(12);
        AppManager.fixKeyBindings(this.callSignField);
        this.callSignField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEditCallCityState && SourceEditor.this.rootEditor.blockActions()) {
                    String string = SourceEditor.this.callSignField.getText().trim();
                    if (string.length() > 0) {
                        ((SourceEditor)SourceEditor.this).source.callSign = string;
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                SourceEditor.this.callSignField.setText(((SourceEditor)SourceEditor.this).source.callSign);
                SourceEditor.this.updateDocumentName();
            }
        });
        this.callSignField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.callSignField.postActionEvent();
                }
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Call Sign"));
        jPanel3.add(this.callSignField);
        this.channelField = new JTextField(6);
        AppManager.fixKeyBindings(this.channelField);
        this.channelField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEditChanZoneStatFile && SourceEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Channel";
                    String string2 = SourceEditor.this.channelField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            int n = Integer.parseInt(string2);
                            if (null != ((SourceEditor)SourceEditor.this).source.parentSourceKey && 0 == ((SourceEditor)SourceEditor.this).source.siteNumber) {
                                if (n < 2 || n > 69) {
                                    SourceEditor.this.errorReporter.reportValidationError(string, "The channel must be in the range 2 to 69.");
                                } else {
                                    ((SourceEditor)SourceEditor.this).source.channel = n;
                                }
                            } else if (n < ((SourceEditor)SourceEditor.this).source.study.minimumChannel || n > ((SourceEditor)SourceEditor.this).source.study.maximumChannel) {
                                SourceEditor.this.errorReporter.reportValidationError(string, "The channel must be in the range " + ((SourceEditor)SourceEditor.this).source.study.minimumChannel + " to " + ((SourceEditor)SourceEditor.this).source.study.maximumChannel + ".");
                            } else {
                                ((SourceEditor)SourceEditor.this).source.channel = n;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            SourceEditor.this.errorReporter.reportValidationError(string, "The channel must be a number.");
                        }
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                SourceEditor.this.channelField.setText(String.valueOf(((SourceEditor)SourceEditor.this).source.channel));
            }
        });
        this.channelField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.channelField.postActionEvent();
                }
            }
        });
        this.replicationLabel = new JLabel();
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder("Channel"));
        jPanel4.add(this.channelField);
        jPanel4.add(this.replicationLabel);
        this.cityField = new JTextField(18);
        AppManager.fixKeyBindings(this.cityField);
        this.cityField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEditCallCityState && SourceEditor.this.rootEditor.blockActions()) {
                    String string = SourceEditor.this.cityField.getText().trim();
                    if (string.length() > 0) {
                        ((SourceEditor)SourceEditor.this).source.city = string;
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                SourceEditor.this.cityField.setText(((SourceEditor)SourceEditor.this).source.city);
            }
        });
        this.cityField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.cityField.postActionEvent();
                }
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder("City"));
        jPanel5.add(this.cityField);
        this.stateField = new JTextField(3);
        AppManager.fixKeyBindings(this.stateField);
        this.stateField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEditCallCityState && SourceEditor.this.rootEditor.blockActions()) {
                    String string = SourceEditor.this.stateField.getText().trim();
                    if (string.length() > 0) {
                        ((SourceEditor)SourceEditor.this).source.state = string;
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                SourceEditor.this.stateField.setText(((SourceEditor)SourceEditor.this).source.state);
            }
        });
        this.stateField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.stateField.postActionEvent();
                }
            }
        });
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder("State"));
        jPanel6.add(this.stateField);
        this.countryLabel = new JLabel();
        this.countryLabel.setPreferredSize(AppManager.getLabelSize(6));
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(BorderFactory.createTitledBorder("Country"));
        jPanel7.add(this.countryLabel);
        DbConnection dbConnection = DbManager.getDb(this.rootEditor.getDbID());
        this.zoneMenu = new KeyedRecordMenu(Zone.getZonesWithNull(dbConnection));
        this.zoneMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEditChanZoneStatFile && SourceEditor.this.rootEditor.blockActions()) {
                    ((SourceEditor)SourceEditor.this).source.zone = (Zone)SourceEditor.this.zoneMenu.getSelectedItem();
                    SourceEditor.this.rootEditor.blockActionsEnd();
                } else {
                    SourceEditor.this.zoneMenu.setSelectedItem(((SourceEditor)SourceEditor.this).source.zone);
                }
            }
        });
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(BorderFactory.createTitledBorder("Zone"));
        jPanel8.add(this.zoneMenu);
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        for (int i = 0; i < CDBSRecord.STATUS_CODES.length; ++i) {
            arrayList.add(new KeyedRecord(i + 1, CDBSRecord.STATUS_CODES[i]));
        }
        this.statusMenu = new KeyedRecordMenu(arrayList);
        this.statusMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEditChanZoneStatFile && SourceEditor.this.rootEditor.blockActions()) {
                    SourceEditor.this.statusItem = SourceEditor.this.statusMenu.getSelectedItem();
                    ((SourceEditor)SourceEditor.this).source.status = ((SourceEditor)SourceEditor.this).statusItem.name;
                    ((SourceEditor)SourceEditor.this).source.statusType = CDBSRecord.STATUS_TYPES[((SourceEditor)SourceEditor.this).statusItem.key - 1];
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                SourceEditor.this.statusMenu.setSelectedItem(SourceEditor.this.statusItem);
            }
        });
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(BorderFactory.createTitledBorder("Status"));
        jPanel9.add(this.statusMenu);
        this.fileNumberField = new JTextField(16);
        AppManager.fixKeyBindings(this.fileNumberField);
        this.fileNumberField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEditChanZoneStatFile && SourceEditor.this.rootEditor.blockActions()) {
                    ((SourceEditor)SourceEditor.this).source.fileNumber = SourceEditor.this.fileNumberField.getText().trim();
                    ((SourceEditor)SourceEditor.this).source.appARN = "";
                    for (int i = 0; i < ((SourceEditor)SourceEditor.this).source.fileNumber.length(); ++i) {
                        if (!Character.isDigit(((SourceEditor)SourceEditor.this).source.fileNumber.charAt(i))) continue;
                        ((SourceEditor)SourceEditor.this).source.appARN = ((SourceEditor)SourceEditor.this).source.fileNumber.substring(i);
                        break;
                    }
                }
                SourceEditor.this.rootEditor.blockActionsEnd();
                SourceEditor.this.fileNumberField.setText(((SourceEditor)SourceEditor.this).source.fileNumber);
            }
        });
        this.fileNumberField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.fileNumberField.postActionEvent();
                }
            }
        });
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(BorderFactory.createTitledBorder("File Number"));
        jPanel10.add(this.fileNumberField);
        this.frequencyOffsetMenu = new KeyedRecordMenu(FrequencyOffset.getFrequencyOffsetsWithNull(dbConnection));
        this.frequencyOffsetMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEdit && SourceEditor.this.rootEditor.blockActions()) {
                    ((SourceEditor)SourceEditor.this).source.frequencyOffset = (FrequencyOffset)SourceEditor.this.frequencyOffsetMenu.getSelectedItem();
                    SourceEditor.this.rootEditor.blockActionsEnd();
                } else {
                    SourceEditor.this.frequencyOffsetMenu.setSelectedItem(((SourceEditor)SourceEditor.this).source.frequencyOffset);
                }
            }
        });
        JPanel jPanel11 = new JPanel();
        jPanel11.setBorder(BorderFactory.createTitledBorder("Frequency Offset"));
        jPanel11.add(this.frequencyOffsetMenu);
        this.emissionMaskMenu = new KeyedRecordMenu(EmissionMask.getEmissionMasksWithNull(dbConnection));
        this.emissionMaskMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEdit && SourceEditor.this.rootEditor.blockActions()) {
                    if (((SourceEditor)SourceEditor.this).source.service.serviceType.needsEmissionMask) {
                        ((SourceEditor)SourceEditor.this).source.emissionMask = (EmissionMask)SourceEditor.this.emissionMaskMenu.getSelectedItem();
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                } else {
                    SourceEditor.this.emissionMaskMenu.setSelectedItem(((SourceEditor)SourceEditor.this).source.emissionMask);
                }
            }
        });
        JPanel jPanel12 = new JPanel();
        jPanel12.setBorder(BorderFactory.createTitledBorder("Emission Mask"));
        jPanel12.add(this.emissionMaskMenu);
        this.latitudePanel = new CoordinatePanel(this.rootEditor, this.errorReporter, false, new Runnable(){

            @Override
            public void run() {
                ((SourceEditor)SourceEditor.this).source.latitude = SourceEditor.this.latitudePanel.getCoordinate();
            }
        });
        this.longitudePanel = new CoordinatePanel(this.rootEditor, this.errorReporter, true, new Runnable(){

            @Override
            public void run() {
                ((SourceEditor)SourceEditor.this).source.longitude = SourceEditor.this.longitudePanel.getCoordinate();
            }
        });
        this.heightAMSLField = new JTextField(7);
        AppManager.fixKeyBindings(this.heightAMSLField);
        this.heightAMSLField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEdit && SourceEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Height AMSL";
                    String string2 = SourceEditor.this.heightAMSLField.getText().trim();
                    if (string2.length() > 0) {
                        if (string2.equals("(derive)")) {
                            string2 = String.valueOf(-999.0);
                        }
                        try {
                            double d = Double.parseDouble(string2);
                            if (d < -1000.0 || d > 10000.0) {
                                SourceEditor.this.errorReporter.reportValidationError(string, "The height must be in the range -1000.0 to 10000.0.");
                            } else {
                                ((SourceEditor)SourceEditor.this).source.heightAMSL = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            SourceEditor.this.errorReporter.reportValidationError(string, "The height must be a number.");
                        }
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                if (-999.0 == ((SourceEditor)SourceEditor.this).source.heightAMSL) {
                    SourceEditor.this.heightAMSLField.setText("(derive)");
                } else {
                    SourceEditor.this.heightAMSLField.setText(AppManager.formatHeight(((SourceEditor)SourceEditor.this).source.heightAMSL));
                }
                if (null != ((SourceEditor)SourceEditor.this).source.source && ((SourceEditor)SourceEditor.this).source.source.actualHeightAMSL != ((SourceEditor)SourceEditor.this).source.heightAMSL && -999.0 != ((SourceEditor)SourceEditor.this).source.source.actualHeightAMSL) {
                    SourceEditor.this.actualHeightAMSLLabel.setText("Last run: " + AppManager.formatHeight(((SourceEditor)SourceEditor.this).source.source.actualHeightAMSL));
                } else {
                    SourceEditor.this.actualHeightAMSLLabel.setText(" ");
                }
            }
        });
        this.heightAMSLField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.heightAMSLField.postActionEvent();
                }
            }
        });
        this.actualHeightAMSLLabel = new JLabel("Last run: 9999.9");
        JPanel jPanel13 = new JPanel();
        jPanel13.setBorder(BorderFactory.createTitledBorder("Height AMSL, m"));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BoxLayout(jPanel14, 1));
        jPanel14.add(this.heightAMSLField);
        jPanel14.add(this.actualHeightAMSLLabel);
        jPanel13.add(jPanel14);
        this.overallHAATField = new JTextField(7);
        AppManager.fixKeyBindings(this.overallHAATField);
        this.overallHAATField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEdit && SourceEditor.this.rootEditor.blockActions()) {
                    String string = "Edit HAAT";
                    String string2 = SourceEditor.this.overallHAATField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            double d = Double.parseDouble(string2);
                            if (d < -1000.0 || d > 10000.0) {
                                SourceEditor.this.errorReporter.reportValidationError(string, "The HAAT must be in the range -1000.0 to 10000.0.");
                            } else {
                                ((SourceEditor)SourceEditor.this).source.overallHAAT = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            SourceEditor.this.errorReporter.reportValidationError(string, "The HAAT must be a number.");
                        }
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                SourceEditor.this.overallHAATField.setText(AppManager.formatHeight(((SourceEditor)SourceEditor.this).source.overallHAAT));
            }
        });
        this.overallHAATField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.overallHAATField.postActionEvent();
                }
            }
        });
        JPanel jPanel15 = new JPanel();
        jPanel15.setBorder(BorderFactory.createTitledBorder("HAAT, m"));
        jPanel15.add(this.overallHAATField);
        this.peakERPField = new JTextField(7);
        AppManager.fixKeyBindings(this.peakERPField);
        this.peakERPField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEdit && SourceEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Peak ERP";
                    String string2 = SourceEditor.this.peakERPField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            double d = Double.parseDouble(string2);
                            if (d < 1.0E-5 || d > 5000.0) {
                                SourceEditor.this.errorReporter.reportValidationError(string, "The ERP must be in the range 1.0E-5 to 5000.0.");
                            } else {
                                ((SourceEditor)SourceEditor.this).source.peakERP = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            SourceEditor.this.errorReporter.reportValidationError(string, "The ERP must be a number.");
                        }
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                SourceEditor.this.peakERPField.setText(AppManager.formatERP(((SourceEditor)SourceEditor.this).source.peakERP));
            }
        });
        this.peakERPField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.peakERPField.postActionEvent();
                }
            }
        });
        JPanel jPanel16 = new JPanel();
        jPanel16.setBorder(BorderFactory.createTitledBorder("Peak ERP, kW"));
        jPanel16.add(this.peakERPField);
        this.horizontalPatternLabel = new JLabel();
        this.horizontalPatternLabel.setPreferredSize(AppManager.getLabelSize(20));
        this.editHorizontalPatternButton = new JButton("Edit");
        this.editHorizontalPatternButton.setFocusable(false);
        this.editHorizontalPatternButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceEditor.this.doEditHorizontalPattern();
            }
        });
        this.horizontalPatternOrientationField = new JTextField(7);
        AppManager.fixKeyBindings(this.horizontalPatternOrientationField);
        this.horizontalPatternOrientationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEdit && SourceEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Pattern Orientation";
                    String string2 = SourceEditor.this.horizontalPatternOrientationField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            double d = Double.parseDouble(string2);
                            if (d < -360.0 || d > 360.0) {
                                SourceEditor.this.errorReporter.reportValidationError(string, "The orientation must be in the range -360.0 to 360.0.");
                            } else {
                                ((SourceEditor)SourceEditor.this).source.horizontalPatternOrientation = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            SourceEditor.this.errorReporter.reportValidationError(string, "The orientation must be a number.");
                        }
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                SourceEditor.this.horizontalPatternOrientationField.setText(AppManager.formatAzimuth(((SourceEditor)SourceEditor.this).source.horizontalPatternOrientation));
            }
        });
        this.horizontalPatternOrientationField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.horizontalPatternOrientationField.postActionEvent();
                }
            }
        });
        JPanel jPanel17 = new JPanel(new FlowLayout(0));
        jPanel17.add(this.editHorizontalPatternButton);
        JPanel jPanel18 = new JPanel(new GridLayout(2, 1));
        jPanel18.add(this.horizontalPatternLabel);
        jPanel18.add(jPanel17);
        JPanel jPanel19 = new JPanel(new GridLayout(2, 1));
        jPanel19.add(new JLabel("Orient."));
        jPanel19.add(this.horizontalPatternOrientationField);
        JPanel jPanel20 = new JPanel();
        jPanel20.setBorder(BorderFactory.createTitledBorder("Azimuth Pattern"));
        jPanel20.add(jPanel18);
        jPanel20.add(jPanel19);
        this.verticalPatternLabel = new JLabel();
        this.verticalPatternLabel.setPreferredSize(AppManager.getLabelSize(30));
        this.editVerticalPatternButton = new JButton("Edit");
        this.editVerticalPatternButton.setFocusable(false);
        this.editVerticalPatternButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceEditor.this.doEditVerticalPattern();
            }
        });
        this.verticalPatternElectricalTiltField = new JTextField(7);
        AppManager.fixKeyBindings(this.verticalPatternElectricalTiltField);
        this.verticalPatternElectricalTiltField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEdit && SourceEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Electrical Tilt";
                    String string2 = SourceEditor.this.verticalPatternElectricalTiltField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            double d = Double.parseDouble(string2);
                            if (d < -10.0 || d > 11.1) {
                                SourceEditor.this.errorReporter.reportValidationError(string, "The tilt must be in the range -10.0 to 11.1.");
                            } else {
                                ((SourceEditor)SourceEditor.this).source.verticalPatternElectricalTilt = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            SourceEditor.this.errorReporter.reportValidationError(string, "The tilt must be a number.");
                        }
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                SourceEditor.this.verticalPatternElectricalTiltField.setText(AppManager.formatDepression(((SourceEditor)SourceEditor.this).source.verticalPatternElectricalTilt));
            }
        });
        this.verticalPatternElectricalTiltField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.verticalPatternElectricalTiltField.postActionEvent();
                }
            }
        });
        this.verticalPatternMechanicalTiltField = new JTextField(7);
        AppManager.fixKeyBindings(this.verticalPatternMechanicalTiltField);
        this.verticalPatternMechanicalTiltField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEdit && SourceEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Mechanical Tilt";
                    String string2 = SourceEditor.this.verticalPatternMechanicalTiltField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            double d = Double.parseDouble(string2);
                            if (d < -10.0 || d > 11.1) {
                                SourceEditor.this.errorReporter.reportValidationError(string, "The tilt must be in the range -10.0 to 11.1.");
                            } else {
                                ((SourceEditor)SourceEditor.this).source.verticalPatternMechanicalTilt = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            SourceEditor.this.errorReporter.reportValidationError(string, "The tilt must be a number.");
                        }
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                SourceEditor.this.verticalPatternMechanicalTiltField.setText(AppManager.formatDepression(((SourceEditor)SourceEditor.this).source.verticalPatternMechanicalTilt));
            }
        });
        this.verticalPatternMechanicalTiltField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.verticalPatternMechanicalTiltField.postActionEvent();
                }
            }
        });
        this.verticalPatternMechanicalTiltOrientationField = new JTextField(7);
        AppManager.fixKeyBindings(this.verticalPatternMechanicalTiltOrientationField);
        this.verticalPatternMechanicalTiltOrientationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEdit && SourceEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Tilt Orientation";
                    String string2 = SourceEditor.this.verticalPatternMechanicalTiltOrientationField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            double d = Double.parseDouble(string2);
                            if (d < -360.0 || d > 360.0) {
                                SourceEditor.this.errorReporter.reportValidationError(string, "The orientation must be in the range -360.0 to 360.0.");
                            } else {
                                ((SourceEditor)SourceEditor.this).source.verticalPatternMechanicalTiltOrientation = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            SourceEditor.this.errorReporter.reportValidationError(string, "The orientation must be a number.");
                        }
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                SourceEditor.this.verticalPatternMechanicalTiltOrientationField.setText(AppManager.formatAzimuth(((SourceEditor)SourceEditor.this).source.verticalPatternMechanicalTiltOrientation));
            }
        });
        this.verticalPatternMechanicalTiltOrientationField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.verticalPatternMechanicalTiltOrientationField.postActionEvent();
                }
            }
        });
        this.useGenericVerticalPatternCheckBox = new JCheckBox("May use generic pattern when needed");
        this.useGenericVerticalPatternCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEdit && SourceEditor.this.rootEditor.blockActions()) {
                    ((SourceEditor)SourceEditor.this).source.useGenericVerticalPattern = SourceEditor.this.useGenericVerticalPatternCheckBox.isSelected();
                    SourceEditor.this.rootEditor.blockActionsEnd();
                } else {
                    SourceEditor.this.useGenericVerticalPatternCheckBox.setSelected(((SourceEditor)SourceEditor.this).source.useGenericVerticalPattern);
                }
            }
        });
        JPanel jPanel21 = new JPanel(new FlowLayout(0));
        jPanel21.add(this.editVerticalPatternButton);
        JPanel jPanel22 = new JPanel(new GridLayout(2, 1));
        jPanel22.add(this.verticalPatternLabel);
        jPanel22.add(jPanel21);
        JPanel jPanel23 = new JPanel(new GridLayout(2, 3));
        jPanel23.add(new JLabel("Elec. Tilt"));
        jPanel23.add(new JLabel("Mech. Tilt"));
        jPanel23.add(new JLabel("Tilt Orient."));
        jPanel23.add(this.verticalPatternElectricalTiltField);
        jPanel23.add(this.verticalPatternMechanicalTiltField);
        jPanel23.add(this.verticalPatternMechanicalTiltOrientationField);
        JPanel jPanel24 = new JPanel(new GridLayout(2, 1));
        jPanel24.add(jPanel23);
        jPanel24.add(this.useGenericVerticalPatternCheckBox);
        JPanel jPanel25 = new JPanel();
        jPanel25.setBorder(BorderFactory.createTitledBorder("Elevation Pattern"));
        jPanel25.add(jPanel22);
        jPanel25.add(jPanel24);
        this.siteNumberField = new JTextField(6);
        AppManager.fixKeyBindings(this.siteNumberField);
        this.siteNumberField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceEditor.this.canEditSite && SourceEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Site Number";
                    String string2 = SourceEditor.this.siteNumberField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            int n = Integer.parseInt(string2);
                            if (((SourceEditor)SourceEditor.this).source.service.isDTS) {
                                if (n < 1) {
                                    SourceEditor.this.errorReporter.reportValidationError(string, "The site number must be greater than 0.");
                                } else {
                                    ((SourceEditor)SourceEditor.this).source.siteNumber = n;
                                }
                            } else if (n < 0) {
                                SourceEditor.this.errorReporter.reportValidationError(string, "The site number must be greater than or equal to 0.");
                            } else {
                                ((SourceEditor)SourceEditor.this).source.siteNumber = n;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            SourceEditor.this.errorReporter.reportValidationError(string, "The site number must be a number.");
                        }
                    }
                    SourceEditor.this.rootEditor.blockActionsEnd();
                }
                SourceEditor.this.siteNumberField.setText(String.valueOf(((SourceEditor)SourceEditor.this).source.siteNumber));
            }
        });
        this.siteNumberField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SourceEditor.this.siteNumberField.postActionEvent();
                }
            }
        });
        this.application_idLabel = new JLabel(" ");
        JPanel jPanel26 = new JPanel();
        jPanel26.setBorder(BorderFactory.createTitledBorder("Site Number"));
        JPanel jPanel27 = new JPanel();
        jPanel27.setLayout(new BoxLayout(jPanel27, 1));
        jPanel27.add(this.siteNumberField);
        jPanel27.add(this.application_idLabel);
        jPanel26.add(jPanel27);
        this.rootEditor.blockActionsEnd();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceEditor.this.doOK();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceEditor.this.doCancel();
            }
        });
        JPanel jPanel28 = new JPanel();
        jPanel28.add(jPanel);
        jPanel28.add(jPanel2);
        jPanel28.add(jPanel7);
        jPanel28.add(jPanel3);
        jPanel28.add(jPanel9);
        JPanel jPanel29 = new JPanel();
        jPanel29.add(jPanel10);
        jPanel29.add(jPanel5);
        jPanel29.add(jPanel6);
        jPanel29.add(jPanel8);
        JPanel jPanel30 = new JPanel();
        jPanel30.add(jPanel4);
        jPanel30.add(jPanel11);
        jPanel30.add(jPanel12);
        jPanel30.add(jPanel26);
        JPanel jPanel31 = new JPanel();
        jPanel31.add(this.latitudePanel);
        jPanel31.add(this.longitudePanel);
        JPanel jPanel32 = new JPanel();
        jPanel32.add(jPanel13);
        jPanel32.add(jPanel15);
        jPanel32.add(jPanel16);
        jPanel32.add(jPanel20);
        JPanel jPanel33 = new JPanel();
        jPanel33.add(jPanel25);
        JPanel jPanel34 = new JPanel();
        jPanel34.setLayout(new BoxLayout(jPanel34, 1));
        jPanel34.add(jPanel28);
        jPanel34.add(jPanel29);
        jPanel34.add(jPanel30);
        jPanel34.add(jPanel31);
        jPanel34.add(jPanel32);
        jPanel34.add(jPanel33);
        JPanel jPanel35 = new JPanel(new FlowLayout(2));
        jPanel35.add(this.cancelButton);
        jPanel35.add(this.okButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel34, "Center");
        container.add((Component)jPanel35, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setResizable(true);
        this.setLocationSaved(true);
        this.patternEditor = new PatternEditor(this.rootEditor, this);
    }

    @Override
    public void dispose() {
        this.patternEditor.dispose();
        super.dispose();
    }

    @Override
    public String getDbID() {
        return this.rootEditor.getDbID();
    }

    @Override
    public void updateDocumentName() {
        String string = null;
        string = null != this.source ? (null != this.documentNameSuffix ? this.parent.getDocumentName() + "/" + this.source.callSign + "/" + this.documentNameSuffix : this.parent.getDocumentName() + "/" + this.source.callSign) : this.parent.getDocumentName();
        this.setDocumentName(string);
        this.patternEditor.updateDocumentName();
    }

    public void setSource(SourceEditData sourceEditData) {
        this.setSource(sourceEditData, null);
    }

    public void setSource(SourceEditData sourceEditData, String string) {
        if (this.isVisible()) {
            return;
        }
        this.rootEditor.blockActionsStart();
        this.canceled = false;
        this.source = sourceEditData.copy();
        this.canEditCallCityState = this.canEdit = !this.source.isLocked;
        this.canEditChanZoneStatFile = this.canEdit;
        this.canEditSite = this.canEdit;
        if (null != this.source.parentSourceKey) {
            this.canEditCallCityState = false;
            if (this.source.siteNumber > 0) {
                this.canEditChanZoneStatFile = false;
            } else {
                this.canEditSite = false;
            }
        }
        this.documentNameSuffix = string;
        this.updateDocumentName();
        this.facility_idLabel.setText(String.valueOf(this.source.facility_id));
        this.serviceLabel.setText(this.source.service.name);
        this.callSignField.setText(this.source.callSign);
        AppManager.setComponentEnabled(this.callSignField, this.canEditCallCityState);
        this.channelField.setText(String.valueOf(this.source.channel));
        AppManager.setComponentEnabled(this.channelField, this.canEditChanZoneStatFile);
        if (null == this.source.originalSourceKey) {
            this.replicationLabel.setText("");
        } else {
            String string2 = "replicated from ";
            SourceEditData sourceEditData2 = null;
            if (null == this.source.parentSourceKey) {
                sourceEditData2 = this.source.study.getSource(this.source.originalSourceKey);
            } else {
                sourceEditData2 = this.source.study.getSource(this.source.parentSourceKey);
                if (null != sourceEditData2) {
                    sourceEditData2 = null == sourceEditData2.originalSourceKey ? null : this.source.study.getSource(sourceEditData2.originalSourceKey);
                }
            }
            string2 = null == sourceEditData2 ? string2 + "???" : (sourceEditData2.service.serviceType.digital ? string2 + "D" + sourceEditData2.channel : string2 + "N" + sourceEditData2.channel);
            this.replicationLabel.setText(string2);
        }
        this.cityField.setText(this.source.city);
        AppManager.setComponentEnabled(this.cityField, this.canEditCallCityState);
        this.stateField.setText(this.source.state);
        AppManager.setComponentEnabled(this.stateField, this.canEditCallCityState);
        this.countryLabel.setText(this.source.country.name);
        this.zoneMenu.setSelectedItem(this.source.zone);
        AppManager.setComponentEnabled(this.zoneMenu, this.canEditChanZoneStatFile);
        int n = 0;
        for (int i = 0; i < CDBSRecord.STATUS_CODES.length; ++i) {
            if (!this.source.status.equals(CDBSRecord.STATUS_CODES[i])) continue;
            n = i + 1;
            break;
        }
        this.statusItem = new KeyedRecord(n, this.source.status);
        this.statusMenu.setSelectedItem(this.statusItem);
        AppManager.setComponentEnabled(this.statusMenu, this.canEditChanZoneStatFile);
        this.fileNumberField.setText(this.source.fileNumber);
        AppManager.setComponentEnabled(this.fileNumberField, this.canEditChanZoneStatFile);
        this.siteNumberField.setText(String.valueOf(this.source.siteNumber));
        AppManager.setComponentEnabled(this.siteNumberField, this.canEditSite);
        if (null == this.source.application_id) {
            this.application_idLabel.setText("");
        } else {
            this.application_idLabel.setText("App. ID " + this.source.application_id);
        }
        this.frequencyOffsetMenu.setSelectedItem(this.source.frequencyOffset);
        AppManager.setComponentEnabled(this.frequencyOffsetMenu, this.canEdit);
        this.emissionMaskMenu.setSelectedItem(this.source.emissionMask);
        AppManager.setComponentEnabled(this.emissionMaskMenu, this.canEdit && this.source.service.serviceType.needsEmissionMask);
        this.latitudePanel.setCoordinate(this.source.latitude);
        this.longitudePanel.setCoordinate(this.source.longitude);
        this.latitudePanel.setEnabled(this.canEdit);
        this.longitudePanel.setEnabled(this.canEdit);
        if (-999.0 == this.source.heightAMSL) {
            this.heightAMSLField.setText("(derive)");
        } else {
            this.heightAMSLField.setText(AppManager.formatHeight(this.source.heightAMSL));
        }
        AppManager.setComponentEnabled(this.heightAMSLField, this.canEdit);
        if (null != this.source.source && this.source.source.actualHeightAMSL != this.source.heightAMSL && -999.0 != this.source.source.actualHeightAMSL) {
            this.actualHeightAMSLLabel.setText("Last run: " + AppManager.formatHeight(this.source.source.actualHeightAMSL));
        } else {
            this.actualHeightAMSLLabel.setText(" ");
        }
        this.overallHAATField.setText(AppManager.formatHeight(this.source.overallHAAT));
        AppManager.setComponentEnabled(this.overallHAATField, this.canEdit);
        this.peakERPField.setText(AppManager.formatERP(this.source.peakERP));
        AppManager.setComponentEnabled(this.peakERPField, this.canEdit);
        if (this.source.hasHorizontalPattern) {
            this.horizontalPatternLabel.setText(this.source.horizontalPatternName);
            this.horizontalPatternLabel.setToolTipText(this.source.horizontalPatternName);
        } else {
            this.horizontalPatternLabel.setText("(none)");
            this.horizontalPatternLabel.setToolTipText(null);
        }
        if (this.canEdit) {
            this.editHorizontalPatternButton.setText("Edit");
            this.editHorizontalPatternButton.setEnabled(true);
        } else {
            this.editHorizontalPatternButton.setText("View");
            this.editHorizontalPatternButton.setEnabled(this.source.hasHorizontalPattern);
        }
        this.horizontalPatternOrientationField.setText(AppManager.formatAzimuth(this.source.horizontalPatternOrientation));
        AppManager.setComponentEnabled(this.horizontalPatternOrientationField, this.canEdit);
        if (this.source.hasMatrixPattern) {
            this.verticalPatternLabel.setText(this.source.matrixPatternName + " (matrix)");
            this.verticalPatternLabel.setToolTipText(this.source.matrixPatternName + " (matrix)");
            if (this.canEdit) {
                this.editVerticalPatternButton.setText("Edit");
            } else {
                this.editVerticalPatternButton.setText("View");
            }
            this.editVerticalPatternButton.setEnabled(true);
        } else {
            if (this.source.hasVerticalPattern) {
                this.verticalPatternLabel.setText(this.source.verticalPatternName);
                this.verticalPatternLabel.setToolTipText(this.source.verticalPatternName);
            } else {
                this.verticalPatternLabel.setText("(none)");
                this.verticalPatternLabel.setToolTipText(null);
            }
            if (this.canEdit) {
                this.editVerticalPatternButton.setText("Edit");
                this.editVerticalPatternButton.setEnabled(true);
            } else {
                this.editVerticalPatternButton.setText("View");
                this.editVerticalPatternButton.setEnabled(this.source.hasVerticalPattern);
            }
        }
        this.verticalPatternElectricalTiltField.setText(AppManager.formatDepression(this.source.verticalPatternElectricalTilt));
        this.verticalPatternMechanicalTiltField.setText(AppManager.formatDepression(this.source.verticalPatternMechanicalTilt));
        this.verticalPatternMechanicalTiltOrientationField.setText(AppManager.formatAzimuth(this.source.verticalPatternMechanicalTiltOrientation));
        AppManager.setComponentEnabled(this.verticalPatternElectricalTiltField, this.canEdit);
        AppManager.setComponentEnabled(this.verticalPatternMechanicalTiltField, this.canEdit);
        AppManager.setComponentEnabled(this.verticalPatternMechanicalTiltOrientationField, this.canEdit);
        this.useGenericVerticalPatternCheckBox.setSelected(this.source.useGenericVerticalPattern);
        AppManager.setComponentEnabled(this.useGenericVerticalPatternCheckBox, this.canEdit);
        this.cancelButton.setVisible(this.canEdit);
        this.rootEditor.blockActionsEnd();
    }

    public SourceEditData getSource() {
        return this.source;
    }

    private void doOK() {
        this.canceled = false;
        if (this.windowShouldClose()) {
            AppManager.hideWindow(this);
        }
    }

    public boolean cancel() {
        this.doCancel();
        return this.canceled;
    }

    private void doCancel() {
        if (this.patternEditor.isVisible() && !this.patternEditor.cancel()) {
            return;
        }
        this.canceled = true;
        if (this.windowShouldClose()) {
            AppManager.hideWindow(this);
        } else {
            this.canceled = false;
        }
    }

    private void doEditHorizontalPattern() {
        if (this.patternEditor.isVisible()) {
            return;
        }
        if (this.source.hasHorizontalPattern && null == this.source.horizontalPattern) {
            if (null != this.source.source) {
                this.source.horizontalPattern = this.source.source.getHorizontalPattern(DbManager.getDb(this.rootEditor.getDbID()), this.errorReporter);
            }
            if (null == this.source.horizontalPattern) {
                this.source.hasHorizontalPattern = false;
                this.source.horizontalPatternName = "";
                this.source.horizontalPatternChanged = true;
            }
        }
        this.patternEditor.setPatternType(1);
        AppManager.showWindow(this.patternEditor);
        if (this.source.hasHorizontalPattern) {
            this.horizontalPatternLabel.setText(this.source.horizontalPatternName);
            this.horizontalPatternLabel.setToolTipText(this.source.horizontalPatternName);
        } else {
            this.horizontalPatternLabel.setText("(none)");
            this.horizontalPatternLabel.setToolTipText(null);
        }
    }

    private void doEditVerticalPattern() {
        if (this.patternEditor.isVisible()) {
            return;
        }
        if (this.source.hasMatrixPattern) {
            if (this.source.hasVerticalPattern) {
                this.source.verticalPattern = null;
                this.source.hasVerticalPattern = false;
                this.source.verticalPatternName = "";
                this.source.verticalPatternChanged = true;
            }
            if (null == this.source.matrixPattern) {
                if (null != this.source.source) {
                    this.source.matrixPattern = this.source.source.getMatrixPattern(DbManager.getDb(this.rootEditor.getDbID()), this.errorReporter);
                }
                if (null == this.source.matrixPattern) {
                    this.source.hasMatrixPattern = false;
                    this.source.matrixPatternName = "";
                    this.source.matrixPatternChanged = true;
                }
            }
            this.patternEditor.setPatternType(3);
        } else {
            if (this.source.hasVerticalPattern && null == this.source.verticalPattern) {
                if (null != this.source.source) {
                    this.source.verticalPattern = this.source.source.getVerticalPattern(DbManager.getDb(this.rootEditor.getDbID()), this.errorReporter);
                }
                if (null == this.source.verticalPattern) {
                    this.source.hasVerticalPattern = false;
                    this.source.verticalPatternName = "";
                    this.source.verticalPatternChanged = true;
                }
            }
            this.patternEditor.setPatternType(2);
        }
        AppManager.showWindow(this.patternEditor);
        if (this.source.hasMatrixPattern) {
            this.verticalPatternLabel.setText(this.source.matrixPatternName + " (matrix)");
            this.verticalPatternLabel.setToolTipText(this.source.matrixPatternName + " (matrix)");
        } else if (this.source.hasVerticalPattern) {
            this.verticalPatternLabel.setText(this.source.verticalPatternName);
            this.verticalPatternLabel.setToolTipText(this.source.verticalPatternName);
        } else {
            this.verticalPatternLabel.setText("(none)");
            this.verticalPatternLabel.setToolTipText(null);
        }
    }

    @Override
    public void windowWillOpen() {
        this.setLocationRelativeTo(this.parent);
        this.canceled = false;
        if (!this.canEdit) {
            this.okButton.requestFocusInWindow();
        }
    }

    @Override
    public boolean windowShouldClose() {
        Component component;
        if (this.patternEditor.isVisible()) {
            return false;
        }
        if (this.canceled || !this.canEdit) {
            return true;
        }
        this.errorReporter.clearErrors();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (keyboardFocusManager.getFocusedWindow() == this && null != (component = keyboardFocusManager.getFocusOwner()) && component instanceof JTextField) {
            ((JTextField)component).postActionEvent();
        }
        if (this.errorReporter.hasErrors()) {
            return false;
        }
        if (!this.source.isDataValid(this.errorReporter)) {
            return false;
        }
        this.callSignField.requestFocusInWindow();
        return true;
    }
}

