/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.Country;
import gov.fcc.tvstudy.data.Service;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.KeyedRecordMenu;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SourceCreateNew
extends AppDialog {
    public static final String WINDOW_TITLE = "Add New Station";
    private AppFrame parent;
    private JTextField facility_idField;
    private KeyedRecordMenu countryMenu;
    private KeyedRecordMenu serviceMenu;
    private int facility_id;
    private Service service;
    private Country country;
    public boolean canceled;

    public SourceCreateNew(AppFrame appFrame) {
        super((Window)appFrame, WINDOW_TITLE, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDisposeOnClose(false);
        this.parent = appFrame;
        this.facility_idField = new JTextField(8);
        AppManager.fixKeyBindings(this.facility_idField);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Facility ID"));
        jPanel.add(this.facility_idField);
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        this.serviceMenu = new KeyedRecordMenu(Service.getServices(dbConnection));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Service"));
        jPanel2.add(this.serviceMenu);
        this.countryMenu = new KeyedRecordMenu(Country.getCountries(dbConnection));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Country"));
        jPanel3.add(this.countryMenu);
        JButton jButton = new JButton("Cancel");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceCreateNew.this.doCancel();
            }
        });
        JButton jButton2 = new JButton("Add");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceCreateNew.this.doOK();
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jPanel);
        jPanel4.add(jPanel3);
        jPanel4.add(jPanel2);
        JPanel jPanel5 = new JPanel(new FlowLayout(2));
        jPanel5.add(jButton);
        jPanel5.add(jButton2);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(jPanel4);
        container.add(jPanel5);
        this.getRootPane().setDefaultButton(jButton2);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setResizable(true);
        this.setLocationSaved(true);
    }

    @Override
    public String getDbID() {
        return this.parent.getDbID();
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
    }

    private void doOK() {
        String string = this.facility_idField.getText().trim();
        if (0 == string.length()) {
            AppManager.showMessage(this, "Please enter a facility ID.", WINDOW_TITLE, 2);
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            AppManager.showMessage(this, "The facility ID must be a number.", WINDOW_TITLE, 2);
            return;
        }
        if (n < 1) {
            AppManager.showMessage(this, "The facility ID must be greater than 0.", WINDOW_TITLE, 2);
            return;
        }
        this.facility_id = n;
        this.service = (Service)this.serviceMenu.getSelectedItem();
        this.country = (Country)this.countryMenu.getSelectedItem();
        this.canceled = false;
        AppManager.hideWindow(this);
    }

    public int getFacility_id() {
        return this.facility_id;
    }

    public Service getService() {
        return this.service;
    }

    public Country getCountry() {
        return this.country;
    }

    public boolean cancel() {
        this.doCancel();
        return this.canceled;
    }

    private void doCancel() {
        this.canceled = true;
        AppManager.hideWindow(this);
    }

    @Override
    public void windowWillOpen() {
        this.facility_id = 0;
        this.service = null;
        this.country = null;
        this.facility_idField.setText("");
        this.serviceMenu.setSelectedIndex(0);
        this.countryMenu.setSelectedIndex(0);
        this.facility_idField.requestFocusInWindow();
        this.setLocationRelativeTo(this.parent);
        this.canceled = false;
    }

    @Override
    public boolean windowShouldClose() {
        this.canceled = true;
        return true;
    }
}

