/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.Country;
import gov.fcc.tvstudy.data.Service;
import gov.fcc.tvstudy.editdata.CDBSRecord;
import gov.fcc.tvstudy.editdata.ScenarioEditData;
import gov.fcc.tvstudy.editdata.SourceEditData;
import gov.fcc.tvstudy.editor.DTSSourceEditor;
import gov.fcc.tvstudy.editor.RootEditor;
import gov.fcc.tvstudy.editor.ScenarioAddCDBS;
import gov.fcc.tvstudy.editor.SourceCreateNew;
import gov.fcc.tvstudy.editor.SourceEditor;
import gov.fcc.tvstudy.editor.SourceFindCDBS;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.QueryWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ScenarioEditor
extends AppFrame {
    public static final String WINDOW_TITLE = "Scenario";
    private RootEditor rootEditor;
    private AppFrame parent;
    private ScenarioEditData scenario;
    private JTextField scenarioNameField;
    private JTextArea scenarioDescriptionArea;
    private JTable sourceTable;
    private JButton editSourceButton;
    private JButton removeSourceButton;
    private JMenuItem editSourceMenuItem;
    private JMenuItem removeSourceMenuItem;
    private JMenuItem addUndesiredsMenuItem;
    private JMenuItem replicateSourceMenuItem;
    private JMenuItem unlockSourceMenuItem;
    private JMenuItem revertSourceMenuItem;
    private JMenuItem setDesiredMenuItem;
    private JMenuItem clearDesiredMenuItem;
    private JMenuItem setUndesiredMenuItem;
    private JMenuItem clearUndesiredMenuItem;
    private ScenarioAddCDBS sourcesAddDialog;
    private SourceFindCDBS sourceFindDialog;
    private SourceCreateNew sourceCreateDialog;
    private SourceEditor sourceEditor;
    private DTSSourceEditor dtsSourceEditor;
    private boolean inQuery;

    public ScenarioEditor(RootEditor rootEditor, AppFrame appFrame, ScenarioEditData scenarioEditData) {
        super(WINDOW_TITLE);
        this.rootEditor = rootEditor;
        this.parent = appFrame;
        this.scenario = scenarioEditData;
        this.setTitleKey(this.scenario.key);
        this.rootEditor.blockActionsStart();
        this.scenarioNameField = new JTextField(30);
        AppManager.fixKeyBindings(this.scenarioNameField);
        final ScenarioEditor scenarioEditor = this;
        this.scenarioNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ScenarioEditor.this.rootEditor.blockActions()) {
                    String string = ScenarioEditor.this.scenarioNameField.getText().trim();
                    if (!((ScenarioEditor)ScenarioEditor.this).scenario.name.equalsIgnoreCase(string) && DbManager.checkScenarioName(string, ((ScenarioEditor)ScenarioEditor.this).scenario.study, new ErrorReporter(ScenarioEditor.this.rootEditor, scenarioEditor, "Change Scenario Name"))) {
                        ((ScenarioEditor)ScenarioEditor.this).scenario.name = string;
                        ScenarioEditor.this.updateDocumentName();
                        ScenarioEditor.this.scenario.wasEdited();
                    }
                    ScenarioEditor.this.rootEditor.blockActionsEnd();
                }
                ScenarioEditor.this.scenarioNameField.setText(((ScenarioEditor)ScenarioEditor.this).scenario.name);
            }
        });
        this.scenarioNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    ScenarioEditor.this.scenarioNameField.postActionEvent();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Scenario Name"));
        jPanel.add(this.scenarioNameField);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel);
        this.scenarioNameField.setText(this.scenario.name);
        this.scenarioDescriptionArea = new JTextArea(6, 40);
        AppManager.fixKeyBindings(this.scenarioDescriptionArea);
        this.scenarioDescriptionArea.setLineWrap(true);
        this.scenarioDescriptionArea.setWrapStyleWord(true);
        this.scenarioDescriptionArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ((ScenarioEditor)ScenarioEditor.this).scenario.description = ScenarioEditor.this.scenarioDescriptionArea.getText().trim();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ((ScenarioEditor)ScenarioEditor.this).scenario.description = ScenarioEditor.this.scenarioDescriptionArea.getText().trim();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.scenarioDescriptionArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    ScenarioEditor.this.scenario.wasEdited();
                }
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Scenario Description"));
        jPanel3.add((Component)AppManager.createScrollPane(this.scenarioDescriptionArea), "Center");
        this.scenarioDescriptionArea.setText(this.scenario.description);
        this.scenario.description = this.scenarioDescriptionArea.getText().trim();
        this.sourceTable = this.scenario.sourceModel.createTable(this.editMenu);
        this.sourceTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 == mouseEvent.getClickCount()) {
                    ScenarioEditor.this.doEditSource();
                }
            }
        });
        this.sourceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ScenarioEditor.this.updateControls();
            }
        });
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder("Stations"));
        jPanel4.add((Component)AppManager.createScrollPane(this.sourceTable), "Center");
        this.rootEditor.blockActionsEnd();
        JButton jButton = new JButton("Add");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doAddSource();
            }
        });
        this.editSourceButton = new JButton("View");
        this.editSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doEditSource();
            }
        });
        this.removeSourceButton = new JButton("Remove");
        this.removeSourceButton.setFocusable(false);
        this.removeSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doRemoveSource();
            }
        });
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel2, "North");
        jPanel5.add((Component)jPanel3, "Center");
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        jPanel6.add(jButton);
        JPanel jPanel7 = new JPanel(new FlowLayout(2));
        jPanel7.add(this.removeSourceButton);
        jPanel7.add(this.editSourceButton);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.add(jPanel6);
        jPanel8.add(jPanel7);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel5, "North");
        container.add((Component)jPanel4, "Center");
        container.add((Component)jPanel8, "South");
        this.getRootPane().setDefaultButton(this.editSourceButton);
        this.pack();
        Dimension dimension = new Dimension(860, 650);
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.fileMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Previous");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, AppManager.MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doPrevious();
            }
        });
        this.fileMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Next");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(40, AppManager.MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doNext();
            }
        });
        this.fileMenu.add(jMenuItem2);
        this.fileMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Add...");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(78, AppManager.MENU_SHORTCUT_KEY_MASK));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doAddSource();
            }
        });
        this.fileMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("New...");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(78, AppManager.MENU_SHORTCUT_KEY_MASK | 1));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doAddNewSource();
            }
        });
        this.fileMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Add Desireds...");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doAddSources(false);
            }
        });
        this.fileMenu.add(jMenuItem5);
        this.addUndesiredsMenuItem = new JMenuItem("Add Undesireds...");
        this.addUndesiredsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doAddSources(true);
            }
        });
        this.fileMenu.add(this.addUndesiredsMenuItem);
        this.addUndesiredsMenuItem.setEnabled(this.scenario.sourceModel.hasDesiredSources());
        this.scenario.sourceModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                ScenarioEditor.this.addUndesiredsMenuItem.setEnabled(((ScenarioEditor)ScenarioEditor.this).scenario.sourceModel.hasDesiredSources());
            }
        });
        this.fileMenu.addSeparator();
        this.editSourceMenuItem = new JMenuItem("View");
        this.editSourceMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppManager.MENU_SHORTCUT_KEY_MASK));
        this.editSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doEditSource();
            }
        });
        this.fileMenu.add(this.editSourceMenuItem);
        this.removeSourceMenuItem = new JMenuItem("Remove");
        this.removeSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doRemoveSource();
            }
        });
        this.fileMenu.add(this.removeSourceMenuItem);
        this.fileMenu.addSeparator();
        this.replicateSourceMenuItem = new JMenuItem("Replicate...");
        this.replicateSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doReplicateSource();
            }
        });
        this.fileMenu.add(this.replicateSourceMenuItem);
        this.unlockSourceMenuItem = new JMenuItem("Allow Editing");
        this.unlockSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doUnlockSource();
            }
        });
        this.fileMenu.add(this.unlockSourceMenuItem);
        this.revertSourceMenuItem = new JMenuItem("Revert");
        this.revertSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doRevertSource();
            }
        });
        this.fileMenu.add(this.revertSourceMenuItem);
        this.editMenu.addSeparator();
        this.setDesiredMenuItem = new JMenuItem("Set Desired");
        this.setDesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSetFlags(true, true);
            }
        });
        this.editMenu.add(this.setDesiredMenuItem);
        this.clearDesiredMenuItem = new JMenuItem("Clear Desired");
        this.clearDesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSetFlags(true, false);
            }
        });
        this.editMenu.add(this.clearDesiredMenuItem);
        this.setUndesiredMenuItem = new JMenuItem("Set Undesired");
        this.setUndesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSetFlags(false, true);
            }
        });
        this.editMenu.add(this.setUndesiredMenuItem);
        this.clearUndesiredMenuItem = new JMenuItem("Clear Undesired");
        this.clearUndesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSetFlags(false, false);
            }
        });
        this.editMenu.add(this.clearUndesiredMenuItem);
        this.updateControls();
        this.sourcesAddDialog = new ScenarioAddCDBS(this.rootEditor, this, this.scenario);
        this.sourceFindDialog = new SourceFindCDBS(this, this.scenario.study.study.cdbsKey);
        this.sourceCreateDialog = new SourceCreateNew(this);
        this.sourceEditor = new SourceEditor(this.rootEditor, this);
        this.dtsSourceEditor = new DTSSourceEditor(this.rootEditor, this, this.sourceEditor);
        this.updateDocumentName();
    }

    private void updateControls() {
        int n = this.sourceTable.getSelectedRowCount();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (1 == n) {
            SourceEditData sourceEditData = this.scenario.sourceModel.getSource(this.sourceTable.convertRowIndexToModel(this.sourceTable.getSelectedRow()));
            bl = sourceEditData.isLocked;
            bl2 = true;
            bl3 = true;
            bl4 = true;
            bl5 = sourceEditData.isLocked && null == sourceEditData.originalSourceKey;
            bl6 = null != sourceEditData.originalSourceKey || !sourceEditData.isLocked && null != sourceEditData.application_id;
            bl7 = true;
        } else {
            bl = true;
            if (n > 1) {
                bl3 = true;
                bl7 = true;
            }
        }
        if (bl) {
            this.editSourceButton.setText("View");
            this.editSourceMenuItem.setText("View");
        } else {
            this.editSourceButton.setText("Edit");
            this.editSourceMenuItem.setText("Edit");
        }
        this.editSourceButton.setEnabled(bl2);
        this.editSourceMenuItem.setEnabled(bl2);
        this.removeSourceButton.setEnabled(bl3);
        this.removeSourceMenuItem.setEnabled(bl3);
        this.replicateSourceMenuItem.setEnabled(bl4);
        this.unlockSourceMenuItem.setEnabled(bl5);
        this.revertSourceMenuItem.setEnabled(bl6);
        this.setDesiredMenuItem.setEnabled(bl7);
        this.clearDesiredMenuItem.setEnabled(bl7);
        this.setUndesiredMenuItem.setEnabled(bl7);
        this.clearUndesiredMenuItem.setEnabled(bl7);
    }

    @Override
    public void dispose() {
        this.sourcesAddDialog.dispose();
        this.sourceFindDialog.dispose();
        this.sourceCreateDialog.dispose();
        this.sourceEditor.dispose();
        this.dtsSourceEditor.dispose();
        super.dispose();
    }

    @Override
    public String getDbID() {
        return this.scenario.study.dbID;
    }

    @Override
    public String getKeyTitle() {
        return this.rootEditor.getKeyTitle() + "." + super.getKeyTitle();
    }

    @Override
    protected String getFileMenuName() {
        return "Station";
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName() + "/" + this.scenario.name);
        this.sourcesAddDialog.updateDocumentName();
        this.sourceFindDialog.updateDocumentName();
        this.sourceCreateDialog.updateDocumentName();
        this.sourceEditor.updateDocumentName();
        this.dtsSourceEditor.updateDocumentName();
    }

    public ScenarioEditData getScenario() {
        return this.scenario;
    }

    public boolean isDataValid(String string) {
        Component component;
        if (this.inQuery) {
            this.rootEditor.reportValidationError(this, string, "Database operations are in progress.", 2);
            return false;
        }
        if (this.sourcesAddDialog.isVisible() || this.sourceFindDialog.isVisible() || this.sourceCreateDialog.isVisible() || this.sourceEditor.isVisible() || this.dtsSourceEditor.isVisible()) {
            this.rootEditor.reportValidationError(this, string, "Please close all editing dialogs before saving.", 2);
            return false;
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (keyboardFocusManager.getFocusedWindow() == this && null != (component = keyboardFocusManager.getFocusOwner()) && component instanceof JTextField) {
            ((JTextField)component).postActionEvent();
        }
        return !this.rootEditor.isValidationErrorPending();
    }

    private void doPrevious() {
        int n = this.sourceTable.getRowCount();
        int n2 = this.sourceTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.sourceTable.setRowSelectionInterval(n2, n2);
            this.sourceTable.scrollRectToVisible(this.sourceTable.getCellRect(n2, 0, true));
        }
    }

    private void doNext() {
        int n = this.sourceTable.getRowCount();
        int n2 = this.sourceTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.sourceTable.setRowSelectionInterval(n2, n2);
            this.sourceTable.scrollRectToVisible(this.sourceTable.getCellRect(n2, 0, true));
        }
    }

    private void doAddSources(boolean bl) {
        if (this.sourcesAddDialog.isVisible() || this.sourceFindDialog.isVisible() || this.sourceCreateDialog.isVisible() || this.sourceEditor.isVisible() || this.dtsSourceEditor.isVisible() || this.inQuery) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.scenario.study.dbID);
        String string = bl ? "Add Undesireds" : "Add Desireds";
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        if (bl && !this.scenario.sourceModel.hasDesiredSources()) {
            errorReporter.reportWarning("The scenario must have at least one desired station.");
            return;
        }
        this.sourcesAddDialog.setAddUndesired(bl);
        AppManager.showWindow(this.sourcesAddDialog);
        if (this.sourcesAddDialog.canceled) {
            return;
        }
        if (this.sourcesAddDialog.disableMX) {
            errorReporter.reportWarning("MX checks are disabled, new records will not be marked as undesireds.\nRecords that should be undesireds must be identified manually.");
        }
        QueryWorker<Integer> queryWorker = new QueryWorker<Integer>((Window)this, string, dbConnection){

            @Override
            public Integer doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                int n = ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.addUndesired ? CDBSRecord.scenarioAddUndesireds(dbConnection, ScenarioEditor.this.scenario, ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.query, ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.radius, ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.latitude, ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.longitude, ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.disableMX, ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.preferOperating, errorReporter) : CDBSRecord.scenarioAddDesireds(dbConnection, ScenarioEditor.this.scenario, ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.query, ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.radius, ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.latitude, ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.longitude, ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.disableMX, ((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.preferOperating, !((ScenarioEditor)ScenarioEditor.this).sourcesAddDialog.desiredOnly, errorReporter);
                if (n < 0) {
                    return null;
                }
                return new Integer(n);
            }
        };
        errorReporter.clearMessages();
        this.scenario.sourceModel.setHoldUpdates(true);
        this.inQuery = true;
        Integer n = (Integer)queryWorker.runQuery("Searching for stations, please wait...", errorReporter);
        this.inQuery = false;
        this.scenario.sourceModel.setHoldUpdates(false);
        if (null == n) {
            return;
        }
        if (errorReporter.hasMessages()) {
            AppManager.showLongMessage(this, errorReporter.getMessages(), string, 1);
            errorReporter.clearMessages();
        }
        errorReporter.reportMessage(n.toString() + " stations were added.");
    }

    private void doAddSource() {
        Object object;
        if (this.sourcesAddDialog.isVisible() || this.sourceFindDialog.isVisible() || this.sourceCreateDialog.isVisible() || this.sourceEditor.isVisible() || this.dtsSourceEditor.isVisible() || this.inQuery) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.scenario.study.dbID);
        String string = "Add Station";
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        this.sourceFindDialog.setChannelRange(this.scenario.study.minimumChannel, this.scenario.study.maximumChannel);
        AppManager.showWindow(this.sourceFindDialog);
        if (this.sourceFindDialog.canceled) {
            return;
        }
        CDBSRecord cDBSRecord = this.sourceFindDialog.getRecord();
        if (null == cDBSRecord) {
            return;
        }
        boolean bl = this.sourceFindDialog.getIsLocked();
        boolean bl2 = this.sourceFindDialog.getReplicate();
        int n = this.sourceFindDialog.getReplicationChannel();
        boolean bl3 = false;
        if (!bl2) {
            n = cDBSRecord.channel;
        }
        for (SourceEditData sourceEditData : this.scenario.sourceModel.getSources()) {
            if (cDBSRecord.application_id.equals(sourceEditData.application_id)) {
                errorReporter.reportWarning("That record is already in the scenario.");
                return;
            }
            if (bl3 || !CDBSRecord.areRecordsMX(cDBSRecord, n, sourceEditData, this.scenario.study.coChannelMxDistance, this.scenario.study.kilometersPerDegree)) continue;
            bl3 = true;
        }
        if (bl3) {
            AppManager.beep();
            object = new String[]{"No", "Yes"};
            if (1 != JOptionPane.showOptionDialog(this, "The new record appears to be mutually-exclusive with a record already in\nthe scenario.  The study will always consider all records in a scenario\nas potential interference sources to all others, regardless of apparent\nMX conditions.  Are you sure you want to add this record?", string, 0, 2, null, object, object[0])) {
                return;
            }
            errorReporter.reportWarning("The record will not be flagged as an undesired.");
        }
        object = null;
        errorReporter.clearErrors();
        if (bl2) {
            SourceEditData sourceEditData;
            sourceEditData = this.scenario.study.findSharedSource(cDBSRecord.application_id);
            if (null == sourceEditData) {
                sourceEditData = cDBSRecord.makeSource(dbConnection, this.scenario.study, true, errorReporter);
                if (null == sourceEditData) {
                    if (!errorReporter.hasErrors()) {
                        if (errorReporter.hasMessages()) {
                            errorReporter.reportError(errorReporter.getMessages());
                        } else {
                            errorReporter.reportError("The station record could not be created due to an unknown error.");
                        }
                    }
                    return;
                }
                this.scenario.study.addOrReplaceSource(sourceEditData);
            }
            if (null == (object = this.scenario.study.findSharedReplicationSource(cDBSRecord.application_id, n)) && null == (object = sourceEditData.replicate(n, errorReporter))) {
                return;
            }
        } else {
            if (bl) {
                object = this.scenario.study.findSharedSource(cDBSRecord.application_id);
            }
            if (null == object && null == (object = cDBSRecord.makeSource(dbConnection, this.scenario.study, bl, errorReporter))) {
                if (!errorReporter.hasErrors()) {
                    if (errorReporter.hasMessages()) {
                        errorReporter.reportError(errorReporter.getMessages());
                    } else {
                        errorReporter.reportError("The station record could not be created due to an unknown error.");
                    }
                }
                return;
            }
        }
        int n2 = this.scenario.sourceModel.addOrReplace((SourceEditData)object, true, !bl3);
        n2 = this.sourceTable.convertRowIndexToView(n2);
        this.sourceTable.setRowSelectionInterval(n2, n2);
        this.sourceTable.scrollRectToVisible(this.sourceTable.getCellRect(n2, 0, true));
        if (errorReporter.hasMessages()) {
            AppManager.showLongMessage(this, errorReporter.getMessages(), string, 1);
        }
        if (!object.isLocked) {
            this.doEditSource();
        }
    }

    private void doAddNewSource() {
        Country country;
        Service service;
        if (this.sourcesAddDialog.isVisible() || this.sourceFindDialog.isVisible() || this.sourceCreateDialog.isVisible() || this.sourceEditor.isVisible() || this.dtsSourceEditor.isVisible() || this.inQuery) {
            return;
        }
        String string = "Add New Station";
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        AppManager.showWindow(this.sourceCreateDialog);
        if (this.sourceCreateDialog.canceled) {
            return;
        }
        int n = this.sourceCreateDialog.getFacility_id();
        SourceEditData sourceEditData = SourceEditData.createSource(this.scenario.study, n, service = this.sourceCreateDialog.getService(), country = this.sourceCreateDialog.getCountry(), false, null, null, errorReporter);
        if (null == sourceEditData) {
            return;
        }
        if (sourceEditData.isParent) {
            this.dtsSourceEditor.setSource(sourceEditData);
            AppManager.showWindow(this.dtsSourceEditor);
            if (this.dtsSourceEditor.canceled) {
                return;
            }
            sourceEditData = this.dtsSourceEditor.getSource();
        } else {
            this.sourceEditor.setSource(sourceEditData);
            AppManager.showWindow(this.sourceEditor);
            if (this.sourceEditor.canceled) {
                return;
            }
            sourceEditData = this.sourceEditor.getSource();
        }
        boolean bl = false;
        for (SourceEditData sourceEditData2 : this.scenario.sourceModel.getSources()) {
            if (!CDBSRecord.areRecordsMX(sourceEditData, sourceEditData2, this.scenario.study.coChannelMxDistance, this.scenario.study.kilometersPerDegree)) continue;
            AppManager.beep();
            Object[] objectArray = new String[]{"No", "Yes"};
            if (1 != JOptionPane.showOptionDialog(this, "The new record appears to be mutually-exclusive with a record already in\nthe scenario.  The study will always consider all records in a scenario\nas potential interference sources to all others, regardless of apparent\nMX conditions.  Are you sure you want to add this record?", string, 0, 2, null, objectArray, objectArray[0])) {
                return;
            }
            errorReporter.reportWarning("The record will not be flagged as an undesired.");
            bl = true;
            break;
        }
        int n2 = this.scenario.sourceModel.addOrReplace(sourceEditData, true, !bl);
        n2 = this.sourceTable.convertRowIndexToView(n2);
        this.sourceTable.setRowSelectionInterval(n2, n2);
        this.sourceTable.scrollRectToVisible(this.sourceTable.getCellRect(n2, 0, true));
    }

    private void doEditSource() {
        if (this.sourcesAddDialog.isVisible() || this.sourceFindDialog.isVisible() || this.sourceCreateDialog.isVisible() || this.sourceEditor.isVisible() || this.dtsSourceEditor.isVisible() || this.inQuery) {
            return;
        }
        if (this.sourceTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.sourceTable.convertRowIndexToModel(this.sourceTable.getSelectedRow());
        SourceEditData sourceEditData = this.scenario.sourceModel.getSource(n);
        if (sourceEditData.isParent) {
            this.dtsSourceEditor.setSource(sourceEditData);
            AppManager.showWindow(this.dtsSourceEditor);
            if (this.dtsSourceEditor.canceled) {
                return;
            }
            if (!sourceEditData.isLocked) {
                this.scenario.sourceModel.set(n, this.dtsSourceEditor.getSource());
            }
        } else {
            this.sourceEditor.setSource(sourceEditData);
            AppManager.showWindow(this.sourceEditor);
            if (this.sourceEditor.canceled) {
                return;
            }
            if (!sourceEditData.isLocked) {
                this.scenario.sourceModel.set(n, this.sourceEditor.getSource());
            }
        }
    }

    private void doRemoveSource() {
        if (this.sourcesAddDialog.isVisible() || this.sourceFindDialog.isVisible() || this.sourceCreateDialog.isVisible() || this.sourceEditor.isVisible() || this.dtsSourceEditor.isVisible() || this.inQuery) {
            return;
        }
        if (0 == this.sourceTable.getSelectedRowCount()) {
            return;
        }
        int[] nArray = this.sourceTable.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.sourceTable.convertRowIndexToModel(nArray[i]);
        }
        this.scenario.sourceModel.remove(nArray2);
    }

    private void doUnlockSource() {
        if (this.sourcesAddDialog.isVisible() || this.sourceFindDialog.isVisible() || this.sourceCreateDialog.isVisible() || this.sourceEditor.isVisible() || this.dtsSourceEditor.isVisible() || this.inQuery) {
            return;
        }
        if (this.sourceTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.sourceTable.convertRowIndexToModel(this.sourceTable.getSelectedRow());
        SourceEditData sourceEditData = this.scenario.sourceModel.getSource(n);
        if (!sourceEditData.isLocked || null != sourceEditData.originalSourceKey) {
            return;
        }
        SourceEditData sourceEditData2 = sourceEditData.duplicate(false, new ErrorReporter(this, "Allow Editing"));
        if (null == sourceEditData2) {
            return;
        }
        this.scenario.sourceModel.set(n, sourceEditData2);
        this.editSourceButton.setText("Edit");
        this.editSourceMenuItem.setText("Edit");
        this.unlockSourceMenuItem.setEnabled(false);
        this.revertSourceMenuItem.setEnabled(true);
        this.doEditSource();
    }

    private void doReplicateSource() {
        if (this.sourcesAddDialog.isVisible() || this.sourceFindDialog.isVisible() || this.sourceCreateDialog.isVisible() || this.sourceEditor.isVisible() || this.dtsSourceEditor.isVisible() || this.inQuery) {
            return;
        }
        if (this.sourceTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.sourceTable.convertRowIndexToModel(this.sourceTable.getSelectedRow());
        SourceEditData sourceEditData = this.scenario.sourceModel.getSource(n);
        String string = "Replicate";
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        SourceEditData sourceEditData2 = sourceEditData;
        if (null != sourceEditData.originalSourceKey && null == (sourceEditData2 = this.scenario.study.getSource(sourceEditData.originalSourceKey))) {
            errorReporter.reportError("The original record for replication does not exist.\nThis should never happen; the study database is damaged.");
            return;
        }
        int n2 = 0;
        do {
            String string2;
            if (null == (string2 = JOptionPane.showInputDialog(this, "Enter the replication channel", string, 3))) {
                return;
            }
            if ((string2 = string2.trim()).length() <= 0) continue;
            try {
                n2 = Integer.parseInt(string2);
                if (n2 < this.scenario.study.minimumChannel || n2 > this.scenario.study.maximumChannel) {
                    errorReporter.reportWarning("The channel must be in the range " + this.scenario.study.minimumChannel + " to " + this.scenario.study.maximumChannel + ".");
                    n2 = 0;
                    continue;
                }
                if (!sourceEditData2.service.serviceType.digital || n2 != sourceEditData2.channel) continue;
                errorReporter.reportWarning("The channel must be different than the original.");
                n2 = 0;
            }
            catch (NumberFormatException numberFormatException) {
                errorReporter.reportWarning("The channel must be a number.");
                n2 = 0;
            }
        } while (false == n2);
        if (null != sourceEditData.originalSourceKey && n2 == sourceEditData.channel) {
            return;
        }
        SourceEditData sourceEditData3 = null;
        if (sourceEditData2.isLocked && null != sourceEditData2.application_id) {
            sourceEditData3 = this.scenario.study.findSharedReplicationSource(sourceEditData2.application_id, n2);
        }
        if (null == sourceEditData3 && null == (sourceEditData3 = sourceEditData2.replicate(n2, errorReporter))) {
            return;
        }
        this.scenario.sourceModel.set(n, sourceEditData3);
        this.editSourceButton.setText("View");
        this.editSourceMenuItem.setText("View");
        this.unlockSourceMenuItem.setEnabled(false);
        this.revertSourceMenuItem.setEnabled(true);
        if (errorReporter.hasMessages()) {
            AppManager.showLongMessage(this, errorReporter.getMessages(), string, 1);
        }
    }

    private void doRevertSource() {
        if (this.sourcesAddDialog.isVisible() || this.sourceFindDialog.isVisible() || this.sourceCreateDialog.isVisible() || this.sourceEditor.isVisible() || this.dtsSourceEditor.isVisible() || this.inQuery) {
            return;
        }
        if (this.sourceTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.sourceTable.convertRowIndexToModel(this.sourceTable.getSelectedRow());
        SourceEditData sourceEditData = this.scenario.sourceModel.getSource(n);
        DbConnection dbConnection = DbManager.getDb(this.scenario.study.dbID);
        String string = "Revert";
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        SourceEditData sourceEditData2 = null;
        errorReporter.clearErrors();
        if (null != sourceEditData.originalSourceKey) {
            sourceEditData2 = this.scenario.study.getSource(sourceEditData.originalSourceKey);
            if (null == sourceEditData2) {
                errorReporter.reportError("The original pre-replication record does not exist.\nThis should never happen; the study database is damaged.");
                return;
            }
        } else {
            if (sourceEditData.isLocked || null == sourceEditData.application_id) {
                return;
            }
            sourceEditData2 = this.scenario.study.findSharedSource(sourceEditData.application_id);
            if (null == sourceEditData2 && null == (sourceEditData2 = CDBSRecord.findSource(dbConnection, this.scenario.study, sourceEditData.application_id, true, errorReporter))) {
                if (!errorReporter.hasErrors()) {
                    errorReporter.reportError("The original CDBS record does not exist.\nThis should never happen; the study database is damaged.");
                }
                return;
            }
        }
        this.scenario.sourceModel.set(n, sourceEditData2);
        if (sourceEditData2.isLocked) {
            this.editSourceButton.setText("View");
            this.editSourceMenuItem.setText("View");
            this.unlockSourceMenuItem.setEnabled(true);
        } else {
            this.editSourceButton.setText("Edit");
            this.editSourceMenuItem.setText("Edit");
            this.unlockSourceMenuItem.setEnabled(false);
        }
        if (!sourceEditData2.isLocked && null != sourceEditData.application_id) {
            this.revertSourceMenuItem.setEnabled(true);
        } else {
            this.revertSourceMenuItem.setEnabled(false);
        }
    }

    private void doSetFlags(boolean bl, boolean bl2) {
        if (this.sourcesAddDialog.isVisible() || this.sourceFindDialog.isVisible() || this.sourceCreateDialog.isVisible() || this.sourceEditor.isVisible() || this.dtsSourceEditor.isVisible() || this.inQuery) {
            return;
        }
        if (0 == this.sourceTable.getSelectedRowCount()) {
            return;
        }
        for (int n : this.sourceTable.getSelectedRows()) {
            if (bl) {
                this.scenario.sourceModel.setIsDesired(this.sourceTable.convertRowIndexToModel(n), bl2);
                continue;
            }
            this.scenario.sourceModel.setIsUndesired(this.sourceTable.convertRowIndexToModel(n), bl2);
        }
    }

    public boolean closeWithoutSave() {
        if (this.inQuery) {
            return false;
        }
        if (this.sourcesAddDialog.isVisible() && !this.sourcesAddDialog.cancel()) {
            return false;
        }
        if (this.sourceFindDialog.isVisible() && !this.sourceFindDialog.cancel()) {
            return false;
        }
        if (this.sourceCreateDialog.isVisible() && !this.sourceCreateDialog.cancel()) {
            return false;
        }
        if (this.sourceEditor.isVisible() && !this.sourceEditor.cancel()) {
            return false;
        }
        if (this.dtsSourceEditor.isVisible() && !this.dtsSourceEditor.cancel()) {
            return false;
        }
        this.rootEditor.otherWindowClosed(this);
        AppManager.hideWindow(this);
        return true;
    }

    @Override
    public void windowWillOpen() {
        DbManager.restoreColumnWidths(this.scenario.study.dbID, this.getKeyTitle(), this.sourceTable);
    }

    @Override
    public boolean windowShouldClose() {
        if (this.sourcesAddDialog.isVisible() || this.sourceFindDialog.isVisible() || this.sourceCreateDialog.isVisible() || this.sourceEditor.isVisible() || this.dtsSourceEditor.isVisible() || this.inQuery) {
            return false;
        }
        DbManager.saveColumnWidths(this.scenario.study.dbID, this.getKeyTitle(), this.sourceTable);
        this.rootEditor.otherWindowClosed(this);
        return true;
    }
}

