/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.Country;
import gov.fcc.tvstudy.data.Service;
import gov.fcc.tvstudy.editdata.CDBSRecord;
import gov.fcc.tvstudy.editdata.ScenarioEditData;
import gov.fcc.tvstudy.editor.CoordinatePanel;
import gov.fcc.tvstudy.editor.RootEditor;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ScenarioAddCDBS
extends AppDialog {
    public static final String WINDOW_TITLE = "Add Stations";
    private RootEditor rootEditor;
    private AppFrame parent;
    private ScenarioEditData scenario;
    private ErrorReporter errors;
    private JCheckBox radiusSearchCheckBox;
    private JTextField radiusField;
    private CoordinatePanel latitudePanel;
    private CoordinatePanel longitudePanel;
    private JCheckBox countrySearchCheckBox;
    private ArrayList<Country> countries;
    private ArrayList<JCheckBox> countryCheckBoxes;
    private JCheckBox serviceSearchCheckBox;
    private ArrayList<Service> services;
    private ArrayList<JCheckBox> serviceCheckBoxes;
    private JCheckBox statusSearchCheckBox;
    private ArrayList<String> statuses;
    private ArrayList<JCheckBox> statusCheckBoxes;
    private JTextArea queryArea;
    private JCheckBox disableMXCheckBox;
    private JCheckBox preferOperatingCheckBox;
    private JCheckBox desiredOnlyCheckBox;
    private JButton okButton;
    public boolean addUndesired;
    public String query;
    public double radius;
    public double latitude;
    public double longitude;
    public boolean disableMX;
    public boolean preferOperating;
    public boolean desiredOnly;
    public boolean canceled;

    /*
     * WARNING - void declaration
     */
    public ScenarioAddCDBS(RootEditor rootEditor, AppFrame appFrame, ScenarioEditData scenarioEditData) {
        super((Window)appFrame, WINDOW_TITLE, Dialog.ModalityType.DOCUMENT_MODAL);
        void var11_19;
        JCheckBox jCheckBox;
        this.setDisposeOnClose(false);
        this.rootEditor = rootEditor;
        this.parent = appFrame;
        this.scenario = scenarioEditData;
        this.errors = new ErrorReporter(this.rootEditor, this, WINDOW_TITLE);
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        this.radiusSearchCheckBox = new JCheckBox("Search by center point and radius");
        this.radiusSearchCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ScenarioAddCDBS.this.radiusSearchCheckBox.isSelected();
                AppManager.setComponentEnabled(ScenarioAddCDBS.this.radiusField, bl);
                ScenarioAddCDBS.this.latitudePanel.setEnabled(bl);
                ScenarioAddCDBS.this.longitudePanel.setEnabled(bl);
            }
        });
        this.radiusField = new JTextField(7);
        AppManager.fixKeyBindings(this.radiusField);
        this.radiusField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ScenarioAddCDBS.this.rootEditor.blockActions()) {
                    String string = "Edit Radius";
                    String string2 = ScenarioAddCDBS.this.radiusField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            double d = Double.parseDouble(string2);
                            if (d < 1.0 || d > 1000.0) {
                                ScenarioAddCDBS.this.errors.reportValidationError(string, "The value must be in the range 1 to 1000.");
                            } else {
                                ScenarioAddCDBS.this.radius = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            ScenarioAddCDBS.this.errors.reportValidationError(string, "The value must be a number.");
                        }
                    }
                    ScenarioAddCDBS.this.rootEditor.blockActionsEnd();
                }
                ScenarioAddCDBS.this.radiusField.setText(AppManager.formatDistance(ScenarioAddCDBS.this.radius));
            }
        });
        this.radiusField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    ScenarioAddCDBS.this.radiusField.postActionEvent();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Radius, km"));
        jPanel.add(this.radiusField);
        this.latitudePanel = new CoordinatePanel(this.rootEditor, this.errors, false, new Runnable(){

            @Override
            public void run() {
                ScenarioAddCDBS.this.latitude = ScenarioAddCDBS.this.latitudePanel.getCoordinate();
            }
        });
        this.longitudePanel = new CoordinatePanel(this.rootEditor, this.errors, true, new Runnable(){

            @Override
            public void run() {
                ScenarioAddCDBS.this.longitude = ScenarioAddCDBS.this.longitudePanel.getCoordinate();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.radiusSearchCheckBox);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(jPanel);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.latitudePanel);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.longitudePanel);
        jPanel2.add(jPanel3);
        this.countrySearchCheckBox = new JCheckBox("Search by country");
        this.countrySearchCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ScenarioAddCDBS.this.countrySearchCheckBox.isSelected();
                for (JCheckBox jCheckBox : ScenarioAddCDBS.this.countryCheckBoxes) {
                    AppManager.setComponentEnabled(jCheckBox, bl);
                }
            }
        });
        this.countries = Country.getAllCountries(dbConnection);
        this.countryCheckBoxes = new ArrayList();
        for (Country object22 : this.countries) {
            jCheckBox = new JCheckBox(object22.name);
            this.countryCheckBoxes.add(jCheckBox);
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.add(this.countrySearchCheckBox);
        for (JCheckBox jCheckBox2 : this.countryCheckBoxes) {
            jPanel4.add(jCheckBox2);
        }
        this.serviceSearchCheckBox = new JCheckBox("Search by service");
        this.serviceSearchCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ScenarioAddCDBS.this.serviceSearchCheckBox.isSelected();
                for (JCheckBox jCheckBox : ScenarioAddCDBS.this.serviceCheckBoxes) {
                    AppManager.setComponentEnabled(jCheckBox, bl);
                }
            }
        });
        this.services = Service.getAllServices(dbConnection);
        this.serviceCheckBoxes = new ArrayList();
        for (Service service : this.services) {
            jCheckBox = new JCheckBox(service.serviceCode + " - " + service.name);
            this.serviceCheckBoxes.add(jCheckBox);
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setBorder(BorderFactory.createEtchedBorder());
        jPanel5.add(this.serviceSearchCheckBox);
        for (JCheckBox jCheckBox3 : this.serviceCheckBoxes) {
            jPanel5.add(jCheckBox3);
        }
        this.statusSearchCheckBox = new JCheckBox("Search by status");
        this.statusSearchCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ScenarioAddCDBS.this.statusSearchCheckBox.isSelected();
                for (JCheckBox jCheckBox : ScenarioAddCDBS.this.statusCheckBoxes) {
                    AppManager.setComponentEnabled(jCheckBox, bl);
                }
            }
        });
        this.statuses = new ArrayList();
        this.statusCheckBoxes = new ArrayList();
        boolean bl = false;
        while (var11_19 < CDBSRecord.STATUS_CODES.length) {
            this.statuses.add(CDBSRecord.STATUS_CODES[var11_19]);
            jCheckBox = new JCheckBox(CDBSRecord.STATUS_CODES[var11_19]);
            this.statusCheckBoxes.add(jCheckBox);
            ++var11_19;
        }
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setBorder(BorderFactory.createEtchedBorder());
        jPanel6.add(this.statusSearchCheckBox);
        for (JCheckBox jCheckBox4 : this.statusCheckBoxes) {
            jPanel6.add(jCheckBox4);
        }
        this.queryArea = new JTextArea(5, 46);
        AppManager.fixKeyBindings(this.queryArea);
        this.queryArea.setLineWrap(true);
        this.queryArea.setWrapStyleWord(true);
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(BorderFactory.createTitledBorder("Additional SQL for query WHERE clause"));
        jPanel7.add(AppManager.createScrollPane(this.queryArea));
        this.disableMXCheckBox = new JCheckBox("Disable all MX checks");
        this.disableMXCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ScenarioAddCDBS.this.disableMXCheckBox.isSelected()) {
                    AppManager.setComponentEnabled(ScenarioAddCDBS.this.preferOperatingCheckBox, false);
                    ScenarioAddCDBS.this.preferOperatingCheckBox.setSelected(false);
                    AppManager.setComponentEnabled(ScenarioAddCDBS.this.desiredOnlyCheckBox, false);
                    ScenarioAddCDBS.this.desiredOnlyCheckBox.setSelected(!ScenarioAddCDBS.this.addUndesired);
                } else {
                    AppManager.setComponentEnabled(ScenarioAddCDBS.this.preferOperatingCheckBox, true);
                    ScenarioAddCDBS.this.preferOperatingCheckBox.setSelected(ScenarioAddCDBS.this.addUndesired);
                    AppManager.setComponentEnabled(ScenarioAddCDBS.this.desiredOnlyCheckBox, !ScenarioAddCDBS.this.addUndesired);
                    ScenarioAddCDBS.this.desiredOnlyCheckBox.setSelected(false);
                }
            }
        });
        this.preferOperatingCheckBox = new JCheckBox("Prefer operating facilities");
        this.desiredOnlyCheckBox = new JCheckBox("Add stations as desired-only");
        JButton jButton = new JButton("Reset");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioAddCDBS.this.doReset();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioAddCDBS.this.doCancel();
            }
        });
        this.okButton = new JButton("Add Desireds");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioAddCDBS.this.doOK();
            }
        });
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.add(this.disableMXCheckBox);
        jPanel8.add(this.preferOperatingCheckBox);
        JPanel jPanel9 = new JPanel(new FlowLayout(0));
        jPanel9.add(jPanel8);
        jPanel9.add(this.desiredOnlyCheckBox);
        JPanel jPanel10 = new JPanel(new FlowLayout(0));
        jPanel10.add(jPanel4);
        jPanel10.add(jPanel6);
        JPanel jPanel11 = new JPanel(new FlowLayout(0));
        jPanel11.add(jPanel2);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BoxLayout(jPanel12, 1));
        jPanel12.add(jPanel10);
        jPanel12.add(jPanel11);
        JPanel jPanel13 = new JPanel(new FlowLayout(0));
        jPanel13.add(jPanel5);
        jPanel13.add(jPanel12);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BoxLayout(jPanel14, 1));
        jPanel14.add(jPanel9);
        jPanel14.add(jPanel13);
        jPanel14.add(jPanel7);
        JPanel jPanel15 = new JPanel(new FlowLayout(0));
        jPanel15.add(jButton);
        JPanel jPanel16 = new JPanel(new FlowLayout(2));
        jPanel16.add(jButton2);
        jPanel16.add(this.okButton);
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new BoxLayout(jPanel17, 0));
        jPanel17.add(jPanel15);
        jPanel17.add(jPanel16);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel14, "Center");
        container.add((Component)jPanel17, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setResizable(true);
        this.setLocationSaved(true);
    }

    @Override
    public String getDbID() {
        return this.parent.getDbID();
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
    }

    public void setAddUndesired(boolean bl) {
        this.addUndesired = bl;
        if (this.addUndesired) {
            this.desiredOnlyCheckBox.setVisible(false);
            this.okButton.setText("Add Undesireds");
        } else {
            this.desiredOnlyCheckBox.setVisible(true);
            this.okButton.setText("Add Desireds");
        }
    }

    private void doReset() {
        this.radiusSearchCheckBox.setSelected(false);
        this.radiusField.setText("");
        AppManager.setComponentEnabled(this.radiusField, false);
        this.latitudePanel.setCoordinate(0.0);
        this.latitudePanel.setEnabled(false);
        this.longitudePanel.setCoordinate(0.0);
        this.longitudePanel.setEnabled(false);
        this.countrySearchCheckBox.setSelected(false);
        for (JCheckBox jCheckBox : this.countryCheckBoxes) {
            jCheckBox.setSelected(false);
            AppManager.setComponentEnabled(jCheckBox, false);
        }
        this.serviceSearchCheckBox.setSelected(false);
        for (JCheckBox jCheckBox : this.serviceCheckBoxes) {
            jCheckBox.setSelected(false);
            AppManager.setComponentEnabled(jCheckBox, false);
        }
        this.statusSearchCheckBox.setSelected(false);
        for (JCheckBox jCheckBox : this.statusCheckBoxes) {
            jCheckBox.setSelected(false);
            AppManager.setComponentEnabled(jCheckBox, false);
        }
        this.queryArea.setText("");
        this.disableMXCheckBox.setSelected(false);
        AppManager.setComponentEnabled(this.preferOperatingCheckBox, true);
        this.preferOperatingCheckBox.setSelected(this.addUndesired);
        AppManager.setComponentEnabled(this.desiredOnlyCheckBox, !this.addUndesired);
        this.desiredOnlyCheckBox.setSelected(false);
        this.query = "";
        this.radius = 0.0;
        this.latitude = 0.0;
        this.longitude = 0.0;
        this.disableMX = false;
        this.preferOperating = false;
        this.desiredOnly = false;
    }

    private void doOK() {
        JCheckBox jCheckBox;
        Object object;
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder("(tv_eng_data.eng_record_type NOT IN ('A','R'))");
        if (this.countrySearchCheckBox.isSelected()) {
            stringBuilder.append(" AND (facility.fac_country IN ");
            n2 = 40;
            for (n = 0; n < this.countries.size(); ++n) {
                object = this.countries.get(n);
                jCheckBox = this.countryCheckBoxes.get(n);
                if (!jCheckBox.isSelected()) continue;
                stringBuilder.append((char)n2);
                stringBuilder.append('\'');
                stringBuilder.append(((Country)object).countryCode);
                stringBuilder.append('\'');
                n2 = 44;
            }
            if (40 == n2) {
                this.errors.reportWarning("Please select at least one country.");
                return;
            }
            stringBuilder.append("))");
        }
        if (this.serviceSearchCheckBox.isSelected()) {
            stringBuilder.append(" AND (tv_eng_data.vsd_service IN ");
            n2 = 40;
            for (n = 0; n < this.services.size(); ++n) {
                object = this.services.get(n);
                jCheckBox = this.serviceCheckBoxes.get(n);
                if (!jCheckBox.isSelected()) continue;
                stringBuilder.append((char)n2);
                stringBuilder.append('\'');
                stringBuilder.append(((Service)object).serviceCode);
                stringBuilder.append('\'');
                n2 = 44;
            }
            if (40 == n2) {
                this.errors.reportWarning("Please select at least one service.");
                return;
            }
            stringBuilder.append("))");
        }
        if (this.statusSearchCheckBox.isSelected()) {
            stringBuilder.append(" AND (tv_eng_data.tv_dom_status IN ");
            n2 = 40;
            for (n = 0; n < this.statuses.size(); ++n) {
                object = this.statuses.get(n);
                jCheckBox = this.statusCheckBoxes.get(n);
                if (!jCheckBox.isSelected()) continue;
                stringBuilder.append((char)n2);
                stringBuilder.append('\'');
                stringBuilder.append((String)object);
                stringBuilder.append('\'');
                n2 = 44;
            }
            if (40 == n2) {
                this.errors.reportWarning("Please select at least one status.");
                return;
            }
            stringBuilder.append("))");
        }
        if (((String)(object = this.queryArea.getText().trim())).length() > 0) {
            stringBuilder.append(" AND (");
            stringBuilder.append((String)object);
            stringBuilder.append(')');
        }
        this.query = stringBuilder.toString();
        this.disableMX = this.disableMXCheckBox.isSelected();
        this.preferOperating = this.preferOperatingCheckBox.isSelected();
        this.desiredOnly = this.desiredOnlyCheckBox.isSelected();
        this.canceled = false;
        AppManager.hideWindow(this);
    }

    public boolean cancel() {
        this.doCancel();
        return this.canceled;
    }

    private void doCancel() {
        this.canceled = true;
        AppManager.hideWindow(this);
    }

    @Override
    public void windowWillOpen() {
        this.doReset();
        this.setLocationRelativeTo(this.parent);
        this.canceled = false;
    }

    @Override
    public boolean windowShouldClose() {
        this.canceled = true;
        return true;
    }
}

