/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.Source;
import gov.fcc.tvstudy.editdata.CDBSRecord;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.QueryWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PatternFindCDBS
extends AppDialog {
    public static final String WINDOW_TITLE = "Find CDBS Pattern";
    private AppDialog parent;
    private int cdbsKey;
    private int patternType;
    private JTextField searchField;
    private SearchListModel searchModel;
    private JButton searchButton;
    private JButton okButton;
    private JButton cancelButton;
    private String patternName;
    private ArrayList<Source.PatternPoint> patternPoints;
    private int antenna_id;
    public boolean canceled;
    private boolean inQuery;

    public PatternFindCDBS(AppDialog appDialog) {
        super((Window)appDialog, WINDOW_TITLE, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDisposeOnClose(false);
        this.parent = appDialog;
        this.searchField = new JTextField(15);
        AppManager.fixKeyBindings(this.searchField);
        this.searchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternFindCDBS.this.doSearch();
            }
        });
        this.searchModel = new SearchListModel();
        this.searchModel.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PatternFindCDBS.this.okButton.setEnabled(PatternFindCDBS.this.searchModel.getSelectedIndex() >= 0);
            }
        });
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternFindCDBS.this.doSearch();
            }
        });
        this.okButton = new JButton("Use");
        this.okButton.setFocusable(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternFindCDBS.this.doOK();
            }
        });
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternFindCDBS.this.doCancel();
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.searchField);
        jPanel.add(this.searchButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.cancelButton);
        jPanel2.add(this.okButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "North");
        container.add((Component)AppManager.createScrollPane(this.searchModel.list), "Center");
        container.add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(this.searchButton);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.height = 350;
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.setResizable(true);
        this.setLocationSaved(true);
    }

    @Override
    public String getDbID() {
        return this.parent.getDbID();
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
    }

    public void setPatternType(int n) {
        if (this.isVisible()) {
            return;
        }
        this.patternType = n;
        this.searchField.setText("");
        this.searchModel.setItems(null);
        this.patternName = null;
        this.patternPoints = null;
        this.antenna_id = 0;
    }

    public void setCDBSKey(int n) {
        this.cdbsKey = n;
        this.searchField.setText("");
        this.searchModel.setItems(null);
        this.patternName = null;
        this.patternPoints = null;
        this.antenna_id = 0;
    }

    private void doSearch() {
        if (this.inQuery) {
            return;
        }
        String string = this.searchField.getText().trim().toUpperCase();
        if (0 == string.length()) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        ErrorReporter errorReporter = new ErrorReporter(this, WINDOW_TITLE);
        String string2 = "";
        String string3 = "";
        switch (this.patternType) {
            default: {
                string2 = "antenna_id";
                string3 = "ant_make";
                break;
            }
            case 2: 
            case 3: {
                string2 = "elevation_antenna_id";
                string3 = "elevation_ant_make";
            }
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT " + string2 + ", ant_make, ant_model_num FROM tvstudy_cdbs_" + this.cdbsKey + "." + string3 + " WHERE ");
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n > 0) {
            stringBuilder.append("(" + string2 + "=" + n + ") OR ");
        }
        if (string.length() <= 3) {
            stringBuilder.append("(UPPER(ant_make) LIKE '%" + dbConnection.clean(string) + "%') OR ");
        }
        stringBuilder.append("(UPPER(ant_model_num) LIKE '%" + dbConnection.clean(string) + "%') ORDER BY 2, 3");
        final String string4 = stringBuilder.toString();
        final ArrayList arrayList = new ArrayList();
        QueryWorker<Object> queryWorker = new QueryWorker<Object>((Window)this, WINDOW_TITLE, dbConnection){

            @Override
            protected Object doBackgroundQuery(DbConnection dbConnection, ErrorReporter errorReporter) {
                if (dbConnection.connect(errorReporter)) {
                    try {
                        dbConnection.query(string4);
                        while (dbConnection.next()) {
                            SearchListItem searchListItem = new SearchListItem();
                            searchListItem.cdbs_id = dbConnection.getInt(1);
                            searchListItem.name = dbConnection.getString(2) + "-" + dbConnection.getString(3);
                            arrayList.add(searchListItem);
                        }
                    }
                    catch (SQLException sQLException) {
                        dbConnection.reportError(errorReporter, sQLException);
                    }
                    dbConnection.close();
                }
                return null;
            }
        };
        this.inQuery = true;
        queryWorker.runQuery("Searching for patterns, please wait...", errorReporter);
        this.inQuery = false;
        this.searchModel.setItems(arrayList);
    }

    private void doOK() {
        if (this.inQuery) {
            return;
        }
        SearchListItem searchListItem = this.searchModel.getSelectedItem();
        if (null == searchListItem) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.parent.getDbID());
        ErrorReporter errorReporter = new ErrorReporter(this, WINDOW_TITLE);
        ArrayList<Source.PatternPoint> arrayList = null;
        switch (this.patternType) {
            default: {
                arrayList = CDBSRecord.getAntennaPattern(dbConnection, this.cdbsKey, searchListItem.cdbs_id, errorReporter);
                if (null != arrayList && arrayList.isEmpty()) {
                    errorReporter.reportWarning("No pattern data found, the antenna type is omnidirectional.");
                    arrayList = null;
                    this.antenna_id = 0;
                    break;
                }
                this.antenna_id = searchListItem.cdbs_id;
                break;
            }
            case 2: 
            case 3: {
                arrayList = CDBSRecord.getElevationPattern(dbConnection, this.cdbsKey, searchListItem.cdbs_id, errorReporter);
            }
        }
        if (null == arrayList) {
            return;
        }
        if (errorReporter.hasMessages()) {
            AppManager.showLongMessage(this, errorReporter.getMessages(), WINDOW_TITLE, 1);
        }
        this.patternName = searchListItem.name;
        this.patternPoints = arrayList;
        AppManager.hideWindow(this);
    }

    public String getPatternName() {
        return this.patternName;
    }

    public ArrayList<Source.PatternPoint> getPatternPoints() {
        return this.patternPoints;
    }

    public int getAntennaID() {
        return this.antenna_id;
    }

    public boolean cancel() {
        this.doCancel();
        return this.canceled;
    }

    private void doCancel() {
        if (this.inQuery) {
            return;
        }
        this.canceled = true;
        AppManager.hideWindow(this);
    }

    @Override
    public void windowWillOpen() {
        this.patternName = null;
        this.patternPoints = null;
        this.antenna_id = 0;
        this.searchField.requestFocusInWindow();
        this.setLocationRelativeTo(this.parent);
        this.okButton.setEnabled(this.searchModel.getSelectedIndex() >= 0);
        this.canceled = false;
    }

    @Override
    public boolean windowShouldClose() {
        if (this.inQuery) {
            return false;
        }
        this.canceled = true;
        return true;
    }

    private class SearchListModel
    extends AbstractListModel {
        private ArrayList<SearchListItem> modelRows = new ArrayList();
        private JList list = new JList(this);

        private SearchListModel() {
            this.list.setSelectionMode(0);
        }

        private void setItems(ArrayList<SearchListItem> arrayList) {
            int n = this.modelRows.size() - 1;
            if (n >= 0) {
                this.modelRows.clear();
                this.fireIntervalRemoved(this, 0, n);
            }
            if (null != arrayList) {
                this.modelRows.addAll(arrayList);
            }
            if ((n = this.modelRows.size() - 1) >= 0) {
                this.fireIntervalAdded(this, 0, n);
            }
        }

        private int getSelectedIndex() {
            return this.list.getSelectedIndex();
        }

        private SearchListItem get(int n) {
            return this.modelRows.get(n);
        }

        private SearchListItem getSelectedItem() {
            int n = this.list.getSelectedIndex();
            if (n >= 0) {
                return this.modelRows.get(n);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.modelRows.size();
        }

        @Override
        public Object getElementAt(int n) {
            SearchListItem searchListItem = this.modelRows.get(n);
            return String.valueOf(searchListItem.cdbs_id) + " " + searchListItem.name;
        }
    }

    private class SearchListItem {
        int cdbs_id;
        private String name;

        private SearchListItem() {
        }
    }
}

