/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.data.Source;
import gov.fcc.tvstudy.editdata.SourceEditData;
import gov.fcc.tvstudy.editor.PatternFindCDBS;
import gov.fcc.tvstudy.editor.RootEditor;
import gov.fcc.tvstudy.editor.SourceEditor;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Path2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class PatternEditor
extends AppDialog {
    public static final String WINDOW_TITLE = "Antenna Pattern";
    public static final int PATTERN_TYPE_HORIZONTAL = 1;
    public static final int PATTERN_TYPE_VERTICAL = 2;
    public static final int PATTERN_TYPE_MATRIX = 3;
    private RootEditor rootEditor;
    private SourceEditor parent;
    private ErrorReporter errorReporter;
    private int patternType;
    private JTextField patternNameField;
    private PatternTableModel patternModel;
    private int antenna_id;
    private ArrayList<Source.PatternSlice> matrixPattern;
    private int matrixPatternIndex;
    private JLabel matrixAzimuthLabel;
    private JPanel matrixPanel;
    private PatternPlot patternPlot;
    private JButton addPointButton;
    private JButton insertPointButton;
    private JButton deletePointButton;
    private JButton setNoPatternButton;
    private JButton importButton;
    private JButton exportButton;
    private JButton searchButton;
    private JButton okButton;
    private JButton cancelButton;
    private File lastImportExport;
    private PatternFindCDBS searchDialog;
    private boolean canEdit;
    private boolean didEdit;
    private boolean matrixDidEdit;
    public boolean canceled;

    public PatternEditor(RootEditor rootEditor, SourceEditor sourceEditor) {
        super((Window)sourceEditor, WINDOW_TITLE, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDisposeOnClose(false);
        this.rootEditor = rootEditor;
        this.parent = sourceEditor;
        this.errorReporter = new ErrorReporter(this.rootEditor, this, "Edit Antenna Pattern");
        this.rootEditor.blockActionsStart();
        this.patternNameField = new JTextField(30);
        AppManager.fixKeyBindings(this.patternNameField);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Pattern Name"));
        jPanel.add(this.patternNameField);
        this.patternModel = new PatternTableModel();
        this.patternModel.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (PatternEditor.this.canEdit && PatternEditor.this.patternModel.getSelectedRow() >= 0) {
                    PatternEditor.this.insertPointButton.setEnabled(true);
                    PatternEditor.this.deletePointButton.setEnabled(true);
                } else {
                    PatternEditor.this.insertPointButton.setEnabled(false);
                    PatternEditor.this.deletePointButton.setEnabled(false);
                }
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)AppManager.createScrollPane(this.patternModel.table), "Center");
        this.matrixAzimuthLabel = new JLabel();
        this.matrixAzimuthLabel.setPreferredSize(AppManager.getLabelSize(10));
        this.rootEditor.blockActionsEnd();
        this.addPointButton = new JButton("Add");
        this.addPointButton.setFocusable(false);
        this.addPointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternEditor.this.doAddPoint();
            }
        });
        this.insertPointButton = new JButton("Insert");
        this.insertPointButton.setFocusable(false);
        this.insertPointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternEditor.this.doInsertPoint();
            }
        });
        this.deletePointButton = new JButton("Delete");
        this.deletePointButton.setFocusable(false);
        this.deletePointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternEditor.this.doDeletePoint();
            }
        });
        JButton jButton = new JButton("Previous");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternEditor.this.doPreviousAzimuth();
            }
        });
        JButton jButton2 = new JButton("Next");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternEditor.this.doNextAzimuth();
            }
        });
        this.setNoPatternButton = new JButton("Clear");
        this.setNoPatternButton.setFocusable(false);
        this.setNoPatternButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternEditor.this.doSetNoPattern();
            }
        });
        this.importButton = new JButton("Import");
        this.importButton.setFocusable(false);
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternEditor.this.doImport();
            }
        });
        this.exportButton = new JButton("Export");
        this.exportButton.setFocusable(false);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternEditor.this.doExport();
            }
        });
        this.searchButton = new JButton("Find");
        this.searchButton.setFocusable(false);
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternEditor.this.doSearch();
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternEditor.this.doOK();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternEditor.this.doCancel();
            }
        });
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.addPointButton);
        jPanel3.add(this.insertPointButton);
        jPanel3.add(this.deletePointButton);
        jPanel2.add((Component)jPanel3, "South");
        this.patternPlot = new PatternPlot();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Data", jPanel2);
        jTabbedPane.addTab("Plot", this.patternPlot);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(this.setNoPatternButton);
        jPanel4.add(this.importButton);
        jPanel4.add(this.exportButton);
        jPanel4.add(this.searchButton);
        JPanel jPanel5 = new JPanel(new FlowLayout(2));
        jPanel5.add(this.cancelButton);
        jPanel5.add(this.okButton);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        this.matrixPanel = new JPanel(new FlowLayout(0));
        this.matrixPanel.setBorder(BorderFactory.createTitledBorder("Pattern Azimuth"));
        this.matrixPanel.add(this.matrixAzimuthLabel);
        this.matrixPanel.add(jButton);
        this.matrixPanel.add(jButton2);
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.add(this.matrixPanel);
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.add((Component)jPanel7, "North");
        jPanel8.add((Component)jTabbedPane, "Center");
        JPanel jPanel9 = new JPanel(new FlowLayout(0));
        jPanel9.add(jPanel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel9, "North");
        container.add((Component)jPanel8, "Center");
        container.add((Component)jPanel6, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.height = 650;
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.setResizable(true);
        this.setLocationSaved(true);
        this.searchDialog = new PatternFindCDBS(this);
    }

    @Override
    public void dispose() {
        this.searchDialog.dispose();
        super.dispose();
    }

    @Override
    public String getDbID() {
        return this.rootEditor.getDbID();
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
    }

    public void setPatternType(int n) {
        if (this.isVisible()) {
            return;
        }
        this.patternType = n;
        switch (n) {
            default: {
                this.matrixPanel.setVisible(false);
                break;
            }
            case 2: {
                this.matrixPanel.setVisible(false);
                break;
            }
            case 3: {
                this.matrixPanel.setVisible(true);
            }
        }
        this.patternModel.table.getColumnModel().getColumn(0).setHeaderValue(this.patternModel.getColumnName(0));
        this.searchDialog.setPatternType(n);
    }

    private void doSetNoPattern() {
        if (this.canEdit) {
            this.patternNameField.setText("");
            this.patternModel.setPoints(null);
            this.didEdit = true;
            this.antenna_id = 0;
            if (3 == this.patternType) {
                this.patternType = 2;
                this.matrixPattern = null;
                this.matrixPatternIndex = 0;
                this.matrixPanel.setVisible(false);
                this.matrixDidEdit = false;
            }
        }
    }

    private void doImport() {
        double d;
        double d2;
        double d3;
        if (!this.canEdit) {
            return;
        }
        String string = "Import Pattern";
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        JFileChooser jFileChooser = new JFileChooser(this.lastImportExport);
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("CSV file", "csv", "CSV"));
        if (0 != jFileChooser.showDialog(this, "Import")) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            errorReporter.reportError("Could not open the file:\n" + fileNotFoundException.getMessage());
            return;
        }
        this.lastImportExport = file.getParentFile();
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        ArrayList<Source.PatternPoint> arrayList = new ArrayList<Source.PatternPoint>();
        boolean bl = false;
        String string2 = "";
        int n = 0;
        Pattern pattern = Pattern.compile(",");
        if (1 == this.patternType) {
            d3 = 0.0;
            d2 = 359.999;
            d = -1.0;
        } else {
            d3 = -90.0;
            d2 = 90.0;
            d = -91.0;
        }
        try {
            String string3;
            while (null != (string3 = bufferedReader.readLine())) {
                double d4;
                double d5;
                ++n;
                String[] stringArray = pattern.split(string3);
                if (2 != stringArray.length) {
                    bl = true;
                    string2 = "Bad data format";
                    break;
                }
                try {
                    d5 = Double.parseDouble(stringArray[0]);
                    d4 = Double.parseDouble(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    string2 = "Bad data format";
                    break;
                }
                if (d5 < d3 || d5 > d2) {
                    bl = true;
                    if (1 == this.patternType) {
                        string2 = "Azimuth out of range";
                        break;
                    }
                    string2 = "Depression angle out of range";
                    break;
                }
                if (d5 <= d) {
                    bl = true;
                    string2 = "Points out of sequence";
                    break;
                }
                d = d5;
                if (d4 < 0.001 || d4 > 1.0) {
                    bl = true;
                    string2 = "Field out of range";
                    break;
                }
                arrayList.add(new Source.PatternPoint(d5, d4));
            }
            if (!bl && arrayList.isEmpty()) {
                bl = true;
                string2 = "The file was empty.";
            }
        }
        catch (IOException iOException) {
            bl = true;
            string2 = "Could not read from the file:\n" + iOException.getMessage();
            n = 0;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            if (n > 0) {
                string2 = string2 + " at line " + n;
            }
            errorReporter.reportError(string2);
        } else {
            this.patternModel.setPoints(arrayList);
            this.didEdit = true;
            this.antenna_id = 0;
        }
    }

    private void doExport() {
        if (0 == this.patternModel.getRowCount()) {
            return;
        }
        String string = "Export Pattern";
        ErrorReporter errorReporter = new ErrorReporter(this, string);
        JFileChooser jFileChooser = new JFileChooser(this.lastImportExport);
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        File file = null;
        do {
            if (0 != jFileChooser.showDialog(this, "Export")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            if (!file.exists()) continue;
            AppManager.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        String string2 = file.getName();
        if (!string2.endsWith(".csv") && !string2.endsWith(".CSV")) {
            file = new File(file.getAbsolutePath() + ".csv");
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return;
        }
        this.lastImportExport = file.getParentFile();
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        try {
            for (Source.PatternPoint patternPoint : this.patternModel.getPoints()) {
                bufferedWriter.write(String.format("%.3f,%.4f\n", patternPoint.azimuthOrDepression, patternPoint.relativeField));
            }
        }
        catch (IOException iOException) {
            errorReporter.reportError("Could not write to the file:\n" + iOException.getMessage());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doSearch() {
        if (!this.canEdit || this.searchDialog.isVisible()) {
            return;
        }
        AppManager.showWindow(this.searchDialog);
        if (this.searchDialog.canceled) {
            return;
        }
        String string = this.searchDialog.getPatternName();
        ArrayList<Source.PatternPoint> arrayList = this.searchDialog.getPatternPoints();
        if (null == string || null == arrayList) {
            return;
        }
        this.patternNameField.setText(string);
        this.patternModel.setPoints(arrayList);
        this.didEdit = true;
        this.antenna_id = this.searchDialog.getAntennaID();
    }

    private void doAddPoint() {
        if (!this.canEdit) {
            return;
        }
        double d = 0.0;
        double d2 = 1.0;
        int n = this.patternModel.getRowCount() - 1;
        if (n >= 0) {
            double d3;
            double d4;
            switch (this.patternType) {
                default: {
                    d4 = 10.0;
                    d3 = 359.999;
                    break;
                }
                case 2: 
                case 3: {
                    d4 = 1.0;
                    d3 = 90.0;
                }
            }
            Source.PatternPoint patternPoint = this.patternModel.get(n);
            if (n > 0) {
                Source.PatternPoint patternPoint2 = this.patternModel.get(n - 1);
                d4 = patternPoint.azimuthOrDepression - patternPoint2.azimuthOrDepression;
            }
            if ((d = patternPoint.azimuthOrDepression + d4) > d3) {
                d = d3;
            }
            if (d == patternPoint.azimuthOrDepression) {
                AppManager.beep();
                return;
            }
            d2 = patternPoint.relativeField;
        }
        if (this.patternModel.addPoint(new Source.PatternPoint(d, d2)) >= 0) {
            this.didEdit = true;
            this.antenna_id = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doInsertPoint() {
        double d;
        double d2;
        double d3;
        if (!this.canEdit) {
            return;
        }
        int n = this.patternModel.getSelectedRow();
        if (n < 0) {
            return;
        }
        double d4 = 0.0;
        double d5 = 1.0;
        Source.PatternPoint patternPoint = this.patternModel.get(n);
        switch (this.patternType) {
            default: {
                d3 = 10.0;
                d2 = 0.0;
                d = 1000.0;
                break;
            }
            case 2: 
            case 3: {
                d3 = 1.0;
                d2 = -90.0;
                d = 1000.0;
            }
        }
        if (n > 0) {
            Source.PatternPoint patternPoint2 = this.patternModel.get(n - 1);
            if (!(patternPoint.azimuthOrDepression - patternPoint2.azimuthOrDepression > 2.0 / d)) {
                AppManager.beep();
                return;
            }
            d4 = (patternPoint.azimuthOrDepression + patternPoint2.azimuthOrDepression) / 2.0;
            d4 = Math.rint(d4 * d) / d;
            d5 = (patternPoint.relativeField + patternPoint2.relativeField) / 2.0;
            d5 = Math.rint(d5 * 1000.0) / 1000.0;
        } else {
            if (n < this.patternModel.getRowCount() - 1) {
                Source.PatternPoint patternPoint3 = this.patternModel.get(n + 1);
                d3 = patternPoint3.azimuthOrDepression - patternPoint.azimuthOrDepression;
            }
            if ((d4 = patternPoint.azimuthOrDepression - d3) < d2) {
                d4 = d2;
            }
            if (d4 == patternPoint.azimuthOrDepression) {
                AppManager.beep();
                return;
            }
            d5 = patternPoint.relativeField;
        }
        if (this.patternModel.addPoint(new Source.PatternPoint(d4, d5)) >= 0) {
            this.didEdit = true;
            this.antenna_id = 0;
        }
    }

    private void doDeletePoint() {
        int n;
        if (this.canEdit && (n = this.patternModel.getSelectedRow()) >= 0) {
            this.patternModel.remove(n);
            this.didEdit = true;
            this.antenna_id = 0;
        }
    }

    private void doPreviousAzimuth() {
        if (3 != this.patternType) {
            return;
        }
        if (this.didEdit) {
            this.matrixPattern.set(this.matrixPatternIndex, new Source.PatternSlice(this.matrixPattern.get((int)this.matrixPatternIndex).azimuth, this.patternModel.getPoints()));
            this.matrixDidEdit = true;
            this.didEdit = false;
        }
        if (--this.matrixPatternIndex < 0) {
            this.matrixPatternIndex = this.matrixPattern.size() - 1;
        }
        Source.PatternSlice patternSlice = this.matrixPattern.get(this.matrixPatternIndex);
        this.matrixAzimuthLabel.setText(AppManager.formatAzimuth(patternSlice.azimuth));
        this.patternModel.setPoints(patternSlice.pattern);
    }

    private void doNextAzimuth() {
        if (3 != this.patternType) {
            return;
        }
        if (this.didEdit) {
            this.matrixPattern.set(this.matrixPatternIndex, new Source.PatternSlice(this.matrixPattern.get((int)this.matrixPatternIndex).azimuth, this.patternModel.getPoints()));
            this.matrixDidEdit = true;
            this.didEdit = false;
        }
        if (++this.matrixPatternIndex >= this.matrixPattern.size()) {
            this.matrixPatternIndex = 0;
        }
        Source.PatternSlice patternSlice = this.matrixPattern.get(this.matrixPatternIndex);
        this.matrixAzimuthLabel.setText(AppManager.formatAzimuth(patternSlice.azimuth));
        this.patternModel.setPoints(patternSlice.pattern);
    }

    private void doOK() {
        if (!this.windowShouldClose()) {
            return;
        }
        if (this.canEdit) {
            SourceEditData sourceEditData = this.parent.getSource();
            switch (this.patternType) {
                default: {
                    sourceEditData.horizontalPatternName = this.patternNameField.getText().trim();
                    if (!this.didEdit) break;
                    sourceEditData.horizontalPatternChanged = true;
                    sourceEditData.horizontalPattern = this.patternModel.getPoints();
                    sourceEditData.hasHorizontalPattern = null != sourceEditData.horizontalPattern;
                    sourceEditData.antenna_id = this.antenna_id;
                    break;
                }
                case 2: {
                    sourceEditData.verticalPatternName = this.patternNameField.getText().trim();
                    if (!this.didEdit) break;
                    sourceEditData.verticalPatternChanged = true;
                    sourceEditData.verticalPattern = this.patternModel.getPoints();
                    boolean bl = sourceEditData.hasVerticalPattern = null != sourceEditData.verticalPattern;
                    if (!sourceEditData.hasMatrixPattern) break;
                    sourceEditData.matrixPatternName = "";
                    sourceEditData.matrixPatternChanged = true;
                    sourceEditData.matrixPattern = null;
                    sourceEditData.hasMatrixPattern = false;
                    break;
                }
                case 3: {
                    sourceEditData.matrixPatternName = this.patternNameField.getText().trim();
                    if (this.didEdit) {
                        this.matrixPattern.set(this.matrixPatternIndex, new Source.PatternSlice(this.matrixPattern.get((int)this.matrixPatternIndex).azimuth, this.patternModel.getPoints()));
                        this.matrixDidEdit = true;
                    }
                    if (!this.matrixDidEdit) break;
                    sourceEditData.matrixPatternChanged = true;
                    sourceEditData.matrixPattern = this.matrixPattern;
                    sourceEditData.hasMatrixPattern = true;
                    this.didEdit = true;
                }
            }
        }
        this.patternModel.setPoints(null);
        this.matrixPattern = null;
        this.matrixPatternIndex = 0;
        AppManager.hideWindow(this);
    }

    public boolean cancel() {
        this.doCancel();
        return this.canceled;
    }

    private void doCancel() {
        if (this.searchDialog.isVisible() && !this.searchDialog.cancel()) {
            return;
        }
        this.canceled = true;
        if (this.windowShouldClose()) {
            AppManager.hideWindow(this);
        } else {
            this.canceled = false;
        }
    }

    @Override
    public void windowWillOpen() {
        SourceEditData sourceEditData = this.parent.getSource();
        this.searchDialog.setCDBSKey(sourceEditData.study.study.cdbsKey);
        this.canceled = false;
        this.rootEditor.blockActionsStart();
        ArrayList<Source.PatternPoint> arrayList = null;
        switch (this.patternType) {
            default: {
                this.patternNameField.setText(sourceEditData.horizontalPatternName);
                arrayList = sourceEditData.horizontalPattern;
                this.antenna_id = sourceEditData.antenna_id;
                break;
            }
            case 2: {
                this.patternNameField.setText(sourceEditData.verticalPatternName);
                arrayList = sourceEditData.verticalPattern;
                this.antenna_id = 0;
                break;
            }
            case 3: {
                this.patternNameField.setText(sourceEditData.matrixPatternName);
                this.matrixPattern = new ArrayList<Source.PatternSlice>(sourceEditData.matrixPattern);
                this.matrixPatternIndex = 0;
                Source.PatternSlice patternSlice = this.matrixPattern.get(0);
                this.matrixAzimuthLabel.setText(AppManager.formatAzimuth(patternSlice.azimuth));
                arrayList = patternSlice.pattern;
                this.antenna_id = 0;
            }
        }
        this.patternModel.setPoints(arrayList);
        this.canEdit = !sourceEditData.isLocked;
        AppManager.setComponentEnabled(this.patternNameField, this.canEdit);
        AppManager.setComponentEnabled(this.patternModel.table, this.canEdit);
        this.addPointButton.setEnabled(this.canEdit);
        this.insertPointButton.setEnabled(false);
        this.deletePointButton.setEnabled(false);
        this.setNoPatternButton.setEnabled(this.canEdit);
        this.importButton.setEnabled(this.canEdit);
        this.exportButton.setEnabled(this.patternModel.getRowCount() > 0);
        this.searchButton.setEnabled(this.canEdit);
        this.cancelButton.setVisible(this.canEdit);
        this.didEdit = false;
        this.setLocationRelativeTo(this.parent);
        this.rootEditor.blockActionsEnd();
    }

    @Override
    public boolean windowShouldClose() {
        Component component;
        if (this.searchDialog.isVisible()) {
            return false;
        }
        if (this.canceled || !this.canEdit) {
            return true;
        }
        this.errorReporter.clearErrors();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (keyboardFocusManager.getFocusedWindow() == this && null != (component = keyboardFocusManager.getFocusOwner()) && component instanceof JTextField) {
            ((JTextField)component).postActionEvent();
        }
        if (this.errorReporter.hasErrors()) {
            return false;
        }
        return this.patternModel.checkPattern();
    }

    private class PatternPlot
    extends Canvas {
        private PatternPlot() {
        }

        @Override
        public void paint(Graphics graphics) {
            int n = PatternEditor.this.patternModel.getRowCount();
            if (n < 2) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.GRAY);
            graphics2D.setStroke(new BasicStroke(1.0f));
            Path2D.Double double_ = new Path2D.Double();
            double d = this.getHeight();
            double d2 = 1.0;
            double d3 = 1.0;
            double d4 = 1.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            if (1 == PatternEditor.this.patternType) {
                double d9;
                int n2;
                int n3;
                int n4;
                int n5;
                double d10;
                double d11;
                double d12;
                double d13 = (double)this.getWidth() / 2.0;
                d2 = d13 * 0.95;
                d4 = d2 < (d3 = (d12 = d / 2.0) * 0.95) ? d2 : d3;
                double d14 = 0.02;
                for (d11 = 0.2; d11 < 1.01; d11 += 0.2) {
                    d10 = d11 * d4 * 2.0;
                    n5 = (int)(d13 - d10 / 2.0);
                    n4 = (int)(d - (d12 + d10 / 2.0));
                    n3 = (int)d10;
                    n2 = (int)d10;
                    graphics2D.drawOval(n5, n4, n3, n2);
                }
                for (d9 = 0.0; d9 < 359.99; d9 += 10.0) {
                    n5 = (int)(d13 + 0.2 * d4 * Math.sin(d9 * (Math.PI / 180)));
                    n4 = (int)(d - (d12 + 0.2 * d4 * Math.cos(d9 * (Math.PI / 180))));
                    n3 = (int)(d13 + d4 * Math.sin(d9 * (Math.PI / 180)));
                    n2 = (int)(d - (d12 + d4 * Math.cos(d9 * (Math.PI / 180))));
                    graphics2D.drawLine(n5, n4, n3, n2);
                }
                for (int i = 0; i < n; ++i) {
                    Source.PatternPoint patternPoint = PatternEditor.this.patternModel.get(i);
                    double d15 = patternPoint.azimuthOrDepression * (Math.PI / 180);
                    double d16 = patternPoint.relativeField;
                    int n6 = i + 1;
                    if (n6 == n) {
                        n6 = 0;
                    }
                    Source.PatternPoint patternPoint2 = PatternEditor.this.patternModel.get(n6);
                    double d17 = patternPoint2.azimuthOrDepression * (Math.PI / 180);
                    if (d17 < d15) {
                        d17 += Math.PI * 2;
                    }
                    double d18 = patternPoint2.relativeField;
                    for (d9 = d15; d9 < d17; d9 += d14) {
                        d11 = d16 + (d18 - d16) * ((d9 - d15) / (d17 - d15));
                        d10 = d13 + d11 * d4 * Math.sin(d9);
                        double d19 = d - (d12 + d11 * d4 * Math.cos(d9));
                        if (0 == i) {
                            double_.moveTo(d10, d19);
                            d7 = d10;
                            d8 = d19;
                            d5 = d10;
                            d6 = d19;
                            continue;
                        }
                        double d20 = d10 - d7;
                        double d21 = d19 - d8;
                        if (!(Math.sqrt(d20 * d20 + d21 * d21) > 2.0)) continue;
                        double_.lineTo(d10, d19);
                        d7 = d10;
                        d8 = d19;
                    }
                }
                double_.lineTo(d5, d6);
            } else {
                double d22;
                int n7;
                int n8;
                double d23;
                boolean bl = true;
                double d24 = (double)this.getWidth() / 100.0;
                d2 = d24 * 0.95;
                double d25 = (d24 - d2) / 2.0 * 100.0;
                d3 = d * 0.95;
                double d26 = (d - d3) / 2.0;
                double d27 = 0.25;
                int n9 = (int)d25;
                int n10 = (int)(d25 + 100.0 * d2);
                for (d23 = 0.0; d23 < 1.01; d23 += 0.1) {
                    n7 = n8 = (int)(d - (d26 + d23 * d3));
                    graphics2D.drawLine(n9, n8, n10, n7);
                }
                n8 = (int)(d - d26);
                n7 = (int)(d - (d26 + d3));
                for (d22 = 0.0; d22 < 100.01; d22 += 5.0) {
                    n10 = n9 = (int)(d25 + d22 * d2);
                    graphics2D.drawLine(n9, n8, n10, n7);
                }
                n10 = n9 = (int)(d25 + 10.0 * d2);
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.drawLine(n9, n8, n10, n7);
                for (int i = 0; i < n - 1; ++i) {
                    Source.PatternPoint patternPoint = PatternEditor.this.patternModel.get(i);
                    double d28 = patternPoint.azimuthOrDepression + 10.0;
                    double d29 = patternPoint.relativeField;
                    Source.PatternPoint patternPoint3 = PatternEditor.this.patternModel.get(i + 1);
                    double d30 = patternPoint3.azimuthOrDepression + 10.0;
                    double d31 = patternPoint3.relativeField;
                    for (d22 = d28; d22 < d30; d22 += d27) {
                        if (d22 < 0.0) continue;
                        d23 = d29 + (d31 - d29) * ((d22 - d28) / (d30 - d28));
                        d24 = d25 + d22 * d2;
                        double d32 = d - (d26 + d23 * d3);
                        if (bl) {
                            double_.moveTo(d24, d32);
                            d7 = d24;
                            d8 = d32;
                            bl = false;
                            continue;
                        }
                        double d33 = d24 - d7;
                        double d34 = d32 - d8;
                        if (!(Math.sqrt(d33 * d33 + d34 * d34) > 2.0)) continue;
                        double_.lineTo(d24, d32);
                        d7 = d24;
                        d8 = d32;
                    }
                }
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
            graphics2D.draw(double_);
        }
    }

    private class PatternTableModel
    extends AbstractTableModel {
        private ArrayList<Source.PatternPoint> modelRows = new ArrayList();
        private JTable table = new JTable(this);

        private PatternTableModel() {
            AppManager.configureTable(this.table);
            int n = AppManager.getTextFieldWidth(4);
            int n2 = AppManager.getTextFieldWidth(6);
            TableColumn tableColumn = this.table.getColumn(this.getColumnName(0));
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n2);
            tableColumn = this.table.getColumn(this.getColumnName(1));
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n2);
            this.table.setPreferredScrollableViewportSize(new Dimension(this.table.getPreferredSize().width, this.table.getRowHeight() * 30));
        }

        private void setPoints(ArrayList<Source.PatternPoint> arrayList) {
            this.modelRows.clear();
            if (null != arrayList) {
                for (Source.PatternPoint patternPoint : arrayList) {
                    this.modelRows.add(patternPoint.copy());
                }
            }
            this.fireTableDataChanged();
            PatternEditor.this.exportButton.setEnabled(!this.modelRows.isEmpty());
            PatternEditor.this.patternPlot.repaint();
        }

        private int addPoint(Source.PatternPoint patternPoint) {
            int n = 0;
            for (n = 0; n < this.modelRows.size(); ++n) {
                Source.PatternPoint patternPoint2 = this.modelRows.get(n);
                if (!(patternPoint.azimuthOrDepression <= patternPoint2.azimuthOrDepression)) continue;
                if (patternPoint.azimuthOrDepression != patternPoint2.azimuthOrDepression) break;
                return -1;
            }
            this.modelRows.add(n, patternPoint);
            this.fireTableRowsInserted(n, n);
            final int n2 = n;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PatternTableModel.this.table.setRowSelectionInterval(n2, n2);
                    PatternTableModel.this.table.scrollRectToVisible(PatternTableModel.this.table.getCellRect(n2, 0, true));
                }
            });
            PatternEditor.this.exportButton.setEnabled(true);
            return n;
        }

        private void remove(int n) {
            this.modelRows.remove(n);
            this.fireTableRowsDeleted(n, n);
            PatternEditor.this.exportButton.setEnabled(!this.modelRows.isEmpty());
        }

        private int getSelectedRow() {
            return this.table.getSelectedRow();
        }

        private Source.PatternPoint get(int n) {
            return this.modelRows.get(n);
        }

        private ArrayList<Source.PatternPoint> getPoints() {
            if (this.modelRows.isEmpty()) {
                return null;
            }
            return new ArrayList<Source.PatternPoint>(this.modelRows);
        }

        private boolean checkPattern() {
            if (this.modelRows.isEmpty()) {
                return true;
            }
            if (this.modelRows.size() < 2) {
                PatternEditor.this.errorReporter.reportValidationError(PatternEditor.WINDOW_TITLE, "Pattern must have 2 or more points.");
                return false;
            }
            double d = 0.0;
            for (Source.PatternPoint patternPoint : this.modelRows) {
                if (!(patternPoint.relativeField > d)) continue;
                d = patternPoint.relativeField;
            }
            if (d < 1.0) {
                PatternEditor.this.errorReporter.reportValidationError(PatternEditor.WINDOW_TITLE, "Pattern must have a 1.");
                return false;
            }
            return true;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            if (0 == n) {
                switch (PatternEditor.this.patternType) {
                    default: {
                        return "Azimuth";
                    }
                    case 2: 
                    case 3: 
                }
                return "Depression";
            }
            return "Field";
        }

        @Override
        public int getRowCount() {
            return this.modelRows.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return PatternEditor.this.canEdit;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Source.PatternPoint patternPoint = this.modelRows.get(n);
            switch (n2) {
                case 0: {
                    switch (PatternEditor.this.patternType) {
                        default: {
                            return AppManager.formatAzimuth(patternPoint.azimuthOrDepression);
                        }
                        case 2: 
                        case 3: 
                    }
                    return AppManager.formatDepression(patternPoint.azimuthOrDepression);
                }
                case 1: {
                    return AppManager.formatRelativeField(patternPoint.relativeField);
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (!PatternEditor.this.canEdit) {
                return;
            }
            String string = "Edit Pattern Point";
            double d = 0.0;
            try {
                d = Double.parseDouble(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                PatternEditor.this.errorReporter.reportValidationError(string, "The value must be a number.");
                return;
            }
            Source.PatternPoint patternPoint = this.modelRows.get(n);
            switch (n2) {
                case 0: {
                    String string2 = "";
                    switch (PatternEditor.this.patternType) {
                        default: {
                            d = Math.rint(d * 1000.0) / 1000.0;
                            if (d == patternPoint.azimuthOrDepression) {
                                return;
                            }
                            if (d < 0.0 || d > 359.999) {
                                PatternEditor.this.errorReporter.reportValidationError(string, "Azimuth must be from 0.0 to 359.999.");
                                return;
                            }
                            string2 = "azimuth";
                            break;
                        }
                        case 2: 
                        case 3: {
                            d = Math.rint(d * 1000.0) / 1000.0;
                            if (d == patternPoint.azimuthOrDepression) {
                                return;
                            }
                            if (d < -90.0 || d > 90.0) {
                                PatternEditor.this.errorReporter.reportValidationError(string, "Depression angle must be from -90.0 to 90.0.");
                                return;
                            }
                            string2 = "depression angle";
                        }
                    }
                    int n3 = 0;
                    for (n3 = 0; n3 < this.modelRows.size(); ++n3) {
                        if (n3 == n) continue;
                        Source.PatternPoint patternPoint2 = this.modelRows.get(n3);
                        if (!(d <= patternPoint2.azimuthOrDepression)) continue;
                        if (d != patternPoint2.azimuthOrDepression) break;
                        PatternEditor.this.errorReporter.reportValidationError(string, "A point at that " + string2 + " already exists.");
                        return;
                    }
                    if (n3 > n) {
                        --n3;
                    }
                    patternPoint.azimuthOrDepression = d;
                    PatternEditor.this.didEdit = true;
                    PatternEditor.this.antenna_id = 0;
                    if (n3 == n) {
                        this.fireTableRowsUpdated(n, n);
                    } else {
                        this.modelRows.remove(n);
                        this.fireTableRowsDeleted(n, n);
                        this.modelRows.add(n3, patternPoint);
                        this.fireTableRowsInserted(n3, n3);
                        final int n4 = n3;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PatternTableModel.this.table.setRowSelectionInterval(n4, n4);
                                PatternTableModel.this.table.scrollRectToVisible(PatternTableModel.this.table.getCellRect(n4, 0, true));
                            }
                        });
                    }
                    return;
                }
                case 1: {
                    d = Math.rint(d * 1000.0) / 1000.0;
                    if (d == patternPoint.relativeField) {
                        return;
                    }
                    if (d < 0.001 || d > 1.0) {
                        PatternEditor.this.errorReporter.reportValidationError(string, "Relative field must be from 0.001 to 1.0.");
                        return;
                    }
                    patternPoint.relativeField = d;
                    PatternEditor.this.didEdit = true;
                    PatternEditor.this.antenna_id = 0;
                    this.fireTableRowsUpdated(n, n);
                    return;
                }
            }
        }
    }
}

