/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.editdata.ParameterEditData;
import gov.fcc.tvstudy.editor.RootEditor;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.KeyedRecordMenu;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ParameterEditor {
    private RootEditor rootEditor;
    private ErrorReporter errorReporter;
    private ParameterEditData parameter;
    public final JLabel label;
    public final JComponent editComponent;
    public final JButton setDefaultButton;
    private NumberFormat doubleFormatter;
    private boolean canEdit;
    private ArrayList<ParameterEditor> enablesEditors;

    public ParameterEditor(RootEditor rootEditor, ErrorReporter errorReporter, ParameterEditData parameterEditData, boolean bl) {
        JComponent jComponent;
        this.rootEditor = rootEditor;
        this.errorReporter = errorReporter;
        this.rootEditor.blockActionsStart();
        this.parameter = parameterEditData;
        this.doubleFormatter = NumberFormat.getInstance();
        this.doubleFormatter.setMinimumFractionDigits(0);
        this.doubleFormatter.setMaximumFractionDigits(6);
        this.doubleFormatter.setMinimumIntegerDigits(1);
        this.doubleFormatter.setGroupingUsed(false);
        this.canEdit = !this.parameter.isLocked && (!this.parameter.parameter.studyFixed || bl);
        switch (this.parameter.parameter.type) {
            default: {
                JTextField jTextField = new JTextField(10);
                jComponent = jTextField;
                AppManager.fixKeyBindings(jTextField);
                jTextField.setText(this.parameter.value);
                jTextField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JTextField jTextField = (JTextField)ParameterEditor.this.editComponent;
                        if (ParameterEditor.this.rootEditor.blockActions()) {
                            if (ParameterEditor.this.canEdit) {
                                ((ParameterEditor)ParameterEditor.this).parameter.value = jTextField.getText().trim();
                                ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value.equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue));
                            }
                            ParameterEditor.this.rootEditor.blockActionsEnd();
                        }
                        jTextField.setText(((ParameterEditor)ParameterEditor.this).parameter.value);
                    }
                });
                jTextField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            ((JTextField)ParameterEditor.this.editComponent).postActionEvent();
                        }
                    }
                });
                break;
            }
            case 2: {
                JTextField jTextField = new JTextField(10);
                jComponent = jTextField;
                AppManager.fixKeyBindings(jTextField);
                jTextField.setText(this.parameter.value);
                jTextField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JTextField jTextField = (JTextField)ParameterEditor.this.editComponent;
                        if (ParameterEditor.this.rootEditor.blockActions()) {
                            String string = "Edit Parameter";
                            if (ParameterEditor.this.canEdit) {
                                String string2 = jTextField.getText().trim();
                                if (string2.length() > 0) {
                                    try {
                                        int n = Integer.parseInt(string2);
                                        if (n < ((ParameterEditor)ParameterEditor.this).parameter.parameter.minIntegerValue || n > ((ParameterEditor)ParameterEditor.this).parameter.parameter.maxIntegerValue) {
                                            ParameterEditor.this.errorReporter.reportValidationError(string, "The value must be in the range " + ((ParameterEditor)ParameterEditor.this).parameter.parameter.minIntegerValue + " to " + ((ParameterEditor)ParameterEditor.this).parameter.parameter.maxIntegerValue + ".");
                                        } else {
                                            ((ParameterEditor)ParameterEditor.this).parameter.integerValue = n;
                                            ((ParameterEditor)ParameterEditor.this).parameter.value = String.valueOf(n);
                                        }
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        ParameterEditor.this.errorReporter.reportValidationError(string, "The value must be a number.");
                                    }
                                }
                                ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value.equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue));
                            }
                            ParameterEditor.this.rootEditor.blockActionsEnd();
                        }
                        jTextField.setText(((ParameterEditor)ParameterEditor.this).parameter.value);
                    }
                });
                jTextField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            ((JTextField)ParameterEditor.this.editComponent).postActionEvent();
                        }
                    }
                });
                break;
            }
            case 3: {
                JTextField jTextField = new JTextField(10);
                jComponent = jTextField;
                AppManager.fixKeyBindings(jTextField);
                jTextField.setText(this.parameter.value);
                jTextField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JTextField jTextField = (JTextField)ParameterEditor.this.editComponent;
                        if (ParameterEditor.this.rootEditor.blockActions()) {
                            String string = "Edit Parameter";
                            if (ParameterEditor.this.canEdit) {
                                String string2 = jTextField.getText().trim();
                                if (string2.length() > 0) {
                                    try {
                                        double d = Double.parseDouble(string2);
                                        if (d < ((ParameterEditor)ParameterEditor.this).parameter.parameter.minDecimalValue || d > ((ParameterEditor)ParameterEditor.this).parameter.parameter.maxDecimalValue) {
                                            ParameterEditor.this.errorReporter.reportValidationError(string, "The value must be in the range " + ((ParameterEditor)ParameterEditor.this).parameter.parameter.minDecimalValue + " to " + ((ParameterEditor)ParameterEditor.this).parameter.parameter.maxDecimalValue + ".");
                                        } else {
                                            ((ParameterEditor)ParameterEditor.this).parameter.decimalValue = d;
                                            ((ParameterEditor)ParameterEditor.this).parameter.value = ParameterEditor.this.doubleFormatter.format(d);
                                        }
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        ParameterEditor.this.errorReporter.reportValidationError(string, "The value must be a number.");
                                    }
                                }
                                ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value.equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue));
                            }
                            ParameterEditor.this.rootEditor.blockActionsEnd();
                        }
                        jTextField.setText(((ParameterEditor)ParameterEditor.this).parameter.value);
                    }
                });
                jTextField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (!focusEvent.isTemporary()) {
                            ((JTextField)ParameterEditor.this.editComponent).postActionEvent();
                        }
                    }
                });
                break;
            }
            case 4: {
                JCheckBox jCheckBox = new JCheckBox();
                jComponent = jCheckBox;
                jCheckBox.setSelected(this.parameter.optionValue);
                jCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ParameterEditor.this.rootEditor.blockActions()) {
                            if (ParameterEditor.this.canEdit) {
                                ((ParameterEditor)ParameterEditor.this).parameter.optionValue = ((JCheckBox)ParameterEditor.this.editComponent).isSelected();
                                ((ParameterEditor)ParameterEditor.this).parameter.value = ((ParameterEditor)ParameterEditor.this).parameter.optionValue ? "1" : "0";
                                ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value.equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue));
                                if (null != ParameterEditor.this.enablesEditors) {
                                    for (ParameterEditor parameterEditor : ParameterEditor.this.enablesEditors) {
                                        parameterEditor.setEnabled(((ParameterEditor)ParameterEditor.this).parameter.optionValue);
                                    }
                                }
                            } else {
                                ((JCheckBox)ParameterEditor.this.editComponent).setSelected(((ParameterEditor)ParameterEditor.this).parameter.optionValue);
                            }
                            ParameterEditor.this.rootEditor.blockActionsEnd();
                        } else {
                            ((JCheckBox)ParameterEditor.this.editComponent).setSelected(((ParameterEditor)ParameterEditor.this).parameter.optionValue);
                        }
                    }
                });
                break;
            }
            case 5: {
                KeyedRecordMenu keyedRecordMenu = new KeyedRecordMenu(this.parameter.parameter.pickfromItems);
                jComponent = keyedRecordMenu;
                keyedRecordMenu.setSelectedIndex(this.parameter.pickfromIndex);
                keyedRecordMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ParameterEditor.this.rootEditor.blockActions()) {
                            if (ParameterEditor.this.canEdit) {
                                ((ParameterEditor)ParameterEditor.this).parameter.pickfromIndex = ((KeyedRecordMenu)ParameterEditor.this.editComponent).getSelectedIndex();
                                ((ParameterEditor)ParameterEditor.this).parameter.integerValue = ((KeyedRecordMenu)ParameterEditor.this.editComponent).getSelectedKey();
                                ((ParameterEditor)ParameterEditor.this).parameter.value = String.valueOf(((ParameterEditor)ParameterEditor.this).parameter.integerValue);
                                ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value.equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue));
                            } else {
                                ((KeyedRecordMenu)ParameterEditor.this.editComponent).setSelectedIndex(((ParameterEditor)ParameterEditor.this).parameter.pickfromIndex);
                            }
                            ParameterEditor.this.rootEditor.blockActionsEnd();
                        } else {
                            ((KeyedRecordMenu)ParameterEditor.this.editComponent).setSelectedIndex(((ParameterEditor)ParameterEditor.this).parameter.pickfromIndex);
                        }
                    }
                });
                break;
            }
        }
        jComponent.setToolTipText(this.parameter.parameter.description);
        this.label = new JLabel(this.parameter.parameter.name);
        if (null == this.parameter.parameter.value) {
            this.label.setForeground(Color.RED.darker());
        }
        this.editComponent = jComponent;
        this.setDefaultButton = new JButton("Revert");
        this.setDefaultButton.setFocusable(false);
        this.setDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParameterEditor.this.setDefaultValue();
            }
        });
        this.setEnabled(true);
        this.rootEditor.blockActionsEnd();
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.label.setEnabled(true);
            this.editComponent.setEnabled(true);
            if (this.canEdit) {
                AppManager.setComponentEnabled(this.editComponent, true);
                this.setDefaultButton.setEnabled(!this.parameter.value.equals(this.parameter.parameter.defaultValue));
            } else {
                AppManager.setComponentEnabled(this.editComponent, false);
                this.setDefaultButton.setEnabled(false);
            }
        } else {
            this.label.setEnabled(false);
            this.editComponent.setEnabled(false);
            this.setDefaultButton.setEnabled(false);
        }
    }

    public void setDefaultValue() {
        if (!this.canEdit) {
            return;
        }
        this.rootEditor.blockActionsStart();
        this.parameter.setDefaultValue();
        switch (this.parameter.parameter.type) {
            default: {
                ((JTextField)this.editComponent).setText(this.parameter.value);
                break;
            }
            case 4: {
                ((JCheckBox)this.editComponent).setSelected(this.parameter.optionValue);
                if (null == this.enablesEditors) break;
                for (ParameterEditor parameterEditor : this.enablesEditors) {
                    parameterEditor.setEnabled(this.parameter.optionValue);
                }
                break;
            }
            case 5: {
                ((KeyedRecordMenu)this.editComponent).setSelectedIndex(this.parameter.pickfromIndex);
            }
        }
        this.setDefaultButton.setEnabled(false);
        this.rootEditor.blockActionsEnd();
    }

    public static JComponent createEditorLayout(RootEditor rootEditor, ArrayList<ParameterEditData> arrayList, boolean bl, ArrayList<ParameterEditor> arrayList2) {
        ParameterEditorGroup parameterEditorGroup;
        int n;
        if (arrayList.isEmpty()) {
            return new JPanel();
        }
        ErrorReporter errorReporter = new ErrorReporter(rootEditor, rootEditor, "Edit Study Parameter");
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<ParameterEditorGroup> arrayList4 = new ArrayList<ParameterEditorGroup>();
        for (ParameterEditData parameterEditData : arrayList) {
            n = arrayList3.indexOf(parameterEditData.parameter.groupName);
            if (n < 0) {
                parameterEditorGroup = new ParameterEditorGroup();
                arrayList3.add(parameterEditData.parameter.groupName);
                arrayList4.add(parameterEditorGroup);
            } else {
                parameterEditorGroup = (ParameterEditorGroup)arrayList4.get(n);
            }
            ParameterEditor parameterEditor = new ParameterEditor(rootEditor, errorReporter, parameterEditData, bl);
            parameterEditorGroup.addEditor(parameterEditor);
            if (null == arrayList2) continue;
            arrayList2.add(parameterEditor);
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        for (n = 0; n < arrayList3.size(); ++n) {
            parameterEditorGroup = (ParameterEditorGroup)arrayList4.get(n);
            jTabbedPane.addTab((String)arrayList3.get(n), AppManager.createScrollPane(parameterEditorGroup.panel));
            if (!parameterEditorGroup.hasNewParameters) continue;
            jTabbedPane.setForegroundAt(n, Color.RED.darker());
        }
        return jTabbedPane;
    }

    private static class ParameterEditorGroup {
        private ParameterEditor enablingEditor;
        private JPanel panel;
        private GroupLayout layout;
        private GroupLayout.ParallelGroup labelGroup;
        private GroupLayout.ParallelGroup componentGroup;
        private GroupLayout.ParallelGroup buttonGroup;
        private GroupLayout.SequentialGroup verticalGroup;
        private boolean hasNewParameters;

        private ParameterEditorGroup() {
            JPanel jPanel = new JPanel();
            this.layout = new GroupLayout(jPanel);
            jPanel.setLayout(this.layout);
            this.layout.setAutoCreateGaps(true);
            this.layout.setAutoCreateContainerGaps(true);
            this.labelGroup = this.layout.createParallelGroup(GroupLayout.Alignment.TRAILING);
            this.componentGroup = this.layout.createParallelGroup();
            this.buttonGroup = this.layout.createParallelGroup();
            this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addGroup(this.labelGroup).addGroup(this.componentGroup).addGroup(this.buttonGroup));
            this.verticalGroup = this.layout.createSequentialGroup();
            this.layout.setVerticalGroup(this.verticalGroup);
            this.panel = new JPanel();
            this.panel.add(jPanel);
        }

        private void addEditor(ParameterEditor parameterEditor) {
            if (4 == ((ParameterEditor)parameterEditor).parameter.parameter.type && ((ParameterEditor)parameterEditor).parameter.parameter.enablesGroup) {
                this.enablingEditor = parameterEditor;
                parameterEditor.enablesEditors = new ArrayList();
            } else if (null != this.enablingEditor) {
                this.enablingEditor.enablesEditors.add(parameterEditor);
                parameterEditor.setEnabled(((ParameterEditor)this.enablingEditor).parameter.optionValue);
            }
            this.labelGroup.addComponent(parameterEditor.label);
            this.componentGroup.addComponent(parameterEditor.editComponent);
            this.buttonGroup.addComponent(parameterEditor.setDefaultButton);
            this.verticalGroup.addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(parameterEditor.label).addComponent(parameterEditor.editComponent).addComponent(parameterEditor.setDefaultButton));
            if (null == ((ParameterEditor)parameterEditor).parameter.parameter.value) {
                this.hasNewParameters = true;
            }
        }
    }
}

