/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.ChannelBand;
import gov.fcc.tvstudy.data.ChannelDelta;
import gov.fcc.tvstudy.data.Country;
import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.data.ServiceType;
import gov.fcc.tvstudy.editdata.IxRuleEditData;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.KeyedRecordMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IxRuleEnableDisable
extends AppDialog {
    public static final String WINDOW_TITLE = "Enable/Disable Interference Rules";
    private AppFrame parent;
    private StudyEditData study;
    private JComboBox enableDisableMenu;
    private KeyedRecordMenu countryMenu;
    private KeyedRecordMenu serviceTypeMenu;
    private KeyedRecordMenu undesiredServiceTypeMenu;
    private KeyedRecordMenu channelDeltaMenu;
    private KeyedRecordMenu channelBandMenu;
    private JButton okButton;
    private JButton cancelButton;
    public boolean canceled;

    public IxRuleEnableDisable(AppFrame appFrame, StudyEditData studyEditData) {
        super((Window)appFrame, WINDOW_TITLE, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDisposeOnClose(false);
        this.parent = appFrame;
        this.study = studyEditData;
        this.enableDisableMenu = new JComboBox();
        this.enableDisableMenu.addItem("Disable");
        this.enableDisableMenu.addItem("Enable");
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Action"));
        jPanel.add(this.enableDisableMenu);
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        arrayList.add(new KeyedRecord(-1, ""));
        arrayList.addAll(Country.getCountries(dbConnection));
        this.countryMenu = new KeyedRecordMenu(arrayList);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Country"));
        jPanel2.add(this.countryMenu);
        arrayList.clear();
        arrayList.add(new KeyedRecord(-1, ""));
        arrayList.addAll(ServiceType.getServiceTypes(dbConnection));
        this.serviceTypeMenu = new KeyedRecordMenu(arrayList);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Service"));
        jPanel3.add(this.serviceTypeMenu);
        this.undesiredServiceTypeMenu = new KeyedRecordMenu(arrayList);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder("Service"));
        jPanel4.add(this.undesiredServiceTypeMenu);
        arrayList.clear();
        arrayList.add(new KeyedRecord(-1, ""));
        arrayList.addAll(ChannelDelta.getChannelDeltas(dbConnection));
        this.channelDeltaMenu = new KeyedRecordMenu(arrayList);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder("Channel"));
        jPanel5.add(this.channelDeltaMenu);
        arrayList.clear();
        arrayList.add(new KeyedRecord(-1, ""));
        arrayList.addAll(ChannelBand.getChannelBandsWithNull(dbConnection));
        this.channelBandMenu = new KeyedRecordMenu(arrayList);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder("Band"));
        jPanel6.add(this.channelBandMenu);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IxRuleEnableDisable.this.doOK();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IxRuleEnableDisable.this.doCancel();
            }
        });
        JPanel jPanel7 = new JPanel();
        jPanel7.add(jPanel2);
        jPanel7.add(jPanel3);
        jPanel7.add(jPanel6);
        jPanel7.setBorder(BorderFactory.createTitledBorder("Desired Station"));
        JPanel jPanel8 = new JPanel();
        jPanel8.add(jPanel4);
        jPanel8.add(jPanel5);
        jPanel8.setBorder(BorderFactory.createTitledBorder("Undesired Station"));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 1));
        jPanel9.add(jPanel);
        jPanel9.add(jPanel7);
        jPanel9.add(jPanel8);
        JPanel jPanel10 = new JPanel(new FlowLayout(2));
        jPanel10.add(this.cancelButton);
        jPanel10.add(this.okButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel9, "Center");
        container.add((Component)jPanel10, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setResizable(true);
        this.setLocationSaved(true);
    }

    @Override
    public String getDbID() {
        return this.study.dbID;
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(this.parent.getDocumentName());
    }

    private void doOK() {
        boolean bl = false;
        if (this.enableDisableMenu.getSelectedIndex() > 0) {
            bl = true;
        }
        int n = this.countryMenu.getSelectedKey();
        int n2 = this.serviceTypeMenu.getSelectedKey();
        int n3 = this.undesiredServiceTypeMenu.getSelectedKey();
        int n4 = this.channelDeltaMenu.getSelectedKey();
        int n5 = this.channelBandMenu.getSelectedKey();
        int n6 = this.study.ixRuleModel.getRowCount();
        for (int i = 0; i < n6; ++i) {
            IxRuleEditData ixRuleEditData = this.study.ixRuleModel.get(i);
            if (n >= 0 && ixRuleEditData.country.key != n || n2 >= 0 && ixRuleEditData.serviceType.key != n2 || n3 >= 0 && ixRuleEditData.undesiredServiceType.key != n3 || n4 >= 0 && ixRuleEditData.channelDelta.key != n4 || n5 >= 0 && ixRuleEditData.channelBand.key != n5) continue;
            this.study.ixRuleModel.setActive(i, bl);
        }
        this.canceled = false;
        AppManager.hideWindow(this);
    }

    public boolean cancel() {
        this.doCancel();
        return this.canceled;
    }

    private void doCancel() {
        this.canceled = true;
        AppManager.hideWindow(this);
    }

    @Override
    public void windowWillOpen() {
        this.enableDisableMenu.setSelectedIndex(0);
        this.countryMenu.setSelectedIndex(0);
        this.serviceTypeMenu.setSelectedIndex(0);
        this.undesiredServiceTypeMenu.setSelectedIndex(0);
        this.channelDeltaMenu.setSelectedIndex(0);
        this.channelBandMenu.setSelectedIndex(0);
        this.setLocationRelativeTo(this.parent);
        this.canceled = false;
    }

    @Override
    public boolean windowShouldClose() {
        this.canceled = true;
        return true;
    }
}

