/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.ChannelBand;
import gov.fcc.tvstudy.data.ChannelDelta;
import gov.fcc.tvstudy.data.Country;
import gov.fcc.tvstudy.data.EmissionMask;
import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.data.ServiceType;
import gov.fcc.tvstudy.editdata.IxRuleEditData;
import gov.fcc.tvstudy.editor.RootEditor;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.KeyedRecordMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IxRuleEditor
extends AppDialog {
    public static final String WINDOW_TITLE = "Interference Rule";
    private RootEditor rootEditor;
    private AppFrame parent;
    private ErrorReporter errorReporter;
    private IxRuleEditData ixRule;
    private boolean canEdit;
    private KeyedRecordMenu countryMenu;
    private KeyedRecordMenu serviceTypeMenu;
    private KeyedRecordMenu undesiredServiceTypeMenu;
    private KeyedRecordMenu channelDeltaMenu;
    private KeyedRecordMenu channelBandMenu;
    private KeyedRecordMenu frequencyOffsetMenu;
    private KeyedRecordMenu emissionMaskMenu;
    private JTextField distanceField;
    private JTextField requiredDUField;
    private JTextField undesiredTimeField;
    private JButton okButton;
    private JButton cancelButton;
    public boolean canceled;

    public IxRuleEditor(RootEditor rootEditor, AppFrame appFrame) {
        super((Window)appFrame, WINDOW_TITLE, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDisposeOnClose(false);
        this.rootEditor = rootEditor;
        this.parent = appFrame;
        this.errorReporter = new ErrorReporter(this.rootEditor, this, "Edit Interference Rule");
        this.rootEditor.blockActionsStart();
        DbConnection dbConnection = DbManager.getDb(this.rootEditor.getDbID());
        this.countryMenu = new KeyedRecordMenu(Country.getCountries(dbConnection));
        this.countryMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.rootEditor.blockActions()) {
                    ((IxRuleEditor)IxRuleEditor.this).ixRule.country = (Country)IxRuleEditor.this.countryMenu.getSelectedItem();
                    IxRuleEditor.this.rootEditor.blockActionsEnd();
                } else {
                    IxRuleEditor.this.countryMenu.setSelectedItem(((IxRuleEditor)IxRuleEditor.this).ixRule.country);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Country"));
        jPanel.add(this.countryMenu);
        this.serviceTypeMenu = new KeyedRecordMenu(ServiceType.getServiceTypes(dbConnection));
        this.serviceTypeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.rootEditor.blockActions()) {
                    ServiceType serviceType = (ServiceType)IxRuleEditor.this.serviceTypeMenu.getSelectedItem();
                    if (serviceType.digital && ((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta.key > 0 && ((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta.analogOnly) {
                        IxRuleEditor.this.errorReporter.reportValidationError("Edit Service Type", "That service type cannot be used with the selected channel.");
                        IxRuleEditor.this.serviceTypeMenu.setSelectedItem(((IxRuleEditor)IxRuleEditor.this).ixRule.serviceType);
                    } else {
                        ((IxRuleEditor)IxRuleEditor.this).ixRule.serviceType = serviceType;
                    }
                    IxRuleEditor.this.rootEditor.blockActionsEnd();
                } else {
                    IxRuleEditor.this.serviceTypeMenu.setSelectedItem(((IxRuleEditor)IxRuleEditor.this).ixRule.serviceType);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Service"));
        jPanel2.add(this.serviceTypeMenu);
        this.undesiredServiceTypeMenu = new KeyedRecordMenu(ServiceType.getServiceTypes(dbConnection));
        this.undesiredServiceTypeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.rootEditor.blockActions()) {
                    ((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredServiceType = (ServiceType)IxRuleEditor.this.undesiredServiceTypeMenu.getSelectedItem();
                    if (((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredServiceType.needsEmissionMask && 1 == Math.abs(((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta.delta)) {
                        AppManager.setComponentEnabled(IxRuleEditor.this.emissionMaskMenu, true);
                        if (0 == ((IxRuleEditor)IxRuleEditor.this).ixRule.emissionMask.key) {
                            IxRuleEditor.this.emissionMaskMenu.setSelectedItem(EmissionMask.getInvalidObject());
                        }
                    } else {
                        AppManager.setComponentEnabled(IxRuleEditor.this.emissionMaskMenu, false);
                        if (((IxRuleEditor)IxRuleEditor.this).ixRule.emissionMask.key != 0) {
                            IxRuleEditor.this.emissionMaskMenu.setSelectedItem(EmissionMask.getNullObject());
                        }
                    }
                    IxRuleEditor.this.rootEditor.blockActionsEnd();
                } else {
                    IxRuleEditor.this.undesiredServiceTypeMenu.setSelectedItem(((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredServiceType);
                }
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Service"));
        jPanel3.add(this.undesiredServiceTypeMenu);
        this.channelDeltaMenu = new KeyedRecordMenu(ChannelDelta.getChannelDeltas(dbConnection));
        this.channelDeltaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.rootEditor.blockActions()) {
                    ChannelDelta channelDelta = (ChannelDelta)IxRuleEditor.this.channelDeltaMenu.getSelectedItem();
                    if (channelDelta.analogOnly && ((IxRuleEditor)IxRuleEditor.this).ixRule.serviceType.key > 0 && ((IxRuleEditor)IxRuleEditor.this).ixRule.serviceType.digital) {
                        IxRuleEditor.this.errorReporter.reportValidationError("Edit Channel", "That channel cannot be used with the selected desired service type.");
                        IxRuleEditor.this.channelDeltaMenu.setSelectedItem(((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta);
                    } else {
                        ((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta = channelDelta;
                        if (!AppManager.isComponentEnabled(IxRuleEditor.this.distanceField) || ((IxRuleEditor)IxRuleEditor.this).ixRule.distance > channelDelta.maximumDistance) {
                            ((IxRuleEditor)IxRuleEditor.this).ixRule.distance = channelDelta.maximumDistance;
                            IxRuleEditor.this.distanceField.setText(AppManager.formatDistance(((IxRuleEditor)IxRuleEditor.this).ixRule.distance));
                        }
                        AppManager.setComponentEnabled(IxRuleEditor.this.distanceField, true);
                        if (((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredServiceType.needsEmissionMask && 1 == Math.abs(channelDelta.delta)) {
                            AppManager.setComponentEnabled(IxRuleEditor.this.emissionMaskMenu, true);
                            if (0 == ((IxRuleEditor)IxRuleEditor.this).ixRule.emissionMask.key) {
                                IxRuleEditor.this.emissionMaskMenu.setSelectedItem(EmissionMask.getInvalidObject());
                            }
                        } else {
                            AppManager.setComponentEnabled(IxRuleEditor.this.emissionMaskMenu, false);
                            if (((IxRuleEditor)IxRuleEditor.this).ixRule.emissionMask.key != 0) {
                                IxRuleEditor.this.emissionMaskMenu.setSelectedItem(EmissionMask.getNullObject());
                            }
                        }
                    }
                    IxRuleEditor.this.rootEditor.blockActionsEnd();
                } else {
                    IxRuleEditor.this.channelDeltaMenu.setSelectedItem(((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta);
                }
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder("Channel"));
        jPanel4.add(this.channelDeltaMenu);
        this.channelBandMenu = new KeyedRecordMenu(ChannelBand.getChannelBandsWithNull(dbConnection));
        this.channelBandMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.rootEditor.blockActions()) {
                    ((IxRuleEditor)IxRuleEditor.this).ixRule.channelBand = (ChannelBand)IxRuleEditor.this.channelBandMenu.getSelectedItem();
                    IxRuleEditor.this.rootEditor.blockActionsEnd();
                } else {
                    IxRuleEditor.this.channelBandMenu.setSelectedItem(((IxRuleEditor)IxRuleEditor.this).ixRule.channelBand);
                }
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder("Band"));
        jPanel5.add(this.channelBandMenu);
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        arrayList.add(new KeyedRecord(0, "(any)"));
        arrayList.add(new KeyedRecord(2, "With"));
        arrayList.add(new KeyedRecord(1, "Without"));
        this.frequencyOffsetMenu = new KeyedRecordMenu(arrayList);
        this.frequencyOffsetMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.rootEditor.blockActions()) {
                    ((IxRuleEditor)IxRuleEditor.this).ixRule.frequencyOffset = IxRuleEditor.this.frequencyOffsetMenu.getSelectedKey();
                    IxRuleEditor.this.rootEditor.blockActionsEnd();
                } else {
                    IxRuleEditor.this.frequencyOffsetMenu.setSelectedKey(((IxRuleEditor)IxRuleEditor.this).ixRule.frequencyOffset);
                }
            }
        });
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder("Frequency Offset"));
        jPanel6.add(this.frequencyOffsetMenu);
        this.emissionMaskMenu = new KeyedRecordMenu(EmissionMask.getEmissionMasksWithNull(dbConnection));
        this.emissionMaskMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.rootEditor.blockActions()) {
                    ((IxRuleEditor)IxRuleEditor.this).ixRule.emissionMask = (EmissionMask)IxRuleEditor.this.emissionMaskMenu.getSelectedItem();
                    IxRuleEditor.this.rootEditor.blockActionsEnd();
                } else {
                    IxRuleEditor.this.emissionMaskMenu.setSelectedItem(((IxRuleEditor)IxRuleEditor.this).ixRule.emissionMask);
                }
            }
        });
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(BorderFactory.createTitledBorder("Emission Mask"));
        jPanel7.add(this.emissionMaskMenu);
        AppManager.setComponentEnabled(this.emissionMaskMenu, false);
        this.distanceField = new JTextField(10);
        AppManager.fixKeyBindings(this.distanceField);
        this.distanceField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Distance Limit";
                    if (((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta.key < 0) {
                        IxRuleEditor.this.errorReporter.reportValidationError(string, "A channel must be selected before entering the distance.");
                    } else {
                        String string2 = IxRuleEditor.this.distanceField.getText().trim();
                        if (string2.length() > 0) {
                            try {
                                double d = Double.parseDouble(string2);
                                if (d < 1.0 || d > ((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta.maximumDistance) {
                                    IxRuleEditor.this.errorReporter.reportValidationError(string, "The value must be in the range 1.0 to " + ((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta.maximumDistance + ".");
                                } else {
                                    ((IxRuleEditor)IxRuleEditor.this).ixRule.distance = d;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                IxRuleEditor.this.errorReporter.reportValidationError(string, "The value must be a number.");
                            }
                        }
                    }
                    IxRuleEditor.this.rootEditor.blockActionsEnd();
                }
                IxRuleEditor.this.distanceField.setText(AppManager.formatDistance(((IxRuleEditor)IxRuleEditor.this).ixRule.distance));
            }
        });
        this.distanceField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    IxRuleEditor.this.distanceField.postActionEvent();
                }
            }
        });
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(BorderFactory.createTitledBorder("Distance Limit"));
        jPanel8.add(this.distanceField);
        this.requiredDUField = new JTextField(10);
        AppManager.fixKeyBindings(this.requiredDUField);
        this.requiredDUField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Required D/U";
                    String string2 = IxRuleEditor.this.requiredDUField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            double d = Double.parseDouble(string2);
                            if (d < -60.0 || d > 60.0) {
                                IxRuleEditor.this.errorReporter.reportValidationError(string, "The value must be in the range -60.0  to 60.0.");
                            } else {
                                ((IxRuleEditor)IxRuleEditor.this).ixRule.requiredDU = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            IxRuleEditor.this.errorReporter.reportValidationError(string, "The value must be a number.");
                        }
                    }
                    IxRuleEditor.this.rootEditor.blockActionsEnd();
                }
                IxRuleEditor.this.requiredDUField.setText(AppManager.formatDU(((IxRuleEditor)IxRuleEditor.this).ixRule.requiredDU));
            }
        });
        this.requiredDUField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    IxRuleEditor.this.requiredDUField.postActionEvent();
                }
            }
        });
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(BorderFactory.createTitledBorder("Required D/U"));
        jPanel9.add(this.requiredDUField);
        this.undesiredTimeField = new JTextField(10);
        AppManager.fixKeyBindings(this.undesiredTimeField);
        this.undesiredTimeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Undesired % Time";
                    String string2 = IxRuleEditor.this.undesiredTimeField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            int n = Integer.parseInt(string2);
                            if (n < 1 || n > 99) {
                                IxRuleEditor.this.errorReporter.reportValidationError(string, "The value must be in the range 1 to 99.");
                            } else {
                                ((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredTime = n;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            IxRuleEditor.this.errorReporter.reportValidationError(string, "The value must be a number.");
                        }
                    }
                    IxRuleEditor.this.rootEditor.blockActionsEnd();
                }
                IxRuleEditor.this.undesiredTimeField.setText(String.valueOf(((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredTime));
            }
        });
        this.undesiredTimeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    IxRuleEditor.this.undesiredTimeField.postActionEvent();
                }
            }
        });
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(BorderFactory.createTitledBorder("Undesired % Time"));
        jPanel10.add(this.undesiredTimeField);
        this.rootEditor.blockActionsEnd();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IxRuleEditor.this.doOK();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IxRuleEditor.this.doCancel();
            }
        });
        JPanel jPanel11 = new JPanel();
        jPanel11.add(jPanel);
        jPanel11.add(jPanel2);
        jPanel11.add(jPanel5);
        jPanel11.setBorder(BorderFactory.createTitledBorder("Desired Station"));
        JPanel jPanel12 = new JPanel();
        jPanel12.add(jPanel3);
        jPanel12.add(jPanel4);
        jPanel12.add(jPanel7);
        jPanel12.setBorder(BorderFactory.createTitledBorder("Undesired Station"));
        JPanel jPanel13 = new JPanel();
        jPanel13.add(jPanel6);
        jPanel13.add(jPanel8);
        jPanel13.add(jPanel9);
        jPanel13.add(jPanel10);
        jPanel13.setBorder(BorderFactory.createTitledBorder("Conditions"));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BoxLayout(jPanel14, 1));
        jPanel14.add(jPanel11);
        jPanel14.add(jPanel12);
        jPanel14.add(jPanel13);
        JPanel jPanel15 = new JPanel(new FlowLayout(2));
        jPanel15.add(this.cancelButton);
        jPanel15.add(this.okButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel14, "Center");
        container.add((Component)jPanel15, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setResizable(true);
        this.setLocationSaved(true);
    }

    @Override
    public String getDbID() {
        return this.rootEditor.getDbID();
    }

    @Override
    public void updateDocumentName() {
        String string = null != this.ixRule && !this.ixRule.isActive ? this.parent.getDocumentName() + "/disabled" : this.parent.getDocumentName();
        this.setDocumentName(string);
    }

    public void setIxRule(IxRuleEditData ixRuleEditData) {
        if (this.isVisible()) {
            return;
        }
        this.canceled = false;
        this.rootEditor.blockActionsStart();
        this.ixRule = ixRuleEditData.copy();
        this.canEdit = !this.ixRule.study.study.templateLocked;
        this.updateDocumentName();
        this.countryMenu.setSelectedItem(this.ixRule.country);
        AppManager.setComponentEnabled(this.countryMenu, this.canEdit);
        this.serviceTypeMenu.setSelectedItem(this.ixRule.serviceType);
        AppManager.setComponentEnabled(this.serviceTypeMenu, this.canEdit);
        this.undesiredServiceTypeMenu.setSelectedItem(this.ixRule.undesiredServiceType);
        AppManager.setComponentEnabled(this.undesiredServiceTypeMenu, this.canEdit);
        this.channelDeltaMenu.setSelectedItem(this.ixRule.channelDelta);
        AppManager.setComponentEnabled(this.channelDeltaMenu, this.canEdit);
        this.channelBandMenu.setSelectedItem(this.ixRule.channelBand);
        AppManager.setComponentEnabled(this.channelBandMenu, this.canEdit);
        this.frequencyOffsetMenu.setSelectedKey(this.ixRule.frequencyOffset);
        AppManager.setComponentEnabled(this.frequencyOffsetMenu, this.canEdit);
        this.emissionMaskMenu.setSelectedItem(this.ixRule.emissionMask);
        if (this.ixRule.undesiredServiceType.needsEmissionMask && 1 == Math.abs(this.ixRule.channelDelta.delta)) {
            AppManager.setComponentEnabled(this.emissionMaskMenu, this.canEdit);
        } else {
            AppManager.setComponentEnabled(this.emissionMaskMenu, false);
        }
        this.distanceField.setText(AppManager.formatDistance(this.ixRule.distance));
        if (this.ixRule.channelDelta.key > 0) {
            AppManager.setComponentEnabled(this.distanceField, this.canEdit);
        } else {
            AppManager.setComponentEnabled(this.distanceField, false);
        }
        this.requiredDUField.setText(AppManager.formatDU(this.ixRule.requiredDU));
        AppManager.setComponentEnabled(this.requiredDUField, this.canEdit);
        this.undesiredTimeField.setText(String.valueOf(this.ixRule.undesiredTime));
        AppManager.setComponentEnabled(this.undesiredTimeField, this.canEdit);
        this.rootEditor.blockActionsEnd();
    }

    public IxRuleEditData getIxRule() {
        return this.ixRule;
    }

    private void doOK() {
        this.canceled = false;
        if (this.windowShouldClose()) {
            AppManager.hideWindow(this);
        }
    }

    public boolean cancel() {
        this.doCancel();
        return this.canceled;
    }

    private void doCancel() {
        this.canceled = true;
        if (this.windowShouldClose()) {
            AppManager.hideWindow(this);
        } else {
            this.canceled = false;
        }
    }

    @Override
    public void windowWillOpen() {
        this.setLocationRelativeTo(this.parent);
        this.canceled = false;
    }

    @Override
    public boolean windowShouldClose() {
        Component component;
        if (this.canceled || !this.canEdit) {
            return true;
        }
        this.errorReporter.clearErrors();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (keyboardFocusManager.getFocusedWindow() == this && null != (component = keyboardFocusManager.getFocusOwner()) && component instanceof JTextField) {
            ((JTextField)component).postActionEvent();
        }
        if (this.errorReporter.hasErrors()) {
            return false;
        }
        return this.ixRule.isDataValid(this.errorReporter);
    }
}

