/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppDialog;
import gov.fcc.tvstudy.AppFrame;
import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.data.Zone;
import gov.fcc.tvstudy.editdata.CDBSRecord;
import gov.fcc.tvstudy.editdata.SourceEditData;
import gov.fcc.tvstudy.editor.CoordinatePanel;
import gov.fcc.tvstudy.editor.RootEditor;
import gov.fcc.tvstudy.editor.SourceEditor;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import gov.fcc.tvstudy.util.KeyedRecordMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class DTSSourceEditor
extends AppDialog {
    public static final String WINDOW_TITLE = "DTS Station Data";
    private RootEditor rootEditor;
    private AppFrame parent;
    private SourceEditor sourceEditor;
    private ErrorReporter errorReporter;
    private SourceEditData source;
    private boolean canEdit;
    private JLabel facility_idLabel;
    private JTextField callSignField;
    private JTextField channelField;
    private JLabel replicationLabel;
    private JTextField cityField;
    private JTextField stateField;
    private JLabel countryLabel;
    private KeyedRecordMenu zoneMenu;
    private KeyedRecordMenu statusMenu;
    private KeyedRecord statusItem;
    private JTextField fileNumberField;
    private CoordinatePanel latitudePanel;
    private CoordinatePanel longitudePanel;
    private JTextField distanceField;
    private static final String TABLE_DIST_LABEL = "(table)";
    private DTSSourceTableModel sourceModel;
    private JTable sourceTable;
    private JButton addNewSourceButton;
    private JButton editSourceButton;
    private JButton removeSourceButton;
    private JButton okButton;
    private JButton cancelButton;
    public boolean canceled;

    public DTSSourceEditor(RootEditor rootEditor, AppFrame appFrame, SourceEditor sourceEditor) {
        super((Window)appFrame, WINDOW_TITLE, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDisposeOnClose(false);
        this.rootEditor = rootEditor;
        this.parent = appFrame;
        this.sourceEditor = sourceEditor;
        this.errorReporter = new ErrorReporter(this.rootEditor, this, "Edit DTS Station");
        this.rootEditor.blockActionsStart();
        this.facility_idLabel = new JLabel();
        this.facility_idLabel.setPreferredSize(AppManager.getLabelSize(8));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Facility ID"));
        jPanel.add(this.facility_idLabel);
        this.callSignField = new JTextField(12);
        AppManager.fixKeyBindings(this.callSignField);
        this.callSignField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DTSSourceEditor.this.canEdit && DTSSourceEditor.this.rootEditor.blockActions()) {
                    String string = DTSSourceEditor.this.callSignField.getText().trim();
                    if (string.length() > 0) {
                        ((DTSSourceEditor)DTSSourceEditor.this).source.callSign = string;
                        for (SourceEditData sourceEditData : DTSSourceEditor.this.source.getDTSSources()) {
                            sourceEditData.callSign = string;
                        }
                    }
                    DTSSourceEditor.this.rootEditor.blockActionsEnd();
                }
                DTSSourceEditor.this.callSignField.setText(((DTSSourceEditor)DTSSourceEditor.this).source.callSign);
                DTSSourceEditor.this.updateDocumentName();
            }
        });
        this.callSignField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    DTSSourceEditor.this.callSignField.postActionEvent();
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Call Sign"));
        jPanel2.add(this.callSignField);
        this.channelField = new JTextField(6);
        AppManager.fixKeyBindings(this.channelField);
        this.channelField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DTSSourceEditor.this.canEdit && DTSSourceEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Channel";
                    String string2 = DTSSourceEditor.this.channelField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            int n = Integer.parseInt(string2);
                            if (n < ((DTSSourceEditor)DTSSourceEditor.this).source.study.minimumChannel || n > ((DTSSourceEditor)DTSSourceEditor.this).source.study.maximumChannel) {
                                DTSSourceEditor.this.errorReporter.reportValidationError(string, "The channel must be in the range " + ((DTSSourceEditor)DTSSourceEditor.this).source.study.minimumChannel + " to " + ((DTSSourceEditor)DTSSourceEditor.this).source.study.maximumChannel + ".");
                            } else {
                                ((DTSSourceEditor)DTSSourceEditor.this).source.channel = n;
                                for (SourceEditData sourceEditData : DTSSourceEditor.this.source.getDTSSources()) {
                                    if (sourceEditData.siteNumber <= 0) continue;
                                    sourceEditData.channel = n;
                                }
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            DTSSourceEditor.this.errorReporter.reportValidationError(string, "The channel must be a number.");
                        }
                    }
                    DTSSourceEditor.this.rootEditor.blockActionsEnd();
                }
                DTSSourceEditor.this.channelField.setText(String.valueOf(((DTSSourceEditor)DTSSourceEditor.this).source.channel));
            }
        });
        this.channelField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    DTSSourceEditor.this.channelField.postActionEvent();
                }
            }
        });
        this.replicationLabel = new JLabel();
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Channel"));
        jPanel3.add(this.channelField);
        jPanel3.add(this.replicationLabel);
        this.cityField = new JTextField(18);
        AppManager.fixKeyBindings(this.cityField);
        this.cityField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DTSSourceEditor.this.canEdit && DTSSourceEditor.this.rootEditor.blockActions()) {
                    String string = DTSSourceEditor.this.cityField.getText().trim();
                    if (string.length() > 0) {
                        ((DTSSourceEditor)DTSSourceEditor.this).source.city = string;
                        for (SourceEditData sourceEditData : DTSSourceEditor.this.source.getDTSSources()) {
                            sourceEditData.city = string;
                        }
                    }
                    DTSSourceEditor.this.rootEditor.blockActionsEnd();
                }
                DTSSourceEditor.this.cityField.setText(((DTSSourceEditor)DTSSourceEditor.this).source.city);
            }
        });
        this.cityField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    DTSSourceEditor.this.cityField.postActionEvent();
                }
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder("City"));
        jPanel4.add(this.cityField);
        this.stateField = new JTextField(3);
        AppManager.fixKeyBindings(this.stateField);
        this.stateField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DTSSourceEditor.this.canEdit && DTSSourceEditor.this.rootEditor.blockActions()) {
                    String string = DTSSourceEditor.this.stateField.getText().trim();
                    if (string.length() > 0) {
                        ((DTSSourceEditor)DTSSourceEditor.this).source.state = string;
                        for (SourceEditData sourceEditData : DTSSourceEditor.this.source.getDTSSources()) {
                            sourceEditData.state = string;
                        }
                    }
                    DTSSourceEditor.this.rootEditor.blockActionsEnd();
                }
                DTSSourceEditor.this.stateField.setText(((DTSSourceEditor)DTSSourceEditor.this).source.state);
            }
        });
        this.stateField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    DTSSourceEditor.this.stateField.postActionEvent();
                }
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder("State"));
        jPanel5.add(this.stateField);
        this.countryLabel = new JLabel();
        this.countryLabel.setPreferredSize(AppManager.getLabelSize(6));
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder("Country"));
        jPanel6.add(this.countryLabel);
        this.zoneMenu = new KeyedRecordMenu(Zone.getZonesWithNull(DbManager.getDb(this.rootEditor.getDbID())));
        this.zoneMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DTSSourceEditor.this.canEdit && DTSSourceEditor.this.rootEditor.blockActions()) {
                    ((DTSSourceEditor)DTSSourceEditor.this).source.zone = (Zone)DTSSourceEditor.this.zoneMenu.getSelectedItem();
                    for (SourceEditData sourceEditData : DTSSourceEditor.this.source.getDTSSources()) {
                        if (sourceEditData.siteNumber <= 0) continue;
                        sourceEditData.zone = ((DTSSourceEditor)DTSSourceEditor.this).source.zone;
                    }
                    DTSSourceEditor.this.rootEditor.blockActionsEnd();
                } else {
                    DTSSourceEditor.this.zoneMenu.setSelectedItem(((DTSSourceEditor)DTSSourceEditor.this).source.zone);
                }
            }
        });
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(BorderFactory.createTitledBorder("Zone"));
        jPanel7.add(this.zoneMenu);
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        for (int i = 0; i < CDBSRecord.STATUS_CODES.length; ++i) {
            arrayList.add(new KeyedRecord(i + 1, CDBSRecord.STATUS_CODES[i]));
        }
        this.statusMenu = new KeyedRecordMenu(arrayList);
        this.statusMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DTSSourceEditor.this.canEdit && DTSSourceEditor.this.rootEditor.blockActions()) {
                    DTSSourceEditor.this.statusItem = DTSSourceEditor.this.statusMenu.getSelectedItem();
                    ((DTSSourceEditor)DTSSourceEditor.this).source.status = ((DTSSourceEditor)DTSSourceEditor.this).statusItem.name;
                    ((DTSSourceEditor)DTSSourceEditor.this).source.statusType = CDBSRecord.STATUS_TYPES[((DTSSourceEditor)DTSSourceEditor.this).statusItem.key - 1];
                    for (SourceEditData sourceEditData : DTSSourceEditor.this.source.getDTSSources()) {
                        if (sourceEditData.siteNumber <= 0) continue;
                        sourceEditData.status = ((DTSSourceEditor)DTSSourceEditor.this).source.status;
                        sourceEditData.statusType = ((DTSSourceEditor)DTSSourceEditor.this).source.statusType;
                    }
                    DTSSourceEditor.this.rootEditor.blockActionsEnd();
                }
                DTSSourceEditor.this.statusMenu.setSelectedItem(DTSSourceEditor.this.statusItem);
            }
        });
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(BorderFactory.createTitledBorder("Status"));
        jPanel8.add(this.statusMenu);
        this.fileNumberField = new JTextField(16);
        AppManager.fixKeyBindings(this.fileNumberField);
        this.fileNumberField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DTSSourceEditor.this.canEdit && DTSSourceEditor.this.rootEditor.blockActions()) {
                    ((DTSSourceEditor)DTSSourceEditor.this).source.fileNumber = DTSSourceEditor.this.fileNumberField.getText().trim();
                    ((DTSSourceEditor)DTSSourceEditor.this).source.appARN = "";
                    for (int i = 0; i < ((DTSSourceEditor)DTSSourceEditor.this).source.fileNumber.length(); ++i) {
                        if (!Character.isDigit(((DTSSourceEditor)DTSSourceEditor.this).source.fileNumber.charAt(i))) continue;
                        ((DTSSourceEditor)DTSSourceEditor.this).source.appARN = ((DTSSourceEditor)DTSSourceEditor.this).source.fileNumber.substring(i);
                        break;
                    }
                    for (SourceEditData sourceEditData : DTSSourceEditor.this.source.getDTSSources()) {
                        if (sourceEditData.siteNumber <= 0) continue;
                        sourceEditData.fileNumber = ((DTSSourceEditor)DTSSourceEditor.this).source.fileNumber;
                        sourceEditData.appARN = ((DTSSourceEditor)DTSSourceEditor.this).source.appARN;
                    }
                    DTSSourceEditor.this.rootEditor.blockActionsEnd();
                }
                DTSSourceEditor.this.fileNumberField.setText(((DTSSourceEditor)DTSSourceEditor.this).source.fileNumber);
            }
        });
        this.fileNumberField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    DTSSourceEditor.this.fileNumberField.postActionEvent();
                }
            }
        });
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(BorderFactory.createTitledBorder("File Number"));
        jPanel9.add(this.fileNumberField);
        this.latitudePanel = new CoordinatePanel(this.rootEditor, this.errorReporter, false, new Runnable(){

            @Override
            public void run() {
                ((DTSSourceEditor)DTSSourceEditor.this).source.latitude = DTSSourceEditor.this.latitudePanel.getCoordinate();
            }
        });
        this.longitudePanel = new CoordinatePanel(this.rootEditor, this.errorReporter, true, new Runnable(){

            @Override
            public void run() {
                ((DTSSourceEditor)DTSSourceEditor.this).source.longitude = DTSSourceEditor.this.longitudePanel.getCoordinate();
            }
        });
        this.distanceField = new JTextField(7);
        AppManager.fixKeyBindings(this.distanceField);
        this.distanceField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DTSSourceEditor.this.canEdit && DTSSourceEditor.this.rootEditor.blockActions()) {
                    String string = "Edit Distance";
                    String string2 = DTSSourceEditor.this.distanceField.getText().trim();
                    if (string2.length() > 0) {
                        if (string2.equals(DTSSourceEditor.TABLE_DIST_LABEL)) {
                            string2 = "0";
                        }
                        try {
                            double d = Double.parseDouble(string2);
                            if (d != 0.0 && (d < 50.0 || d > 200.0)) {
                                DTSSourceEditor.this.errorReporter.reportValidationError(string, "The distance must be in the range 50.0 to 200.0.");
                            } else {
                                ((DTSSourceEditor)DTSSourceEditor.this).source.dtsMaximumDistance = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            DTSSourceEditor.this.errorReporter.reportValidationError(string, "The distance must be a number.");
                        }
                    }
                    DTSSourceEditor.this.rootEditor.blockActionsEnd();
                }
                if (0.0 == ((DTSSourceEditor)DTSSourceEditor.this).source.dtsMaximumDistance) {
                    DTSSourceEditor.this.distanceField.setText(DTSSourceEditor.TABLE_DIST_LABEL);
                } else {
                    DTSSourceEditor.this.distanceField.setText(AppManager.formatDistance(((DTSSourceEditor)DTSSourceEditor.this).source.dtsMaximumDistance));
                }
            }
        });
        this.distanceField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    DTSSourceEditor.this.distanceField.postActionEvent();
                }
            }
        });
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(BorderFactory.createTitledBorder("Distance, km"));
        jPanel10.add(this.distanceField);
        this.sourceModel = new DTSSourceTableModel();
        this.sourceTable = this.sourceModel.createTable();
        this.sourceTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 == mouseEvent.getClickCount()) {
                    DTSSourceEditor.this.doEditSource();
                }
            }
        });
        this.sourceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = DTSSourceEditor.this.sourceTable.getSelectedRowCount();
                if (1 == n) {
                    DTSSourceEditor.this.editSourceButton.setEnabled(true);
                    DTSSourceEditor.this.removeSourceButton.setEnabled(DTSSourceEditor.this.canEdit);
                } else {
                    DTSSourceEditor.this.editSourceButton.setEnabled(false);
                    DTSSourceEditor.this.removeSourceButton.setEnabled(false);
                }
            }
        });
        JPanel jPanel11 = new JPanel(new BorderLayout());
        jPanel11.setBorder(BorderFactory.createTitledBorder("Station Data Records"));
        jPanel11.add((Component)AppManager.createScrollPane(this.sourceTable), "Center");
        this.rootEditor.blockActionsEnd();
        this.addNewSourceButton = new JButton("Add Reference");
        this.addNewSourceButton.setFocusable(false);
        this.addNewSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTSSourceEditor.this.doAddNewSource();
            }
        });
        this.addNewSourceButton.setEnabled(false);
        this.editSourceButton = new JButton("View");
        this.editSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTSSourceEditor.this.doEditSource();
            }
        });
        this.editSourceButton.setEnabled(false);
        this.removeSourceButton = new JButton("Remove");
        this.removeSourceButton.setFocusable(false);
        this.removeSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTSSourceEditor.this.doRemoveSource();
            }
        });
        this.removeSourceButton.setEnabled(false);
        this.okButton = new JButton("OK");
        this.okButton.setFocusable(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTSSourceEditor.this.doOK();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTSSourceEditor.this.doCancel();
            }
        });
        JPanel jPanel12 = new JPanel();
        jPanel12.add(jPanel);
        jPanel12.add(jPanel6);
        jPanel12.add(jPanel2);
        jPanel12.add(jPanel8);
        JPanel jPanel13 = new JPanel();
        jPanel13.add(jPanel4);
        jPanel13.add(jPanel5);
        jPanel13.add(jPanel7);
        JPanel jPanel14 = new JPanel();
        jPanel14.add(jPanel3);
        jPanel14.add(jPanel9);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new BoxLayout(jPanel15, 1));
        jPanel15.add(this.latitudePanel);
        jPanel15.add(this.longitudePanel);
        JPanel jPanel16 = new JPanel();
        jPanel16.setBorder(BorderFactory.createTitledBorder("Reference point and distance"));
        jPanel16.add(jPanel15);
        jPanel16.add(jPanel10);
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new BoxLayout(jPanel17, 1));
        jPanel17.add(jPanel12);
        jPanel17.add(jPanel13);
        jPanel17.add(jPanel14);
        jPanel17.add(jPanel16);
        JPanel jPanel18 = new JPanel(new FlowLayout(0));
        jPanel18.add(this.addNewSourceButton);
        JPanel jPanel19 = new JPanel();
        jPanel19.add(this.removeSourceButton);
        jPanel19.add(this.editSourceButton);
        JPanel jPanel20 = new JPanel(new FlowLayout(2));
        jPanel20.add(this.cancelButton);
        jPanel20.add(this.okButton);
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout(new BoxLayout(jPanel21, 0));
        jPanel21.add(jPanel18);
        jPanel21.add(jPanel19);
        jPanel21.add(jPanel20);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel17, "North");
        container.add((Component)jPanel11, "Center");
        container.add((Component)jPanel21, "South");
        this.getRootPane().setDefaultButton(this.editSourceButton);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.height = 600;
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.setResizable(true);
        this.setLocationSaved(true);
    }

    @Override
    public String getDbID() {
        return this.rootEditor.getDbID();
    }

    @Override
    public void updateDocumentName() {
        String string = null != this.source ? this.parent.getDocumentName() + "/" + this.source.callSign : this.parent.getDocumentName();
        this.setDocumentName(string);
        this.sourceEditor.updateDocumentName();
    }

    public void setSource(SourceEditData sourceEditData) {
        if (!sourceEditData.isParent) {
            throw new IllegalArgumentException("DTSSourceEditor.setSource() called with non-parent source");
        }
        if (this.isVisible()) {
            return;
        }
        this.canceled = false;
        this.rootEditor.blockActionsStart();
        this.source = sourceEditData.copy();
        this.canEdit = !this.source.isLocked;
        this.updateDocumentName();
        this.facility_idLabel.setText(String.valueOf(this.source.facility_id));
        this.callSignField.setText(this.source.callSign);
        AppManager.setComponentEnabled(this.callSignField, this.canEdit);
        this.channelField.setText(String.valueOf(this.source.channel));
        AppManager.setComponentEnabled(this.channelField, this.canEdit);
        if (null == this.source.originalSourceKey) {
            this.replicationLabel.setText("");
        } else {
            String string = "replicated from ";
            SourceEditData sourceEditData2 = this.source.study.getSource(this.source.originalSourceKey);
            string = null == sourceEditData2 ? string + "???" : string + "D" + sourceEditData2.channel;
            this.replicationLabel.setText(string);
        }
        this.cityField.setText(this.source.city);
        AppManager.setComponentEnabled(this.cityField, this.canEdit);
        this.stateField.setText(this.source.state);
        AppManager.setComponentEnabled(this.stateField, this.canEdit);
        this.countryLabel.setText(this.source.country.name);
        this.zoneMenu.setSelectedItem(this.source.zone);
        AppManager.setComponentEnabled(this.zoneMenu, this.canEdit);
        int n = 0;
        for (int i = 0; i < CDBSRecord.STATUS_CODES.length; ++i) {
            if (!this.source.status.equals(CDBSRecord.STATUS_CODES[i])) continue;
            n = i + 1;
            break;
        }
        this.statusItem = new KeyedRecord(n, this.source.status);
        this.statusMenu.setSelectedItem(this.statusItem);
        AppManager.setComponentEnabled(this.statusMenu, this.canEdit);
        this.fileNumberField.setText(this.source.fileNumber);
        AppManager.setComponentEnabled(this.fileNumberField, this.canEdit);
        this.latitudePanel.setCoordinate(this.source.latitude);
        this.longitudePanel.setCoordinate(this.source.longitude);
        this.latitudePanel.setEnabled(this.canEdit);
        this.longitudePanel.setEnabled(this.canEdit);
        if (0.0 == this.source.dtsMaximumDistance) {
            this.distanceField.setText(TABLE_DIST_LABEL);
        } else {
            this.distanceField.setText(AppManager.formatDistance(this.source.dtsMaximumDistance));
        }
        AppManager.setComponentEnabled(this.distanceField, this.canEdit);
        this.sourceModel.reload();
        if (this.sourceModel.hasReference) {
            this.addNewSourceButton.setText("Add Site");
        } else {
            this.addNewSourceButton.setText("Add Reference");
        }
        if (this.canEdit) {
            this.editSourceButton.setText("Edit");
        } else {
            this.editSourceButton.setText("View");
        }
        this.addNewSourceButton.setEnabled(this.canEdit);
        this.editSourceButton.setEnabled(false);
        this.removeSourceButton.setEnabled(false);
        this.addNewSourceButton.setVisible(this.canEdit);
        this.removeSourceButton.setVisible(this.canEdit);
        this.cancelButton.setVisible(this.canEdit);
        this.rootEditor.blockActionsEnd();
    }

    public SourceEditData getSource() {
        return this.source;
    }

    private void doEditSource() {
        if (this.sourceEditor.isVisible()) {
            return;
        }
        int n = this.sourceTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        n = this.sourceTable.convertRowIndexToModel(n);
        SourceEditData sourceEditData = this.sourceModel.get(n);
        this.sourceEditor.setSource(sourceEditData, this.sourceModel.getValueAt(n, 0).toString());
        AppManager.showWindow(this.sourceEditor);
        if (this.sourceEditor.canceled) {
            return;
        }
        if (this.canEdit) {
            sourceEditData = this.sourceEditor.getSource();
            this.source.addOrReplaceDTSSource(sourceEditData);
            this.sourceModel.reload();
            n = this.sourceTable.convertRowIndexToView(this.sourceModel.indexOf(sourceEditData));
            this.sourceTable.setRowSelectionInterval(n, n);
            this.sourceTable.scrollRectToVisible(this.sourceTable.getCellRect(n, 0, true));
        }
    }

    private void doAddNewSource() {
        String string;
        SourceEditData sourceEditData;
        ErrorReporter errorReporter;
        if (!this.canEdit || this.sourceEditor.isVisible()) {
            return;
        }
        DbConnection dbConnection = DbManager.getDb(this.rootEditor.getDbID());
        if (this.sourceModel.hasReference) {
            errorReporter = new ErrorReporter(this, "Add DTS Site");
            if (0 == this.source.callSign.length() || 0 == this.source.city.length() || 0 == this.source.state.length() || 0 == this.source.channel || this.source.zone.key < 0) {
                errorReporter.reportWarning("The call sign, city, state, channel, and zone must be set first.");
                return;
            }
            sourceEditData = this.source.createDTSSource(dbConnection, this.source.getNextDTSSiteNumber(), errorReporter);
            if (null == sourceEditData) {
                return;
            }
            string = "Site " + sourceEditData.siteNumber;
        } else {
            errorReporter = new ErrorReporter(this, "Add DTS Reference");
            if (0 == this.source.callSign.length() || 0 == this.source.city.length() || 0 == this.source.state.length()) {
                errorReporter.reportWarning("The call sign, city, and state must be set first.");
                return;
            }
            sourceEditData = this.source.createDTSSource(dbConnection, 0, errorReporter);
            if (null == sourceEditData) {
                return;
            }
            string = "Reference";
        }
        this.sourceEditor.setSource(sourceEditData, string);
        AppManager.showWindow(this.sourceEditor);
        if (this.sourceEditor.canceled) {
            return;
        }
        sourceEditData = this.sourceEditor.getSource();
        this.source.addOrReplaceDTSSource(sourceEditData);
        this.sourceModel.reload();
        this.addNewSourceButton.setText("Add Site");
        int n = this.sourceTable.convertRowIndexToView(this.sourceModel.indexOf(sourceEditData));
        this.sourceTable.setRowSelectionInterval(n, n);
        this.sourceTable.scrollRectToVisible(this.sourceTable.getCellRect(n, 0, true));
    }

    private void doRemoveSource() {
        if (!this.canEdit || this.sourceEditor.isVisible()) {
            return;
        }
        int n = this.sourceTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        SourceEditData sourceEditData = this.sourceModel.get(this.sourceTable.convertRowIndexToModel(n));
        this.source.removeDTSSource(sourceEditData);
        this.sourceModel.reload();
        if (this.sourceModel.hasReference) {
            this.addNewSourceButton.setText("Add Site");
        } else {
            this.addNewSourceButton.setText("Add Reference");
        }
    }

    private void doOK() {
        this.canceled = false;
        if (this.windowShouldClose()) {
            AppManager.hideWindow(this);
        }
    }

    public boolean cancel() {
        this.doCancel();
        return this.canceled;
    }

    private void doCancel() {
        if (this.sourceEditor.isVisible() && !this.sourceEditor.cancel()) {
            return;
        }
        this.canceled = true;
        if (this.windowShouldClose()) {
            AppManager.hideWindow(this);
        } else {
            this.canceled = false;
        }
    }

    @Override
    public void windowWillOpen() {
        this.setLocationRelativeTo(this.parent);
        this.canceled = false;
    }

    @Override
    public boolean windowShouldClose() {
        Component component;
        if (this.canceled || !this.canEdit) {
            return true;
        }
        this.errorReporter.clearErrors();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (keyboardFocusManager.getFocusedWindow() == this && null != (component = keyboardFocusManager.getFocusOwner()) && component instanceof JTextField) {
            ((JTextField)component).postActionEvent();
        }
        if (this.errorReporter.hasErrors()) {
            return false;
        }
        return this.source.isDataValid(this.errorReporter);
    }

    private class DTSSourceTableModel
    extends AbstractTableModel {
        private static final String SOURCE_LABEL_COLUMN = "Record";
        private static final String SOURCE_LATITUDE_COLUMN = "Latitude";
        private static final String SOURCE_LONGITUDE_COLUMN = "Longitude";
        private static final String SOURCE_HEIGHT_COLUMN = "Height, m";
        private static final String SOURCE_ERP_COLUMN = "ERP, kW";
        private String[] columnNames = new String[]{"Record", "Latitude", "Longitude", "Height, m", "ERP, kW"};
        private static final int SOURCE_LABEL_INDEX = 0;
        private static final int SOURCE_LATITUDE_INDEX = 1;
        private static final int SOURCE_LONGITUDE_INDEX = 2;
        private static final int SOURCE_HEIGHT_INDEX = 3;
        private static final int SOURCE_ERP_INDEX = 4;
        private ArrayList<SourceEditData> modelRows = new ArrayList();
        private boolean hasReference;

        private DTSSourceTableModel() {
        }

        private JTable createTable() {
            JTable jTable = new JTable(this);
            AppManager.configureTable(jTable);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            defaultTableCellRenderer.setHorizontalAlignment(4);
            DefaultTableCellRenderer defaultTableCellRenderer2 = (DefaultTableCellRenderer)new JTableHeader().getDefaultRenderer();
            defaultTableCellRenderer2.setHorizontalAlignment(4);
            int n = AppManager.getTextFieldWidth(5);
            int n2 = AppManager.getTextFieldWidth(7);
            int n3 = AppManager.getTextFieldWidth(12);
            TableColumn tableColumn = jTable.getColumn(SOURCE_LABEL_COLUMN);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n2);
            tableColumn = jTable.getColumn(SOURCE_LATITUDE_COLUMN);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n3);
            tableColumn = jTable.getColumn(SOURCE_LONGITUDE_COLUMN);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n3);
            tableColumn = jTable.getColumn(SOURCE_HEIGHT_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setHeaderRenderer(defaultTableCellRenderer2);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n2);
            tableColumn = jTable.getColumn(SOURCE_ERP_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setHeaderRenderer(defaultTableCellRenderer2);
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n2);
            return jTable;
        }

        private void reload() {
            this.modelRows.clear();
            this.hasReference = false;
            for (SourceEditData sourceEditData : DTSSourceEditor.this.source.getDTSSources()) {
                int n;
                if (0 == sourceEditData.siteNumber) {
                    this.hasReference = true;
                }
                for (n = 0; n < this.modelRows.size() && sourceEditData.siteNumber >= this.modelRows.get((int)n).siteNumber; ++n) {
                }
                this.modelRows.add(n, sourceEditData);
            }
            this.fireTableDataChanged();
        }

        public SourceEditData get(int n) {
            return this.modelRows.get(n);
        }

        public int indexOf(SourceEditData sourceEditData) {
            return this.modelRows.indexOf(sourceEditData);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.modelRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SourceEditData sourceEditData = this.modelRows.get(n);
            switch (n2) {
                case 0: {
                    if (0 == n) {
                        return "Reference";
                    }
                    return "Site " + sourceEditData.siteNumber;
                }
                case 1: {
                    return AppManager.formatLatitude(sourceEditData.latitude);
                }
                case 2: {
                    return AppManager.formatLongitude(sourceEditData.longitude);
                }
                case 3: {
                    return AppManager.formatHeight(sourceEditData.heightAMSL);
                }
                case 4: {
                    return AppManager.formatERP(sourceEditData.peakERP);
                }
            }
            return "";
        }
    }
}

