/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editor;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.editor.RootEditor;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CoordinatePanel
extends JPanel {
    private RootEditor rootEditor;
    private ErrorReporter errorReporter;
    private Runnable callBack;
    private boolean isLongitude;
    private double coordinate;
    private int degrees;
    private int minutes;
    private double seconds;
    private JComboBox directionMenu;
    private JTextField degreesField;
    private JTextField minutesField;
    private JTextField secondsField;

    public CoordinatePanel(RootEditor rootEditor, ErrorReporter errorReporter, boolean bl, Runnable runnable) {
        this.rootEditor = rootEditor;
        this.errorReporter = errorReporter;
        this.callBack = runnable;
        this.isLongitude = bl;
        this.rootEditor.blockActionsStart();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                try {
                    n = Integer.parseInt(actionEvent.getActionCommand());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n < 1 || n > 3) {
                    return;
                }
                if (CoordinatePanel.this.rootEditor.blockActions()) {
                    String string = "Edit Coordinates";
                    String string2 = "";
                    boolean bl = false;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    String string3 = "";
                    switch (n) {
                        case 1: {
                            string2 = CoordinatePanel.this.degreesField.getText().trim();
                            n3 = 0;
                            n4 = CoordinatePanel.this.isLongitude ? (int)Math.rint(179.0) : (int)Math.rint(72.0);
                            string3 = "Degrees";
                            break;
                        }
                        case 2: {
                            string2 = CoordinatePanel.this.minutesField.getText().trim();
                            n3 = 0;
                            n4 = 60;
                            string3 = "Minutes";
                            break;
                        }
                        case 3: {
                            string2 = CoordinatePanel.this.secondsField.getText().trim();
                            bl = true;
                            d2 = 0.0;
                            d3 = 60.0;
                            string3 = "Seconds";
                        }
                    }
                    if (string2.length() > 0) {
                        try {
                            boolean bl2 = false;
                            if (bl) {
                                d = Double.parseDouble(string2);
                                if (d < d2 || d >= d3) {
                                    CoordinatePanel.this.errorReporter.reportValidationError(string, string3 + " must be in the range " + d2 + " to less than " + d3 + ".");
                                } else {
                                    bl2 = true;
                                }
                            } else {
                                n2 = Integer.parseInt(string2);
                                if (n2 < n3 || n2 > n4) {
                                    CoordinatePanel.this.errorReporter.reportValidationError(string, string3 + " must be in the range " + n3 + " to " + n4 + ".");
                                } else {
                                    bl2 = true;
                                }
                            }
                            if (bl2) {
                                switch (n) {
                                    case 1: {
                                        CoordinatePanel.this.degrees = n2;
                                        break;
                                    }
                                    case 2: {
                                        CoordinatePanel.this.minutes = n2;
                                        break;
                                    }
                                    case 3: {
                                        CoordinatePanel.this.seconds = d;
                                    }
                                }
                                CoordinatePanel.this.coordinate = (double)CoordinatePanel.this.degrees + (double)CoordinatePanel.this.minutes / 60.0 + CoordinatePanel.this.seconds / 3600.0;
                                if (CoordinatePanel.this.directionMenu.getSelectedIndex() != 0) {
                                    CoordinatePanel.this.coordinate = -CoordinatePanel.this.coordinate;
                                }
                                if (null != CoordinatePanel.this.callBack) {
                                    CoordinatePanel.this.callBack.run();
                                }
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            CoordinatePanel.this.errorReporter.reportValidationError(string, string3 + " must be a number.");
                        }
                    }
                    CoordinatePanel.this.rootEditor.blockActionsEnd();
                }
                switch (n) {
                    case 1: {
                        CoordinatePanel.this.degreesField.setText(String.valueOf(CoordinatePanel.this.degrees));
                        break;
                    }
                    case 2: {
                        CoordinatePanel.this.minutesField.setText(String.valueOf(CoordinatePanel.this.minutes));
                        break;
                    }
                    case 3: {
                        CoordinatePanel.this.secondsField.setText(AppManager.formatSeconds(CoordinatePanel.this.seconds));
                    }
                }
            }
        };
        this.directionMenu = new JComboBox();
        if (this.isLongitude) {
            this.directionMenu.addItem("W");
            this.directionMenu.addItem("E");
        } else {
            this.directionMenu.addItem("N");
            this.directionMenu.addItem("S");
        }
        this.directionMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CoordinatePanel.this.rootEditor.blockActions()) {
                    if (CoordinatePanel.this.directionMenu.getSelectedIndex() != 0) {
                        if (CoordinatePanel.this.coordinate > 0.0) {
                            CoordinatePanel.this.coordinate = -CoordinatePanel.this.coordinate;
                        }
                    } else if (CoordinatePanel.this.coordinate < 0.0) {
                        CoordinatePanel.this.coordinate = -CoordinatePanel.this.coordinate;
                    }
                    CoordinatePanel.this.rootEditor.blockActionsEnd();
                } else if (CoordinatePanel.this.coordinate >= 0.0) {
                    CoordinatePanel.this.directionMenu.setSelectedIndex(0);
                } else {
                    CoordinatePanel.this.directionMenu.setSelectedIndex(1);
                }
            }
        });
        this.degreesField = new JTextField(3);
        AppManager.fixKeyBindings(this.degreesField);
        this.degreesField.setActionCommand("1");
        this.degreesField.addActionListener(actionListener);
        this.degreesField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    CoordinatePanel.this.degreesField.postActionEvent();
                }
            }
        });
        this.minutesField = new JTextField(3);
        AppManager.fixKeyBindings(this.minutesField);
        this.minutesField.setActionCommand("2");
        this.minutesField.addActionListener(actionListener);
        this.minutesField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    CoordinatePanel.this.minutesField.postActionEvent();
                }
            }
        });
        this.secondsField = new JTextField(6);
        AppManager.fixKeyBindings(this.secondsField);
        this.secondsField.setActionCommand("3");
        this.secondsField.addActionListener(actionListener);
        this.secondsField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    CoordinatePanel.this.secondsField.postActionEvent();
                }
            }
        });
        if (this.isLongitude) {
            this.setBorder(BorderFactory.createTitledBorder("Longitude (NAD27)"));
        } else {
            this.setBorder(BorderFactory.createTitledBorder("Latitude (NAD27)"));
        }
        this.add(this.directionMenu);
        this.add(this.degreesField);
        this.add(new JLabel("\u00b0"));
        this.add(this.minutesField);
        this.add(new JLabel("'"));
        this.add(this.secondsField);
        this.add(new JLabel("\""));
        this.rootEditor.blockActionsEnd();
    }

    public boolean isLongitude() {
        return this.isLongitude;
    }

    public double getCoordinate() {
        return this.coordinate;
    }

    public void setCoordinate(double d) {
        this.rootEditor.blockActionsStart();
        this.coordinate = d;
        d = Math.abs(d);
        this.degrees = (int)d;
        this.minutes = (int)((d - (double)this.degrees) * 60.0);
        this.seconds = ((d - (double)this.degrees) * 60.0 - (double)this.minutes) * 60.0;
        if (this.seconds >= 59.995) {
            this.seconds = 0.0;
            if (60 == ++this.minutes) {
                this.minutes = 0;
                ++this.degrees;
            }
        }
        if (this.coordinate < 0.0) {
            this.directionMenu.setSelectedIndex(1);
        } else {
            this.directionMenu.setSelectedIndex(0);
        }
        this.degreesField.setText(String.valueOf(this.degrees));
        this.minutesField.setText(String.valueOf(this.minutes));
        this.secondsField.setText(AppManager.formatSeconds(this.seconds));
        this.rootEditor.blockActionsEnd();
    }

    @Override
    public void setEnabled(boolean bl) {
        AppManager.setComponentEnabled(this.directionMenu, bl);
        AppManager.setComponentEnabled(this.degreesField, bl);
        AppManager.setComponentEnabled(this.minutesField, bl);
        AppManager.setComponentEnabled(this.secondsField, bl);
    }
}

