/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editdata;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.data.ChannelBand;
import gov.fcc.tvstudy.data.ChannelDelta;
import gov.fcc.tvstudy.data.Country;
import gov.fcc.tvstudy.data.EmissionMask;
import gov.fcc.tvstudy.data.ServiceType;
import gov.fcc.tvstudy.editdata.IxRuleEditData;
import gov.fcc.tvstudy.editdata.ParameterEditData;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class StudyTemplate {
    public int key;
    public String name;
    public boolean isLocked;
    public boolean isLockedInStudy;
    public int useCount;

    public StudyTemplate(int n, String string, boolean bl, boolean bl2, int n2) {
        this.key = n;
        this.name = string;
        this.isLocked = bl;
        this.isLockedInStudy = bl2;
        this.useCount = n2;
    }

    public static ArrayList<StudyTemplate> getStudyTemplates(DbConnection dbConnection, ErrorReporter errorReporter) {
        ArrayList<StudyTemplate> arrayList = null;
        if (dbConnection.connect(errorReporter)) {
            try {
                dbConnection.query("SELECT template_key, name, locked, locked_in_study, use_count FROM tvstudy.template ORDER BY 2");
                arrayList = new ArrayList<StudyTemplate>();
                while (dbConnection.next()) {
                    arrayList.add(new StudyTemplate(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getBoolean(3), dbConnection.getBoolean(4), dbConnection.getInt(5)));
                }
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(errorReporter, sQLException);
                arrayList = null;
            }
            dbConnection.close();
        }
        return arrayList;
    }

    public static int getTemplateKeyForName(DbConnection dbConnection, ErrorReporter errorReporter, String string) {
        int n = -1;
        if (dbConnection.connect(errorReporter)) {
            try {
                dbConnection.query("SELECT template_key FROM tvstudy.template WHERE UPPER(name) = '" + dbConnection.clean(string.toUpperCase()) + "'");
                n = dbConnection.next() ? dbConnection.getInt(1) : 0;
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(errorReporter, sQLException);
            }
            dbConnection.close();
        }
        return n;
    }

    public static Integer createNewTemplate(DbConnection dbConnection, ErrorReporter errorReporter, String string, boolean bl, StudyEditData studyEditData) {
        ArrayList<TemplateParameter> arrayList = new ArrayList<TemplateParameter>(studyEditData.parameters.size());
        for (ParameterEditData object2 : studyEditData.parameters) {
            arrayList.add(new TemplateParameter(object2));
        }
        ArrayList<IxRuleEditData> arrayList2 = studyEditData.ixRuleModel.getRows();
        ArrayList<TemplateIxRule> arrayList3 = new ArrayList<TemplateIxRule>(arrayList2.size());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            IxRuleEditData ixRuleEditData = (IxRuleEditData)iterator.next();
            arrayList3.add(new TemplateIxRule(ixRuleEditData));
        }
        return StudyTemplate.createNewTemplate(dbConnection, errorReporter, string, bl, arrayList, arrayList3);
    }

    public static Integer createNewTemplate(DbConnection dbConnection, ErrorReporter errorReporter, String string, boolean bl, ArrayList<TemplateParameter> arrayList, ArrayList<TemplateIxRule> arrayList2) {
        if (!dbConnection.connect(errorReporter)) {
            return null;
        }
        boolean bl2 = false;
        String string2 = "";
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        try {
            dbConnection.update("LOCK TABLES tvstudy.template WRITE, tvstudy.template_key_sequence WRITE");
            dbConnection.query("SELECT template_key FROM tvstudy.template WHERE UPPER(name) = '" + dbConnection.clean(string.toUpperCase()) + "'");
            if (!dbConnection.next()) {
                dbConnection.update("UPDATE tvstudy.template_key_sequence SET template_key = template_key + 1");
                dbConnection.query("SELECT template_key FROM tvstudy.template_key_sequence");
                dbConnection.next();
                n = dbConnection.getInt(1);
                dbConnection.update("INSERT INTO tvstudy.template (template_key, name, locked, locked_in_study, use_count) VALUES (" + n + ", " + "'" + dbConnection.clean(string) + "', " + "false, " + bl + ", " + "0" + ")");
                bl3 = true;
                dbConnection.update("UNLOCK TABLES");
                for (TemplateParameter object : arrayList) {
                    dbConnection.update("INSERT INTO tvstudy.template_parameter_data (template_key, parameter_key, value) VALUES (" + n + "," + object.key + "," + "'" + dbConnection.clean(object.value) + "')");
                    bl4 = true;
                }
                int n2 = 0;
                for (TemplateIxRule templateIxRule : arrayList2) {
                    dbConnection.update("INSERT INTO tvstudy.template_ix_rule (template_key, ix_rule_key, country_key, service_type_key, undesired_service_type_key, channel_delta_key, channel_band_key, frequency_offset, emission_mask_key, distance, required_du, undesired_time) VALUES (" + n + "," + ++n2 + "," + ((TemplateIxRule)templateIxRule).country.key + "," + ((TemplateIxRule)templateIxRule).serviceType.key + "," + ((TemplateIxRule)templateIxRule).undesiredServiceType.key + "," + ((TemplateIxRule)templateIxRule).channelDelta.key + "," + ((TemplateIxRule)templateIxRule).channelBand.key + "," + templateIxRule.frequencyOffset + "," + ((TemplateIxRule)templateIxRule).emissionMask.key + "," + templateIxRule.distance + "," + templateIxRule.requiredDU + "," + templateIxRule.undesiredTime + ")");
                    bl5 = true;
                }
            } else {
                bl2 = true;
                string2 = "Template name '" + string + "' already exists.";
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
            bl2 = true;
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
        }
        try {
            dbConnection.update("UNLOCK TABLES");
            if (bl2) {
                if (bl3) {
                    dbConnection.update("DELETE FROM tvstudy.template WHERE template_key = " + n);
                }
                if (bl4) {
                    dbConnection.update("DELETE FROM tvstudy.template_parameter_data WHERE template_key = " + n);
                }
                if (bl5) {
                    dbConnection.update("DELETE FROM tvstudy.template_ix_rule WHERE template_key = " + n);
                }
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
        }
        dbConnection.close();
        if (bl2) {
            errorReporter.reportError(string2);
            return null;
        }
        return new Integer(n);
    }

    public static boolean deleteTemplate(DbConnection dbConnection, ErrorReporter errorReporter, int n) {
        if (!dbConnection.connect(errorReporter)) {
            return false;
        }
        boolean bl = false;
        String string = "";
        try {
            dbConnection.update("LOCK TABLES tvstudy.template WRITE");
            dbConnection.query("SELECT locked, use_count FROM tvstudy.template WHERE template_key = " + n);
            if (dbConnection.next()) {
                if (!dbConnection.getBoolean(1)) {
                    if (0 == dbConnection.getInt(2)) {
                        dbConnection.update("DELETE FROM tvstudy.template WHERE template_key = " + n);
                        dbConnection.update("UNLOCK TABLES");
                        dbConnection.update("DELETE FROM tvstudy.template_parameter_data WHERE template_key = " + n);
                        dbConnection.update("DELETE FROM tvstudy.template_ix_rule WHERE template_key = " + n);
                    } else {
                        bl = true;
                        string = "The template is in use by existing studies.";
                    }
                } else {
                    bl = true;
                    string = "The template is locked and cannot be deleted.";
                }
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
            bl = true;
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
        }
        dbConnection.close();
        if (bl) {
            errorReporter.reportError(string);
        }
        return !bl;
    }

    public static boolean writeTemplateToXML(DbConnection dbConnection, ErrorReporter errorReporter, int n, Writer writer) {
        if (!dbConnection.connect(errorReporter)) {
            return false;
        }
        boolean bl = false;
        String string = "";
        String string2 = "";
        boolean bl2 = false;
        ArrayList<TemplateParameter> arrayList = new ArrayList<TemplateParameter>();
        ArrayList<TemplateIxRule> arrayList2 = new ArrayList<TemplateIxRule>();
        try {
            dbConnection.update("LOCK TABLES tvstudy.template READ, tvstudy.template_parameter_data READ, tvstudy.template_ix_rule READ");
            dbConnection.query("SELECT locked, name, locked_in_study FROM tvstudy.template WHERE template_key = " + n);
            if (dbConnection.next()) {
                if (!dbConnection.getBoolean(1)) {
                    string2 = dbConnection.getString(2);
                    bl2 = dbConnection.getBoolean(3);
                    dbConnection.query("SELECT parameter_key, value FROM tvstudy.template_parameter_data WHERE template_key = " + n);
                    while (dbConnection.next()) {
                        TemplateParameter templateParameter = new TemplateParameter();
                        templateParameter.key = new Integer(dbConnection.getInt(1));
                        templateParameter.value = dbConnection.getString(2);
                        arrayList.add(templateParameter);
                    }
                    dbConnection.query("SELECT country_key, service_type_key, undesired_service_type_key, channel_delta_key, channel_band_key, frequency_offset, emission_mask_key, distance, required_du, undesired_time FROM tvstudy.template_ix_rule WHERE template_key = " + n);
                    DbConnection dbConnection2 = dbConnection.copy();
                    while (dbConnection.next()) {
                        TemplateIxRule templateIxRule = new TemplateIxRule();
                        templateIxRule.country = Country.getCountry(dbConnection2, dbConnection.getInt(1));
                        templateIxRule.serviceType = ServiceType.getServiceType(dbConnection2, dbConnection.getInt(2));
                        templateIxRule.undesiredServiceType = ServiceType.getServiceType(dbConnection2, dbConnection.getInt(3));
                        templateIxRule.channelDelta = ChannelDelta.getChannelDelta(dbConnection2, dbConnection.getInt(4));
                        if (null == templateIxRule.country || null == templateIxRule.serviceType || null == templateIxRule.undesiredServiceType || null == templateIxRule.channelDelta) continue;
                        templateIxRule.channelBand = ChannelBand.getChannelBand(dbConnection2, dbConnection.getInt(5));
                        templateIxRule.frequencyOffset = dbConnection.getInt(6);
                        templateIxRule.emissionMask = EmissionMask.getEmissionMask(dbConnection2, dbConnection.getInt(7));
                        templateIxRule.distance = dbConnection.getDouble(8);
                        templateIxRule.requiredDU = dbConnection.getDouble(9);
                        templateIxRule.undesiredTime = dbConnection.getInt(10);
                        arrayList2.add(templateIxRule);
                    }
                } else {
                    bl = true;
                    string = "The template is locked and cannot be exported.";
                }
            } else {
                bl = true;
                string = "The template does not exist.";
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
            bl = true;
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
        }
        dbConnection.close();
        if (bl) {
            errorReporter.reportError(string);
            return false;
        }
        try {
            writer.append("<TEMPLATE NAME=\"" + string2 + "\" LOCKED=\"" + bl2 + "\">\n");
            for (TemplateParameter object : arrayList) {
                writer.append("<PARAMETER KEY=\"" + object.key + "\">" + object.value + "</PARAMETER>\n");
            }
            for (TemplateIxRule templateIxRule : arrayList2) {
                writer.append("<RULE COUNTRY=\"" + ((TemplateIxRule)templateIxRule).country.key + '\"');
                writer.append(" DSERVICE=\"" + ((TemplateIxRule)templateIxRule).serviceType.key + '\"');
                writer.append(" USERVICE=\"" + ((TemplateIxRule)templateIxRule).undesiredServiceType.key + '\"');
                writer.append(" CHANNEL=\"" + ((TemplateIxRule)templateIxRule).channelDelta.delta + '\"');
                if (((TemplateIxRule)templateIxRule).channelBand.key > 0) {
                    writer.append(" BAND=\"" + ((TemplateIxRule)templateIxRule).channelBand.key + '\"');
                }
                if (templateIxRule.frequencyOffset > 0) {
                    writer.append(" OFFSET=\"" + templateIxRule.frequencyOffset + '\"');
                }
                if (((TemplateIxRule)templateIxRule).emissionMask.key > 0) {
                    writer.append(" MASK=\"" + ((TemplateIxRule)templateIxRule).emissionMask.key + '\"');
                }
                writer.append(" DISTANCE=\"" + AppManager.formatDistance(templateIxRule.distance) + '\"');
                writer.append(" DU=\"" + AppManager.formatDU(templateIxRule.requiredDU) + '\"');
                writer.append(" UTIME=\"" + templateIxRule.undesiredTime + "\"/>\n");
            }
            writer.append("</TEMPLATE>\n");
        }
        catch (IOException iOException) {
            errorReporter.reportError("Could not write to the file:\n" + iOException.getMessage());
            return false;
        }
        return true;
    }

    public static Integer readTemplateFromXML(DbConnection dbConnection, Reader reader, ErrorReporter errorReporter) {
        TemplateXMLHandler templateXMLHandler;
        block2: {
            templateXMLHandler = new TemplateXMLHandler(dbConnection, errorReporter);
            try {
                XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                xMLReader.setContentHandler(templateXMLHandler);
                xMLReader.parse(new InputSource(reader));
            }
            catch (Throwable throwable) {
                String string = throwable.getMessage();
                if (null == string || string.length() <= 0) break block2;
                errorReporter.reportError("XML error: " + string);
            }
        }
        return templateXMLHandler.templateKey;
    }

    private static class TemplateXMLHandler
    extends DefaultHandler {
        private DbConnection db;
        private ErrorReporter errors;
        private String templateName;
        private boolean isLockedInStudy;
        private ArrayList<TemplateParameter> parameters;
        private ArrayList<TemplateIxRule> ixRules;
        private TemplateParameter parameter;
        private TemplateIxRule ixRule;
        private ArrayDeque<String> elements;
        private ArrayDeque<StringWriter> buffers;
        private Integer templateKey;

        private TemplateXMLHandler(DbConnection dbConnection, ErrorReporter errorReporter) {
            this.db = dbConnection;
            this.errors = errorReporter;
            this.parameters = new ArrayList();
            this.ixRules = new ArrayList();
            this.elements = new ArrayDeque();
            this.buffers = new ArrayDeque();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.elements.push(string3);
            this.buffers.push(new StringWriter());
            if (string3.equals("TEMPLATE")) {
                if (this.templateName != null) {
                    this.errors.reportError("TEMPLATE elements may not be nested");
                    throw new SAXException();
                }
                this.templateName = attributes.getValue("NAME");
                if (null == this.templateName) {
                    this.errors.reportError("Missing NAME attribute in TEMPLATE tag");
                    throw new SAXException();
                }
                String string4 = attributes.getValue("LOCKED");
                this.isLockedInStudy = null != string4 && Boolean.valueOf(string4) != false;
                return;
            }
            if (string3.equals("PARAMETER")) {
                if (null == this.templateName) {
                    this.errors.reportError("PARAMETER element must be inside a TEMPLATE element");
                    throw new SAXException();
                }
                if (null != this.parameter) {
                    this.errors.reportError("PARAMETER elements cannot be nested");
                    throw new SAXException();
                }
                int n = 0;
                String string5 = attributes.getValue("KEY");
                if (null != string5) {
                    try {
                        n = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n <= 0) {
                    this.errors.reportError("Missing or bad KEY attribute in PARAMETER tag");
                    throw new SAXException();
                }
                for (TemplateParameter templateParameter : this.parameters) {
                    if (n != templateParameter.key) continue;
                    this.errors.reportError("Duplicate parameter key in template");
                    throw new SAXException();
                }
                this.parameter = new TemplateParameter();
                this.parameter.key = new Integer(n);
                return;
            }
            if (string3.equals("RULE")) {
                if (null == this.templateName) {
                    this.errors.reportError("RULE element must be inside a TEMPLATE element");
                    throw new SAXException();
                }
                if (null != this.ixRule) {
                    this.errors.reportError("RULE elements cannot be nested");
                    throw new SAXException();
                }
                this.ixRule = new TemplateIxRule();
                String string6 = attributes.getValue("COUNTRY");
                if (null != string6) {
                    try {
                        this.ixRule.country = Country.getCountry(this.db, Integer.parseInt(string6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (null == this.ixRule.country) {
                    this.errors.reportError("Missing or bad COUNTRY attribute in RULE tag");
                    throw new SAXException();
                }
                string6 = attributes.getValue("DSERVICE");
                if (null != string6) {
                    try {
                        this.ixRule.serviceType = ServiceType.getServiceType(this.db, Integer.parseInt(string6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (null == this.ixRule.serviceType) {
                    this.errors.reportError("Missing or bad DSERVICE attribute in RULE tag");
                    throw new SAXException();
                }
                string6 = attributes.getValue("USERVICE");
                if (null != string6) {
                    try {
                        this.ixRule.undesiredServiceType = ServiceType.getServiceType(this.db, Integer.parseInt(string6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (null == this.ixRule.undesiredServiceType) {
                    this.errors.reportError("Missing or bad USERVICE attribute in RULE tag");
                    throw new SAXException();
                }
                string6 = attributes.getValue("CHANNEL");
                if (null != string6) {
                    try {
                        this.ixRule.channelDelta = ChannelDelta.getChannelDeltaByDelta(this.db, Integer.parseInt(string6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (null == this.ixRule.channelDelta) {
                    this.errors.reportError("Missing or bad CHANNEL attribute in RULE tag");
                    throw new SAXException();
                }
                string6 = attributes.getValue("BAND");
                if (null != string6) {
                    try {
                        this.ixRule.channelBand = ChannelBand.getChannelBand(this.db, Integer.parseInt(string6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (null == this.ixRule.channelBand) {
                        this.errors.reportError("Bad BAND attribute in RULE tag");
                        throw new SAXException();
                    }
                } else {
                    this.ixRule.channelBand = ChannelBand.getNullObject();
                }
                if (null != (string6 = attributes.getValue("OFFSET"))) {
                    try {
                        this.ixRule.frequencyOffset = Integer.parseInt(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (1 != this.ixRule.frequencyOffset && 2 != this.ixRule.frequencyOffset) {
                        this.errors.reportError("Bad OFFSET attribute in RULE tag");
                        throw new SAXException();
                    }
                }
                if (null != (string6 = attributes.getValue("MASK"))) {
                    try {
                        this.ixRule.emissionMask = EmissionMask.getEmissionMask(this.db, Integer.parseInt(string6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (null == this.ixRule.emissionMask) {
                        this.errors.reportError("Bad BAND attribute in RULE tag");
                        throw new SAXException();
                    }
                } else {
                    this.ixRule.emissionMask = EmissionMask.getNullObject();
                }
                this.ixRule.distance = 0.0;
                string6 = attributes.getValue("DISTANCE");
                if (null != string6) {
                    try {
                        this.ixRule.distance = Double.parseDouble(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.ixRule.distance < 1.0 || this.ixRule.distance > ((TemplateIxRule)this.ixRule).channelDelta.maximumDistance) {
                    this.errors.reportError("Missing or bad DISTANCE attribute in RULE tag");
                    throw new SAXException();
                }
                this.ixRule.requiredDU = -61.0;
                string6 = attributes.getValue("DU");
                if (null != string6) {
                    try {
                        this.ixRule.requiredDU = Double.parseDouble(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.ixRule.requiredDU < -60.0 || this.ixRule.requiredDU > 60.0) {
                    this.errors.reportError("Missing or bad DU attribute in RULE tag");
                    throw new SAXException();
                }
                this.ixRule.undesiredTime = 0;
                string6 = attributes.getValue("UTIME");
                if (null != string6) {
                    try {
                        this.ixRule.undesiredTime = Integer.parseInt(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.ixRule.undesiredTime < 1 || this.ixRule.undesiredTime > 99) {
                    this.errors.reportError("Missing or bad UTIME attribute in RULE tag");
                    throw new SAXException();
                }
                return;
            }
            this.errors.reportError("Unknown element '" + string3 + "'");
            throw new SAXException();
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (!this.buffers.isEmpty()) {
                this.buffers.peek().write(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            String string4 = this.elements.pop();
            String string5 = this.buffers.pop().toString().trim();
            if (!string4.equals(string3)) {
                this.errors.reportError("Overlapping elements not allowed");
                throw new SAXException();
            }
            if (string4.equals("TEMPLATE")) {
                if (this.parameters.isEmpty() || this.ixRules.isEmpty()) {
                    this.errors.reportError("TEMPLATE element must contain parameters and rules");
                    throw new SAXException();
                }
                this.templateKey = StudyTemplate.createNewTemplate(this.db, this.errors, this.templateName, this.isLockedInStudy, this.parameters, this.ixRules);
                if (null == this.templateKey) {
                    throw new SAXException();
                }
                this.templateName = null;
                this.isLockedInStudy = false;
                this.parameters.clear();
                this.ixRules.clear();
                this.parameter = null;
                this.ixRule = null;
                return;
            }
            if (string4.equals("PARAMETER")) {
                this.parameter.value = string5.trim();
                if (0 == this.parameter.value.length()) {
                    this.errors.reportError("PARAMETER element must have non-empty content");
                    throw new SAXException();
                }
                this.parameters.add(this.parameter);
                this.parameter = null;
                return;
            }
            if (string4.equals("RULE")) {
                this.ixRules.add(this.ixRule);
                this.ixRule = null;
                return;
            }
        }
    }

    private static class TemplateIxRule {
        private Country country;
        private ServiceType serviceType;
        private ServiceType undesiredServiceType;
        private ChannelDelta channelDelta;
        private ChannelBand channelBand;
        private int frequencyOffset;
        private EmissionMask emissionMask;
        private double distance;
        private double requiredDU;
        private int undesiredTime;

        private TemplateIxRule() {
        }

        private TemplateIxRule(IxRuleEditData ixRuleEditData) {
            this.country = ixRuleEditData.country;
            this.serviceType = ixRuleEditData.serviceType;
            this.undesiredServiceType = ixRuleEditData.undesiredServiceType;
            this.channelDelta = ixRuleEditData.channelDelta;
            this.channelBand = ixRuleEditData.channelBand;
            this.frequencyOffset = ixRuleEditData.frequencyOffset;
            this.emissionMask = ixRuleEditData.emissionMask;
            this.distance = ixRuleEditData.distance;
            this.requiredDU = ixRuleEditData.requiredDU;
            this.undesiredTime = ixRuleEditData.undesiredTime;
        }
    }

    private static class TemplateParameter {
        private int key;
        private String value;

        private TemplateParameter() {
        }

        private TemplateParameter(ParameterEditData parameterEditData) {
            this.key = parameterEditData.parameter.key;
            this.value = parameterEditData.value;
        }
    }
}

