/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editdata;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.IxRule;
import gov.fcc.tvstudy.data.Parameter;
import gov.fcc.tvstudy.data.Scenario;
import gov.fcc.tvstudy.data.Source;
import gov.fcc.tvstudy.data.Study;
import gov.fcc.tvstudy.editdata.CDBSRecord;
import gov.fcc.tvstudy.editdata.IxRuleEditData;
import gov.fcc.tvstudy.editdata.IxRuleTableModel;
import gov.fcc.tvstudy.editdata.ParameterEditData;
import gov.fcc.tvstudy.editdata.ScenarioEditData;
import gov.fcc.tvstudy.editdata.ScenarioTableModel;
import gov.fcc.tvstudy.editdata.SourceEditData;
import gov.fcc.tvstudy.editdata.SourceTableModel;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class StudyEditData {
    public static final int XML_VERSION = 103000;
    public final String dbID;
    public Study study;
    public double kilometersPerDegree;
    public double ruleExtraDistance;
    public double coChannelMxDistance;
    public int minimumChannel;
    public int maximumChannel;
    public boolean trustPatternFlag;
    public boolean useGenericVpatForCanada;
    public double defaultMexicanDigitalVloERP;
    public double defaultMexicanDigitalVloHAAT;
    public double defaultMexicanDigitalVhiERP;
    public double defaultMexicanDigitalVhiHAAT;
    public double defaultMexicanDigitalUhfERP;
    public double defaultMexicanDigitalUhfHAAT;
    public double defaultMexicanAnalogVloERP;
    public double defaultMexicanAnalogVloHAAT;
    public double defaultMexicanAnalogVhiERP;
    public double defaultMexicanAnalogVhiHAAT;
    public double defaultMexicanAnalogUhfERP;
    public double defaultMexicanAnalogUhfHAAT;
    public boolean checkIndividualDTSDistance;
    private boolean studyParametersSet;
    private boolean studyParametersBad;
    private int newIxRuleKey;
    private int newScenarioKey;
    private int newSourceKey;
    private boolean[] sourceKeyMap;
    public String name;
    public String description;
    public final ArrayList<ParameterEditData> parameters;
    public final IxRuleTableModel ixRuleModel;
    private HashMap<Integer, SourceEditData> sources;
    private HashSet<Integer> addedSourceKeys;
    private HashSet<Integer> deletedSourceKeys;
    private ArrayList<SourceEditData> changedSources;
    private ArrayList<Integer> replicationOriginalKeys;
    private HashMap<Integer, SourceEditData> sharedSources;
    private ArrayList<HashMap<Integer, SourceEditData>> sharedReplicationSources;
    public final ScenarioTableModel scenarioModel;
    private boolean invalidated;
    private boolean didUpdateLegacyDTS;
    private boolean hasContourChannel;

    /*
     * WARNING - void declaration
     */
    public StudyEditData(String string, Study study, ArrayList<ParameterEditData> arrayList) {
        this.dbID = string;
        this.study = study;
        this.newIxRuleKey = 0;
        for (IxRule object2 : this.study.ixRules) {
            if (object2.key <= this.newIxRuleKey) continue;
            this.newIxRuleKey = object2.key;
        }
        this.newScenarioKey = 0;
        for (Scenario scenario : this.study.scenarios) {
            if (scenario.key <= this.newScenarioKey) continue;
            this.newScenarioKey = scenario.key;
        }
        this.sourceKeyMap = new boolean[65536];
        this.updateSourceKeyMap();
        this.name = this.study.name;
        this.description = this.study.description;
        this.parameters = new ArrayList();
        HashMap hashMap = new HashMap();
        if (null != arrayList) {
            for (ParameterEditData parameterEditData : arrayList) {
                hashMap.put(new Integer(parameterEditData.parameter.key), parameterEditData);
            }
        }
        for (Parameter parameter : this.study.parameters) {
            void var5_13;
            ParameterEditData parameterEditData = (ParameterEditData)hashMap.get(new Integer(parameter.key));
            if (null == parameterEditData) {
                ParameterEditData parameterEditData2 = new ParameterEditData(parameter, this.study.templateLocked);
            }
            this.parameters.add((ParameterEditData)var5_13);
        }
        this.ixRuleModel = new IxRuleTableModel(this, this.study.ixRules);
        this.sources = new HashMap();
        for (Source source : this.study.sources) {
            SourceEditData sourceEditData = new SourceEditData(this, source);
            this.sources.put(sourceEditData.key, sourceEditData);
        }
        this.addedSourceKeys = new HashSet();
        this.deletedSourceKeys = new HashSet();
        this.changedSources = new ArrayList();
        this.replicationOriginalKeys = new ArrayList();
        this.sharedSources = new HashMap();
        int n = 68;
        this.sharedReplicationSources = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.sharedReplicationSources.add(new HashMap());
        }
        this.rebuildSourceIndex();
        this.scenarioModel = new ScenarioTableModel(this, this.study.scenarios);
    }

    public String toString() {
        return this.name;
    }

    public synchronized void invalidate() {
        this.invalidated = true;
    }

    public synchronized Integer getNewIxRuleKey() {
        if (++this.newIxRuleKey <= 0) {
            this.newIxRuleKey = -1;
            throw new RuntimeException("Interference rule key range exhausted");
        }
        return new Integer(this.newIxRuleKey);
    }

    public synchronized Integer getNewScenarioKey() {
        if (++this.newScenarioKey <= 0) {
            this.newScenarioKey = -1;
            throw new RuntimeException("Scenario key range exhausted");
        }
        return new Integer(this.newScenarioKey);
    }

    public synchronized Integer getNewSourceKey() {
        int n = this.newSourceKey;
        do {
            if (++this.newSourceKey <= 65535) continue;
            this.newSourceKey = 1;
        } while (this.sourceKeyMap[this.newSourceKey] && this.newSourceKey != n);
        if (this.newSourceKey == n) {
            return null;
        }
        this.sourceKeyMap[this.newSourceKey] = true;
        return new Integer(this.newSourceKey);
    }

    private void updateSourceKeyMap() {
        this.sourceKeyMap[0] = true;
        for (int i = 1; i < 65536; ++i) {
            this.sourceKeyMap[i] = false;
        }
        this.newSourceKey = 0;
        for (Source source : this.study.sources) {
            if (source.key > this.newSourceKey) {
                this.newSourceKey = source.key;
            }
            this.sourceKeyMap[source.key] = true;
            if (!source.isParent) continue;
            for (Source source2 : source.dtsSources) {
                if (source2.key > this.newSourceKey) {
                    this.newSourceKey = source2.key;
                }
                this.sourceKeyMap[source2.key] = true;
            }
        }
    }

    public String getStringParameter(int n) {
        ParameterEditData parameterEditData = this.findParameter(n);
        if (null == parameterEditData) {
            return null;
        }
        return parameterEditData.value;
    }

    public Integer getIntegerParameter(int n) {
        ParameterEditData parameterEditData = this.findParameter(n);
        if (null == parameterEditData || parameterEditData.parameter.type != 2 && parameterEditData.parameter.type != 5) {
            return null;
        }
        return new Integer(parameterEditData.integerValue);
    }

    public Double getDecimalParameter(int n) {
        ParameterEditData parameterEditData = this.findParameter(n);
        if (null == parameterEditData || parameterEditData.parameter.type != 3) {
            return null;
        }
        return new Double(parameterEditData.decimalValue);
    }

    public Boolean getOptionParameter(int n) {
        ParameterEditData parameterEditData = this.findParameter(n);
        if (null == parameterEditData || parameterEditData.parameter.type != 4) {
            return null;
        }
        return new Boolean(parameterEditData.optionValue);
    }

    private ParameterEditData findParameter(int n) {
        for (ParameterEditData parameterEditData : this.parameters) {
            if (n != parameterEditData.parameter.key) continue;
            return parameterEditData;
        }
        return null;
    }

    public boolean setStudyParameters(ErrorReporter errorReporter) {
        if (!this.studyParametersSet) {
            this.studyParametersSet = true;
            Double d = this.getDecimalParameter(200);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.kilometersPerDegree = d;
            }
            d = this.getDecimalParameter(210);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.ruleExtraDistance = d;
            }
            d = this.getDecimalParameter(212);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.coChannelMxDistance = d;
            }
            Integer n = this.getIntegerParameter(324);
            if (null == n) {
                this.studyParametersBad = true;
                this.minimumChannel = 2;
            } else {
                this.minimumChannel = n;
                if (this.minimumChannel < 2) {
                    this.minimumChannel = 2;
                }
                if (this.minimumChannel > 69) {
                    this.minimumChannel = 69;
                }
            }
            n = this.getIntegerParameter(325);
            if (null == n) {
                this.studyParametersBad = true;
                this.maximumChannel = 69;
            } else {
                int n2 = n;
                if (n2 < 2) {
                    n2 = 2;
                }
                if (n2 > 69) {
                    n2 = 69;
                }
                if (n2 >= this.minimumChannel) {
                    this.maximumChannel = n2;
                } else {
                    this.maximumChannel = this.minimumChannel;
                    this.minimumChannel = n2;
                }
            }
            Boolean bl = this.getOptionParameter(18);
            if (null == bl) {
                this.studyParametersBad = true;
            } else {
                this.trustPatternFlag = bl;
            }
            bl = this.getOptionParameter(219);
            if (null == bl) {
                this.studyParametersBad = true;
            } else {
                this.useGenericVpatForCanada = bl;
            }
            d = this.getDecimalParameter(220);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.defaultMexicanDigitalVloERP = d;
            }
            d = this.getDecimalParameter(221);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.defaultMexicanDigitalVloHAAT = d;
            }
            d = this.getDecimalParameter(222);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.defaultMexicanDigitalVhiERP = d;
            }
            d = this.getDecimalParameter(223);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.defaultMexicanDigitalVhiHAAT = d;
            }
            d = this.getDecimalParameter(224);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.defaultMexicanDigitalUhfERP = d;
            }
            d = this.getDecimalParameter(225);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.defaultMexicanDigitalUhfHAAT = d;
            }
            d = this.getDecimalParameter(226);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.defaultMexicanAnalogVloERP = d;
            }
            d = this.getDecimalParameter(227);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.defaultMexicanAnalogVloHAAT = d;
            }
            d = this.getDecimalParameter(228);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.defaultMexicanAnalogVhiERP = d;
            }
            Double d2 = this.getDecimalParameter(229);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.defaultMexicanAnalogVhiHAAT = d;
            }
            d = this.getDecimalParameter(230);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.defaultMexicanAnalogUhfERP = d;
            }
            d = this.getDecimalParameter(231);
            if (null == d) {
                this.studyParametersBad = true;
            } else {
                this.defaultMexicanAnalogUhfHAAT = d;
            }
            bl = this.getOptionParameter(326);
            if (null == bl) {
                this.studyParametersBad = true;
            } else {
                this.checkIndividualDTSDistance = bl;
            }
        }
        if (this.studyParametersBad) {
            if (null != errorReporter) {
                errorReporter.reportError("Required study parameters not found, the study database is damaged.");
            }
            return false;
        }
        return true;
    }

    public synchronized void addOrReplaceSource(SourceEditData sourceEditData) {
        if (null == this.sources.put(sourceEditData.key, sourceEditData)) {
            if (!this.deletedSourceKeys.remove(sourceEditData.key)) {
                this.addedSourceKeys.add(sourceEditData.key);
            }
            if (null != sourceEditData.originalSourceKey) {
                this.replicationOriginalKeys.add(sourceEditData.originalSourceKey);
            }
        }
        if (sourceEditData.isLocked && null != sourceEditData.application_id) {
            if (null == sourceEditData.originalSourceKey) {
                this.sharedSources.put(sourceEditData.application_id, sourceEditData);
            } else {
                SourceEditData sourceEditData2 = this.sources.get(sourceEditData.originalSourceKey);
                if (null != sourceEditData2 && sourceEditData2.isLocked) {
                    this.sharedReplicationSources.get(sourceEditData.channel - 2).put(sourceEditData.application_id, sourceEditData);
                }
            }
        }
    }

    public synchronized SourceEditData getSource(Integer n) {
        return this.sources.get(n);
    }

    public synchronized SourceEditData findSharedSource(Integer n) {
        return this.sharedSources.get(n);
    }

    public synchronized SourceEditData findSharedReplicationSource(Integer n, int n2) {
        return this.sharedReplicationSources.get(n2 - 2).get(n);
    }

    public synchronized void removeSource(SourceEditData sourceEditData) {
        if (sourceEditData.isLocked && null != sourceEditData.application_id) {
            if (null == sourceEditData.originalSourceKey) {
                return;
            }
            SourceEditData sourceEditData2 = this.sources.get(sourceEditData.originalSourceKey);
            if (null != sourceEditData2 && sourceEditData2.isLocked) {
                return;
            }
        }
        if (this.replicationOriginalKeys.contains(sourceEditData.key)) {
            return;
        }
        if (null != this.sources.remove(sourceEditData.key)) {
            if (!this.addedSourceKeys.remove(sourceEditData.key)) {
                this.deletedSourceKeys.add(sourceEditData.key);
            }
            if (null != sourceEditData.originalSourceKey) {
                this.replicationOriginalKeys.remove(sourceEditData.originalSourceKey);
            }
        }
    }

    public synchronized void removeAllUnusedSources() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (ScenarioEditData object : this.scenarioModel.getRows()) {
            for (SourceEditData sourceEditData : object.sourceModel.getSources()) {
                hashSet.add(sourceEditData.key);
                if (null == sourceEditData.originalSourceKey) continue;
                hashSet.add(sourceEditData.originalSourceKey);
            }
        }
        Iterator<Object> iterator = this.sources.values().iterator();
        while (iterator.hasNext()) {
            SourceEditData sourceEditData = (SourceEditData)iterator.next();
            if (hashSet.contains(sourceEditData.key)) continue;
            iterator.remove();
            if (this.addedSourceKeys.remove(sourceEditData.key)) continue;
            this.deletedSourceKeys.add(sourceEditData.key);
        }
        this.rebuildSourceIndex();
    }

    public synchronized int getUnusedSourceCount() {
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (ScenarioEditData object : this.scenarioModel.getRows()) {
            for (SourceEditData sourceEditData : object.sourceModel.getSources()) {
                hashSet.add(sourceEditData.key);
                if (null == sourceEditData.originalSourceKey) continue;
                hashSet.add(sourceEditData.originalSourceKey);
            }
        }
        for (SourceEditData sourceEditData : this.sources.values()) {
            if (hashSet.contains(sourceEditData.key)) continue;
            ++n;
        }
        return n;
    }

    private void rebuildSourceIndex() {
        this.replicationOriginalKeys.clear();
        this.sharedSources.clear();
        for (HashMap<Integer, SourceEditData> object : this.sharedReplicationSources) {
            object.clear();
        }
        for (SourceEditData sourceEditData : this.sources.values()) {
            if (null != sourceEditData.originalSourceKey) {
                this.replicationOriginalKeys.add(sourceEditData.originalSourceKey);
            }
            if (!sourceEditData.isLocked || null == sourceEditData.application_id) continue;
            if (null == sourceEditData.originalSourceKey) {
                this.sharedSources.put(sourceEditData.application_id, sourceEditData);
                continue;
            }
            SourceEditData sourceEditData2 = this.sources.get(sourceEditData.originalSourceKey);
            if (null == sourceEditData2 || !sourceEditData2.isLocked) continue;
            this.sharedReplicationSources.get(sourceEditData.channel - 2).put(sourceEditData.application_id, sourceEditData);
        }
    }

    public boolean isDataValid(ErrorReporter errorReporter) {
        if (this.invalidated) {
            errorReporter.reportError("Object has been invalidated.");
            return false;
        }
        if (!this.ixRuleModel.isDataValid(errorReporter)) {
            return false;
        }
        return this.scenarioModel.isDataValid(errorReporter);
    }

    public boolean isDataChanged() {
        if (this.invalidated) {
            return false;
        }
        boolean bl = false;
        if (this.ixRuleModel.isDataChanged()) {
            bl = true;
        }
        if (this.scenarioModel.isDataChanged()) {
            bl = true;
        }
        this.changedSources.clear();
        for (SourceEditData object : this.sources.values()) {
            if (!object.isDataChanged() && !this.addedSourceKeys.contains(object.key)) continue;
            this.changedSources.add(object);
            bl = true;
        }
        if (bl) {
            return true;
        }
        if (!this.deletedSourceKeys.isEmpty()) {
            return true;
        }
        for (ParameterEditData parameterEditData : this.parameters) {
            if (!parameterEditData.isDataChanged()) continue;
            return true;
        }
        if (this.study.newStudy || this.study.needsUpdate) {
            return true;
        }
        if (!this.name.equals(this.study.name)) {
            return true;
        }
        return !this.description.equals(this.study.description);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean save(DbConnection dbConnection, ErrorReporter errorReporter) {
        if (this.invalidated) {
            errorReporter.reportError("Study save failed, object has been invalidated.");
            return false;
        }
        if (dbConnection.connect(errorReporter)) {
            try {
                boolean bl = false;
                String string = "";
                dbConnection.query("SELECT study_lock, lock_count FROM tvstudy.study WHERE study_key = " + this.study.key);
                if (dbConnection.next()) {
                    if (1 != dbConnection.getInt(1) || this.study.lockCount != dbConnection.getInt(2)) {
                        bl = true;
                        string = "Study save failed, lock has been modified.";
                    }
                } else {
                    bl = true;
                    string = "Study save failed, study does not exist.";
                }
                if (bl) {
                    dbConnection.close();
                    errorReporter.reportError(string);
                    return false;
                }
                dbConnection.update("USE tvstudy_" + this.study.key);
                if (this.didUpdateLegacyDTS) {
                    dbConnection.update("ALTER TABLE source DROP COLUMN dts_latitude");
                    dbConnection.update("ALTER TABLE source DROP COLUMN dts_longitude");
                    if (this.hasContourChannel) {
                        dbConnection.update("ALTER TABLE source DROP COLUMN dts_contour_channel");
                    }
                    this.didUpdateLegacyDTS = false;
                    this.hasContourChannel = false;
                }
                boolean bl2 = false;
                for (ParameterEditData object22 : this.parameters) {
                    if (!object22.isDataChanged()) continue;
                    if (null == object22.parameter.value) {
                        dbConnection.update("INSERT INTO parameter_data ( parameter_key,value) VALUES (" + object22.parameter.key + "," + "'" + dbConnection.clean(object22.value) + "')");
                    } else {
                        dbConnection.update("UPDATE parameter_data SET value = '" + dbConnection.clean(object22.value) + "' " + "WHERE parameter_key = " + object22.parameter.key);
                    }
                    object22.didSave();
                    bl2 = true;
                }
                HashSet<Integer> hashSet = this.ixRuleModel.getDeletedKeys();
                if (!hashSet.isEmpty()) {
                    dbConnection.update("DELETE FROM ix_rule WHERE ix_rule_key IN " + this.makeKeyList(hashSet));
                    bl2 = true;
                }
                for (IxRuleEditData ixRuleEditData : this.ixRuleModel.getChangedRows()) {
                    if (null != ixRuleEditData.ixRule) {
                        dbConnection.update("DELETE FROM ix_rule WHERE ix_rule_key = " + ixRuleEditData.key);
                    }
                    dbConnection.update("INSERT INTO ix_rule (ix_rule_key,country_key,service_type_key,undesired_service_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time,is_active) VALUES (" + ixRuleEditData.key + "," + ixRuleEditData.country.key + "," + ixRuleEditData.serviceType.key + "," + ixRuleEditData.undesiredServiceType.key + "," + ixRuleEditData.channelDelta.key + "," + ixRuleEditData.channelBand.key + "," + ixRuleEditData.frequencyOffset + "," + ixRuleEditData.emissionMask.key + "," + ixRuleEditData.distance + "," + ixRuleEditData.requiredDU + "," + ixRuleEditData.undesiredTime + "," + ixRuleEditData.isActive + ")");
                    ixRuleEditData.didSave();
                    bl2 = true;
                }
                this.ixRuleModel.didSave();
                hashSet = this.scenarioModel.getDeletedKeys();
                if (!hashSet.isEmpty()) {
                    String string2 = this.makeKeyList(hashSet);
                    dbConnection.update("DELETE FROM scenario WHERE scenario_key IN " + string2);
                    dbConnection.update("DELETE FROM scenario_source WHERE scenario_key IN " + string2);
                }
                for (ScenarioEditData scenarioEditData : this.scenarioModel.getChangedRows()) {
                    if (null != scenarioEditData.scenario) {
                        dbConnection.update("DELETE FROM scenario WHERE scenario_key = " + scenarioEditData.key);
                        dbConnection.update("DELETE FROM scenario_source WHERE scenario_key = " + scenarioEditData.key);
                    }
                    dbConnection.update("INSERT INTO scenario (scenario_key, name, description) VALUES (" + scenarioEditData.key + "," + "'" + dbConnection.clean(scenarioEditData.name) + "'," + "'" + dbConnection.clean(scenarioEditData.description) + "')");
                    StringBuilder stringBuilder = new StringBuilder("INSERT INTO scenario_source (scenario_key, source_key, is_desired, is_undesired) VALUES");
                    String string3 = " (";
                    for (SourceTableModel.SourceItem sourceItem : scenarioEditData.sourceModel.getRows()) {
                        stringBuilder.append(string3 + scenarioEditData.key + "," + sourceItem.key + "," + sourceItem.isDesired + "," + sourceItem.isUndesired);
                        string3 = "),(";
                    }
                    stringBuilder.append(')');
                    dbConnection.update(stringBuilder.toString());
                    scenarioEditData.didSave();
                }
                this.scenarioModel.didSave();
                if (!this.deletedSourceKeys.isEmpty()) {
                    void var7_14;
                    String string4 = this.makeKeyList(this.deletedSourceKeys);
                    boolean bl3 = false;
                    dbConnection.query("SELECT source_key FROM source WHERE parent_source_key IN " + string4);
                    while (dbConnection.next()) {
                        this.deletedSourceKeys.add(new Integer(dbConnection.getInt(1)));
                        bl3 = true;
                    }
                    if (bl3) {
                        String string5 = this.makeKeyList(this.deletedSourceKeys);
                    }
                    dbConnection.update("DELETE FROM source_horizontal_pattern WHERE source_key IN " + (String)var7_14);
                    dbConnection.update("DELETE FROM source_vertical_pattern WHERE source_key IN " + (String)var7_14);
                    dbConnection.update("DELETE FROM source WHERE source_key IN " + (String)var7_14);
                }
                for (SourceEditData sourceEditData : this.changedSources) {
                    this.doSourceSave(dbConnection, sourceEditData);
                    if (sourceEditData.isParent) {
                        hashSet = sourceEditData.getDeletedDTSSourceKeys();
                        if (!hashSet.isEmpty()) {
                            String string6 = this.makeKeyList(hashSet);
                            dbConnection.update("DELETE FROM source_horizontal_pattern WHERE source_key IN " + string6);
                            dbConnection.update("DELETE FROM source_vertical_pattern WHERE source_key IN " + string6);
                            dbConnection.update("DELETE FROM source WHERE source_key IN " + string6);
                        }
                        for (SourceEditData sourceEditData2 : sourceEditData.getChangedDTSSources()) {
                            this.doSourceSave(dbConnection, sourceEditData2);
                            sourceEditData2.didSave();
                        }
                    }
                    sourceEditData.didSave();
                }
                this.addedSourceKeys.clear();
                this.deletedSourceKeys.clear();
                this.changedSources.clear();
                if (bl2) {
                    dbConnection.update("UPDATE source SET needs_update = true");
                }
                ArrayList arrayList = new ArrayList();
                for (ParameterEditData parameterEditData : this.parameters) {
                    arrayList.add(parameterEditData.parameter);
                }
                dbConnection.update("UPDATE tvstudy.study SET name = '" + dbConnection.clean(this.name) + "'," + "description = '" + dbConnection.clean(this.description) + "'," + "new_study = false," + "needs_update = false," + "parameter_summary = '" + dbConnection.clean(Parameter.makeParameterSummary(arrayList)) + "'" + "WHERE " + "study_key = " + this.study.key);
                ArrayList<Source> arrayList2 = new ArrayList<Source>();
                for (SourceEditData sourceEditData : this.sources.values()) {
                    arrayList2.add(sourceEditData.source);
                }
                this.study = new Study(this.study.key, this.name, this.description, this.study.studyLock, this.study.lockCount, false, false, this.study.templateKey, this.study.templateName, this.study.templateLocked, this.study.cdbsKey, this.study.cdbsName, arrayList, this.ixRuleModel.getRules(), arrayList2, this.scenarioModel.getScenarios());
                this.updateSourceKeyMap();
                Study.purgeStudyCache(this.dbID, this.study.key, this.sourceKeyMap);
            }
            catch (SQLException sQLException) {
                dbConnection.close();
                dbConnection.reportError(errorReporter, sQLException);
                return false;
            }
        } else {
            return false;
        }
        dbConnection.close();
        return true;
    }

    private String makeKeyList(HashSet<Integer> hashSet) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Integer n : hashSet) {
            if (bl) {
                stringBuilder.append('(');
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(n);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private void doSourceSave(DbConnection dbConnection, SourceEditData sourceEditData) throws SQLException {
        String string;
        StringBuilder stringBuilder;
        if (null != sourceEditData.source) {
            dbConnection.update("DELETE FROM source WHERE source_key=" + sourceEditData.key);
            if (sourceEditData.horizontalPatternChanged) {
                dbConnection.update("DELETE FROM source_horizontal_pattern WHERE source_key=" + sourceEditData.key);
            }
            if (sourceEditData.verticalPatternChanged) {
                dbConnection.update("DELETE FROM source_vertical_pattern WHERE source_key=" + sourceEditData.key);
            }
            if (sourceEditData.matrixPatternChanged) {
                dbConnection.update("DELETE FROM source_matrix_pattern WHERE source_key=" + sourceEditData.key);
            }
        }
        int n = 0;
        if (null != sourceEditData.source && null == sourceEditData.parentSourceKey) {
            n = sourceEditData.source.modCount + 1;
        }
        dbConnection.update("INSERT INTO source (source_key,needs_update,mod_count,facility_id,service_key,call_sign,channel,city,state,country_key,zone_key,status,file_number,frequency_offset_key,emission_mask_key,latitude,longitude,dts_maximum_distance,height_amsl,actual_height_amsl,height_agl,overall_haat,peak_erp,contour_erp,antenna_id,has_horizontal_pattern,horizontal_pattern_name,horizontal_pattern_orientation,has_vertical_pattern,vertical_pattern_name,vertical_pattern_electrical_tilt,vertical_pattern_mechanical_tilt,vertical_pattern_mechanical_tilt_orientation,has_matrix_pattern,matrix_pattern_name,use_generic_vertical_pattern,locked,application_id,site_number,original_source_key,parent_source_key) VALUES (" + sourceEditData.key + "," + "true," + n + "," + sourceEditData.facility_id + "," + sourceEditData.service.key + "," + "'" + dbConnection.clean(sourceEditData.callSign) + "'," + sourceEditData.channel + "," + "'" + dbConnection.clean(sourceEditData.city) + "'," + "'" + dbConnection.clean(sourceEditData.state) + "'," + sourceEditData.country.key + "," + sourceEditData.zone.key + "," + "'" + dbConnection.clean(sourceEditData.status) + "'," + "'" + dbConnection.clean(sourceEditData.fileNumber) + "'," + sourceEditData.frequencyOffset.key + "," + sourceEditData.emissionMask.key + "," + sourceEditData.latitude + "," + sourceEditData.longitude + "," + sourceEditData.dtsMaximumDistance + "," + sourceEditData.heightAMSL + "," + sourceEditData.heightAMSL + "," + "0," + sourceEditData.overallHAAT + "," + sourceEditData.peakERP + "," + 10.0 * Math.log10(sourceEditData.peakERP) + "," + sourceEditData.antenna_id + "," + sourceEditData.hasHorizontalPattern + "," + "'" + dbConnection.clean(sourceEditData.horizontalPatternName) + "'," + sourceEditData.horizontalPatternOrientation + "," + sourceEditData.hasVerticalPattern + "," + "'" + dbConnection.clean(sourceEditData.verticalPatternName) + "'," + sourceEditData.verticalPatternElectricalTilt + "," + sourceEditData.verticalPatternMechanicalTilt + "," + sourceEditData.verticalPatternMechanicalTiltOrientation + "," + sourceEditData.hasMatrixPattern + "," + "'" + dbConnection.clean(sourceEditData.matrixPatternName) + "'," + sourceEditData.useGenericVerticalPattern + "," + sourceEditData.isLocked + "," + (null == sourceEditData.application_id ? "0" : sourceEditData.application_id) + "," + sourceEditData.siteNumber + "," + (null == sourceEditData.originalSourceKey ? "0" : sourceEditData.originalSourceKey) + "," + (null == sourceEditData.parentSourceKey ? "0" : sourceEditData.parentSourceKey) + ")");
        if (sourceEditData.horizontalPatternChanged && null != sourceEditData.horizontalPattern) {
            stringBuilder = new StringBuilder("INSERT INTO source_horizontal_pattern (source_key,azimuth,relative_field) VALUES");
            string = " (";
            for (Source.PatternPoint object : sourceEditData.horizontalPattern) {
                stringBuilder.append(string + sourceEditData.key + "," + object.azimuthOrDepression + "," + object.relativeField);
                string = "),(";
            }
            stringBuilder.append(")");
            dbConnection.update(stringBuilder.toString());
        }
        if (sourceEditData.verticalPatternChanged && null != sourceEditData.verticalPattern) {
            stringBuilder = new StringBuilder("INSERT INTO source_vertical_pattern (source_key,depression_angle,relative_field) VALUES");
            string = " (";
            for (Source.PatternPoint patternPoint : sourceEditData.verticalPattern) {
                stringBuilder.append(string + sourceEditData.key + "," + patternPoint.azimuthOrDepression + "," + patternPoint.relativeField);
                string = "),(";
            }
            stringBuilder.append(")");
            dbConnection.update(stringBuilder.toString());
        }
        if (sourceEditData.matrixPatternChanged && null != sourceEditData.matrixPattern) {
            stringBuilder = new StringBuilder("INSERT INTO source_matrix_pattern (source_key,azimuth,depression_angle,relative_field) VALUES");
            string = " (";
            for (Source.PatternSlice patternSlice : sourceEditData.matrixPattern) {
                for (Source.PatternPoint patternPoint : patternSlice.pattern) {
                    stringBuilder.append(string + sourceEditData.key + "," + patternSlice.azimuth + "," + patternPoint.azimuthOrDepression + "," + patternPoint.relativeField);
                    string = "),(";
                }
            }
            stringBuilder.append(")");
            dbConnection.update(stringBuilder.toString());
        }
    }

    public void writeScenariosToXML(DbConnection dbConnection, Writer writer, ArrayList<ScenarioEditData> arrayList, ErrorReporter errorReporter) {
        try {
            writer.append("<TVSTUDY VERSION=\"103000\">\n");
            for (ScenarioEditData scenarioEditData : arrayList) {
                scenarioEditData.writeToXML(dbConnection, writer, errorReporter);
            }
            writer.append("</TVSTUDY>\n");
        }
        catch (IOException iOException) {
            errorReporter.reportError("Could not write to the file:\n" + iOException.getMessage());
        }
        catch (Throwable throwable) {
            errorReporter.reportError("An unexpected error occurred:\n" + throwable);
        }
    }

    public void readScenariosFromXML(DbConnection dbConnection, Reader reader, ErrorReporter errorReporter) {
        if (!this.setStudyParameters(errorReporter)) {
            return;
        }
        errorReporter.clearErrors();
        ScenarioXMLHandler scenarioXMLHandler = new ScenarioXMLHandler(this, dbConnection, errorReporter);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setContentHandler(scenarioXMLHandler);
            xMLReader.parse(new InputSource(reader));
        }
        catch (SAXException sAXException) {
            String string = sAXException.getMessage();
            if (null != string && string.length() > 0) {
                errorReporter.reportError("XML error: " + string);
            }
        }
        catch (Throwable throwable) {
            errorReporter.reportError("An unexpected error occurred:\n" + throwable);
        }
        this.rebuildSourceIndex();
    }

    public boolean updateIfNeeded(ErrorReporter errorReporter) {
        if (!this.study.needsUpdate) {
            return true;
        }
        boolean bl = false;
        DbConnection dbConnection = DbManager.getDb(this.dbID);
        if (dbConnection.connect(errorReporter)) {
            block7: {
                try {
                    dbConnection.update("USE tvstudy_" + this.study.key);
                    dbConnection.query("SHOW CREATE TABLE source");
                    dbConnection.next();
                    String string = dbConnection.getString(2);
                    if (!string.contains("dts_latitude") || !string.contains("dts_longitude")) break block7;
                    this.didUpdateLegacyDTS = true;
                    String string2 = "channel";
                    if (string.contains("dts_contour_channel")) {
                        this.hasContourChannel = true;
                        string2 = "dts_contour_channel";
                    }
                    DbConnection dbConnection2 = dbConnection.copy();
                    for (SourceEditData sourceEditData : this.sources.values()) {
                        if (!sourceEditData.isParent) continue;
                        dbConnection.query("SELECT " + string2 + ", dts_latitude, dts_longitude FROM source WHERE source_key = " + sourceEditData.key);
                        dbConnection.next();
                        if (sourceEditData.updateLegacyDTS(dbConnection2, dbConnection.getInt(1), dbConnection.getDouble(2), dbConnection.getDouble(3), errorReporter)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    bl = true;
                    dbConnection.reportError(errorReporter, sQLException);
                }
            }
            dbConnection.close();
        } else {
            bl = true;
        }
        return !bl;
    }

    private class ScenarioXMLHandler
    extends DefaultHandler {
        private StudyEditData study;
        private DbConnection db;
        private ErrorReporter errors;
        private int xmlVersion;
        private String scenarioName;
        private String scenarioDescription;
        private ArrayList<SourceTableModel.SourceItem> scenarioSourceItems;
        private ArrayList<SourceEditData> newSources;
        private HashMap<Integer, SourceEditData> newSharedSources;
        private ArrayList<HashMap<Integer, SourceEditData>> newSharedReplicationSources;
        private SourceEditData newSource;
        private SourceEditData newDTSSource;
        private boolean isDesired;
        private boolean isUndesired;
        private boolean isLegacyDTS;
        private int dtsContourChannel;
        private double dtsLatitude;
        private double dtsLongitude;
        private int replicateToChannel;
        private ArrayDeque<String> elements;
        private ArrayDeque<StringWriter> buffers;
        private Pattern patternParser;

        private ScenarioXMLHandler(StudyEditData studyEditData2, DbConnection dbConnection, ErrorReporter errorReporter) {
            this.study = studyEditData2;
            this.db = dbConnection;
            this.errors = errorReporter;
            this.scenarioSourceItems = new ArrayList();
            this.newSources = new ArrayList();
            this.newSharedSources = new HashMap(StudyEditData.this.sharedSources);
            this.newSharedReplicationSources = new ArrayList();
            for (HashMap hashMap : StudyEditData.this.sharedReplicationSources) {
                this.newSharedReplicationSources.add(new HashMap(hashMap));
            }
            this.elements = new ArrayDeque();
            this.buffers = new ArrayDeque();
            this.patternParser = Pattern.compile("[,\\n]");
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.elements.push(string3);
            this.buffers.push(new StringWriter());
            if (string3.equals("TVSTUDY")) {
                if (this.xmlVersion > 0) {
                    this.errors.reportError("TVSTUDY elements may not be nested.");
                    throw new SAXException();
                }
                String string4 = attributes.getValue("VERSION");
                if (null != string4) {
                    try {
                        this.xmlVersion = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.xmlVersion <= 0) {
                    this.errors.reportError("Missing or bad VERSION attribute in TVSTUDY tag.");
                    throw new SAXException();
                }
                if (this.xmlVersion > 103000) {
                    this.errors.reportError("Format version is not compatible.");
                    throw new SAXException();
                }
                return;
            }
            if (string3.equals("SCENARIO")) {
                if (this.scenarioName != null) {
                    this.errors.reportError("SCENARIO elements may not be nested.");
                    throw new SAXException();
                }
                this.scenarioName = attributes.getValue("NAME");
                if (null == this.scenarioName || !DbManager.checkScenarioName(this.scenarioName, this.study)) {
                    this.scenarioName = "imported_scenario";
                }
                return;
            }
            if (string3.equals("DESCRIPTION")) {
                if (this.scenarioName == null) {
                    this.errors.reportError("DESCRIPTION element must be inside a SCENARIO element.");
                    throw new SAXException();
                }
                return;
            }
            if (string3.equals("SOURCE")) {
                if (this.newSource != null) {
                    this.errors.reportError("SOURCE elements may not be nested.");
                    throw new SAXException();
                }
                String string5 = attributes.getValue("DESIRED");
                if (null == string5) {
                    string5 = attributes.getValue("STUDY");
                }
                this.isDesired = null == string5 || Boolean.valueOf(string5) != false;
                string5 = attributes.getValue("UNDESIRED");
                this.isUndesired = null == string5 || Boolean.valueOf(string5) != false;
                string5 = attributes.getValue("LOCKED");
                boolean bl = null == string5 || Boolean.valueOf(string5) != false;
                Integer n = null;
                string5 = attributes.getValue("CDBS_ID");
                if (null != string5) {
                    try {
                        n = Integer.valueOf(string5);
                        if (n <= 0) {
                            n = null;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (null == n) {
                        this.errors.reportError("Bad CDBS_ID attribute in SOURCE tag.");
                        throw new SAXException();
                    }
                    if (bl) {
                        this.newSource = this.newSharedSources.get(n);
                        if (null == this.newSource) {
                            this.newSource = CDBSRecord.findSource(this.db, this.study, n, true, this.errors);
                            if (null == this.newSource) {
                                if (this.errors.hasErrors()) {
                                    throw new SAXException();
                                }
                                return;
                            }
                            this.newSources.add(this.newSource);
                            this.newSharedSources.put(n, this.newSource);
                        }
                    }
                }
                if (null == this.newSource) {
                    if (0 == this.xmlVersion) {
                        string5 = attributes.getValue("DTS_LATITUDE");
                        String string6 = attributes.getValue("DTS_LONGITUDE");
                        if (null != string5 || null != string6) {
                            this.isLegacyDTS = true;
                            this.dtsLatitude = -74.0;
                            if (null != string5) {
                                this.dtsLatitude = AppManager.parseLatitude(string5);
                            }
                            if (this.dtsLatitude < -73.0 || this.dtsLatitude > 73.0) {
                                this.errors.reportError("Missing or bad DTS_LATITUDE attribute in SOURCE tag.");
                                throw new SAXException();
                            }
                            this.dtsLongitude = -181.0;
                            if (null != string6) {
                                this.dtsLongitude = AppManager.parseLongitude(string6);
                            }
                            if (this.dtsLongitude < -180.0 || this.dtsLongitude > 180.0) {
                                this.errors.reportError("Missing or bad DTS_LONGITUDE attribute in SOURCE tag.");
                                throw new SAXException();
                            }
                            string5 = attributes.getValue("DTS_CONTOUR_CHANNEL");
                            if (null != string5) {
                                try {
                                    this.dtsContourChannel = Integer.parseInt(string5);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (this.dtsContourChannel < 2 || this.dtsContourChannel > 69) {
                                    this.errors.reportError("Bad DTS_CONTOUR_CHANNEL attribute in SOURCE tag.");
                                    throw new SAXException();
                                }
                            }
                        }
                    }
                    this.newSource = SourceEditData.makeSourceWithAttributes(this.db, attributes, this.study, n, bl, this.isLegacyDTS, this.errors);
                    if (null == this.newSource) {
                        throw new SAXException();
                    }
                    if (this.newSource.channel < this.study.minimumChannel || this.newSource.channel > this.study.maximumChannel) {
                        this.errors.logMessage(CDBSRecord.makeMessage(this.newSource, "Ignored, channel out of range for study."));
                        this.newSource = null;
                        return;
                    }
                    this.newSources.add(this.newSource);
                }
                if (null != (string5 = attributes.getValue("REPLICATE"))) {
                    int n2 = 0;
                    try {
                        n2 = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n2 < 2 || n2 > 69) {
                        this.errors.reportError("Bad REPLICATE attribute in SOURCE tag.");
                        throw new SAXException();
                    }
                    if (n2 < this.study.minimumChannel || n2 > this.study.maximumChannel) {
                        this.errors.logMessage(CDBSRecord.makeMessage(this.newSource, "Replication channel out of range for study, reverting to original."));
                        return;
                    }
                    if (n2 != this.newSource.channel || !this.newSource.service.serviceType.digital) {
                        this.replicateToChannel = n2;
                    }
                }
                return;
            }
            if (string3.equals("DTS_SOURCE")) {
                if (null != this.newDTSSource) {
                    this.errors.reportError("DTS_SOURCE elements may not be nested.");
                    throw new SAXException();
                }
                if (null == this.newSource) {
                    this.errors.reportError("DTS_SOURCE element must be inside SOURCE element.");
                    throw new SAXException();
                }
                if (!this.newSource.isParent) {
                    this.errors.reportError("DTS_SOURCE not allowed in non-parent SOURCE element.");
                    throw new SAXException();
                }
                if (this.newSource.isLocked && null != this.newSource.application_id) {
                    this.errors.reportError("DTS_SOURCE not allowed in locked CDBS SOURCE element.");
                    throw new SAXException();
                }
                this.newDTSSource = this.newSource.addDTSSourceWithAttributes(this.db, attributes, this.isLegacyDTS, this.errors);
                if (null == this.newDTSSource) {
                    throw new SAXException();
                }
                return;
            }
            if (string3.equals("APAT") || string3.equals("EPAT") || string3.equals("MPAT")) {
                if (null == this.newSource) {
                    this.errors.reportError("APAT/EPAT/MPAT element must be inside SOURCE/DTS_SOURCE element.");
                    throw new SAXException();
                }
                if (this.newSource.isLocked && null != this.newSource.application_id) {
                    this.errors.reportError("APAT/EPAT/MPAT not allowed in locked CDBS SOURCE element.");
                    throw new SAXException();
                }
                return;
            }
            this.errors.reportError("Unknown element '" + string3 + "'.");
            throw new SAXException();
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (!this.buffers.isEmpty()) {
                this.buffers.peek().write(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            String string4 = this.elements.pop();
            String string5 = this.buffers.pop().toString().trim();
            if (!string4.equals(string3)) {
                this.errors.reportError("Overlapping elements not allowed.");
                throw new SAXException();
            }
            if (string4.equals("TVSTUDY")) {
                this.xmlVersion = 0;
                return;
            }
            if (string4.equals("SCENARIO")) {
                if (!this.scenarioSourceItems.isEmpty()) {
                    if (null == this.scenarioDescription) {
                        this.scenarioDescription = "Imported scenario";
                    }
                    for (SourceEditData sourceEditData : this.newSources) {
                        StudyEditData.this.sources.put(sourceEditData.key, sourceEditData);
                        StudyEditData.this.addedSourceKeys.add(sourceEditData.key);
                    }
                    StudyEditData.this.scenarioModel.addOrReplace(new ScenarioEditData(this.study, this.scenarioName, this.scenarioDescription, this.scenarioSourceItems));
                }
                this.scenarioName = null;
                this.scenarioDescription = null;
                this.scenarioSourceItems.clear();
                return;
            }
            if (string4.equals("DESCRIPTION")) {
                this.scenarioDescription = string5;
                return;
            }
            if (string4.equals("SOURCE")) {
                if (null == this.newSource) {
                    return;
                }
                if (this.newSource.isParent) {
                    if (this.isLegacyDTS && !this.newSource.updateLegacyDTS(this.db, this.dtsContourChannel, this.dtsLatitude, this.dtsLongitude, this.errors)) {
                        throw new SAXException();
                    }
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    for (SourceEditData sourceEditData : this.newSource.getDTSSources()) {
                        if (0 == sourceEditData.siteNumber) {
                            if (bl) {
                                bl3 = true;
                                break;
                            }
                            bl = true;
                            continue;
                        }
                        bl2 = true;
                    }
                    if (!bl || !bl2) {
                        bl3 = true;
                    }
                    if (bl3) {
                        this.errors.reportError("Incomplete or invalid set of DTS_SOURCE elements within SOURCE element.");
                        throw new SAXException();
                    }
                }
                if (this.replicateToChannel > 0) {
                    SourceEditData sourceEditData = this.newSource;
                    this.newSource = null;
                    if (sourceEditData.isLocked && null != sourceEditData.application_id) {
                        this.newSource = this.newSharedReplicationSources.get(this.replicateToChannel - 2).get(sourceEditData.application_id);
                    }
                    if (null == this.newSource) {
                        this.newSource = sourceEditData.replicate(this.replicateToChannel, this.errors);
                        if (null == this.newSource) {
                            throw new SAXException();
                        }
                        this.newSources.add(this.newSource);
                        if (sourceEditData.isLocked && null != sourceEditData.application_id) {
                            this.newSharedReplicationSources.get(this.replicateToChannel - 2).put(sourceEditData.application_id, this.newSource);
                        }
                    }
                }
                this.scenarioSourceItems.add(new SourceTableModel.SourceItem(this.newSource, this.isDesired, this.isUndesired));
                this.newSource = null;
                this.isDesired = false;
                this.isUndesired = false;
                this.isLegacyDTS = false;
                this.dtsContourChannel = 0;
                this.dtsLatitude = 0.0;
                this.dtsLongitude = 0.0;
                this.replicateToChannel = 0;
                return;
            }
            if (string4.equals("DTS_SOURCE")) {
                this.newDTSSource = null;
                return;
            }
            boolean bl = string4.equals("APAT");
            boolean bl4 = string4.equals("EPAT");
            boolean bl5 = string4.equals("MPAT");
            if (bl || bl4 || bl5) {
                boolean bl6 = false;
                SourceEditData sourceEditData = this.newSource;
                if (null != this.newDTSSource) {
                    sourceEditData = this.newDTSSource;
                }
                String[] stringArray = this.patternParser.split(string5);
                if (bl || bl4) {
                    double d;
                    double d2;
                    double d3;
                    ArrayList<Source.PatternPoint> arrayList = new ArrayList<Source.PatternPoint>();
                    if (bl) {
                        d3 = 0.0;
                        d2 = 359.999;
                        d = -1.0;
                    } else {
                        d3 = -90.0;
                        d2 = 90.0;
                        d = -91.0;
                    }
                    for (int i = 1; i < stringArray.length; i += 2) {
                        double d4;
                        double d5;
                        try {
                            d5 = Double.parseDouble(stringArray[i - 1]);
                            d4 = Double.parseDouble(stringArray[i]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl6 = true;
                            break;
                        }
                        if (d5 < d3 || d5 > d2) {
                            bl6 = true;
                            break;
                        }
                        if (d5 <= d) {
                            bl6 = true;
                            break;
                        }
                        d = d5;
                        if (d4 < 0.001 || d4 > 1.0) {
                            bl6 = true;
                            break;
                        }
                        arrayList.add(new Source.PatternPoint(d5, d4));
                    }
                    if (!bl6 && arrayList.size() < 2) {
                        bl6 = true;
                    }
                    if (!bl6) {
                        if (bl) {
                            sourceEditData.hasHorizontalPattern = true;
                            sourceEditData.horizontalPattern = arrayList;
                            sourceEditData.horizontalPatternChanged = true;
                        } else {
                            sourceEditData.hasVerticalPattern = true;
                            sourceEditData.verticalPattern = arrayList;
                            sourceEditData.verticalPatternChanged = true;
                        }
                    }
                } else {
                    ArrayList<Source.PatternSlice> arrayList = new ArrayList<Source.PatternSlice>();
                    ArrayList<Source.PatternPoint> arrayList2 = null;
                    double d = -1.0;
                    double d6 = -91.0;
                    for (int i = 1; i < stringArray.length; i += 3) {
                        double d7;
                        double d8;
                        double d9;
                        try {
                            d9 = Double.parseDouble(stringArray[i - 2]);
                            d8 = Double.parseDouble(stringArray[i - 1]);
                            d7 = Double.parseDouble(stringArray[i]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl6 = true;
                            break;
                        }
                        if (d9 < 0.0 || d9 > 359.999) {
                            bl6 = true;
                            break;
                        }
                        if (d8 < -90.0 || d8 > 90.0) {
                            bl6 = true;
                            break;
                        }
                        if (d9 != d) {
                            if (d9 <= d) {
                                bl6 = true;
                                break;
                            }
                            d = d9;
                            if (arrayList2.size() < 2) {
                                bl6 = true;
                                break;
                            }
                            arrayList2 = new ArrayList<Source.PatternPoint>();
                            arrayList.add(new Source.PatternSlice(d9, arrayList2));
                            d6 = -91.0;
                        }
                        if (d8 <= d6) {
                            bl6 = true;
                            break;
                        }
                        d6 = d8;
                        if (d7 < 0.001 || d7 > 1.0) {
                            bl6 = true;
                            break;
                        }
                        arrayList2.add(new Source.PatternPoint(d8, d7));
                    }
                    if (!bl6 && arrayList.size() < 2) {
                        bl6 = true;
                    }
                    if (!bl6) {
                        sourceEditData.hasMatrixPattern = true;
                        sourceEditData.matrixPattern = arrayList;
                        sourceEditData.matrixPatternChanged = true;
                    }
                }
                if (bl6) {
                    this.errors.reportError("Bad data in APAT/EPAT/MPAT element.");
                    throw new SAXException();
                }
                return;
            }
        }
    }
}

