/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editdata;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.data.Scenario;
import gov.fcc.tvstudy.editdata.SourceEditData;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.util.EditMenu;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;

public class SourceTableModel
extends AbstractTableModel {
    public static final String SOURCE_DESIRED_COLUMN = "Des";
    public static final String SOURCE_UNDESIRED_COLUMN = "Und";
    public static final String SOURCE_FACILITY_ID_COLUMN = "Facility ID";
    public static final String SOURCE_CALLSIGN_COLUMN = "Call Sign";
    public static final String SOURCE_CHANNEL_COLUMN = "Channel";
    public static final String SOURCE_STATUS_COLUMN = "Status";
    public static final String SOURCE_SERVICE_COLUMN = "Svc";
    public static final String SOURCE_FILE_COLUMN = "File Number";
    public static final String SOURCE_CITY_COLUMN = "City";
    public static final String SOURCE_STATE_COLUMN = "State";
    public static final String SOURCE_COUNTRY_COLUMN = "Country";
    private String[] columnNames = new String[]{"Des", "Und", "Facility ID", "Call Sign", "Channel", "Status", "Svc", "File Number", "City", "State", "Country"};
    private static final int SOURCE_DESIRED_INDEX = 0;
    private static final int SOURCE_UNDESIRED_INDEX = 1;
    private static final int SOURCE_FACILITY_ID_INDEX = 2;
    private static final int SOURCE_CALLSIGN_INDEX = 3;
    private static final int SOURCE_CHANNEL_INDEX = 4;
    private static final int SOURCE_STATUS_INDEX = 5;
    private static final int SOURCE_SERVICE_INDEX = 6;
    private static final int SOURCE_FILE_INDEX = 7;
    private static final int SOURCE_CITY_INDEX = 8;
    private static final int SOURCE_STATE_INDEX = 9;
    private static final int SOURCE_COUNTRY_INDEX = 10;
    private StudyEditData study;
    private ArrayList<SourceItem> modelRows;
    private HashSet<Integer> addedKeys;
    private HashSet<Integer> deletedKeys;
    private boolean holdUpdates;

    public SourceTableModel(StudyEditData studyEditData, Scenario scenario) {
        this.doInit(studyEditData);
        if (null != scenario) {
            for (Scenario.SourceListItem sourceListItem : scenario.sourceList) {
                SourceItem sourceItem = new SourceItem(studyEditData, sourceListItem);
                if (null == sourceItem.source) {
                    this.deletedKeys.add(sourceItem.key);
                    continue;
                }
                this.modelRows.add(sourceItem);
            }
        }
    }

    public SourceTableModel(StudyEditData studyEditData, ArrayList<SourceItem> arrayList) {
        this.doInit(studyEditData);
        if (null != arrayList) {
            this.modelRows.addAll(arrayList);
        }
    }

    private SourceTableModel(StudyEditData studyEditData) {
        this.doInit(studyEditData);
    }

    private void doInit(StudyEditData studyEditData) {
        this.study = studyEditData;
        this.modelRows = new ArrayList();
        this.addedKeys = new HashSet();
        this.deletedKeys = new HashSet();
        this.holdUpdates = true;
    }

    public SourceTableModel duplicate(ErrorReporter errorReporter) {
        SourceTableModel sourceTableModel = new SourceTableModel(this.study);
        ArrayList<SourceEditData> arrayList = new ArrayList<SourceEditData>();
        for (int i = 0; i < this.modelRows.size(); ++i) {
            SourceItem sourceItem = this.modelRows.get(i);
            SourceEditData sourceEditData = sourceItem.source;
            if (!sourceEditData.isLocked) {
                if (null == (sourceEditData = sourceEditData.duplicate(false, errorReporter))) {
                    return null;
                }
                arrayList.add(sourceEditData);
            } else if (null != sourceEditData.originalSourceKey) {
                SourceEditData sourceEditData2 = this.study.getSource(sourceEditData.originalSourceKey);
                if (null == sourceEditData2) {
                    errorReporter.reportError("An original record needed for replication does not exist.\nThis should never happen; the study database is damaged.");
                    return null;
                }
                if (!sourceEditData2.isLocked) {
                    int n = sourceEditData.channel;
                    sourceEditData = sourceEditData2.duplicate(false, errorReporter);
                    if (null == sourceEditData) {
                        return null;
                    }
                    arrayList.add(sourceEditData);
                    sourceEditData = sourceEditData.replicate(n, errorReporter);
                    if (null == sourceEditData) {
                        return null;
                    }
                    arrayList.add(sourceEditData);
                }
            }
            sourceTableModel.modelRows.add(new SourceItem(sourceEditData, sourceItem.isDesired, sourceItem.isUndesired));
            sourceTableModel.addedKeys.add(sourceEditData.key);
        }
        for (SourceEditData sourceEditData : arrayList) {
            this.study.addOrReplaceSource(sourceEditData);
        }
        return sourceTableModel;
    }

    public JTable createTable(EditMenu editMenu) {
        this.holdUpdates = false;
        JTable jTable = new JTable(this);
        AppManager.configureTable(jTable, editMenu);
        TableRowSorter<SourceTableModel> tableRowSorter = new TableRowSorter<SourceTableModel>(this){

            @Override
            public void setSortKeys(List<? extends RowSorter.SortKey> list) {
                Object object;
                int n = 0;
                SortOrder sortOrder = SortOrder.ASCENDING;
                SortOrder sortOrder2 = SortOrder.DESCENDING;
                if (null != list && list.size() > 0) {
                    object = list.get(0);
                    n = ((RowSorter.SortKey)object).getColumn();
                    if (0 == n || 1 == n) {
                        if (((RowSorter.SortKey)object).getSortOrder().equals((Object)SortOrder.ASCENDING)) {
                            sortOrder = SortOrder.DESCENDING;
                            sortOrder2 = SortOrder.ASCENDING;
                        }
                    } else if (((RowSorter.SortKey)object).getSortOrder().equals((Object)SortOrder.DESCENDING)) {
                        sortOrder = SortOrder.DESCENDING;
                        sortOrder2 = SortOrder.ASCENDING;
                    }
                }
                object = new ArrayList<RowSorter.SortKey>();
                switch (n) {
                    default: {
                        ((ArrayList)object).add(new RowSorter.SortKey(0, sortOrder2));
                        ((ArrayList)object).add(new RowSorter.SortKey(10, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(9, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                        break;
                    }
                    case 1: {
                        ((ArrayList)object).add(new RowSorter.SortKey(1, sortOrder2));
                        ((ArrayList)object).add(new RowSorter.SortKey(10, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(9, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                        break;
                    }
                    case 2: {
                        ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                        break;
                    }
                    case 3: {
                        ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                        break;
                    }
                    case 4: {
                        ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(10, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(9, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                        break;
                    }
                    case 5: {
                        ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(10, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(9, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                        break;
                    }
                    case 6: {
                        ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(10, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(9, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                        break;
                    }
                    case 7: {
                        ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(10, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(9, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                        break;
                    }
                    case 8: {
                        ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(10, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(9, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                        break;
                    }
                    case 9: {
                        ((ArrayList)object).add(new RowSorter.SortKey(9, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(10, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                        break;
                    }
                    case 10: {
                        ((ArrayList)object).add(new RowSorter.SortKey(10, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(9, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                        ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                    }
                }
                super.setSortKeys((List<RowSorter.SortKey>)object);
            }
        };
        TableStringConverter tableStringConverter = new TableStringConverter(){

            @Override
            public String toString(TableModel tableModel, int n, int n2) {
                SourceItem sourceItem = (SourceItem)SourceTableModel.this.modelRows.get(n);
                switch (n2) {
                    case 0: {
                        return sourceItem.isDesired ? "0" : "1";
                    }
                    case 1: {
                        return sourceItem.isUndesired ? "0" : "1";
                    }
                    case 2: {
                        return String.format("%07d", sourceItem.source.facility_id);
                    }
                    case 3: {
                        return sourceItem.source.callSign;
                    }
                    case 4: {
                        return String.format("%02d%c", sourceItem.source.channel, Character.valueOf(sourceItem.source.service.serviceType.digital ? (char)'D' : 'N'));
                    }
                    case 5: {
                        return String.valueOf(sourceItem.source.statusType);
                    }
                    case 6: {
                        return sourceItem.source.service.serviceCode;
                    }
                    case 7: {
                        return sourceItem.source.appARN;
                    }
                    case 8: {
                        return sourceItem.source.city;
                    }
                    case 9: {
                        return sourceItem.source.state;
                    }
                    case 10: {
                        return String.valueOf(sourceItem.source.country.key);
                    }
                }
                return "";
            }
        };
        tableRowSorter.setStringConverter(tableStringConverter);
        jTable.setRowSorter((RowSorter<? extends TableModel>)tableRowSorter);
        tableRowSorter.setSortKeys(null);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (((SourceItem)((SourceTableModel)SourceTableModel.this).modelRows.get((int)jTable.convertRowIndexToModel((int)n))).source.isLocked) {
                    jLabel.setForeground(Color.BLACK);
                } else {
                    jLabel.setForeground(Color.GREEN.darker());
                }
                return jLabel;
            }
        };
        int n = AppManager.getTextFieldWidth(3);
        int n2 = AppManager.getTextFieldWidth(4);
        int n3 = AppManager.getTextFieldWidth(5);
        int n4 = AppManager.getTextFieldWidth(8);
        int n5 = AppManager.getTextFieldWidth(20);
        int n6 = AppManager.getTextFieldWidth(23);
        TableColumn tableColumn = jTable.getColumn(SOURCE_DESIRED_COLUMN);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n);
        tableColumn = jTable.getColumn(SOURCE_UNDESIRED_COLUMN);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n);
        tableColumn = jTable.getColumn(SOURCE_FACILITY_ID_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n3);
        tableColumn.setPreferredWidth(n3);
        tableColumn = jTable.getColumn(SOURCE_CALLSIGN_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n3);
        tableColumn.setPreferredWidth(n4);
        tableColumn = jTable.getColumn(SOURCE_CHANNEL_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n3);
        tableColumn.setPreferredWidth(n3);
        tableColumn = jTable.getColumn(SOURCE_STATUS_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n2);
        tableColumn.setPreferredWidth(n2);
        tableColumn = jTable.getColumn(SOURCE_SERVICE_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n);
        tableColumn = jTable.getColumn(SOURCE_FILE_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n3);
        tableColumn.setPreferredWidth(n6);
        tableColumn = jTable.getColumn(SOURCE_CITY_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n3);
        tableColumn.setPreferredWidth(n5);
        tableColumn = jTable.getColumn(SOURCE_STATE_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n);
        tableColumn = jTable.getColumn(SOURCE_COUNTRY_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n);
        return jTable;
    }

    public void setHoldUpdates(boolean bl) {
        if (this.holdUpdates && !bl) {
            this.fireTableDataChanged();
        }
        this.holdUpdates = bl;
    }

    public int addOrReplace(SourceEditData sourceEditData, boolean bl, boolean bl2) {
        return this.addOrReplace(new SourceItem(sourceEditData, bl, bl2));
    }

    public int addOrReplace(SourceItem sourceItem) {
        int n = this.modelRows.indexOf(sourceItem);
        if (n >= 0) {
            this.modelRows.set(n, sourceItem);
            if (!this.holdUpdates) {
                this.fireTableRowsUpdated(n, n);
            }
        } else {
            n = this.modelRows.size();
            this.modelRows.add(sourceItem);
            if (!this.deletedKeys.remove(sourceItem.key)) {
                this.addedKeys.add(sourceItem.key);
            }
            if (!this.holdUpdates) {
                this.fireTableRowsInserted(n, n);
            }
        }
        this.study.addOrReplaceSource(sourceItem.source);
        return n;
    }

    public void remove(int n) {
        SourceItem sourceItem = this.modelRows.remove(n);
        if (!this.addedKeys.remove(sourceItem.key)) {
            this.deletedKeys.add(sourceItem.key);
        }
        if (!this.holdUpdates) {
            this.fireTableRowsDeleted(n, n);
        }
        this.study.removeSource(sourceItem.source);
    }

    public void remove(int[] nArray) {
        int n;
        if (0 == nArray.length) {
            return;
        }
        if (1 == nArray.length) {
            this.remove(nArray[0]);
            return;
        }
        for (n = 0; n < nArray.length - 1; ++n) {
            int n2 = n;
            for (int i = n + 1; i < nArray.length; ++i) {
                if (nArray[i] <= nArray[n2]) continue;
                n2 = i;
            }
            if (n2 == n) continue;
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
        }
        for (n = 0; n < nArray.length; ++n) {
            SourceItem sourceItem = this.modelRows.remove(nArray[n]);
            if (!this.addedKeys.remove(sourceItem.key)) {
                this.deletedKeys.add(sourceItem.key);
            }
            this.study.removeSource(sourceItem.source);
        }
        if (!this.holdUpdates) {
            this.fireTableDataChanged();
        }
    }

    public void set(int n, SourceEditData sourceEditData) {
        SourceItem sourceItem = this.modelRows.get(n);
        if (sourceItem.key.equals(sourceEditData.key)) {
            sourceItem.source = sourceEditData;
            this.study.addOrReplaceSource(sourceEditData);
        } else {
            SourceEditData sourceEditData2 = sourceItem.source;
            sourceItem.key = sourceEditData.key;
            sourceItem.source = sourceEditData;
            if (!this.addedKeys.remove(sourceEditData2.key)) {
                this.deletedKeys.add(sourceEditData2.key);
            }
            if (!this.deletedKeys.remove(sourceEditData.key)) {
                this.addedKeys.add(sourceEditData.key);
            }
            this.study.addOrReplaceSource(sourceEditData);
            this.study.removeSource(sourceEditData2);
        }
        if (!this.holdUpdates) {
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void setIsDesired(int n, boolean bl) {
        this.modelRows.get((int)n).isDesired = bl;
        if (!this.holdUpdates) {
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void setIsUndesired(int n, boolean bl) {
        this.modelRows.get((int)n).isUndesired = bl;
        if (!this.holdUpdates) {
            this.fireTableRowsUpdated(n, n);
        }
    }

    public SourceItem get(int n) {
        return this.modelRows.get(n);
    }

    public SourceEditData getSource(int n) {
        return this.modelRows.get((int)n).source;
    }

    public ArrayList<SourceItem> getRows() {
        return new ArrayList<SourceItem>(this.modelRows);
    }

    public ArrayList<SourceEditData> getSources() {
        ArrayList<SourceEditData> arrayList = new ArrayList<SourceEditData>(this.modelRows.size());
        for (SourceItem sourceItem : this.modelRows) {
            arrayList.add(sourceItem.source);
        }
        return arrayList;
    }

    public ArrayList<SourceEditData> getDesiredSources() {
        ArrayList<SourceEditData> arrayList = new ArrayList<SourceEditData>();
        for (SourceItem sourceItem : this.modelRows) {
            if (!sourceItem.isDesired) continue;
            arrayList.add(sourceItem.source);
        }
        return arrayList;
    }

    public boolean hasDesiredSources() {
        for (SourceItem sourceItem : this.modelRows) {
            if (!sourceItem.isDesired) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Scenario.SourceListItem> getScenarioSourceItems() {
        ArrayList<Scenario.SourceListItem> arrayList = new ArrayList<Scenario.SourceListItem>(this.modelRows.size());
        for (SourceItem sourceItem : this.modelRows) {
            arrayList.add(new Scenario.SourceListItem(sourceItem.key, sourceItem.isDesired, sourceItem.isUndesired));
        }
        return arrayList;
    }

    public boolean isDataValid(ErrorReporter errorReporter) {
        if (this.modelRows.isEmpty()) {
            errorReporter.reportValidationError("At least one station must be added to every scenario.");
            return false;
        }
        for (SourceItem sourceItem : this.modelRows) {
            if (!sourceItem.isDesired) continue;
            return true;
        }
        errorReporter.reportValidationError("At least one desired station must be in every scenario.");
        return false;
    }

    public boolean isDataChanged() {
        if (!this.addedKeys.isEmpty()) {
            return true;
        }
        return !this.deletedKeys.isEmpty();
    }

    public void didSave() {
        this.addedKeys.clear();
        this.deletedKeys.clear();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public int getRowCount() {
        return this.modelRows.size();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return 0 == n2 || 1 == n2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SourceItem sourceItem = this.modelRows.get(n);
        switch (n2) {
            case 0: {
                return sourceItem.isDesired;
            }
            case 1: {
                return sourceItem.isUndesired;
            }
            case 2: {
                return sourceItem.source.facility_id;
            }
            case 3: {
                return sourceItem.source.callSign;
            }
            case 4: {
                String string = sourceItem.source.service.serviceType.digital ? "D" + sourceItem.source.channel : "N" + sourceItem.source.channel;
                if (null != sourceItem.source.originalSourceKey) {
                    SourceEditData sourceEditData = this.study.getSource(sourceItem.source.originalSourceKey);
                    string = null == sourceEditData ? string + " (???)" : (sourceEditData.service.serviceType.digital ? string + " (D" + sourceEditData.channel + ")" : string + " (N" + sourceEditData.channel + ")");
                }
                return string;
            }
            case 5: {
                return sourceItem.source.status;
            }
            case 6: {
                return sourceItem.source.service.serviceCode;
            }
            case 7: {
                return sourceItem.source.fileNumber;
            }
            case 8: {
                return sourceItem.source.city;
            }
            case 9: {
                return sourceItem.source.state;
            }
            case 10: {
                return sourceItem.source.country.countryCode;
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                this.setIsDesired(n, (Boolean)object);
                break;
            }
            case 1: {
                this.setIsUndesired(n, (Boolean)object);
            }
        }
    }

    public static class SourceItem {
        public Integer key;
        public SourceEditData source;
        public boolean isDesired;
        public boolean isUndesired;

        public SourceItem(StudyEditData studyEditData, Scenario.SourceListItem sourceListItem) {
            this.key = new Integer(sourceListItem.key);
            this.source = studyEditData.getSource(this.key);
            this.isDesired = sourceListItem.isDesired;
            this.isUndesired = sourceListItem.isUndesired;
        }

        public SourceItem(SourceEditData sourceEditData, boolean bl, boolean bl2) {
            this.key = sourceEditData.key;
            this.source = sourceEditData;
            this.isDesired = bl;
            this.isUndesired = bl2;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            return null != object && ((SourceItem)object).key.equals(this.key);
        }
    }
}

