/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editdata;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.Country;
import gov.fcc.tvstudy.data.EmissionMask;
import gov.fcc.tvstudy.data.FrequencyOffset;
import gov.fcc.tvstudy.data.Service;
import gov.fcc.tvstudy.data.Source;
import gov.fcc.tvstudy.data.Zone;
import gov.fcc.tvstudy.editdata.CDBSRecord;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.xml.sax.Attributes;

public class SourceEditData {
    public final StudyEditData study;
    public Source source;
    public final Integer key;
    public final int facility_id;
    public final Service service;
    public String callSign;
    public int channel;
    public String city;
    public String state;
    public final Country country;
    public Zone zone;
    public String status;
    public int statusType;
    public String fileNumber;
    public String appARN;
    public FrequencyOffset frequencyOffset;
    public EmissionMask emissionMask;
    public double latitude;
    public double longitude;
    public double dtsMaximumDistance;
    public double heightAMSL;
    public double overallHAAT;
    public double peakERP;
    public int antenna_id;
    public boolean hasHorizontalPattern;
    public String horizontalPatternName;
    public ArrayList<Source.PatternPoint> horizontalPattern;
    public boolean horizontalPatternChanged;
    public double horizontalPatternOrientation;
    public boolean hasVerticalPattern;
    public String verticalPatternName;
    public ArrayList<Source.PatternPoint> verticalPattern;
    public boolean verticalPatternChanged;
    public double verticalPatternElectricalTilt;
    public double verticalPatternMechanicalTilt;
    public double verticalPatternMechanicalTiltOrientation;
    public boolean hasMatrixPattern;
    public String matrixPatternName;
    public ArrayList<Source.PatternSlice> matrixPattern;
    public boolean matrixPatternChanged;
    public boolean useGenericVerticalPattern;
    public final boolean isLocked;
    public final Integer application_id;
    public int siteNumber;
    public final Integer originalSourceKey;
    public final Integer parentSourceKey;
    public final boolean isParent;
    private HashMap<Integer, SourceEditData> dtsSources;
    private HashSet<Integer> addedDTSSourceKeys;
    private HashSet<Integer> deletedDTSSourceKeys;
    private ArrayList<SourceEditData> changedDTSSources;
    private ArrayList<SourceEditData> dtsSourceListCache;
    private boolean isUpdated;

    public SourceEditData(StudyEditData studyEditData, Source source) {
        int n;
        this.study = studyEditData;
        this.source = source;
        this.key = new Integer(this.source.key);
        this.facility_id = this.source.facility_id;
        this.service = this.source.service;
        this.callSign = this.source.callSign;
        this.channel = this.source.channel;
        this.city = this.source.city;
        this.state = this.source.state;
        this.country = this.source.country;
        this.zone = this.source.zone;
        this.status = this.source.status;
        this.statusType = 5;
        for (n = 0; n < CDBSRecord.STATUS_CODES.length; ++n) {
            if (!this.status.equalsIgnoreCase(CDBSRecord.STATUS_CODES[n])) continue;
            this.statusType = CDBSRecord.STATUS_TYPES[n];
            break;
        }
        this.fileNumber = this.source.fileNumber;
        this.appARN = "";
        for (n = 0; n < this.fileNumber.length(); ++n) {
            if (!Character.isDigit(this.fileNumber.charAt(n))) continue;
            this.appARN = this.fileNumber.substring(n);
            break;
        }
        this.frequencyOffset = this.source.frequencyOffset;
        this.emissionMask = this.source.emissionMask;
        this.latitude = this.source.latitude;
        this.longitude = this.source.longitude;
        this.dtsMaximumDistance = this.source.dtsMaximumDistance;
        this.heightAMSL = this.source.heightAMSL;
        this.overallHAAT = this.source.overallHAAT;
        this.peakERP = this.source.peakERP;
        this.antenna_id = this.source.antenna_id;
        this.hasHorizontalPattern = this.source.hasHorizontalPattern;
        this.horizontalPatternName = this.source.horizontalPatternName;
        this.horizontalPattern = null;
        this.horizontalPatternChanged = false;
        this.horizontalPatternOrientation = this.source.horizontalPatternOrientation;
        this.hasVerticalPattern = this.source.hasVerticalPattern;
        this.verticalPatternName = this.source.verticalPatternName;
        this.verticalPattern = null;
        this.verticalPatternChanged = false;
        this.verticalPatternElectricalTilt = this.source.verticalPatternElectricalTilt;
        this.verticalPatternMechanicalTilt = this.source.verticalPatternMechanicalTilt;
        this.verticalPatternMechanicalTiltOrientation = this.source.verticalPatternMechanicalTiltOrientation;
        this.hasMatrixPattern = this.source.hasMatrixPattern;
        this.matrixPatternName = this.source.matrixPatternName;
        this.matrixPattern = null;
        this.matrixPatternChanged = false;
        this.useGenericVerticalPattern = this.source.useGenericVerticalPattern;
        this.isLocked = this.source.isLocked;
        this.application_id = this.source.application_id;
        this.siteNumber = this.source.siteNumber;
        this.originalSourceKey = this.source.originalSourceKey;
        this.parentSourceKey = this.source.parentSourceKey;
        this.isParent = this.source.isParent;
        if (this.isParent) {
            this.dtsSources = new HashMap();
            for (Source source2 : this.source.dtsSources) {
                SourceEditData sourceEditData = new SourceEditData(this.study, source2);
                this.dtsSources.put(sourceEditData.key, sourceEditData);
            }
            this.addedDTSSourceKeys = new HashSet();
            this.deletedDTSSourceKeys = new HashSet();
            this.changedDTSSources = new ArrayList();
        }
    }

    public static SourceEditData createSource(StudyEditData studyEditData, int n, Service service, Country country, boolean bl, Integer n2, Integer n3, ErrorReporter errorReporter) {
        Integer n4 = studyEditData.getNewSourceKey();
        if (null == n4) {
            errorReporter.reportError("Cannot add new record, no keys available.");
            return null;
        }
        boolean bl2 = service.isDTS & null == n3;
        SourceEditData sourceEditData = new SourceEditData(studyEditData, n4, n, service, country, bl, n2, null, n3, bl2);
        sourceEditData.source = null;
        sourceEditData.callSign = "";
        sourceEditData.channel = 0;
        sourceEditData.city = "";
        sourceEditData.state = "";
        sourceEditData.zone = Zone.getNullObject();
        sourceEditData.status = "";
        sourceEditData.statusType = 5;
        sourceEditData.fileNumber = "";
        sourceEditData.appARN = "";
        sourceEditData.frequencyOffset = FrequencyOffset.getNullObject();
        sourceEditData.emissionMask = service.serviceType.needsEmissionMask ? EmissionMask.getInvalidObject() : EmissionMask.getNullObject();
        sourceEditData.latitude = 0.0;
        sourceEditData.longitude = 0.0;
        sourceEditData.dtsMaximumDistance = 0.0;
        sourceEditData.heightAMSL = 0.0;
        sourceEditData.overallHAAT = 0.0;
        sourceEditData.peakERP = 0.001;
        sourceEditData.antenna_id = 0;
        sourceEditData.hasHorizontalPattern = false;
        sourceEditData.horizontalPatternName = "";
        sourceEditData.horizontalPattern = null;
        sourceEditData.horizontalPatternChanged = false;
        sourceEditData.horizontalPatternOrientation = 0.0;
        sourceEditData.hasVerticalPattern = false;
        sourceEditData.verticalPatternName = "";
        sourceEditData.verticalPattern = null;
        sourceEditData.verticalPatternChanged = false;
        sourceEditData.verticalPatternElectricalTilt = 0.0;
        sourceEditData.verticalPatternMechanicalTilt = 0.0;
        sourceEditData.verticalPatternMechanicalTiltOrientation = 0.0;
        sourceEditData.hasMatrixPattern = false;
        sourceEditData.matrixPatternName = "";
        sourceEditData.matrixPattern = null;
        sourceEditData.matrixPatternChanged = false;
        sourceEditData.useGenericVerticalPattern = true;
        sourceEditData.siteNumber = 0;
        if (sourceEditData.isParent) {
            sourceEditData.dtsSources = new HashMap();
            sourceEditData.addedDTSSourceKeys = new HashSet();
            sourceEditData.deletedDTSSourceKeys = new HashSet();
            sourceEditData.changedDTSSources = new ArrayList();
        }
        return sourceEditData;
    }

    private SourceEditData(StudyEditData studyEditData, Integer n, int n2, Service service, Country country, boolean bl, Integer n3, Integer n4, Integer n5, boolean bl2) {
        this.study = studyEditData;
        this.key = n;
        this.facility_id = n2;
        this.service = service;
        this.country = country;
        this.isLocked = bl;
        this.application_id = n3;
        this.originalSourceKey = n4;
        this.parentSourceKey = n5;
        this.isParent = bl2;
    }

    public SourceEditData copy() {
        SourceEditData sourceEditData = new SourceEditData(this.study, this.key, this.facility_id, this.service, this.country, this.isLocked, this.application_id, this.originalSourceKey, this.parentSourceKey, this.isParent);
        sourceEditData.source = this.source;
        sourceEditData.callSign = this.callSign;
        sourceEditData.channel = this.channel;
        sourceEditData.city = this.city;
        sourceEditData.state = this.state;
        sourceEditData.zone = this.zone;
        sourceEditData.status = this.status;
        sourceEditData.statusType = this.statusType;
        sourceEditData.fileNumber = this.fileNumber;
        sourceEditData.appARN = this.appARN;
        sourceEditData.frequencyOffset = this.frequencyOffset;
        sourceEditData.emissionMask = this.emissionMask;
        sourceEditData.latitude = this.latitude;
        sourceEditData.longitude = this.longitude;
        sourceEditData.dtsMaximumDistance = this.dtsMaximumDistance;
        sourceEditData.heightAMSL = this.heightAMSL;
        sourceEditData.overallHAAT = this.overallHAAT;
        sourceEditData.peakERP = this.peakERP;
        sourceEditData.antenna_id = this.antenna_id;
        sourceEditData.hasHorizontalPattern = this.hasHorizontalPattern;
        sourceEditData.horizontalPatternName = this.horizontalPatternName;
        sourceEditData.horizontalPattern = this.horizontalPattern;
        sourceEditData.horizontalPatternChanged = this.horizontalPatternChanged;
        sourceEditData.horizontalPatternOrientation = this.horizontalPatternOrientation;
        sourceEditData.hasVerticalPattern = this.hasVerticalPattern;
        sourceEditData.verticalPatternName = this.verticalPatternName;
        sourceEditData.verticalPattern = this.verticalPattern;
        sourceEditData.verticalPatternChanged = this.verticalPatternChanged;
        sourceEditData.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        sourceEditData.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        sourceEditData.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        sourceEditData.hasMatrixPattern = this.hasMatrixPattern;
        sourceEditData.matrixPatternName = this.matrixPatternName;
        sourceEditData.matrixPattern = this.matrixPattern;
        sourceEditData.matrixPatternChanged = this.matrixPatternChanged;
        sourceEditData.useGenericVerticalPattern = this.useGenericVerticalPattern;
        sourceEditData.siteNumber = this.siteNumber;
        if (sourceEditData.isParent) {
            sourceEditData.dtsSources = new HashMap();
            for (SourceEditData sourceEditData2 : this.dtsSources.values()) {
                sourceEditData.dtsSources.put(sourceEditData2.key, sourceEditData2.copy());
            }
            sourceEditData.addedDTSSourceKeys = new HashSet<Integer>(this.addedDTSSourceKeys);
            sourceEditData.deletedDTSSourceKeys = new HashSet<Integer>(this.deletedDTSSourceKeys);
            sourceEditData.changedDTSSources = new ArrayList();
        }
        return sourceEditData;
    }

    public SourceEditData duplicate(boolean bl, ErrorReporter errorReporter) {
        if (null != this.parentSourceKey) {
            errorReporter.reportError("The record cannot be duplicated.");
            return null;
        }
        if (null != this.originalSourceKey && !bl) {
            errorReporter.reportError("Replication records cannot be unlocked.");
            return null;
        }
        return this.duplicate(bl, null, errorReporter);
    }

    private SourceEditData duplicate(boolean bl, Integer n, ErrorReporter errorReporter) {
        Integer n2 = this.study.getNewSourceKey();
        if (null == n2) {
            errorReporter.reportError("Cannot add new record, no keys available.");
            return null;
        }
        SourceEditData sourceEditData = new SourceEditData(this.study, n2, this.facility_id, this.service, this.country, bl, this.application_id, this.originalSourceKey, n, this.isParent);
        sourceEditData.source = null;
        sourceEditData.callSign = this.callSign;
        sourceEditData.channel = this.channel;
        sourceEditData.city = this.city;
        sourceEditData.state = this.state;
        sourceEditData.zone = this.zone;
        sourceEditData.status = this.status;
        sourceEditData.statusType = this.statusType;
        sourceEditData.fileNumber = this.fileNumber;
        sourceEditData.appARN = this.appARN;
        sourceEditData.frequencyOffset = this.frequencyOffset;
        sourceEditData.emissionMask = this.emissionMask;
        sourceEditData.latitude = this.latitude;
        sourceEditData.longitude = this.longitude;
        sourceEditData.dtsMaximumDistance = this.dtsMaximumDistance;
        sourceEditData.heightAMSL = this.heightAMSL;
        sourceEditData.overallHAAT = this.overallHAAT;
        sourceEditData.peakERP = this.peakERP;
        sourceEditData.antenna_id = this.antenna_id;
        sourceEditData.horizontalPatternOrientation = this.horizontalPatternOrientation;
        sourceEditData.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        sourceEditData.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        sourceEditData.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        sourceEditData.useGenericVerticalPattern = this.useGenericVerticalPattern;
        sourceEditData.siteNumber = this.siteNumber;
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        sourceEditData.hasHorizontalPattern = false;
        sourceEditData.horizontalPatternName = "";
        sourceEditData.horizontalPattern = null;
        sourceEditData.horizontalPatternChanged = false;
        if (this.hasHorizontalPattern) {
            if (null == this.horizontalPattern && null != this.source) {
                this.horizontalPattern = this.source.getHorizontalPattern(dbConnection, errorReporter);
            }
            if (null != this.horizontalPattern) {
                sourceEditData.hasHorizontalPattern = true;
                sourceEditData.horizontalPatternName = this.horizontalPatternName;
                sourceEditData.horizontalPattern = new ArrayList();
                for (Source.PatternPoint object : this.horizontalPattern) {
                    sourceEditData.horizontalPattern.add(object.copy());
                }
                sourceEditData.horizontalPatternChanged = true;
            }
        }
        sourceEditData.hasVerticalPattern = false;
        sourceEditData.verticalPatternName = "";
        sourceEditData.verticalPattern = null;
        sourceEditData.verticalPatternChanged = false;
        if (this.hasVerticalPattern) {
            if (null == this.verticalPattern && null != this.source) {
                this.verticalPattern = this.source.getVerticalPattern(dbConnection, errorReporter);
            }
            if (null != this.verticalPattern) {
                sourceEditData.hasVerticalPattern = true;
                sourceEditData.verticalPatternName = this.verticalPatternName;
                sourceEditData.verticalPattern = new ArrayList();
                for (Source.PatternPoint patternPoint : this.verticalPattern) {
                    sourceEditData.verticalPattern.add(patternPoint.copy());
                }
                sourceEditData.verticalPatternChanged = true;
            }
        }
        sourceEditData.hasMatrixPattern = false;
        sourceEditData.matrixPatternName = "";
        sourceEditData.matrixPattern = null;
        sourceEditData.matrixPatternChanged = false;
        if (this.hasMatrixPattern) {
            if (null == this.matrixPattern && null != this.source) {
                this.matrixPattern = this.source.getMatrixPattern(dbConnection, errorReporter);
            }
            if (null != this.matrixPattern) {
                sourceEditData.hasMatrixPattern = true;
                sourceEditData.matrixPatternName = this.matrixPatternName;
                sourceEditData.matrixPattern = new ArrayList();
                for (Source.PatternSlice patternSlice : this.matrixPattern) {
                    sourceEditData.matrixPattern.add(patternSlice.copy());
                }
                sourceEditData.matrixPatternChanged = true;
            }
        }
        if (sourceEditData.isParent) {
            sourceEditData.dtsSources = new HashMap();
            sourceEditData.addedDTSSourceKeys = new HashSet();
            for (SourceEditData sourceEditData2 : this.dtsSources.values()) {
                SourceEditData sourceEditData3 = sourceEditData2.duplicate(bl, sourceEditData.key, errorReporter);
                if (null == sourceEditData3) {
                    return null;
                }
                sourceEditData.dtsSources.put(sourceEditData3.key, sourceEditData3);
                sourceEditData.addedDTSSourceKeys.add(sourceEditData3.key);
            }
            sourceEditData.deletedDTSSourceKeys = new HashSet();
            sourceEditData.changedDTSSources = new ArrayList();
        }
        return sourceEditData;
    }

    public SourceEditData replicate(int n, ErrorReporter errorReporter) {
        if (null != this.originalSourceKey || null != this.parentSourceKey) {
            errorReporter.reportError("The record cannot be replicated.");
            return null;
        }
        if (this.service.serviceType.digital && n == this.channel) {
            errorReporter.reportError("The replication channel must be different.");
            return null;
        }
        return this.replicate(n, null, errorReporter);
    }

    private SourceEditData replicate(int n, Integer n2, ErrorReporter errorReporter) {
        Integer n3 = this.study.getNewSourceKey();
        if (null == n3) {
            errorReporter.reportError("Cannot add new record, no keys available.");
            return null;
        }
        Service service = this.service;
        FrequencyOffset frequencyOffset = this.frequencyOffset;
        EmissionMask emissionMask = this.emissionMask;
        DbConnection dbConnection = DbManager.getDb(this.study.dbID);
        if (!service.serviceType.digital) {
            service = this.service.digitalService;
            if (null == service) {
                errorReporter.reportError("Unable to replicate, no equivalent digital service exists.");
                return null;
            }
            frequencyOffset = FrequencyOffset.getNullObject();
            emissionMask = service.serviceType.needsEmissionMask ? EmissionMask.getDefaultObject(dbConnection) : EmissionMask.getNullObject();
        }
        SourceEditData sourceEditData = new SourceEditData(this.study, n3, this.facility_id, service, this.country, true, this.application_id, this.key, n2, this.isParent);
        sourceEditData.source = null;
        sourceEditData.callSign = this.callSign;
        sourceEditData.channel = n;
        sourceEditData.city = this.city;
        sourceEditData.state = this.state;
        sourceEditData.zone = this.zone;
        sourceEditData.status = this.status;
        sourceEditData.statusType = this.statusType;
        sourceEditData.fileNumber = this.fileNumber;
        sourceEditData.appARN = this.appARN;
        sourceEditData.frequencyOffset = frequencyOffset;
        sourceEditData.emissionMask = emissionMask;
        sourceEditData.latitude = this.latitude;
        sourceEditData.longitude = this.longitude;
        sourceEditData.dtsMaximumDistance = this.dtsMaximumDistance;
        sourceEditData.heightAMSL = this.heightAMSL;
        sourceEditData.overallHAAT = this.overallHAAT;
        sourceEditData.peakERP = 0.001;
        sourceEditData.antenna_id = 0;
        sourceEditData.hasHorizontalPattern = false;
        sourceEditData.horizontalPatternName = "";
        sourceEditData.horizontalPattern = null;
        sourceEditData.horizontalPatternChanged = false;
        sourceEditData.horizontalPatternOrientation = 0.0;
        sourceEditData.hasVerticalPattern = false;
        sourceEditData.verticalPatternName = "";
        sourceEditData.verticalPattern = null;
        sourceEditData.verticalPatternChanged = false;
        sourceEditData.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        sourceEditData.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        sourceEditData.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        sourceEditData.hasMatrixPattern = false;
        sourceEditData.matrixPatternName = "";
        sourceEditData.matrixPattern = null;
        sourceEditData.matrixPatternChanged = false;
        sourceEditData.useGenericVerticalPattern = this.useGenericVerticalPattern;
        sourceEditData.siteNumber = this.siteNumber;
        if (sourceEditData.isParent) {
            sourceEditData.dtsSources = new HashMap();
            sourceEditData.addedDTSSourceKeys = new HashSet();
            for (SourceEditData sourceEditData2 : this.dtsSources.values()) {
                SourceEditData sourceEditData3 = 0 == sourceEditData2.siteNumber ? sourceEditData2.duplicate(true, sourceEditData.key, errorReporter) : sourceEditData2.replicate(n, sourceEditData.key, errorReporter);
                if (null == sourceEditData3) {
                    return null;
                }
                sourceEditData.dtsSources.put(sourceEditData3.key, sourceEditData3);
                sourceEditData.addedDTSSourceKeys.add(sourceEditData3.key);
            }
            sourceEditData.deletedDTSSourceKeys = new HashSet();
            sourceEditData.changedDTSSources = new ArrayList();
        }
        return sourceEditData;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object object) {
        return null != object && ((SourceEditData)object).key.equals(this.key);
    }

    public String toString() {
        return this.callSign + " " + (this.service.serviceType.digital ? "D" : "N") + this.channel + " " + this.status + " " + this.city + ", " + this.state;
    }

    /*
     * WARNING - void declaration
     */
    public SourceEditData createDTSSource(DbConnection dbConnection, int n, ErrorReporter errorReporter) {
        void var5_8;
        SourceEditData sourceEditData;
        if (!this.isParent) {
            errorReporter.reportError("SourceEditData.createDTSSource() called on non-parent source.");
            return null;
        }
        if (this.isLocked) {
            errorReporter.reportError("SourceEditData.createDTSSource() called on locked source.");
            return null;
        }
        if (0 == n) {
            for (SourceEditData object2 : this.dtsSources.values()) {
                if (0 != object2.siteNumber) continue;
                errorReporter.reportError("DTS parent source already has a reference facility.");
                return null;
            }
        }
        Object object3 = this.service;
        Integer n2 = this.application_id;
        if (0 == n) {
            object3 = Service.getService(dbConnection, "DT");
            if (null == object3) {
                errorReporter.reportError("SourceEditData.createDTSSource() could not load service record.");
                return null;
            }
            Object var5_7 = null;
        }
        if (null == (sourceEditData = SourceEditData.createSource(this.study, this.facility_id, (Service)object3, this.country, false, (Integer)var5_8, this.key, errorReporter))) {
            return null;
        }
        sourceEditData.siteNumber = n;
        sourceEditData.callSign = this.callSign;
        sourceEditData.city = this.city;
        sourceEditData.state = this.state;
        if (n > 0) {
            sourceEditData.channel = this.channel;
            sourceEditData.zone = this.zone;
            sourceEditData.status = this.status;
            sourceEditData.statusType = this.statusType;
            sourceEditData.fileNumber = this.fileNumber;
            sourceEditData.appARN = this.appARN;
        }
        return sourceEditData;
    }

    public int getNextDTSSiteNumber() {
        if (!this.isParent || this.dtsSources.isEmpty()) {
            return 0;
        }
        int n = 0;
        for (SourceEditData sourceEditData : this.dtsSources.values()) {
            if (sourceEditData.siteNumber <= n) continue;
            n = sourceEditData.siteNumber;
        }
        return n + 1;
    }

    public synchronized void addOrReplaceDTSSource(SourceEditData sourceEditData) {
        if (!this.isParent || !this.key.equals(sourceEditData.parentSourceKey)) {
            return;
        }
        if (null == this.dtsSources.put(sourceEditData.key, sourceEditData) && !this.deletedDTSSourceKeys.remove(sourceEditData.key)) {
            this.addedDTSSourceKeys.add(sourceEditData.key);
        }
        this.dtsSourceListCache = null;
    }

    public synchronized void removeDTSSource(SourceEditData sourceEditData) {
        if (null != this.dtsSources.remove(sourceEditData.key) && !this.addedDTSSourceKeys.remove(sourceEditData.key)) {
            this.deletedDTSSourceKeys.add(sourceEditData.key);
        }
        this.dtsSourceListCache = null;
    }

    public ArrayList<SourceEditData> getDTSSources() {
        if (null == this.dtsSources) {
            return null;
        }
        if (null == this.dtsSourceListCache) {
            this.dtsSourceListCache = new ArrayList<SourceEditData>(this.dtsSources.values());
        }
        return this.dtsSourceListCache;
    }

    public HashSet<Integer> getDeletedDTSSourceKeys() {
        return this.deletedDTSSourceKeys;
    }

    public ArrayList<SourceEditData> getChangedDTSSources() {
        return this.changedDTSSources;
    }

    public boolean isDataValid(ErrorReporter errorReporter) {
        double d;
        if (this.isLocked) {
            return true;
        }
        if (this.facility_id < 1) {
            errorReporter.reportValidationError("Bad facility_id, must be > 0.");
            return false;
        }
        if (this.service.key < 1) {
            errorReporter.reportValidationError("A service must be selected.");
            return false;
        }
        if (this.service.serviceType.needsEmissionMask) {
            if (0 == this.emissionMask.key) {
                this.emissionMask = EmissionMask.getInvalidObject();
            }
        } else if (this.emissionMask.key != 0) {
            this.emissionMask = EmissionMask.getNullObject();
        }
        if (0 == this.callSign.length()) {
            errorReporter.reportValidationError("A call sign must be provided.");
            return false;
        }
        if (!this.study.setStudyParameters(errorReporter)) {
            return false;
        }
        if (null != this.parentSourceKey && 0 == this.siteNumber) {
            if (this.channel < 2 || this.channel > 69) {
                errorReporter.reportValidationError("Bad DTS reference facility channel, must be 2 to 69.");
                return false;
            }
        } else if (this.channel < this.study.minimumChannel || this.channel > this.study.maximumChannel) {
            errorReporter.reportValidationError("Bad channel, must be " + this.study.minimumChannel + " to " + this.study.maximumChannel + ".");
            return false;
        }
        if (0 == this.city.length()) {
            errorReporter.reportValidationError("A city name must be provided.");
            return false;
        }
        if (0 == this.state.length()) {
            errorReporter.reportValidationError("A state code must be provided.");
            return false;
        }
        if (this.country.key < 1) {
            errorReporter.reportValidationError("A country must be selected.");
            return false;
        }
        if (this.zone.key < 0) {
            errorReporter.reportValidationError("A zone must be selected.");
            return false;
        }
        if (this.emissionMask.key < 0) {
            errorReporter.reportValidationError("An emission mask must be selected.");
            return false;
        }
        if (this.latitude < -73.0 || this.latitude > 73.0) {
            errorReporter.reportValidationError("Bad latitude, must be -73.0 to 73.0.");
            return false;
        }
        if (this.longitude < -180.0 || this.longitude > 180.0) {
            errorReporter.reportValidationError("Bad longitude, must be -180.0 to 180.0.");
            return false;
        }
        if (this.isParent && this.dtsMaximumDistance != 0.0 && (this.dtsMaximumDistance < 50.0 || this.dtsMaximumDistance > 200.0)) {
            errorReporter.reportValidationError("Bad DTS maximum distance, must be 50.0 to 200.0.");
            return false;
        }
        if (this.heightAMSL < -1000.0 || this.heightAMSL > 10000.0) {
            errorReporter.reportValidationError("Bad height AMSL, must be -1000.0 to 10000.0.");
            return false;
        }
        if (this.overallHAAT < -1000.0 || this.overallHAAT > 10000.0) {
            errorReporter.reportValidationError("Bad HAAT, must be -1000.0 to 10000.0.");
            return false;
        }
        if (this.peakERP < 1.0E-5 || this.peakERP > 5000.0) {
            errorReporter.reportValidationError("Bad ERP, must be 1.0E-5 to 5000.0.");
            return false;
        }
        if (this.antenna_id < 0) {
            errorReporter.reportValidationError("Bad antenna_id, must be >= 0.");
            return false;
        }
        if (this.horizontalPatternOrientation < -360.0 || this.horizontalPatternOrientation > 360.0) {
            errorReporter.reportValidationError("Bad horizontal pattern orientation, must be -360.0 to 360.0.");
            return false;
        }
        if (this.verticalPatternElectricalTilt < -10.0 || this.verticalPatternElectricalTilt > 11.1) {
            errorReporter.reportValidationError("Bad vertical pattern electrical tilt, must be -10.0 to 11.1.");
            return false;
        }
        if (this.verticalPatternMechanicalTilt < -10.0 || this.verticalPatternMechanicalTilt > 11.1) {
            errorReporter.reportValidationError("Bad vertical pattern mechanical tilt, must be -10.0 to 11.1.");
            return false;
        }
        if (this.verticalPatternMechanicalTiltOrientation < -360.0 || this.verticalPatternMechanicalTiltOrientation > 360.0) {
            errorReporter.reportValidationError("Bad vertical pattern mechanical tilt orientation, must be -360.0 to 360.0.");
            return false;
        }
        if (this.siteNumber < 0) {
            errorReporter.reportValidationError("Bad site number, must be >= 0.");
            return false;
        }
        if (this.hasHorizontalPattern) {
            if (null != this.horizontalPattern && this.horizontalPatternChanged) {
                if (this.horizontalPattern.size() < 2) {
                    errorReporter.reportValidationError("Bad horizontal pattern, must have 2 or more points.");
                    return false;
                }
                d = -1.0;
                for (Source.PatternPoint object : this.horizontalPattern) {
                    if (object.azimuthOrDepression < 0.0 || object.azimuthOrDepression > 359.999) {
                        errorReporter.reportValidationError("Bad horizontal pattern point azimuth, must be 0.0 to 359.999.");
                        return false;
                    }
                    if (object.azimuthOrDepression <= d) {
                        errorReporter.reportValidationError("Bad horizontal pattern, duplicate or out-of-order azimuths.");
                        return false;
                    }
                    d = object.azimuthOrDepression;
                    if (!(object.relativeField < 0.001) && !(object.relativeField > 1.0)) continue;
                    errorReporter.reportValidationError("Bad horizontal pattern point relative field, must be 0.001 to 1.0.");
                    return false;
                }
            }
        } else {
            this.horizontalPatternName = "";
            this.horizontalPattern = null;
        }
        if (this.hasVerticalPattern) {
            if (null != this.verticalPattern && this.verticalPatternChanged) {
                if (this.verticalPattern.size() < 2) {
                    errorReporter.reportValidationError("Bad vertical pattern, must have 2 or more points.");
                    return false;
                }
                d = -91.0;
                for (Source.PatternPoint patternPoint : this.verticalPattern) {
                    if (patternPoint.azimuthOrDepression < -90.0 || patternPoint.azimuthOrDepression > 90.0) {
                        errorReporter.reportValidationError("Bad vertical pattern point depression angle, must be -90.0 to 90.0.");
                        return false;
                    }
                    if (patternPoint.azimuthOrDepression <= d) {
                        errorReporter.reportValidationError("Bad vertical pattern, duplicate or out-of-order depression angles.");
                        return false;
                    }
                    d = patternPoint.azimuthOrDepression;
                    if (!(patternPoint.relativeField < 0.001) && !(patternPoint.relativeField > 1.0)) continue;
                    errorReporter.reportValidationError("Bad vertical pattern point relative field, must be 0.001 to 1.0.");
                    return false;
                }
            }
        } else {
            this.verticalPatternName = "";
            this.verticalPattern = null;
        }
        if (this.hasMatrixPattern) {
            if (null != this.matrixPattern && this.matrixPatternChanged) {
                if (this.matrixPattern.size() < 2) {
                    errorReporter.reportValidationError("Bad matrix pattern, must have 2 or more slices.");
                    return false;
                }
                d = -1.0;
                double d2 = 0.0;
                for (Source.PatternSlice patternSlice : this.matrixPattern) {
                    if (patternSlice.azimuth < 0.0 || patternSlice.azimuth > 359.999) {
                        errorReporter.reportValidationError("Bad matrix pattern slice azimuth, must be 0.0 to 359.999.");
                        return false;
                    }
                    if (patternSlice.azimuth <= d) {
                        errorReporter.reportValidationError("Bad matrix pattern, duplicate or out-of-order slice azimuths.");
                        return false;
                    }
                    d = patternSlice.azimuth;
                    if (patternSlice.pattern.size() < 2) {
                        errorReporter.reportValidationError("Bad matrix pattern, slices must have 2 or more points.");
                        return false;
                    }
                    d2 = -91.0;
                    for (Source.PatternPoint patternPoint : patternSlice.pattern) {
                        if (patternPoint.azimuthOrDepression < -90.0 || patternPoint.azimuthOrDepression > 90.0) {
                            errorReporter.reportValidationError("Bad matrix pattern point depression angle, must be -90.0 to 90.0.");
                            return false;
                        }
                        if (patternPoint.azimuthOrDepression <= d2) {
                            errorReporter.reportValidationError("Bad matrix pattern, duplicate or out-of-order depression angles in slice.");
                            return false;
                        }
                        d2 = patternPoint.azimuthOrDepression;
                        if (!(patternPoint.relativeField < 0.001) && !(patternPoint.relativeField > 1.0)) continue;
                        errorReporter.reportValidationError("Bad matrix pattern point relative field, must be 0.001 to 1.0.");
                        return false;
                    }
                }
            }
        } else {
            this.matrixPatternName = "";
            this.matrixPattern = null;
        }
        if (this.isParent) {
            if (0 != this.siteNumber) {
                errorReporter.reportValidationError("Bad site number for DTS parent, must be 0.");
                return false;
            }
            boolean bl = false;
            boolean bl2 = false;
            for (SourceEditData sourceEditData : this.dtsSources.values()) {
                if (!sourceEditData.isDataValid(errorReporter)) {
                    return false;
                }
                if (0 == sourceEditData.siteNumber) {
                    if (bl) {
                        errorReporter.reportValidationError("Multiple reference facilities (site number 0) for DTS parent.");
                        return false;
                    }
                    bl = true;
                    continue;
                }
                bl2 = true;
            }
            if (!bl) {
                errorReporter.reportValidationError("DTS parent must have a reference facility.");
                return false;
            }
            if (!bl2) {
                errorReporter.reportValidationError("DTS parent must have at least one transmitter site.");
                return false;
            }
        }
        return true;
    }

    public boolean isDataChanged() {
        if (null == this.source || this.isUpdated) {
            if (this.isParent) {
                this.changedDTSSources.clear();
                this.changedDTSSources.addAll(this.dtsSources.values());
            }
            return true;
        }
        if (this.isLocked) {
            return false;
        }
        if (this.isParent) {
            boolean bl = false;
            this.changedDTSSources.clear();
            for (SourceEditData sourceEditData : this.dtsSources.values()) {
                if (!sourceEditData.isDataChanged() && !this.addedDTSSourceKeys.contains(sourceEditData.key)) continue;
                this.changedDTSSources.add(sourceEditData);
                bl = true;
            }
            if (bl) {
                return true;
            }
            if (!this.deletedDTSSourceKeys.isEmpty()) {
                return true;
            }
        }
        if (this.facility_id != this.source.facility_id) {
            return true;
        }
        if (this.service.key != this.source.service.key) {
            return true;
        }
        if (!this.callSign.equals(this.source.callSign)) {
            return true;
        }
        if (this.channel != this.source.channel) {
            return true;
        }
        if (!this.city.equals(this.source.city)) {
            return true;
        }
        if (!this.state.equals(this.source.state)) {
            return true;
        }
        if (this.country.key != this.source.country.key) {
            return true;
        }
        if (this.zone.key != this.source.zone.key) {
            return true;
        }
        if (!this.status.equals(this.source.status)) {
            return true;
        }
        if (!this.fileNumber.equals(this.source.fileNumber)) {
            return true;
        }
        if (this.frequencyOffset.key != this.source.frequencyOffset.key) {
            return true;
        }
        if (this.emissionMask.key != this.source.emissionMask.key) {
            return true;
        }
        if (this.latitude != this.source.latitude) {
            return true;
        }
        if (this.longitude != this.source.longitude) {
            return true;
        }
        if (this.dtsMaximumDistance != this.source.dtsMaximumDistance) {
            return true;
        }
        if (this.heightAMSL != this.source.heightAMSL) {
            return true;
        }
        if (this.overallHAAT != this.source.overallHAAT) {
            return true;
        }
        if (this.peakERP != this.source.peakERP) {
            return true;
        }
        if (this.antenna_id != this.source.antenna_id) {
            return true;
        }
        if (this.hasHorizontalPattern != this.source.hasHorizontalPattern) {
            return true;
        }
        if (!this.horizontalPatternName.equals(this.source.horizontalPatternName)) {
            return true;
        }
        if (this.horizontalPatternChanged) {
            return true;
        }
        if (this.horizontalPatternOrientation != this.source.horizontalPatternOrientation) {
            return true;
        }
        if (this.hasVerticalPattern != this.source.hasVerticalPattern) {
            return true;
        }
        if (!this.verticalPatternName.equals(this.source.verticalPatternName)) {
            return true;
        }
        if (this.verticalPatternChanged) {
            return true;
        }
        if (this.verticalPatternElectricalTilt != this.source.verticalPatternElectricalTilt) {
            return true;
        }
        if (this.verticalPatternMechanicalTilt != this.source.verticalPatternMechanicalTilt) {
            return true;
        }
        if (this.verticalPatternMechanicalTiltOrientation != this.source.verticalPatternMechanicalTiltOrientation) {
            return true;
        }
        if (this.hasMatrixPattern != this.source.hasMatrixPattern) {
            return true;
        }
        if (!this.matrixPatternName.equals(this.source.matrixPatternName)) {
            return true;
        }
        if (this.matrixPatternChanged) {
            return true;
        }
        if (this.useGenericVerticalPattern != this.source.useGenericVerticalPattern) {
            return true;
        }
        return this.siteNumber != this.source.siteNumber;
    }

    public void didSave() {
        ArrayList<Source> arrayList = null;
        int n = 0;
        if (null != this.source && null == this.parentSourceKey) {
            n = this.source.modCount + 1;
        }
        if (this.isParent) {
            arrayList = new ArrayList<Source>();
            for (SourceEditData sourceEditData : this.dtsSources.values()) {
                arrayList.add(sourceEditData.source);
            }
            this.addedDTSSourceKeys.clear();
            this.deletedDTSSourceKeys.clear();
            this.changedDTSSources.clear();
        }
        this.source = new Source(this.key, this.facility_id, this.service, this.callSign, this.channel, this.city, this.state, this.country, this.zone, this.status, this.fileNumber, this.frequencyOffset, this.emissionMask, this.latitude, this.longitude, this.dtsMaximumDistance, this.heightAMSL, this.heightAMSL, this.overallHAAT, this.peakERP, this.antenna_id, this.hasHorizontalPattern, this.horizontalPatternName, this.horizontalPatternOrientation, this.hasVerticalPattern, this.verticalPatternName, this.verticalPatternElectricalTilt, this.verticalPatternMechanicalTilt, this.verticalPatternMechanicalTiltOrientation, this.hasMatrixPattern, this.matrixPatternName, this.useGenericVerticalPattern, this.isLocked, this.application_id, this.siteNumber, this.originalSourceKey, this.parentSourceKey, arrayList, this.study.study.key, n);
        this.horizontalPatternChanged = false;
        this.verticalPatternChanged = false;
        this.matrixPatternChanged = false;
        this.isUpdated = false;
    }

    public void writeToXML(DbConnection dbConnection, Writer writer, boolean bl, boolean bl2, ErrorReporter errorReporter) throws IOException {
        SourceEditData sourceEditData = this;
        if (null != this.originalSourceKey && null == (sourceEditData = this.study.getSource(this.originalSourceKey))) {
            errorReporter.reportError("An original record needed for replication does not exist.\nThis should never occur; the study database is damaged.");
            return;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        if (null == sourceEditData.parentSourceKey) {
            if (!sourceEditData.isDataValid(errorReporter)) {
                return;
            }
            bl4 = sourceEditData.isParent;
            bl3 = !bl4;
            writer.append("<SOURCE DESIRED=\"" + bl + "\" UNDESIRED=\"" + bl2 + '\"');
            writer.append(" LOCKED=\"" + sourceEditData.isLocked + '\"');
            if (null != this.originalSourceKey) {
                writer.append(" REPLICATE=\"" + this.channel + '\"');
            }
        } else {
            if (sourceEditData.isLocked && null != sourceEditData.application_id) {
                return;
            }
            if (0 == sourceEditData.siteNumber) {
                bl5 = true;
            } else {
                bl6 = true;
            }
            writer.append("<DTS_SOURCE");
        }
        if ((bl3 || bl4 || bl5) && null != sourceEditData.application_id) {
            writer.append(" CDBS_ID=\"" + sourceEditData.application_id + '\"');
            if ((bl3 || bl4) && sourceEditData.isLocked) {
                writer.append("/>\n");
                return;
            }
        }
        if ((bl3 || bl5 || bl6) && (bl5 || bl6 || sourceEditData.siteNumber > 0)) {
            writer.append(" SITE_NUMBER=\"" + sourceEditData.siteNumber + '\"');
        }
        if (bl3 || bl4) {
            writer.append(" ID=\"" + sourceEditData.facility_id + '\"');
            writer.append(" CALL_SIGN=\"" + AppManager.xmlclean(sourceEditData.callSign) + '\"');
            writer.append(" CITY=\"" + AppManager.xmlclean(sourceEditData.city) + '\"');
            writer.append(" STATE=\"" + sourceEditData.state + '\"');
            writer.append(" COUNTRY=\"" + sourceEditData.country.countryCode + '\"');
        }
        if (bl3 || bl4 || bl5) {
            writer.append(" SERVICE=\"" + sourceEditData.service.serviceCode + '\"');
            writer.append(" CHANNEL=\"" + sourceEditData.channel + '\"');
            if (sourceEditData.zone.key > 0) {
                writer.append(" ZONE=\"" + sourceEditData.zone.zoneCode + '\"');
            }
            writer.append(" STATUS=\"" + sourceEditData.status + '\"');
            writer.append(" FILE_NUMBER=\"" + AppManager.xmlclean(sourceEditData.fileNumber) + '\"');
        }
        writer.append(" LATITUDE=\"" + AppManager.formatLatitude(sourceEditData.latitude) + '\"');
        writer.append(" LONGITUDE=\"" + AppManager.formatLongitude(sourceEditData.longitude) + '\"');
        if (bl4 && sourceEditData.dtsMaximumDistance > 0.0) {
            writer.append(" DTS_MAXIMUM_DISTANCE=\"" + AppManager.formatDistance(sourceEditData.dtsMaximumDistance) + '\"');
        }
        if (bl3 || bl5 || bl6) {
            if (sourceEditData.frequencyOffset.key > 0) {
                writer.append(" OFFSET=\"" + sourceEditData.frequencyOffset.frequencyOffsetCode + '\"');
            }
            if (sourceEditData.emissionMask.key > 0) {
                writer.append(" MASK=\"" + sourceEditData.emissionMask.emissionMaskCode + '\"');
            }
            writer.append(" HAMSL=\"" + AppManager.formatHeight(sourceEditData.heightAMSL) + '\"');
            writer.append(" HAAT=\"" + AppManager.formatHeight(sourceEditData.overallHAAT) + '\"');
            writer.append(" ERP=\"" + AppManager.formatERP(sourceEditData.peakERP) + '\"');
            if (sourceEditData.antenna_id > 0) {
                writer.append(" ANTENNA_ID=\"" + sourceEditData.antenna_id + '\"');
            }
            writer.append(" USE_GENERIC=\"" + sourceEditData.useGenericVerticalPattern + '\"');
            writer.append(" APAT_ORIENT=\"" + AppManager.formatAzimuth(sourceEditData.horizontalPatternOrientation) + '\"');
            writer.append(" EPAT_ETILT=\"" + AppManager.formatDepression(sourceEditData.verticalPatternElectricalTilt) + '\"');
            writer.append(" EPAT_MTILT=\"" + AppManager.formatDepression(sourceEditData.verticalPatternMechanicalTilt) + '\"');
            writer.append(" EPAT_ORIENT=\"" + AppManager.formatDepression(sourceEditData.verticalPatternMechanicalTiltOrientation) + '\"');
            bl7 = sourceEditData.hasHorizontalPattern;
            if (bl7) {
                if (null == sourceEditData.horizontalPattern && null != sourceEditData.source) {
                    sourceEditData.horizontalPattern = sourceEditData.source.getHorizontalPattern(dbConnection, errorReporter);
                }
                if (null == sourceEditData.horizontalPattern) {
                    bl7 = false;
                }
            }
            writer.append(" HAS_APAT=\"" + bl7 + '\"');
            if (bl7) {
                writer.append(" APAT_NAME=\"" + AppManager.xmlclean(sourceEditData.horizontalPatternName) + '\"');
            }
            boolean bl10 = bl8 = sourceEditData.hasVerticalPattern && !sourceEditData.hasMatrixPattern;
            if (bl8) {
                if (null == sourceEditData.verticalPattern && null != sourceEditData.source) {
                    sourceEditData.verticalPattern = sourceEditData.source.getVerticalPattern(dbConnection, errorReporter);
                }
                if (null == sourceEditData.verticalPattern) {
                    bl8 = false;
                }
            }
            writer.append(" HAS_EPAT=\"" + bl8 + '\"');
            if (bl8) {
                writer.append(" EPAT_NAME=\"" + AppManager.xmlclean(sourceEditData.verticalPatternName) + '\"');
            }
            if (bl9 = sourceEditData.hasMatrixPattern) {
                if (null == sourceEditData.matrixPattern && null != sourceEditData.source) {
                    sourceEditData.matrixPattern = sourceEditData.source.getMatrixPattern(dbConnection, errorReporter);
                }
                if (null == sourceEditData.matrixPattern) {
                    bl9 = false;
                }
            }
            writer.append(" HAS_MPAT=\"" + bl9 + '\"');
            if (bl9) {
                writer.append(" MPAT_NAME=\"" + AppManager.xmlclean(sourceEditData.matrixPatternName) + '\"');
            }
        }
        writer.append(">\n");
        if (bl7) {
            writer.append("<APAT>\n");
            for (Source.PatternPoint object : sourceEditData.horizontalPattern) {
                writer.append(AppManager.formatAzimuth(object.azimuthOrDepression));
                writer.append(',');
                writer.append(AppManager.formatRelativeField(object.relativeField));
                writer.append('\n');
            }
            writer.append("</APAT>\n");
        }
        if (bl8) {
            writer.append("<EPAT>");
            for (Source.PatternPoint patternPoint : sourceEditData.verticalPattern) {
                writer.append(AppManager.formatDepression(patternPoint.azimuthOrDepression));
                writer.append(',');
                writer.append(AppManager.formatRelativeField(patternPoint.relativeField));
                writer.append('\n');
            }
            writer.append("</EPAT>\n");
        }
        if (bl9) {
            writer.append("<MPAT>");
            for (Source.PatternSlice patternSlice : sourceEditData.matrixPattern) {
                for (Source.PatternPoint patternPoint : patternSlice.pattern) {
                    writer.append(AppManager.formatAzimuth(patternSlice.azimuth));
                    writer.append(',');
                    writer.append(AppManager.formatDepression(patternPoint.azimuthOrDepression));
                    writer.append(',');
                    writer.append(AppManager.formatRelativeField(patternPoint.relativeField));
                    writer.append('\n');
                }
            }
            writer.append("</MPAT>\n");
        }
        if (bl4) {
            for (SourceEditData sourceEditData2 : sourceEditData.dtsSources.values()) {
                sourceEditData2.writeToXML(dbConnection, writer, bl, bl2, errorReporter);
            }
        }
        if (bl3 || bl4) {
            writer.append("</SOURCE>\n");
        } else {
            writer.append("</DTS_SOURCE>\n");
        }
    }

    public static SourceEditData makeSourceWithAttributes(DbConnection dbConnection, Attributes attributes, StudyEditData studyEditData, Integer n, boolean bl, boolean bl2, ErrorReporter errorReporter) {
        int n2 = 0;
        String string = attributes.getValue("ID");
        if (null != string) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n2 <= 0) {
            errorReporter.reportError("Missing or bad ID attribute in SOURCE tag.");
            return null;
        }
        Service service = null;
        string = attributes.getValue("SERVICE");
        if (null != string) {
            service = Service.getService(dbConnection, string);
        }
        if (null == service) {
            errorReporter.reportError("Missing or bad SERVICE attribute in SOURCE tag.");
            return null;
        }
        Country country = null;
        string = attributes.getValue("COUNTRY");
        if (null != string) {
            country = Country.getCountry(dbConnection, string);
        }
        if (null == country) {
            errorReporter.reportError("Missing or bad COUNTRY attribute in SOURCE tag.");
            return null;
        }
        SourceEditData sourceEditData = SourceEditData.createSource(studyEditData, n2, service, country, bl, n, null, errorReporter);
        if (null == sourceEditData) {
            return null;
        }
        if (!sourceEditData.isParent && null != (string = attributes.getValue("SITE_NUMBER"))) {
            sourceEditData.siteNumber = -1;
            try {
                sourceEditData.siteNumber = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (sourceEditData.siteNumber < 0) {
                errorReporter.reportError("Bad SITE_NUMBER attribute in SOURCE tag.");
                return null;
            }
        }
        if (!sourceEditData.parseAttributes(dbConnection, attributes, bl2, errorReporter)) {
            return null;
        }
        return sourceEditData;
    }

    public synchronized SourceEditData addDTSSourceWithAttributes(DbConnection dbConnection, Attributes attributes, boolean bl, ErrorReporter errorReporter) {
        SourceEditData sourceEditData;
        String string;
        if (!this.isParent) {
            errorReporter.reportError("SourceEditData.addDTSSourceWithAttributes() called on non-parent source.");
            return null;
        }
        int n = 999;
        if (!bl) {
            n = -1;
            string = attributes.getValue("SITE_NUMBER");
            if (null != string) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n < 0) {
                errorReporter.reportError("Missing or bad SITE_NUMBER attribute in DTS_SOURCE tag.");
                return null;
            }
        }
        Service service = this.service;
        Integer n2 = this.application_id;
        if (0 == n) {
            service = null;
            string = attributes.getValue("SERVICE");
            if (null != string) {
                service = Service.getService(dbConnection, string);
            }
            if (null == service) {
                errorReporter.reportError("Missing or bad SERVICE attribute in DTS_SOURCE tag.");
                return null;
            }
            n2 = null;
            string = attributes.getValue("CDBS_ID");
            if (null != string) {
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n3 <= 0) {
                    errorReporter.reportError("Bad CDBS_ID attribute in DTS_SOURCE tag.");
                    return null;
                }
                n2 = new Integer(n3);
            }
        }
        if (null == (sourceEditData = SourceEditData.createSource(this.study, this.facility_id, service, this.country, this.isLocked, n2, this.key, errorReporter))) {
            return null;
        }
        sourceEditData.siteNumber = n;
        sourceEditData.callSign = this.callSign;
        sourceEditData.city = this.city;
        sourceEditData.state = this.state;
        if (n > 0) {
            sourceEditData.channel = this.channel;
            sourceEditData.zone = this.zone;
            sourceEditData.status = this.status;
            sourceEditData.statusType = this.statusType;
            sourceEditData.fileNumber = this.fileNumber;
            sourceEditData.appARN = this.appARN;
        }
        if (!sourceEditData.parseAttributes(dbConnection, attributes, bl, errorReporter)) {
            return null;
        }
        this.dtsSources.put(sourceEditData.key, sourceEditData);
        this.addedDTSSourceKeys.add(sourceEditData.key);
        this.dtsSourceListCache = null;
        return sourceEditData;
    }

    private boolean parseAttributes(DbConnection dbConnection, Attributes attributes, boolean bl, ErrorReporter errorReporter) {
        String string;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (null != this.parentSourceKey) {
            if (0 == this.siteNumber) {
                bl3 = true;
            } else {
                bl4 = true;
            }
        } else {
            bl2 = !this.isParent;
        }
        String string2 = "SOURCE";
        if (bl3 || bl4) {
            string2 = "DTS_SOURCE";
        }
        if (bl2 || this.isParent) {
            this.callSign = attributes.getValue("CALL_SIGN");
            if (null == this.callSign || 0 == this.callSign.length()) {
                errorReporter.reportError("Missing or bad CALL_SIGN attribute in " + string2 + " tag.");
                return false;
            }
            this.city = attributes.getValue("CITY");
            if (null == this.city || 0 == this.city.length()) {
                errorReporter.reportError("Missing or bad CITY attribute in " + string2 + " tag.");
                return false;
            }
            this.state = attributes.getValue("STATE");
            if (null == this.state || 0 == this.state.length()) {
                errorReporter.reportError("Missing or bad STATE attribute in " + string2 + " tag.");
                return false;
            }
        }
        if (bl2 || this.isParent || bl3) {
            string = attributes.getValue("CHANNEL");
            if (null != string) {
                try {
                    this.channel = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.channel < 2 || this.channel > 69) {
                errorReporter.reportError("Missing or bad CHANNEL attribute in " + string2 + " tag.");
                return false;
            }
            string = attributes.getValue("ZONE");
            if (null != string) {
                this.zone = Zone.getZone(dbConnection, string);
                if (this.zone.key < 1) {
                    errorReporter.reportError("Bad ZONE attribute in " + string2 + " tag.");
                    return false;
                }
            }
            if (null != (string = attributes.getValue("STATUS"))) {
                this.status = string;
                this.statusType = 5;
                for (int i = 0; i < CDBSRecord.STATUS_CODES.length; ++i) {
                    if (!this.status.equalsIgnoreCase(CDBSRecord.STATUS_CODES[i])) continue;
                    this.statusType = CDBSRecord.STATUS_TYPES[i];
                    break;
                }
            }
            if (null != (string = attributes.getValue("FILE_NUMBER"))) {
                this.fileNumber = string;
                this.appARN = "";
                for (int i = 0; i < this.fileNumber.length(); ++i) {
                    if (!Character.isDigit(this.fileNumber.charAt(i))) continue;
                    this.appARN = this.fileNumber.substring(i);
                    break;
                }
            }
        }
        this.latitude = -74.0;
        string = attributes.getValue("LATITUDE");
        if (null != string) {
            this.latitude = AppManager.parseLatitude(string);
        }
        if (this.latitude < -73.0 || this.latitude > 73.0) {
            errorReporter.reportError("Missing or bad LATITUDE attribute in " + string2 + " tag.");
            return false;
        }
        this.longitude = -181.0;
        string = attributes.getValue("LONGITUDE");
        if (null != string) {
            this.longitude = AppManager.parseLongitude(string);
        }
        if (this.longitude < -180.0 || this.longitude > 180.0) {
            errorReporter.reportError("Missing or bad LONGITUDE attribute in " + string2 + " tag.");
            return false;
        }
        if (this.isParent) {
            string = attributes.getValue("DTS_MAXIMUM_DISTANCE");
            if (null != string) {
                this.dtsMaximumDistance = 49.0;
                try {
                    this.dtsMaximumDistance = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.dtsMaximumDistance < 50.0 || this.dtsMaximumDistance > 200.0) {
                    errorReporter.reportError("Bad DTS_MAXIMUM_DISTANCE attribute in " + string2 + " tag.");
                    return false;
                }
            }
            if (!bl) {
                return true;
            }
        }
        if (null != (string = attributes.getValue("OFFSET"))) {
            this.frequencyOffset = FrequencyOffset.getFrequencyOffset(dbConnection, string);
            if (this.frequencyOffset.key < 1) {
                errorReporter.reportError("Bad OFFSET attribute in " + string2 + " tag.");
                return false;
            }
        }
        if (this.service.serviceType.needsEmissionMask) {
            string = attributes.getValue("MASK");
            if (null != string) {
                this.emissionMask = EmissionMask.getEmissionMask(dbConnection, string);
            }
            if (this.emissionMask.key < 1) {
                errorReporter.reportError("Missing or bad MASK attribute in " + string2 + " tag.");
                return false;
            }
        }
        this.heightAMSL = -1001.0;
        string = attributes.getValue("HAMSL");
        if (null != string) {
            try {
                this.heightAMSL = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.heightAMSL < -1000.0 || this.heightAMSL > 10000.0) {
            errorReporter.reportError("Missing or bad HAMSL attribute in " + string2 + " tag.");
            return false;
        }
        string = attributes.getValue("HAAT");
        if (null != string) {
            this.overallHAAT = -1001.0;
            try {
                this.overallHAAT = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.overallHAAT < -1000.0 || this.overallHAAT > 10000.0) {
                errorReporter.reportError("Bad HAAT attribute in " + string2 + " tag.");
                return false;
            }
        }
        this.peakERP = -0.99999;
        string = attributes.getValue("ERP");
        if (null != string) {
            try {
                this.peakERP = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.peakERP < 1.0E-5 || this.peakERP > 5000.0) {
            errorReporter.reportError("Missing or bad ERP attribute in " + string2 + " tag.");
            return false;
        }
        string = attributes.getValue("ANTENNA_ID");
        if (null != string) {
            this.antenna_id = -1;
            try {
                this.antenna_id = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.antenna_id < 0) {
                errorReporter.reportError("Bad ANTENNA_ID attribute in " + string2 + " tag.");
                return false;
            }
        }
        if (null != (string = attributes.getValue("APAT_ORIENT"))) {
            this.horizontalPatternOrientation = -361.0;
            try {
                this.horizontalPatternOrientation = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.horizontalPatternOrientation < -360.0 || this.horizontalPatternOrientation > 360.0) {
                errorReporter.reportError("Bad APAT_ORIENT attribute in " + string2 + " tag.");
                return false;
            }
        }
        if (null != (string = attributes.getValue("EPAT_ETILT"))) {
            this.verticalPatternElectricalTilt = -11.0;
            try {
                this.verticalPatternElectricalTilt = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.verticalPatternElectricalTilt < -10.0 || this.verticalPatternElectricalTilt > 11.1) {
                errorReporter.reportError("Bad EPAT_ETILT attribute in " + string2 + " tag.");
                return false;
            }
        }
        if (null != (string = attributes.getValue("EPAT_MTILT"))) {
            this.verticalPatternMechanicalTilt = -11.0;
            try {
                this.verticalPatternMechanicalTilt = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.verticalPatternMechanicalTilt < -10.0 || this.verticalPatternMechanicalTilt > 11.1) {
                errorReporter.reportError("Bad EPAT_MTILT attribute in " + string2 + " tag.");
                return false;
            }
        }
        if (0.0 != this.verticalPatternMechanicalTilt) {
            this.verticalPatternMechanicalTiltOrientation = -361.0;
        }
        if (null != (string = attributes.getValue("EPAT_ORIENT"))) {
            this.verticalPatternMechanicalTiltOrientation = -361.0;
            try {
                this.verticalPatternMechanicalTiltOrientation = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.verticalPatternMechanicalTiltOrientation < -360.0 || this.verticalPatternMechanicalTiltOrientation > 360.0) {
            errorReporter.reportError("Missing or bad EPAT_ORIENT attribute in " + string2 + " tag.");
            return false;
        }
        string = attributes.getValue("USE_GENERIC");
        this.useGenericVerticalPattern = null == string || Boolean.parseBoolean(string);
        string = attributes.getValue("HAS_APAT");
        boolean bl5 = this.hasHorizontalPattern = null != string && Boolean.parseBoolean(string);
        if (this.hasHorizontalPattern && null != (string = attributes.getValue("APAT_NAME"))) {
            this.horizontalPatternName = string;
        }
        boolean bl6 = this.hasVerticalPattern = null != (string = attributes.getValue("HAS_EPAT")) && Boolean.parseBoolean(string);
        if (this.hasVerticalPattern && null != (string = attributes.getValue("EPAT_NAME"))) {
            this.verticalPatternName = string;
        }
        boolean bl7 = this.hasMatrixPattern = null != (string = attributes.getValue("HAS_MPAT")) && Boolean.parseBoolean(string);
        if (this.hasMatrixPattern) {
            if (this.hasVerticalPattern) {
                this.hasVerticalPattern = false;
                this.verticalPatternName = "";
            }
            if (null != (string = attributes.getValue("MPAT_NAME"))) {
                this.matrixPatternName = string;
            }
        }
        return true;
    }

    public synchronized boolean updateLegacyDTS(DbConnection dbConnection, int n, double d, double d2, ErrorReporter errorReporter) {
        if (!this.isParent) {
            errorReporter.reportError("SourceEditData.updateLegacyDTS() called on non-parent source.");
            return false;
        }
        Service service = Service.getService(dbConnection, "DT");
        if (null == service) {
            errorReporter.reportError("SourceEditData.updateLegacyDTS() could not load service record.");
            return false;
        }
        SourceEditData sourceEditData = SourceEditData.createSource(this.study, this.facility_id, service, this.country, this.isLocked, null, this.key, errorReporter);
        if (null == sourceEditData) {
            return false;
        }
        sourceEditData.source = null;
        sourceEditData.callSign = this.callSign;
        sourceEditData.channel = n > 0 ? n : this.channel;
        sourceEditData.city = this.city;
        sourceEditData.state = this.state;
        sourceEditData.zone = this.zone;
        sourceEditData.status = "";
        sourceEditData.statusType = 5;
        sourceEditData.fileNumber = "";
        sourceEditData.appARN = "";
        sourceEditData.frequencyOffset = this.frequencyOffset;
        this.frequencyOffset = FrequencyOffset.getNullObject();
        sourceEditData.emissionMask = this.emissionMask;
        this.emissionMask = EmissionMask.getNullObject();
        sourceEditData.latitude = this.latitude;
        this.latitude = d;
        sourceEditData.longitude = this.longitude;
        this.longitude = d2;
        sourceEditData.heightAMSL = this.heightAMSL;
        this.heightAMSL = 0.0;
        sourceEditData.overallHAAT = this.overallHAAT;
        this.overallHAAT = 0.0;
        sourceEditData.peakERP = this.peakERP;
        this.peakERP = 0.001;
        sourceEditData.antenna_id = this.antenna_id;
        this.antenna_id = 0;
        sourceEditData.horizontalPatternOrientation = this.horizontalPatternOrientation;
        this.horizontalPatternOrientation = 0.0;
        sourceEditData.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        this.verticalPatternElectricalTilt = 0.0;
        sourceEditData.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        this.verticalPatternMechanicalTilt = 0.0;
        sourceEditData.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        this.verticalPatternMechanicalTiltOrientation = 0.0;
        sourceEditData.useGenericVerticalPattern = this.useGenericVerticalPattern;
        this.useGenericVerticalPattern = true;
        sourceEditData.siteNumber = 0;
        this.siteNumber = 0;
        sourceEditData.hasHorizontalPattern = false;
        sourceEditData.horizontalPatternName = "";
        sourceEditData.horizontalPattern = null;
        sourceEditData.horizontalPatternChanged = false;
        if (this.hasHorizontalPattern) {
            if (null == this.horizontalPattern && null != this.source) {
                this.horizontalPattern = this.source.getHorizontalPattern(dbConnection, errorReporter);
            }
            if (null != this.horizontalPattern) {
                sourceEditData.hasHorizontalPattern = true;
                sourceEditData.horizontalPatternName = this.horizontalPatternName;
                sourceEditData.horizontalPattern = this.horizontalPattern;
                sourceEditData.horizontalPatternChanged = true;
            }
            this.hasHorizontalPattern = false;
            this.horizontalPatternName = "";
            this.horizontalPattern = null;
            this.horizontalPatternChanged = true;
        }
        sourceEditData.hasVerticalPattern = false;
        sourceEditData.verticalPatternName = "";
        sourceEditData.verticalPattern = null;
        sourceEditData.verticalPatternChanged = false;
        if (this.hasVerticalPattern) {
            if (null == this.verticalPattern && null != this.source) {
                this.verticalPattern = this.source.getVerticalPattern(dbConnection, errorReporter);
            }
            if (null != this.verticalPattern) {
                sourceEditData.hasVerticalPattern = true;
                sourceEditData.verticalPatternName = this.verticalPatternName;
                sourceEditData.verticalPattern = this.verticalPattern;
                sourceEditData.verticalPatternChanged = true;
            }
            this.hasVerticalPattern = false;
            this.verticalPatternName = "";
            this.verticalPattern = null;
            this.verticalPatternChanged = true;
        }
        sourceEditData.hasMatrixPattern = false;
        sourceEditData.matrixPatternName = "";
        sourceEditData.matrixPattern = null;
        sourceEditData.matrixPatternChanged = false;
        if (this.hasMatrixPattern) {
            if (null == this.matrixPattern && null != this.source) {
                this.matrixPattern = this.source.getMatrixPattern(dbConnection, errorReporter);
            }
            if (null != this.matrixPattern) {
                sourceEditData.hasMatrixPattern = true;
                sourceEditData.matrixPatternName = this.matrixPatternName;
                sourceEditData.matrixPattern = this.matrixPattern;
                sourceEditData.matrixPatternChanged = true;
            }
            this.hasMatrixPattern = false;
            this.matrixPatternName = "";
            this.matrixPattern = null;
            this.matrixPatternChanged = true;
        }
        int n2 = 901;
        for (SourceEditData sourceEditData2 : this.dtsSources.values()) {
            sourceEditData2.siteNumber = n2++;
        }
        this.dtsSources.put(sourceEditData.key, sourceEditData);
        this.addedDTSSourceKeys.add(sourceEditData.key);
        this.dtsSourceListCache = null;
        this.isUpdated = true;
        return true;
    }
}

