/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editdata;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.data.Scenario;
import gov.fcc.tvstudy.editdata.ScenarioEditData;
import gov.fcc.tvstudy.editdata.SourceEditData;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.util.EditMenu;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ScenarioTableModel
extends AbstractTableModel {
    public static final String SCENARIO_NAME_COLUMN = "Name";
    public static final String SCENARIO_DESCRIPTION_COLUMN = "Description";
    private String[] columnNames = new String[]{"Name", "Description"};
    private static final int SCENARIO_NAME_INDEX = 0;
    private static final int SCENARIO_DESCRIPTION_INDEX = 1;
    private StudyEditData study;
    private ArrayList<ScenarioEditData> modelRows;
    private HashSet<Integer> addedKeys;
    private HashSet<Integer> deletedKeys;
    private ArrayList<ScenarioEditData> changedRows;
    private boolean holdUpdates;

    public ScenarioTableModel(StudyEditData studyEditData, ArrayList<Scenario> arrayList) {
        this.study = studyEditData;
        this.modelRows = new ArrayList();
        for (Scenario scenario : arrayList) {
            if (null == scenario) continue;
            this.modelRows.add(new ScenarioEditData(this.study, scenario));
        }
        this.addedKeys = new HashSet();
        this.deletedKeys = new HashSet();
        this.changedRows = new ArrayList();
        this.holdUpdates = true;
    }

    public JTable createTable(EditMenu editMenu) {
        this.holdUpdates = false;
        JTable jTable = new JTable(this);
        AppManager.configureTable(jTable, editMenu);
        jTable.setAutoCreateRowSorter(true);
        int n = AppManager.getTextFieldWidth(5);
        int n2 = AppManager.getTextFieldWidth(15);
        int n3 = AppManager.getTextFieldWidth(30);
        TableColumn tableColumn = jTable.getColumn(SCENARIO_NAME_COLUMN);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn = jTable.getColumn(SCENARIO_DESCRIPTION_COLUMN);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n3);
        return jTable;
    }

    public void setHoldUpdates(boolean bl) {
        if (this.holdUpdates && !bl) {
            this.fireTableDataChanged();
        }
        this.holdUpdates = bl;
    }

    public int addOrReplace(ScenarioEditData scenarioEditData) {
        int n = this.modelRows.indexOf(scenarioEditData);
        if (n >= 0) {
            this.modelRows.set(n, scenarioEditData);
            if (!this.holdUpdates) {
                this.fireTableRowsUpdated(n, n);
            }
        } else {
            n = this.modelRows.size();
            this.modelRows.add(scenarioEditData);
            if (!this.deletedKeys.remove(scenarioEditData.key)) {
                this.addedKeys.add(scenarioEditData.key);
            }
            if (!this.holdUpdates) {
                this.fireTableRowsInserted(n, n);
            }
        }
        return n;
    }

    public void remove(int n) {
        ScenarioEditData scenarioEditData = this.modelRows.remove(n);
        if (!this.addedKeys.remove(scenarioEditData.key)) {
            this.deletedKeys.add(scenarioEditData.key);
        }
        if (!this.holdUpdates) {
            this.fireTableRowsDeleted(n, n);
        }
        for (SourceEditData sourceEditData : scenarioEditData.sourceModel.getSources()) {
            this.study.removeSource(sourceEditData);
        }
    }

    public void remove(int[] nArray) {
        int n;
        if (0 == nArray.length) {
            return;
        }
        if (1 == nArray.length) {
            this.remove(nArray[0]);
            return;
        }
        for (n = 0; n < nArray.length - 1; ++n) {
            int n2 = n;
            for (int i = n + 1; i < nArray.length; ++i) {
                if (nArray[i] <= nArray[n2]) continue;
                n2 = i;
            }
            if (n2 == n) continue;
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
        }
        for (n = 0; n < nArray.length; ++n) {
            ScenarioEditData scenarioEditData = this.modelRows.remove(nArray[n]);
            if (!this.addedKeys.remove(scenarioEditData.key)) {
                this.deletedKeys.add(scenarioEditData.key);
            }
            for (SourceEditData sourceEditData : scenarioEditData.sourceModel.getSources()) {
                this.study.removeSource(sourceEditData);
            }
        }
        if (!this.holdUpdates) {
            this.fireTableDataChanged();
        }
    }

    public ScenarioEditData get(int n) {
        return this.modelRows.get(n);
    }

    public ScenarioEditData get(String string) {
        for (ScenarioEditData scenarioEditData : this.modelRows) {
            if (!scenarioEditData.name.equalsIgnoreCase(string)) continue;
            return scenarioEditData;
        }
        return null;
    }

    public ArrayList<ScenarioEditData> getRows() {
        return new ArrayList<ScenarioEditData>(this.modelRows);
    }

    public int indexOf(ScenarioEditData scenarioEditData) {
        return this.modelRows.indexOf(scenarioEditData);
    }

    public void scenarioWasEdited(ScenarioEditData scenarioEditData) {
        int n = this.modelRows.indexOf(scenarioEditData);
        if (n >= 0 && !this.holdUpdates) {
            this.fireTableRowsUpdated(n, n);
        }
    }

    public boolean isDataValid(ErrorReporter errorReporter) {
        for (ScenarioEditData scenarioEditData : this.modelRows) {
            if (scenarioEditData.isDataValid(errorReporter)) continue;
            return false;
        }
        return true;
    }

    public boolean isDataChanged() {
        boolean bl = false;
        this.changedRows.clear();
        for (ScenarioEditData scenarioEditData : this.modelRows) {
            if (!scenarioEditData.isDataChanged() && !this.addedKeys.contains(scenarioEditData.key)) continue;
            this.changedRows.add(scenarioEditData);
            bl = true;
        }
        if (bl) {
            return true;
        }
        if (!this.addedKeys.isEmpty()) {
            return true;
        }
        return !this.deletedKeys.isEmpty();
    }

    public HashSet<Integer> getDeletedKeys() {
        return this.deletedKeys;
    }

    public ArrayList<ScenarioEditData> getChangedRows() {
        return this.changedRows;
    }

    public void didSave() {
        this.addedKeys.clear();
        this.deletedKeys.clear();
        this.changedRows.clear();
    }

    public ArrayList<Scenario> getScenarios() {
        ArrayList<Scenario> arrayList = new ArrayList<Scenario>();
        for (ScenarioEditData scenarioEditData : this.modelRows) {
            arrayList.add(scenarioEditData.scenario);
        }
        return arrayList;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.modelRows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ScenarioEditData scenarioEditData = this.modelRows.get(n);
        switch (n2) {
            case 0: {
                return scenarioEditData.name;
            }
            case 1: {
                return scenarioEditData.description;
            }
        }
        return "";
    }
}

