/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editdata;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.data.Scenario;
import gov.fcc.tvstudy.editdata.SourceTableModel;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class ScenarioEditData {
    public final StudyEditData study;
    public Scenario scenario;
    public final Integer key;
    public String name;
    public String description;
    public final SourceTableModel sourceModel;

    public ScenarioEditData(StudyEditData studyEditData, Scenario scenario) {
        this.study = studyEditData;
        this.scenario = scenario;
        SourceTableModel sourceTableModel = null;
        if (null == this.scenario) {
            this.key = studyEditData.getNewScenarioKey();
            this.name = "";
            this.description = "";
            sourceTableModel = new SourceTableModel(studyEditData, (Scenario)null);
        } else {
            this.key = new Integer(this.scenario.key);
            this.name = this.scenario.name;
            this.description = this.scenario.description;
            sourceTableModel = new SourceTableModel(studyEditData, this.scenario);
        }
        this.sourceModel = sourceTableModel;
    }

    public ScenarioEditData(StudyEditData studyEditData, String string, String string2, ArrayList<SourceTableModel.SourceItem> arrayList) {
        this.study = studyEditData;
        this.key = studyEditData.getNewScenarioKey();
        this.name = null != studyEditData.scenarioModel.get(string) ? string + "_" + this.key : string;
        this.description = string2;
        this.sourceModel = new SourceTableModel(studyEditData, arrayList);
    }

    private ScenarioEditData(StudyEditData studyEditData, Integer n, SourceTableModel sourceTableModel) {
        this.study = studyEditData;
        this.key = n;
        this.sourceModel = sourceTableModel;
    }

    public ScenarioEditData duplicate(String string, ErrorReporter errorReporter) {
        SourceTableModel sourceTableModel = this.sourceModel.duplicate(errorReporter);
        if (null == sourceTableModel) {
            return null;
        }
        ScenarioEditData scenarioEditData = new ScenarioEditData(this.study, this.study.getNewScenarioKey(), sourceTableModel);
        scenarioEditData.name = string;
        scenarioEditData.description = this.description;
        return scenarioEditData;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object object) {
        return null != object && ((ScenarioEditData)object).key.equals(this.key);
    }

    public String toString() {
        return this.name;
    }

    public void wasEdited() {
        this.study.scenarioModel.scenarioWasEdited(this);
    }

    public boolean isDataValid(ErrorReporter errorReporter) {
        if (!this.sourceModel.isDataValid(errorReporter)) {
            return false;
        }
        if (0 == this.name.length()) {
            errorReporter.reportValidationError("A name must be entered for every scenario.");
            return false;
        }
        return true;
    }

    public boolean isDataChanged() {
        if (this.sourceModel.isDataChanged()) {
            return true;
        }
        if (null == this.scenario) {
            return true;
        }
        int n = this.scenario.sourceList.size();
        if (this.sourceModel.getRowCount() != n) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            Scenario.SourceListItem sourceListItem = this.scenario.sourceList.get(i);
            SourceTableModel.SourceItem sourceItem = this.sourceModel.get(i);
            if (sourceItem.isDesired == sourceListItem.isDesired && sourceItem.isUndesired == sourceListItem.isUndesired) continue;
            return true;
        }
        if (!this.name.equals(this.scenario.name)) {
            return true;
        }
        return !this.description.equals(this.scenario.description);
    }

    public void didSave() {
        this.sourceModel.didSave();
        this.scenario = new Scenario(this.key, this.name, this.description, this.sourceModel.getScenarioSourceItems());
    }

    public void writeToXML(DbConnection dbConnection, Writer writer, ErrorReporter errorReporter) throws IOException {
        if (!this.isDataValid(errorReporter)) {
            return;
        }
        writer.append("<SCENARIO NAME=\"" + AppManager.xmlclean(this.name) + "\">\n");
        writer.append("<DESCRIPTION>" + AppManager.xmlclean(this.description) + "</DESCRIPTION>\n");
        for (SourceTableModel.SourceItem sourceItem : this.sourceModel.getRows()) {
            sourceItem.source.writeToXML(dbConnection, writer, sourceItem.isDesired, sourceItem.isUndesired, errorReporter);
        }
        writer.append("</SCENARIO>\n");
    }
}

