/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editdata;

import gov.fcc.tvstudy.data.Parameter;

public class ParameterEditData {
    public Parameter parameter;
    public final boolean isLocked;
    public String value;
    public int integerValue;
    public double decimalValue;
    public boolean optionValue;
    public int pickfromIndex;

    public ParameterEditData(Parameter parameter, boolean bl) {
        this.parameter = parameter;
        this.isLocked = bl;
        if (null == this.parameter.value) {
            this.setDefaultValue();
        } else {
            this.value = this.parameter.value;
            this.integerValue = this.parameter.integerValue;
            this.decimalValue = this.parameter.decimalValue;
            this.optionValue = this.parameter.optionValue;
            this.pickfromIndex = this.parameter.pickfromIndex;
        }
    }

    public boolean isDataChanged() {
        if (null == this.parameter.value) {
            return true;
        }
        if (this.isLocked) {
            return false;
        }
        return !this.value.equals(this.parameter.value);
    }

    public void setDefaultValue() {
        if (this.isLocked && null != this.parameter.value) {
            return;
        }
        this.value = this.parameter.defaultValue;
        switch (this.parameter.type) {
            default: {
                break;
            }
            case 2: {
                try {
                    this.integerValue = Integer.parseInt(this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    this.integerValue = 0;
                }
                break;
            }
            case 3: {
                try {
                    this.decimalValue = Double.parseDouble(this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    this.decimalValue = 0.0;
                }
                break;
            }
            case 4: {
                this.optionValue = this.value.equals("1");
                break;
            }
            case 5: {
                try {
                    this.integerValue = Integer.parseInt(this.value);
                    this.pickfromIndex = this.parameter.pickfromItems.size() - 1;
                    while (this.pickfromIndex > 0 && this.integerValue != this.parameter.pickfromItems.get((int)this.pickfromIndex).key) {
                        --this.pickfromIndex;
                    }
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    this.pickfromIndex = 0;
                }
            }
        }
    }

    public void didSave() {
        this.parameter = new Parameter(this.parameter.key, this.parameter.name, this.value, this.parameter.defaultValue, this.parameter.description, this.parameter.studyFixed, this.parameter.groupName, this.parameter.enablesGroup, this.parameter.type, this.integerValue, this.parameter.minIntegerValue, this.parameter.maxIntegerValue, this.decimalValue, this.parameter.minDecimalValue, this.parameter.maxDecimalValue, this.optionValue, this.pickfromIndex, this.parameter.pickfromItems);
    }
}

