/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editdata;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.EmissionMask;
import gov.fcc.tvstudy.data.IxRule;
import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.editdata.IxRuleEditData;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.util.EditMenu;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class IxRuleTableModel
extends AbstractTableModel {
    public static final String IXRULE_COUNTRY_COLUMN = "Country D";
    public static final String IXRULE_SERVICE_COLUMN = "Service D";
    public static final String IXRULE_BAND_COLUMN = "Band D";
    public static final String IXRULE_USERVICE_COLUMN = "Service U";
    public static final String IXRULE_CHANNEL_COLUMN = "Channel U";
    public static final String IXRULE_MASK_COLUMN = "Mask U";
    public static final String IXRULE_OFFSET_COLUMN = "Offset";
    public static final String IXRULE_DISTANCE_COLUMN = "Distance";
    public static final String IXRULE_DU_COLUMN = "D/U";
    public static final String IXRULE_UTIME_COLUMN = "% Time U";
    private StudyEditData study;
    private String[] columnNames = new String[]{"Country D", "Service D", "Band D", "Service U", "Channel U", "Mask U", "Offset", "Distance", "D/U", "% Time U"};
    private static final int IXRULE_COUNTRY_INDEX = 0;
    private static final int IXRULE_SERVICE_INDEX = 1;
    private static final int IXRULE_BAND_INDEX = 2;
    private static final int IXRULE_USERVICE_INDEX = 3;
    private static final int IXRULE_CHANNEL_INDEX = 4;
    private static final int IXRULE_MASK_INDEX = 5;
    private static final int IXRULE_OFFSET_INDEX = 6;
    private static final int IXRULE_DISTANCE_INDEX = 7;
    private static final int IXRULE_DU_INDEX = 8;
    private static final int IXRULE_UTIME_INDEX = 9;
    private ArrayList<IxRuleEditData> modelRows;
    private HashSet<Integer> addedKeys;
    private HashSet<Integer> deletedKeys;
    private ArrayList<IxRuleEditData> changedRows;
    private NumberFormat doubleFormatter;
    private boolean holdUpdates;

    public IxRuleTableModel(StudyEditData studyEditData, ArrayList<IxRule> arrayList) {
        this.study = studyEditData;
        this.modelRows = new ArrayList();
        for (IxRule ixRule : arrayList) {
            if (null == ixRule) continue;
            this.modelRows.add(new IxRuleEditData(this.study, ixRule));
        }
        this.addedKeys = new HashSet();
        this.deletedKeys = new HashSet();
        this.changedRows = new ArrayList();
        this.doubleFormatter = NumberFormat.getInstance();
        this.doubleFormatter.setMinimumFractionDigits(2);
        this.doubleFormatter.setMaximumFractionDigits(2);
        this.doubleFormatter.setMinimumIntegerDigits(1);
        this.holdUpdates = true;
    }

    public JTable createTable(EditMenu editMenu) {
        this.holdUpdates = false;
        JTable jTable = new JTable(this);
        AppManager.configureTable(jTable, editMenu);
        jTable.setAutoCreateRowSorter(true);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (((IxRuleEditData)((IxRuleTableModel)IxRuleTableModel.this).modelRows.get((int)jTable.convertRowIndexToModel((int)n))).isActive) {
                    jLabel.setForeground(Color.BLACK);
                } else {
                    jLabel.setForeground(Color.GRAY.brighter());
                }
                if (7 == n2 || 8 == n2 || 9 == n2) {
                    jLabel.setHorizontalAlignment(4);
                } else {
                    jLabel.setHorizontalAlignment(2);
                }
                return jLabel;
            }
        };
        DefaultTableCellRenderer defaultTableCellRenderer2 = (DefaultTableCellRenderer)new JTableHeader().getDefaultRenderer();
        defaultTableCellRenderer2.setHorizontalAlignment(4);
        int n = AppManager.getTextFieldWidth(5);
        int n2 = AppManager.getTextFieldWidth(8);
        int n3 = AppManager.getTextFieldWidth(10);
        int n4 = AppManager.getTextFieldWidth(15);
        TableColumn tableColumn = jTable.getColumn(IXRULE_COUNTRY_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn = jTable.getColumn(IXRULE_SERVICE_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n4);
        tableColumn = jTable.getColumn(IXRULE_BAND_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n);
        tableColumn = jTable.getColumn(IXRULE_USERVICE_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n4);
        tableColumn = jTable.getColumn(IXRULE_CHANNEL_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n3);
        tableColumn = jTable.getColumn(IXRULE_MASK_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n3);
        tableColumn = jTable.getColumn(IXRULE_OFFSET_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn = jTable.getColumn(IXRULE_DISTANCE_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setHeaderRenderer(defaultTableCellRenderer2);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn = jTable.getColumn(IXRULE_DU_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setHeaderRenderer(defaultTableCellRenderer2);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn = jTable.getColumn(IXRULE_UTIME_COLUMN);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn.setHeaderRenderer(defaultTableCellRenderer2);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n);
        return jTable;
    }

    public void setHoldUpdates(boolean bl) {
        if (this.holdUpdates && !bl) {
            this.fireTableDataChanged();
        }
        this.holdUpdates = bl;
    }

    public boolean isIxRuleUnique(IxRuleEditData ixRuleEditData, ErrorReporter errorReporter) {
        for (IxRuleEditData ixRuleEditData2 : this.modelRows) {
            if (ixRuleEditData.key.equals(ixRuleEditData2.key) || ixRuleEditData.country.key != ixRuleEditData2.country.key || ixRuleEditData.serviceType.key != ixRuleEditData2.serviceType.key || ixRuleEditData.undesiredServiceType.key != ixRuleEditData2.undesiredServiceType.key || ixRuleEditData.channelDelta.key != ixRuleEditData2.channelDelta.key || 0 != ixRuleEditData.channelBand.key && 0 != ixRuleEditData2.channelBand.key && ixRuleEditData.channelBand.key != ixRuleEditData2.channelBand.key || 0 != ixRuleEditData.frequencyOffset && 0 != ixRuleEditData2.frequencyOffset && ixRuleEditData.frequencyOffset != ixRuleEditData2.frequencyOffset || ixRuleEditData.emissionMask.key != ixRuleEditData2.emissionMask.key) continue;
            errorReporter.reportValidationError("That interference rule would duplicate an existing rule.");
            return false;
        }
        return true;
    }

    public int addOrReplace(IxRuleEditData ixRuleEditData) {
        if (this.study.study.templateLocked) {
            return -1;
        }
        int n = this.modelRows.indexOf(ixRuleEditData);
        if (n >= 0) {
            this.modelRows.set(n, ixRuleEditData);
            if (!this.holdUpdates) {
                this.fireTableRowsUpdated(n, n);
            }
        } else {
            n = this.modelRows.size();
            this.modelRows.add(ixRuleEditData);
            if (!this.deletedKeys.remove(ixRuleEditData.key)) {
                this.addedKeys.add(ixRuleEditData.key);
            }
            if (!this.holdUpdates) {
                this.fireTableRowsInserted(n, n);
            }
        }
        return n;
    }

    public void remove(int n) {
        if (this.study.study.templateLocked) {
            return;
        }
        IxRuleEditData ixRuleEditData = this.modelRows.remove(n);
        if (!this.addedKeys.remove(ixRuleEditData.key)) {
            this.deletedKeys.add(ixRuleEditData.key);
        }
        if (!this.holdUpdates) {
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void remove(int[] nArray) {
        int n;
        if (this.study.study.templateLocked) {
            return;
        }
        if (0 == nArray.length) {
            return;
        }
        if (1 == nArray.length) {
            this.remove(nArray[0]);
            return;
        }
        for (n = 0; n < nArray.length - 1; ++n) {
            int n2 = n;
            for (int i = n + 1; i < nArray.length; ++i) {
                if (nArray[i] <= nArray[n2]) continue;
                n2 = i;
            }
            if (n2 == n) continue;
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
        }
        for (n = 0; n < nArray.length; ++n) {
            IxRuleEditData ixRuleEditData = this.modelRows.remove(nArray[n]);
            if (this.addedKeys.remove(ixRuleEditData.key)) continue;
            this.deletedKeys.add(ixRuleEditData.key);
        }
        if (!this.holdUpdates) {
            this.fireTableDataChanged();
        }
    }

    public IxRuleEditData get(int n) {
        return this.modelRows.get(n);
    }

    public ArrayList<IxRuleEditData> getRows() {
        return new ArrayList<IxRuleEditData>(this.modelRows);
    }

    public ArrayList<IxRuleEditData> getActiveRows() {
        ArrayList<IxRuleEditData> arrayList = new ArrayList<IxRuleEditData>();
        for (IxRuleEditData ixRuleEditData : this.modelRows) {
            if (!ixRuleEditData.isActive) continue;
            arrayList.add(ixRuleEditData);
        }
        return arrayList;
    }

    public void setActive(int n, boolean bl) {
        IxRuleEditData ixRuleEditData;
        int n2;
        IxRuleEditData ixRuleEditData2 = this.modelRows.get(n);
        ixRuleEditData2.isActive = bl;
        if (!this.holdUpdates) {
            this.fireTableRowsUpdated(n, n);
        }
        int n3 = this.modelRows.size();
        if (ixRuleEditData2.emissionMask.key > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (n2 == n) continue;
                ixRuleEditData = this.modelRows.get(n2);
                if (ixRuleEditData.country.key != ixRuleEditData2.country.key || ixRuleEditData.serviceType.key != ixRuleEditData2.serviceType.key || ixRuleEditData.undesiredServiceType.key != ixRuleEditData2.undesiredServiceType.key || ixRuleEditData.channelDelta.key != ixRuleEditData2.channelDelta.key || ixRuleEditData.channelBand.key != ixRuleEditData2.channelBand.key || 0 != ixRuleEditData.frequencyOffset && 0 != ixRuleEditData2.frequencyOffset && ixRuleEditData.frequencyOffset != ixRuleEditData2.frequencyOffset) continue;
                ixRuleEditData.isActive = bl;
                if (this.holdUpdates) continue;
                this.fireTableRowsUpdated(n2, n2);
            }
        }
        if (0 != ixRuleEditData2.frequencyOffset) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (n2 == n) continue;
                ixRuleEditData = this.modelRows.get(n2);
                if (ixRuleEditData.country.key != ixRuleEditData2.country.key || ixRuleEditData.serviceType.key != ixRuleEditData2.serviceType.key || ixRuleEditData.undesiredServiceType.key != ixRuleEditData2.undesiredServiceType.key || ixRuleEditData.channelDelta.key != ixRuleEditData2.channelDelta.key || ixRuleEditData.channelBand.key != ixRuleEditData2.channelBand.key || ixRuleEditData.emissionMask.key != ixRuleEditData2.emissionMask.key) continue;
                ixRuleEditData.isActive = bl;
                if (this.holdUpdates) continue;
                this.fireTableRowsUpdated(n2, n2);
            }
        }
    }

    public boolean isDataValid(ErrorReporter errorReporter) {
        int n;
        int n2;
        int n3 = this.modelRows.size();
        boolean[] blArray = new boolean[n3];
        boolean[] blArray2 = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            blArray[n2] = false;
            blArray2[n2] = false;
        }
        ArrayList<KeyedRecord> arrayList = EmissionMask.getEmissionMasks(DbManager.getDb(this.study.dbID));
        int n4 = arrayList.size();
        int[] nArray = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray[n] = arrayList.get((int)n).key;
        }
        boolean[] blArray3 = new boolean[n4];
        boolean bl = false;
        for (n2 = 0; n2 < n3; ++n2) {
            IxRuleEditData ixRuleEditData;
            int n5;
            IxRuleEditData ixRuleEditData2 = this.modelRows.get(n2);
            if (!ixRuleEditData2.isActive) continue;
            if (!blArray[n2] && ixRuleEditData2.emissionMask.key > 0) {
                for (n = 0; n < n4; ++n) {
                    blArray3[n] = nArray[n] == ixRuleEditData2.emissionMask.key;
                }
                bl = false;
                for (n5 = n2 + 1; n5 < n3; ++n5) {
                    ixRuleEditData = this.modelRows.get(n5);
                    if (!ixRuleEditData.isActive || ixRuleEditData.country.key != ixRuleEditData2.country.key || ixRuleEditData.serviceType.key != ixRuleEditData2.serviceType.key || ixRuleEditData.undesiredServiceType.key != ixRuleEditData2.undesiredServiceType.key || ixRuleEditData.channelDelta.key != ixRuleEditData2.channelDelta.key || ixRuleEditData.channelBand.key != ixRuleEditData2.channelBand.key || 0 != ixRuleEditData.frequencyOffset && 0 != ixRuleEditData2.frequencyOffset && ixRuleEditData.frequencyOffset != ixRuleEditData2.frequencyOffset) continue;
                    bl = true;
                    for (n = 0; n < n4; ++n) {
                        if (nArray[n] == ixRuleEditData.emissionMask.key) {
                            blArray3[n] = true;
                            continue;
                        }
                        if (blArray3[n]) continue;
                        bl = false;
                    }
                    blArray[n5] = true;
                    if (bl) break;
                }
                if (!bl) {
                    errorReporter.reportValidationError("Incomplete rule set, for rule:\n" + ixRuleEditData2.toString() + "\nMust have matching active rules for all other emission mask types.");
                    return false;
                }
            }
            blArray[n2] = true;
            if (!blArray2[n2] && 0 != ixRuleEditData2.frequencyOffset) {
                bl = false;
                for (n5 = n2 + 1; n5 < n3; ++n5) {
                    ixRuleEditData = this.modelRows.get(n5);
                    if (!ixRuleEditData.isActive || ixRuleEditData.country.key != ixRuleEditData2.country.key || ixRuleEditData.serviceType.key != ixRuleEditData2.serviceType.key || ixRuleEditData.undesiredServiceType.key != ixRuleEditData2.undesiredServiceType.key || ixRuleEditData.channelDelta.key != ixRuleEditData2.channelDelta.key || ixRuleEditData.channelBand.key != ixRuleEditData2.channelBand.key || ixRuleEditData.emissionMask.key != ixRuleEditData2.emissionMask.key) continue;
                    bl = true;
                    blArray2[n5] = true;
                    break;
                }
                if (!bl) {
                    String string = null;
                    string = 2 == ixRuleEditData2.frequencyOffset ? "without frequency offset" : "with frequency offset";
                    errorReporter.reportValidationError("Incomplete rule set, for rule:\n" + ixRuleEditData2.toString() + "\nMust have matching active rule " + string + ".");
                    return false;
                }
            }
            blArray2[n2] = true;
        }
        return true;
    }

    public boolean isDataChanged() {
        this.changedRows.clear();
        if (this.study.study.templateLocked) {
            return false;
        }
        boolean bl = false;
        for (IxRuleEditData ixRuleEditData : this.modelRows) {
            if (!ixRuleEditData.isDataChanged() && !this.addedKeys.contains(ixRuleEditData.key)) continue;
            this.changedRows.add(ixRuleEditData);
            bl = true;
        }
        if (bl) {
            return true;
        }
        return !this.deletedKeys.isEmpty();
    }

    public HashSet<Integer> getDeletedKeys() {
        return this.deletedKeys;
    }

    public ArrayList<IxRuleEditData> getChangedRows() {
        return this.changedRows;
    }

    public void didSave() {
        this.addedKeys.clear();
        this.deletedKeys.clear();
        this.changedRows.clear();
    }

    public ArrayList<IxRule> getRules() {
        ArrayList<IxRule> arrayList = new ArrayList<IxRule>();
        for (IxRuleEditData ixRuleEditData : this.modelRows) {
            arrayList.add(ixRuleEditData.ixRule);
        }
        return arrayList;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.modelRows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        IxRuleEditData ixRuleEditData = this.modelRows.get(n);
        switch (n2) {
            case 0: {
                return ixRuleEditData.country.name;
            }
            case 1: {
                return ixRuleEditData.serviceType.name;
            }
            case 2: {
                return ixRuleEditData.channelBand.name;
            }
            case 3: {
                return ixRuleEditData.undesiredServiceType.name;
            }
            case 4: {
                return ixRuleEditData.channelDelta.name;
            }
            case 5: {
                return ixRuleEditData.emissionMask.name;
            }
            case 6: {
                switch (ixRuleEditData.frequencyOffset) {
                    default: {
                        return "(any)";
                    }
                    case 1: {
                        return "Without";
                    }
                    case 2: 
                }
                return "With";
            }
            case 7: {
                return this.doubleFormatter.format(ixRuleEditData.distance);
            }
            case 8: {
                return this.doubleFormatter.format(ixRuleEditData.requiredDU);
            }
            case 9: {
                return String.valueOf(ixRuleEditData.undesiredTime);
            }
        }
        return "";
    }
}

