/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editdata;

import gov.fcc.tvstudy.data.ChannelBand;
import gov.fcc.tvstudy.data.ChannelDelta;
import gov.fcc.tvstudy.data.Country;
import gov.fcc.tvstudy.data.EmissionMask;
import gov.fcc.tvstudy.data.IxRule;
import gov.fcc.tvstudy.data.ServiceType;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.util.ErrorReporter;

public class IxRuleEditData {
    public final StudyEditData study;
    public IxRule ixRule;
    public Integer key;
    public Country country;
    public ServiceType serviceType;
    public ServiceType undesiredServiceType;
    public ChannelDelta channelDelta;
    public ChannelBand channelBand;
    public int frequencyOffset;
    public EmissionMask emissionMask;
    public double distance;
    public double requiredDU;
    public int undesiredTime;
    public boolean isActive;

    public IxRuleEditData(StudyEditData studyEditData, IxRule ixRule) {
        this.study = studyEditData;
        this.ixRule = ixRule;
        if (null == this.ixRule) {
            this.key = this.study.getNewIxRuleKey();
            this.country = Country.getInvalidObject();
            this.serviceType = ServiceType.getInvalidObject();
            this.undesiredServiceType = ServiceType.getInvalidObject();
            this.channelDelta = ChannelDelta.getInvalidObject();
            this.channelBand = ChannelBand.getNullObject();
            this.frequencyOffset = 0;
            this.emissionMask = EmissionMask.getNullObject();
            this.isActive = true;
        } else {
            this.key = new Integer(this.ixRule.key);
            this.country = this.ixRule.country;
            this.serviceType = this.ixRule.serviceType;
            this.undesiredServiceType = this.ixRule.undesiredServiceType;
            this.channelDelta = this.ixRule.channelDelta;
            this.channelBand = this.ixRule.channelBand;
            this.frequencyOffset = this.ixRule.frequencyOffset;
            this.emissionMask = this.ixRule.emissionMask;
            this.distance = this.ixRule.distance;
            this.requiredDU = this.ixRule.requiredDU;
            this.undesiredTime = this.ixRule.undesiredTime;
            this.isActive = this.ixRule.isActive;
        }
    }

    private IxRuleEditData(StudyEditData studyEditData) {
        this.study = studyEditData;
    }

    public IxRuleEditData copy() {
        IxRuleEditData ixRuleEditData = new IxRuleEditData(this.study);
        ixRuleEditData.ixRule = this.ixRule;
        ixRuleEditData.key = this.key;
        ixRuleEditData.country = this.country;
        ixRuleEditData.serviceType = this.serviceType;
        ixRuleEditData.undesiredServiceType = this.undesiredServiceType;
        ixRuleEditData.channelDelta = this.channelDelta;
        ixRuleEditData.channelBand = this.channelBand;
        ixRuleEditData.frequencyOffset = this.frequencyOffset;
        ixRuleEditData.emissionMask = this.emissionMask;
        ixRuleEditData.distance = this.distance;
        ixRuleEditData.requiredDU = this.requiredDU;
        ixRuleEditData.undesiredTime = this.undesiredTime;
        ixRuleEditData.isActive = this.isActive;
        return ixRuleEditData;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object object) {
        return null != object && ((IxRuleEditData)object).key.equals(this.key);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        if (this.country.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.country.name);
            string = " ";
        }
        if (this.serviceType.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.serviceType.name);
            string = " ";
        }
        if (this.undesiredServiceType.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.undesiredServiceType.name);
            string = " ";
        }
        if (this.channelDelta.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.channelDelta.name);
            string = " ";
        }
        if (this.channelBand.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.channelBand.name);
            string = " ";
        }
        if (1 == this.frequencyOffset) {
            stringBuilder.append(string);
            stringBuilder.append("without frequency offset");
            string = " ";
        }
        if (2 == this.frequencyOffset) {
            stringBuilder.append(string);
            stringBuilder.append("with frequency offset");
            string = " ";
        }
        if (this.emissionMask.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.emissionMask.name);
            string = " ";
        }
        return stringBuilder.toString();
    }

    public boolean isDataValid(ErrorReporter errorReporter) {
        if (this.country.key < 1) {
            errorReporter.reportValidationError("A desired country must be selected.");
            return false;
        }
        if (this.serviceType.key < 1) {
            errorReporter.reportValidationError("A desired service type must be selected.");
            return false;
        }
        if (this.undesiredServiceType.key < 1) {
            errorReporter.reportValidationError("An undesired service type must be selected.");
            return false;
        }
        if (this.undesiredServiceType.needsEmissionMask && 1 == Math.abs(this.channelDelta.delta)) {
            if (0 == this.emissionMask.key) {
                this.emissionMask = EmissionMask.getInvalidObject();
            }
        } else if (this.emissionMask.key != 0) {
            this.emissionMask = EmissionMask.getNullObject();
        }
        if (this.channelDelta.key < 1) {
            errorReporter.reportValidationError("An undesired channel must be selected.");
            return false;
        }
        if (this.channelBand.key < 0) {
            errorReporter.reportValidationError("A channel band must be selected.");
            return false;
        }
        if (this.emissionMask.key < 0) {
            errorReporter.reportValidationError("An undesired emission mask must be selected.");
            return false;
        }
        if (this.distance < 1.0 || this.distance > this.channelDelta.maximumDistance) {
            errorReporter.reportValidationError("Bad distance limit, must be 1.0 to " + this.channelDelta.maximumDistance + ".");
            return false;
        }
        if (this.requiredDU < -60.0 || this.requiredDU > 60.0) {
            errorReporter.reportValidationError("Bad required D/U, must be -60.0 to 60.0.");
            return false;
        }
        if (this.undesiredTime < 1 || this.undesiredTime > 99) {
            errorReporter.reportValidationError("Bad undesired % time, must be 1 to 99.");
            return false;
        }
        return true;
    }

    public boolean isDataChanged() {
        if (null == this.ixRule) {
            return true;
        }
        if (this.study.study.templateLocked) {
            return false;
        }
        if (this.country.key != this.ixRule.country.key) {
            return true;
        }
        if (this.serviceType.key != this.ixRule.serviceType.key) {
            return true;
        }
        if (this.undesiredServiceType.key != this.ixRule.undesiredServiceType.key) {
            return true;
        }
        if (this.channelDelta.key != this.ixRule.channelDelta.key) {
            return true;
        }
        if (this.channelBand.key != this.ixRule.channelBand.key) {
            return true;
        }
        if (this.frequencyOffset != this.ixRule.frequencyOffset) {
            return true;
        }
        if (this.emissionMask.key != this.ixRule.emissionMask.key) {
            return true;
        }
        if (this.distance != this.ixRule.distance) {
            return true;
        }
        if (this.requiredDU != this.ixRule.requiredDU) {
            return true;
        }
        if (this.undesiredTime != this.ixRule.undesiredTime) {
            return true;
        }
        return this.isActive != this.ixRule.isActive;
    }

    public void didSave() {
        this.ixRule = new IxRule(this.key, this.country, this.serviceType, this.undesiredServiceType, this.channelDelta, this.channelBand, this.frequencyOffset, this.emissionMask, this.distance, this.requiredDU, this.undesiredTime, this.isActive);
    }
}

