/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editdata;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.DbManager;
import gov.fcc.tvstudy.data.ChannelDelta;
import gov.fcc.tvstudy.data.Country;
import gov.fcc.tvstudy.data.EmissionMask;
import gov.fcc.tvstudy.data.FrequencyOffset;
import gov.fcc.tvstudy.data.Service;
import gov.fcc.tvstudy.data.Source;
import gov.fcc.tvstudy.data.Zone;
import gov.fcc.tvstudy.editdata.ScenarioEditData;
import gov.fcc.tvstudy.editdata.SourceEditData;
import gov.fcc.tvstudy.editdata.StudyEditData;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;

public class CDBSRecord {
    public static final int STATUS_TYPE_STA = 0;
    public static final int STATUS_TYPE_CP = 1;
    public static final int STATUS_TYPE_LIC = 2;
    public static final int STATUS_TYPE_APP = 3;
    public static final int STATUS_TYPE_GRANT = 4;
    public static final int STATUS_TYPE_OTHER = 5;
    public static final String[] STATUS_CODES = new String[]{"APP", "CP", "CP MOD", "LIC", "GRANT", "STA"};
    public static final int[] STATUS_TYPES = new int[]{3, 1, 1, 2, 4, 0};
    public final String dbID;
    public final int cdbsKey;
    public Integer application_id;
    public int siteNumber;
    public int facility_id;
    public Service service;
    public String callSign;
    public int channel;
    public String city;
    public String state;
    public Country country;
    public String zoneCode;
    public String status;
    public int statusType;
    public String filePrefix;
    public String appARN;
    public String frequencyOffsetCode;
    public String emissionMaskCode;
    public String latitudeDirection;
    public int latitudeDegrees;
    public int latitudeMinutes;
    public double latitudeSeconds;
    public String longitudeDirection;
    public int longitudeDegrees;
    public int longitudeMinutes;
    public double longitudeSeconds;
    public double latitude;
    public double longitude;
    public double dtsMaximumDistance;
    public double heightAMSL;
    public double overallHAAT;
    public double peakERP;
    public double alternateERP;
    public int antenna_id;
    public double horizontalPatternOrientation;
    public int elevation_antenna_id;
    public double verticalPatternElectricalTilt;
    public double verticalPatternMechanicalTilt;
    public double verticalPatternMechanicalTiltOrientation;
    public boolean isArchived;
    public boolean daIndicated;
    public LinkedList<CDBSRecord> dtsRecords;
    private boolean inSearchRadius;
    private boolean isOperatingFacility;
    private boolean operatingStatusSet;
    private static HashMap<String, HashMap<Integer, String>> licenseAppLists = new HashMap();

    public CDBSRecord(String string, int n) {
        this.dbID = string;
        this.cdbsKey = n;
    }

    public static LinkedList<CDBSRecord> findRecords(DbConnection dbConnection, String string, int n, String string2, double d, double d2, double d3, double d4, boolean bl, ErrorReporter errorReporter) {
        return CDBSRecord.findRecords(dbConnection, string, n, string2, d, d2, d3, d4, bl, null, errorReporter);
    }

    private static LinkedList<CDBSRecord> findRecords(DbConnection dbConnection, String string, int n, String string2, double d, double d2, double d3, double d4, boolean bl, CDBSRecord cDBSRecord, ErrorReporter errorReporter) {
        Object object;
        Object object2;
        LinkedList<CDBSRecord> linkedList = null;
        boolean bl2 = false;
        if (dbConnection.connect(errorReporter)) {
            try {
                object2 = "";
                object = "";
                String string3 = "";
                String string4 = "";
                if (null != cDBSRecord) {
                    object2 = " ";
                    string3 = "(tv_eng_data.application_id = " + cDBSRecord.application_id + ") " + "AND (tv_eng_data.site_number > 0) ";
                    string4 = "site_number";
                } else {
                    object2 = ",service.service_key,country.country_key,tv_eng_data.application_id,tv_eng_data.facility_id,tv_eng_data.station_channel,tv_eng_data.predict_coverage_area ";
                    object = "JOIN tvstudy.service ON (tv_eng_data.vsd_service = service.service_code) JOIN tvstudy.country ON (facility.fac_country = country.country_code) ";
                    string3 = "(" + string2 + ") " + "AND ((tv_eng_data.site_number = 0) OR NOT service.is_dts) ";
                    string4 = "application_id DESC";
                }
                dbConnection.query("SELECT facility.fac_callsign, facility.comm_city, facility.comm_state, tv_eng_data.fac_zone, tv_eng_data.tv_dom_status, application.file_prefix, application.app_arn, tv_eng_data.freq_offset, tv_eng_data.dt_emission_mask, tv_eng_data.lat_dir, tv_eng_data.lat_deg, tv_eng_data.lat_min, tv_eng_data.lat_sec, tv_eng_data.lon_dir, tv_eng_data.lon_deg, tv_eng_data.lon_min, tv_eng_data.lon_sec, tv_eng_data.rcamsl_horiz_mtr, tv_eng_data.haat_rc_mtr, tv_eng_data.effective_erp, tv_eng_data.max_erp_any_angle, tv_eng_data.antenna_id, tv_eng_data.ant_rotation, tv_eng_data.elevation_antenna_id, tv_eng_data.electrical_deg, tv_eng_data.mechanical_deg, tv_eng_data.true_deg, tv_eng_data.eng_record_type, tv_app_indicators.da_ind, tv_eng_data.site_number" + (String)object2 + "FROM " + "tvstudy_cdbs_" + n + ".tv_eng_data " + "JOIN tvstudy_cdbs_" + n + ".facility USING (facility_id) " + "JOIN tvstudy_cdbs_" + n + ".application USING (application_id) " + "LEFT JOIN tvstudy_cdbs_" + n + ".tv_app_indicators USING (application_id, site_number) " + (String)object + "WHERE " + string3 + "ORDER BY " + string4);
                linkedList = new LinkedList<CDBSRecord>();
                DbConnection dbConnection2 = dbConnection.copy();
                while (dbConnection.next()) {
                    String string5;
                    double d5;
                    int n2;
                    int n3;
                    int n4;
                    Country country;
                    Service service;
                    if (null != cDBSRecord) {
                        service = cDBSRecord.service;
                        country = cDBSRecord.country;
                        n4 = cDBSRecord.application_id;
                        n3 = cDBSRecord.facility_id;
                        n2 = cDBSRecord.channel;
                        d5 = 0.0;
                    } else {
                        service = Service.getService(dbConnection2, dbConnection.getInt(31));
                        if (null == service || null == (country = Country.getCountry(dbConnection2, dbConnection.getInt(32))) || (n4 = dbConnection.getInt(33)) <= 0 || (n3 = dbConnection.getInt(34)) <= 0 || (n2 = dbConnection.getInt(35)) < 2 || n2 > 69) continue;
                        d5 = service.isDTS ? dbConnection.getDouble(36) : 0.0;
                    }
                    String string6 = dbConnection.getString(10);
                    if (null == string6) {
                        string6 = "N";
                    }
                    int n5 = dbConnection.getInt(11);
                    int n6 = dbConnection.getInt(12);
                    double d6 = dbConnection.getDouble(13);
                    double d7 = (double)n5 + (double)n6 / 60.0 + d6 / 3600.0;
                    if (string6.equalsIgnoreCase("S")) {
                        d7 = -d7;
                    }
                    if (null == (string5 = dbConnection.getString(14))) {
                        string5 = "W";
                    }
                    int n7 = dbConnection.getInt(15);
                    int n8 = dbConnection.getInt(16);
                    double d8 = dbConnection.getDouble(17);
                    double d9 = (double)n7 + (double)n8 / 60.0 + d8 / 3600.0;
                    if (string5.equalsIgnoreCase("E")) {
                        d9 = -d9;
                    }
                    if (d > 0.0) {
                        if (null != cDBSRecord) {
                            if (!bl || AppManager.computeDistance(d2, d3, d7, d9, d4) <= d) {
                                cDBSRecord.inSearchRadius = true;
                            }
                        } else if ((!service.isDTS || !bl) && AppManager.computeDistance(d2, d3, d7, d9, d4) > d) continue;
                    }
                    CDBSRecord cDBSRecord2 = new CDBSRecord(string, n);
                    cDBSRecord2.application_id = new Integer(n4);
                    cDBSRecord2.siteNumber = dbConnection.getInt(30);
                    cDBSRecord2.facility_id = n3;
                    cDBSRecord2.service = service;
                    cDBSRecord2.callSign = dbConnection.getString(1);
                    if (null == cDBSRecord2.callSign) {
                        cDBSRecord2.callSign = "";
                    }
                    cDBSRecord2.channel = n2;
                    cDBSRecord2.city = dbConnection.getString(2);
                    if (null == cDBSRecord2.city) {
                        cDBSRecord2.city = "";
                    }
                    cDBSRecord2.state = dbConnection.getString(3);
                    if (null == cDBSRecord2.state) {
                        cDBSRecord2.state = "";
                    }
                    cDBSRecord2.country = country;
                    cDBSRecord2.zoneCode = dbConnection.getString(4);
                    if (null == cDBSRecord2.zoneCode) {
                        cDBSRecord2.zoneCode = "";
                    }
                    cDBSRecord2.status = dbConnection.getString(5);
                    cDBSRecord2.statusType = 5;
                    if (null == cDBSRecord2.status) {
                        cDBSRecord2.status = "";
                    } else {
                        for (int i = 0; i < STATUS_CODES.length; ++i) {
                            if (!cDBSRecord2.status.equalsIgnoreCase(STATUS_CODES[i])) continue;
                            cDBSRecord2.statusType = STATUS_TYPES[i];
                            break;
                        }
                    }
                    cDBSRecord2.filePrefix = dbConnection.getString(6);
                    if (null == cDBSRecord2.filePrefix) {
                        cDBSRecord2.filePrefix = "";
                    }
                    cDBSRecord2.appARN = dbConnection.getString(7);
                    if (null == cDBSRecord2.appARN) {
                        cDBSRecord2.appARN = "";
                    }
                    cDBSRecord2.frequencyOffsetCode = dbConnection.getString(8);
                    if (null == cDBSRecord2.frequencyOffsetCode) {
                        cDBSRecord2.frequencyOffsetCode = "";
                    }
                    cDBSRecord2.emissionMaskCode = dbConnection.getString(9);
                    if (null == cDBSRecord2.emissionMaskCode) {
                        cDBSRecord2.emissionMaskCode = "";
                    }
                    cDBSRecord2.latitudeDirection = string6;
                    cDBSRecord2.latitudeDegrees = n5;
                    cDBSRecord2.latitudeMinutes = n6;
                    cDBSRecord2.latitudeSeconds = d6;
                    cDBSRecord2.longitudeDirection = string5;
                    cDBSRecord2.longitudeDegrees = n7;
                    cDBSRecord2.longitudeMinutes = n8;
                    cDBSRecord2.longitudeSeconds = d8;
                    cDBSRecord2.latitude = d7;
                    cDBSRecord2.longitude = d9;
                    cDBSRecord2.dtsMaximumDistance = d5;
                    cDBSRecord2.heightAMSL = dbConnection.getDouble(18);
                    cDBSRecord2.overallHAAT = dbConnection.getDouble(19);
                    cDBSRecord2.peakERP = dbConnection.getDouble(20);
                    cDBSRecord2.alternateERP = dbConnection.getDouble(21);
                    cDBSRecord2.antenna_id = dbConnection.getInt(22);
                    cDBSRecord2.horizontalPatternOrientation = dbConnection.getDouble(23);
                    cDBSRecord2.elevation_antenna_id = dbConnection.getInt(24);
                    cDBSRecord2.verticalPatternElectricalTilt = dbConnection.getDouble(25);
                    cDBSRecord2.verticalPatternMechanicalTilt = dbConnection.getDouble(26);
                    cDBSRecord2.verticalPatternMechanicalTiltOrientation = dbConnection.getDouble(27);
                    String string7 = dbConnection.getString(28);
                    if (null != string7 && (string7.equalsIgnoreCase("A") || string7.equalsIgnoreCase("R"))) {
                        cDBSRecord2.isArchived = true;
                    }
                    if (null != (string7 = dbConnection.getString(29)) && string7.equalsIgnoreCase("Y")) {
                        cDBSRecord2.daIndicated = true;
                    }
                    linkedList.add(cDBSRecord2);
                    if (!service.isDTS) continue;
                    bl2 = true;
                }
            }
            catch (SQLException sQLException) {
                linkedList = null;
                dbConnection.reportError(errorReporter, sQLException);
            }
            dbConnection.close();
        }
        if (null != linkedList && null == cDBSRecord && bl2) {
            object2 = linkedList.listIterator(0);
            while (object2.hasNext()) {
                object = (CDBSRecord)object2.next();
                if (!((CDBSRecord)object).service.isDTS) continue;
                ((CDBSRecord)object).dtsRecords = CDBSRecord.findRecords(dbConnection, string, n, string2, d, d2, d3, d4, bl, (CDBSRecord)object, errorReporter);
                if (null == ((CDBSRecord)object).dtsRecords) {
                    return null;
                }
                if (((CDBSRecord)object).dtsRecords.isEmpty()) {
                    errorReporter.logMessage(CDBSRecord.makeMessage((CDBSRecord)object, "Ignored bad DTS, no records with site_number > 0."));
                    object2.remove();
                    continue;
                }
                if (!(d > 0.0) || ((CDBSRecord)object).inSearchRadius) continue;
                object2.remove();
            }
        }
        return linkedList;
    }

    public static SourceEditData findSource(DbConnection dbConnection, StudyEditData studyEditData, Integer n, boolean bl, ErrorReporter errorReporter) {
        if (!studyEditData.setStudyParameters(errorReporter)) {
            return null;
        }
        LinkedList<CDBSRecord> linkedList = CDBSRecord.findRecords(dbConnection, studyEditData.dbID, studyEditData.study.cdbsKey, "(application_id = " + n + ")", 0.0, 0.0, 0.0, 0.0, false, errorReporter);
        if (null == linkedList) {
            return null;
        }
        if (linkedList.isEmpty()) {
            errorReporter.logMessage("Record not found for application ID " + n + ".");
            return null;
        }
        CDBSRecord cDBSRecord = linkedList.getFirst();
        if (cDBSRecord.channel < studyEditData.minimumChannel || cDBSRecord.channel > studyEditData.maximumChannel) {
            errorReporter.logMessage(CDBSRecord.makeMessage(cDBSRecord, "Ignored, channel out of range for study."));
            return null;
        }
        return cDBSRecord.makeSource(dbConnection, studyEditData, bl, errorReporter);
    }

    public static int scenarioAddDesireds(DbConnection dbConnection, ScenarioEditData scenarioEditData, String string, double d, double d2, double d3, boolean bl, boolean bl2, boolean bl3, ErrorReporter errorReporter) {
        if (!scenarioEditData.study.setStudyParameters(errorReporter)) {
            return -1;
        }
        double d4 = scenarioEditData.study.coChannelMxDistance;
        double d5 = scenarioEditData.study.kilometersPerDegree;
        boolean bl4 = scenarioEditData.study.checkIndividualDTSDistance;
        LinkedList<CDBSRecord> linkedList = CDBSRecord.findRecords(dbConnection, scenarioEditData.study.dbID, scenarioEditData.study.study.cdbsKey, string = string + " AND (tv_eng_data.station_channel BETWEEN " + scenarioEditData.study.minimumChannel + " AND " + scenarioEditData.study.maximumChannel + ")", d, d2, d3, d5, bl4, errorReporter);
        if (null == linkedList) {
            return -1;
        }
        if (linkedList.isEmpty()) {
            errorReporter.reportWarning("The search did not find any matching records.");
            return -1;
        }
        CDBSRecord.removeAllMX(scenarioEditData, linkedList, bl, bl2, d4, d5);
        ArrayList<SourceEditData> arrayList = new ArrayList<SourceEditData>();
        errorReporter.clearErrors();
        for (CDBSRecord object : linkedList) {
            SourceEditData sourceEditData = scenarioEditData.study.findSharedSource(object.application_id);
            if (null == sourceEditData && null == (sourceEditData = object.makeSource(dbConnection, scenarioEditData.study, true, errorReporter))) {
                if (!errorReporter.hasErrors()) continue;
                return -1;
            }
            arrayList.add(sourceEditData);
        }
        if (bl) {
            bl3 = false;
        }
        for (SourceEditData sourceEditData : arrayList) {
            scenarioEditData.sourceModel.addOrReplace(sourceEditData, true, bl3);
        }
        return arrayList.size();
    }

    public static int scenarioAddUndesireds(DbConnection dbConnection, ScenarioEditData scenarioEditData, String string, double d, double d2, double d3, boolean bl, boolean bl2, ErrorReporter errorReporter) {
        LinkedList<CDBSRecord> linkedList;
        int n;
        if (!scenarioEditData.study.setStudyParameters(errorReporter)) {
            return -1;
        }
        double d4 = scenarioEditData.study.coChannelMxDistance;
        double d5 = scenarioEditData.study.kilometersPerDegree;
        double d6 = scenarioEditData.study.ruleExtraDistance;
        boolean bl3 = scenarioEditData.study.checkIndividualDTSDistance;
        ArrayList<SourceEditData> arrayList = scenarioEditData.sourceModel.getDesiredSources();
        if (arrayList.isEmpty()) {
            errorReporter.reportError("There are no desired stations in the scenario.");
            return -1;
        }
        ArrayList<ChannelDelta> arrayList2 = ChannelDelta.getAllChannelDeltas(dbConnection);
        int n2 = 0;
        int n3 = scenarioEditData.study.maximumChannel - scenarioEditData.study.minimumChannel + 1;
        boolean[] blArray = new boolean[n3];
        for (n = 0; n < n3; ++n) {
            blArray[n] = false;
        }
        for (SourceEditData sourceEditData : arrayList) {
            for (ChannelDelta channelDelta : arrayList2) {
                if (channelDelta.analogOnly && sourceEditData.service.serviceType.digital || (n = sourceEditData.channel + channelDelta.delta) < scenarioEditData.study.minimumChannel || n > scenarioEditData.study.maximumChannel || blArray[n - scenarioEditData.study.minimumChannel] || (sourceEditData.channel < 5 ? n > 4 : (sourceEditData.channel < 7 ? n < 5 || n > 6 : (sourceEditData.channel < 14 ? n < 7 || n > 13 : n < 14)))) continue;
                blArray[n - scenarioEditData.study.minimumChannel] = true;
                if (++n2 != n3) continue;
                break;
            }
            if (n2 != n3) continue;
            break;
        }
        if (0 == n2) {
            errorReporter.reportError("The channel search list is empty.  This should never happen.");
            return -1;
        }
        if (n2 < n3) {
            linkedList = new StringBuilder(string);
            ((StringBuilder)((Object)linkedList)).append(" AND (tv_eng_data.station_channel IN ");
            int n4 = 40;
            for (n = 0; n < n3; ++n) {
                if (!blArray[n]) continue;
                ((StringBuilder)((Object)linkedList)).append((char)n4);
                ((StringBuilder)((Object)linkedList)).append(String.valueOf(n + scenarioEditData.study.minimumChannel));
                n4 = 44;
            }
            ((StringBuilder)((Object)linkedList)).append("))");
            string = ((StringBuilder)((Object)linkedList)).toString();
        } else {
            string = string + " AND (tv_eng_data.station_channel BETWEEN " + scenarioEditData.study.minimumChannel + " AND " + scenarioEditData.study.maximumChannel + ")";
        }
        linkedList = CDBSRecord.findRecords(dbConnection, scenarioEditData.study.dbID, scenarioEditData.study.study.cdbsKey, string, d, d2, d3, d5, bl3, errorReporter);
        if (null == linkedList) {
            return -1;
        }
        if (linkedList.isEmpty()) {
            return 0;
        }
        CDBSRecord.removeAllMX(scenarioEditData, linkedList, bl, bl2, d4, d5);
        ListIterator<CDBSRecord> listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            CDBSRecord cDBSRecord = listIterator.next();
            boolean bl4 = true;
            for (SourceEditData object2 : arrayList) {
                int n5 = cDBSRecord.channel - object2.channel;
                for (ChannelDelta channelDelta : arrayList2) {
                    if (channelDelta.delta != n5 || channelDelta.analogOnly && object2.service.serviceType.digital || (object2.channel < 5 ? cDBSRecord.channel > 4 : (object2.channel < 7 ? cDBSRecord.channel < 5 || cDBSRecord.channel > 6 : object2.channel < 14 && (cDBSRecord.channel < 7 || cDBSRecord.channel > 13)))) continue;
                    double d7 = channelDelta.maximumDistance + d6;
                    if (object2.isParent && bl3) {
                        for (SourceEditData sourceEditData : object2.getDTSSources()) {
                            if (sourceEditData.siteNumber <= 0) continue;
                            if (cDBSRecord.service.isDTS) {
                                for (CDBSRecord cDBSRecord2 : cDBSRecord.dtsRecords) {
                                    if (!(AppManager.computeDistance(sourceEditData.latitude, sourceEditData.longitude, cDBSRecord2.latitude, cDBSRecord2.longitude, d5) <= d7)) continue;
                                    bl4 = false;
                                    break;
                                }
                                if (bl4) continue;
                            } else {
                                if (!(AppManager.computeDistance(sourceEditData.latitude, sourceEditData.longitude, cDBSRecord.latitude, cDBSRecord.longitude, d5) <= d7)) continue;
                                bl4 = false;
                            }
                            break;
                        }
                    } else if (cDBSRecord.service.isDTS && bl3) {
                        for (CDBSRecord cDBSRecord3 : cDBSRecord.dtsRecords) {
                            if (!(AppManager.computeDistance(object2.latitude, object2.longitude, cDBSRecord3.latitude, cDBSRecord3.longitude, d5) <= d7)) continue;
                            bl4 = false;
                            break;
                        }
                    } else if (AppManager.computeDistance(object2.latitude, object2.longitude, cDBSRecord.latitude, cDBSRecord.longitude, d5) <= d7) {
                        bl4 = false;
                    }
                    if (bl4) continue;
                    break;
                }
                if (bl4) continue;
                break;
            }
            if (!bl4) continue;
            listIterator.remove();
        }
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        errorReporter.clearErrors();
        for (CDBSRecord cDBSRecord : linkedList) {
            Object object5 = scenarioEditData.study.findSharedSource(cDBSRecord.application_id);
            if (null == object5 && null == (object5 = cDBSRecord.makeSource(dbConnection, scenarioEditData.study, true, errorReporter))) {
                if (!errorReporter.hasErrors()) continue;
                return -1;
            }
            arrayList3.add(object5);
        }
        for (SourceEditData sourceEditData : arrayList3) {
            scenarioEditData.sourceModel.addOrReplace(sourceEditData, false, !bl);
        }
        return arrayList3.size();
    }

    private static void removeAllMX(ScenarioEditData scenarioEditData, LinkedList<CDBSRecord> linkedList, boolean bl, boolean bl2, double d, double d2) {
        CDBSRecord cDBSRecord;
        ArrayList<SourceEditData> arrayList = scenarioEditData.sourceModel.getSources();
        ListIterator<CDBSRecord> listIterator = linkedList.listIterator(0);
        block0: while (listIterator.hasNext()) {
            cDBSRecord = listIterator.next();
            for (SourceEditData object2 : arrayList) {
                if (!cDBSRecord.application_id.equals(object2.application_id) && (bl || !CDBSRecord.areRecordsMX(cDBSRecord, object2, d, d2))) continue;
                listIterator.remove();
                continue block0;
            }
        }
        if (bl) {
            return;
        }
        final boolean bl3 = bl2;
        Comparator<CDBSRecord> comparator = new Comparator<CDBSRecord>(){

            @Override
            public int compare(CDBSRecord cDBSRecord, CDBSRecord cDBSRecord2) {
                if (cDBSRecord.isPreferredRecord(cDBSRecord2, bl3)) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(linkedList, comparator);
        int n = linkedList.size() - 1;
        for (int i = 0; i < n; ++i) {
            cDBSRecord = linkedList.get(i);
            listIterator = linkedList.listIterator(i + 1);
            while (listIterator.hasNext()) {
                if (!CDBSRecord.areRecordsMX(cDBSRecord, listIterator.next(), d, d2)) continue;
                listIterator.remove();
                --n;
            }
        }
    }

    public SourceEditData makeSource(DbConnection dbConnection, StudyEditData studyEditData, boolean bl, ErrorReporter errorReporter) {
        return this.makeSource(dbConnection, studyEditData, bl, null, errorReporter);
    }

    private SourceEditData makeSource(DbConnection dbConnection, StudyEditData studyEditData, boolean bl, Integer n, ErrorReporter errorReporter) {
        Object object;
        if (!studyEditData.setStudyParameters(errorReporter)) {
            return null;
        }
        boolean bl2 = false;
        errorReporter.clearErrors();
        SourceEditData sourceEditData = SourceEditData.createSource(studyEditData, this.facility_id, this.service, this.country, bl, this.application_id, n, errorReporter);
        if (null == sourceEditData) {
            return null;
        }
        sourceEditData.siteNumber = this.siteNumber;
        sourceEditData.callSign = this.callSign;
        sourceEditData.channel = this.channel;
        sourceEditData.city = this.city;
        sourceEditData.state = this.state;
        sourceEditData.zone = Zone.getZone(dbConnection, this.zoneCode);
        sourceEditData.status = this.status;
        sourceEditData.statusType = this.statusType;
        sourceEditData.fileNumber = this.filePrefix + this.appARN;
        sourceEditData.appARN = this.appARN;
        sourceEditData.frequencyOffset = FrequencyOffset.getFrequencyOffset(dbConnection, this.frequencyOffsetCode);
        if (this.service.serviceType.needsEmissionMask) {
            sourceEditData.emissionMask = EmissionMask.getEmissionMask(dbConnection, this.emissionMaskCode);
            if (0 == sourceEditData.emissionMask.key) {
                sourceEditData.emissionMask = EmissionMask.getDefaultObject(dbConnection);
            }
        } else {
            sourceEditData.emissionMask = EmissionMask.getNullObject();
        }
        sourceEditData.latitude = this.latitude;
        sourceEditData.longitude = this.longitude;
        sourceEditData.dtsMaximumDistance = this.dtsMaximumDistance;
        if (null != this.dtsRecords) {
            CDBSRecord cDBSRecord = null;
            LinkedList<CDBSRecord> linkedList = CDBSRecord.findRecords(dbConnection, studyEditData.dbID, studyEditData.study.cdbsKey, "(tv_eng_data.vsd_service = 'DT') AND (tv_eng_data.eng_record_type IN ('C', 'R')) AND (tv_eng_data.facility_id = " + this.facility_id + ")", 0.0, 0.0, 0.0, 0.0, false, errorReporter);
            if (null == linkedList) {
                return null;
            }
            if (!linkedList.isEmpty()) {
                for (CDBSRecord object2 : linkedList) {
                    if (null != cDBSRecord && cDBSRecord.appARN.compareTo(object2.appARN) >= 0) continue;
                    cDBSRecord = object2;
                }
                cDBSRecord.siteNumber = 0;
            } else {
                cDBSRecord = new CDBSRecord(studyEditData.dbID, this.cdbsKey);
                cDBSRecord.siteNumber = 0;
                cDBSRecord.facility_id = this.facility_id;
                cDBSRecord.callSign = this.callSign;
                cDBSRecord.city = this.city;
                cDBSRecord.state = this.state;
                cDBSRecord.country = this.country;
                cDBSRecord.zoneCode = this.zoneCode;
                cDBSRecord.dtsMaximumDistance = 0.0;
                boolean bl3 = false;
                if (dbConnection.connect(errorReporter)) {
                    block78: {
                        try {
                            dbConnection.query("SELECT post_dtv_channel, latitude, longitude, rcamsl, haat, erp, antenna_id, ref_azimuth FROM tvstudy_cdbs_" + this.cdbsKey + ".dtv_channel_assignments " + "WHERE " + "facility_id = " + this.facility_id);
                            if (dbConnection.next()) {
                                int n2;
                                cDBSRecord.application_id = 0;
                                cDBSRecord.service = Service.getService(dbConnection.copy(), "DT");
                                if (null == cDBSRecord.service) {
                                    bl3 = true;
                                }
                                cDBSRecord.channel = dbConnection.getInt(1);
                                if (cDBSRecord.channel < 2 || cDBSRecord.channel > 69) {
                                    bl3 = true;
                                }
                                cDBSRecord.status = "";
                                cDBSRecord.statusType = 5;
                                cDBSRecord.filePrefix = "FCD";
                                cDBSRecord.appARN = "";
                                cDBSRecord.frequencyOffsetCode = "";
                                cDBSRecord.emissionMaskCode = "";
                                String sQLException = dbConnection.getString(2);
                                String string = dbConnection.getString(3);
                                int n3 = 0;
                                if ('-' == sQLException.charAt(0)) {
                                    n3 = 1;
                                }
                                boolean bl4 = false;
                                if ('-' == string.charAt(0)) {
                                    n2 = 1;
                                }
                                int n4 = 2;
                                if (string.length() - n2 > 6) {
                                    n4 = 3;
                                }
                                try {
                                    cDBSRecord.latitudeDirection = n3 > 0 ? "S" : "N";
                                    cDBSRecord.latitudeDegrees = Integer.parseInt(sQLException.substring(n3, n3 + 2));
                                    cDBSRecord.latitudeMinutes = Integer.parseInt(sQLException.substring(n3 + 2, n3 + 4));
                                    cDBSRecord.latitudeSeconds = Double.parseDouble(sQLException.substring(n3 + 4));
                                    cDBSRecord.longitudeDirection = n2 > 0 ? "E" : "W";
                                    cDBSRecord.longitudeDegrees = Integer.parseInt(string.substring(n2, n2 + n4));
                                    cDBSRecord.longitudeMinutes = Integer.parseInt(string.substring(n2 + n4, n2 + n4 + 2));
                                    cDBSRecord.longitudeSeconds = Double.parseDouble(string.substring(n2 + n4 + 2));
                                    cDBSRecord.latitude = (double)cDBSRecord.latitudeDegrees + (double)cDBSRecord.latitudeMinutes / 60.0 + cDBSRecord.latitudeSeconds / 3600.0;
                                    if (n3 > 0) {
                                        cDBSRecord.latitude = -cDBSRecord.latitude;
                                    }
                                    cDBSRecord.longitude = (double)cDBSRecord.longitudeDegrees + (double)cDBSRecord.longitudeMinutes / 60.0 + cDBSRecord.longitudeSeconds / 3600.0;
                                    if (n2 > 0) {
                                        cDBSRecord.longitude = -cDBSRecord.longitude;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    bl3 = true;
                                }
                                cDBSRecord.heightAMSL = dbConnection.getDouble(4);
                                cDBSRecord.overallHAAT = dbConnection.getDouble(5);
                                cDBSRecord.peakERP = dbConnection.getDouble(6);
                                cDBSRecord.alternateERP = 0.0;
                                cDBSRecord.antenna_id = dbConnection.getInt(7);
                                cDBSRecord.horizontalPatternOrientation = dbConnection.getDouble(8);
                                cDBSRecord.elevation_antenna_id = 0;
                                cDBSRecord.verticalPatternElectricalTilt = 0.0;
                                cDBSRecord.verticalPatternMechanicalTilt = 0.0;
                                cDBSRecord.verticalPatternMechanicalTiltOrientation = 0.0;
                                if (cDBSRecord.antenna_id > 0) {
                                    cDBSRecord.daIndicated = true;
                                }
                                cDBSRecord.isArchived = false;
                                break block78;
                            }
                            bl3 = true;
                        }
                        catch (SQLException sQLException) {
                            bl2 = true;
                            dbConnection.reportError(errorReporter, sQLException);
                        }
                    }
                    dbConnection.close();
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    return null;
                }
                if (bl3) {
                    errorReporter.logMessage(CDBSRecord.makeMessage(this, "Missing or bad DTS reference record, used DTS site 0."));
                    cDBSRecord.application_id = this.application_id;
                    cDBSRecord.service = this.service;
                    cDBSRecord.channel = this.channel;
                    cDBSRecord.status = this.status;
                    cDBSRecord.statusType = this.statusType;
                    cDBSRecord.filePrefix = this.filePrefix;
                    cDBSRecord.appARN = this.appARN;
                    cDBSRecord.frequencyOffsetCode = this.frequencyOffsetCode;
                    cDBSRecord.emissionMaskCode = this.emissionMaskCode;
                    cDBSRecord.latitudeDirection = this.latitudeDirection;
                    cDBSRecord.latitudeDegrees = this.latitudeDegrees;
                    cDBSRecord.latitudeMinutes = this.latitudeMinutes;
                    cDBSRecord.latitudeSeconds = this.latitudeSeconds;
                    cDBSRecord.longitudeDirection = this.longitudeDirection;
                    cDBSRecord.longitudeDegrees = this.longitudeDegrees;
                    cDBSRecord.longitudeMinutes = this.longitudeMinutes;
                    cDBSRecord.longitudeSeconds = this.longitudeSeconds;
                    cDBSRecord.latitude = this.latitude;
                    cDBSRecord.longitude = this.longitude;
                    cDBSRecord.heightAMSL = this.heightAMSL;
                    cDBSRecord.overallHAAT = this.overallHAAT;
                    cDBSRecord.peakERP = this.peakERP;
                    cDBSRecord.alternateERP = this.alternateERP;
                    cDBSRecord.antenna_id = this.antenna_id;
                    cDBSRecord.horizontalPatternOrientation = this.horizontalPatternOrientation;
                    cDBSRecord.elevation_antenna_id = this.elevation_antenna_id;
                    cDBSRecord.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
                    cDBSRecord.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
                    cDBSRecord.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
                    cDBSRecord.daIndicated = this.daIndicated;
                    cDBSRecord.isArchived = this.isArchived;
                }
            }
            Object object4 = cDBSRecord.makeSource(dbConnection, studyEditData, bl, sourceEditData.key, errorReporter);
            if (null == object4) {
                return null;
            }
            sourceEditData.addOrReplaceDTSSource((SourceEditData)object4);
            for (CDBSRecord cDBSRecord2 : this.dtsRecords) {
                object4 = cDBSRecord2.makeSource(dbConnection, studyEditData, bl, sourceEditData.key, errorReporter);
                if (null == object4) {
                    return null;
                }
                sourceEditData.addOrReplaceDTSSource((SourceEditData)object4);
            }
            return sourceEditData;
        }
        sourceEditData.heightAMSL = this.heightAMSL;
        sourceEditData.overallHAAT = this.overallHAAT;
        sourceEditData.peakERP = this.peakERP;
        if (this.antenna_id > 0 && (this.daIndicated || !studyEditData.trustPatternFlag)) {
            object = null;
            if (dbConnection.connect(errorReporter)) {
                try {
                    dbConnection.query("SELECT ant_make, ant_model_num FROM tvstudy_cdbs_" + this.cdbsKey + ".ant_make " + "WHERE " + "antenna_id = " + this.antenna_id);
                    if (dbConnection.next()) {
                        object = dbConnection.getString(1) + "-" + dbConnection.getString(2);
                    } else {
                        errorReporter.logMessage(CDBSRecord.makeMessage(this, "Antenna ID " + this.antenna_id + " not found."));
                    }
                }
                catch (SQLException sQLException) {
                    bl2 = true;
                    dbConnection.reportError(errorReporter, sQLException);
                }
                dbConnection.close();
            } else {
                bl2 = true;
            }
            if (bl2) {
                return null;
            }
            if (null != object) {
                sourceEditData.horizontalPattern = CDBSRecord.getAntennaPattern(dbConnection, this.cdbsKey, this.antenna_id, errorReporter, this);
                if (null != sourceEditData.horizontalPattern && sourceEditData.horizontalPattern.isEmpty()) {
                    sourceEditData.horizontalPattern = null;
                }
                if (null != sourceEditData.horizontalPattern) {
                    sourceEditData.antenna_id = this.antenna_id;
                    sourceEditData.hasHorizontalPattern = true;
                    sourceEditData.horizontalPatternName = object;
                    sourceEditData.horizontalPatternChanged = true;
                } else if (errorReporter.hasErrors()) {
                    return null;
                }
            }
        }
        sourceEditData.horizontalPatternOrientation = this.horizontalPatternOrientation;
        if (this.elevation_antenna_id > 0) {
            object = null;
            boolean bl4 = false;
            if (dbConnection.connect(errorReporter)) {
                try {
                    dbConnection.query("SELECT ant_make, ant_model_num FROM tvstudy_cdbs_" + this.cdbsKey + ".elevation_ant_make " + "WHERE " + "elevation_antenna_id = " + this.elevation_antenna_id);
                    if (dbConnection.next()) {
                        object = dbConnection.getString(1) + "-" + dbConnection.getString(2);
                        dbConnection.query("SELECT COUNT(*) FROM tvstudy_cdbs_" + this.cdbsKey + ".elevation_pattern " + "WHERE " + "elevation_antenna_id = " + this.elevation_antenna_id + " " + "AND field_value0 > 0.");
                        if (dbConnection.next() && dbConnection.getInt(1) > 0) {
                            bl4 = true;
                        }
                    } else {
                        errorReporter.logMessage(CDBSRecord.makeMessage(this, "Elevation antenna ID " + this.elevation_antenna_id + " not found."));
                    }
                }
                catch (SQLException sQLException) {
                    bl2 = true;
                    dbConnection.reportError(errorReporter, sQLException);
                }
                dbConnection.close();
            } else {
                bl2 = true;
            }
            if (bl2) {
                return null;
            }
            if (null != object) {
                if (bl4) {
                    sourceEditData.matrixPattern = CDBSRecord.getMatrixPattern(dbConnection, this.cdbsKey, this.elevation_antenna_id, errorReporter, this);
                    if (null != sourceEditData.matrixPattern) {
                        sourceEditData.hasMatrixPattern = true;
                        sourceEditData.matrixPatternName = object;
                        sourceEditData.matrixPatternChanged = true;
                    } else if (errorReporter.hasErrors()) {
                        return null;
                    }
                } else {
                    sourceEditData.verticalPattern = CDBSRecord.getElevationPattern(dbConnection, this.cdbsKey, this.elevation_antenna_id, errorReporter, this);
                    if (null != sourceEditData.verticalPattern) {
                        sourceEditData.hasVerticalPattern = true;
                        sourceEditData.verticalPatternName = object;
                        sourceEditData.verticalPatternChanged = true;
                    } else if (errorReporter.hasErrors()) {
                        return null;
                    }
                }
            }
        }
        sourceEditData.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        sourceEditData.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        sourceEditData.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        if (sourceEditData.hasMatrixPattern) {
            object = new ArrayList();
            boolean bl5 = false;
            for (Source.PatternSlice patternSlice : sourceEditData.matrixPattern) {
                Source.PatternPoint patternPoint = null;
                for (Source.PatternPoint patternPoint2 : patternSlice.pattern) {
                    if (null != patternPoint && !(patternPoint2.relativeField > patternPoint.relativeField)) continue;
                    patternPoint = patternPoint2;
                }
                ((ArrayList)object).add(new Source.PatternPoint(patternSlice.azimuth, patternPoint.relativeField));
                if (!(patternPoint.relativeField < 0.977)) continue;
                bl5 = true;
            }
            if (bl5) {
                sourceEditData.horizontalPattern = object;
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    double d = ((Source.PatternPoint)((ArrayList)object).get((int)i)).relativeField;
                    for (Source.PatternPoint patternPoint : sourceEditData.matrixPattern.get((int)i).pattern) {
                        patternPoint.relativeField /= d;
                    }
                }
                sourceEditData.antenna_id = 0;
                sourceEditData.hasHorizontalPattern = true;
                sourceEditData.horizontalPatternName = "(matrix derived)";
                sourceEditData.horizontalPatternChanged = true;
                sourceEditData.horizontalPatternOrientation = 0.0;
            }
        }
        if (2 == sourceEditData.country.key) {
            sourceEditData.useGenericVerticalPattern = studyEditData.useGenericVpatForCanada;
        }
        if (3 == this.country.key && (1 == this.service.serviceType.key || 2 == this.service.serviceType.key)) {
            if (0.0 == this.peakERP) {
                sourceEditData.peakERP = 1 == this.service.serviceType.key ? (this.channel < 7 ? studyEditData.defaultMexicanDigitalVloERP : (this.channel < 14 ? studyEditData.defaultMexicanDigitalVhiERP : studyEditData.defaultMexicanDigitalUhfERP)) : (this.channel < 7 ? studyEditData.defaultMexicanAnalogVloERP : (this.channel < 14 ? studyEditData.defaultMexicanAnalogVhiERP : studyEditData.defaultMexicanAnalogUhfERP));
                errorReporter.logMessage(CDBSRecord.makeMessage(this, "Used default for missing ERP."));
            }
            if (0.0 == this.heightAMSL && 0.0 == this.overallHAAT) {
                sourceEditData.overallHAAT = 1 == this.service.serviceType.key ? (this.channel < 7 ? studyEditData.defaultMexicanDigitalVloHAAT : (this.channel < 14 ? studyEditData.defaultMexicanDigitalVhiHAAT : studyEditData.defaultMexicanDigitalUhfHAAT)) : (this.channel < 7 ? studyEditData.defaultMexicanAnalogVloHAAT : (this.channel < 14 ? studyEditData.defaultMexicanAnalogVhiHAAT : studyEditData.defaultMexicanAnalogUhfHAAT));
                errorReporter.logMessage(CDBSRecord.makeMessage(this, "Used default for missing HAAT."));
            }
        }
        if (1 != this.country.key && 0.0 == this.heightAMSL && 0.0 != this.overallHAAT) {
            sourceEditData.heightAMSL = -999.0;
            errorReporter.logMessage(CDBSRecord.makeMessage(this, "Derived missing AMSL from HAAT."));
        }
        if (this.peakERP <= 0.0) {
            sourceEditData.peakERP = Math.pow(10.0, this.peakERP / 10.0);
            errorReporter.logMessage(CDBSRecord.makeMessage(this, "Converted ERP from dBk to kilowatts."));
        }
        if (this.verticalPatternMechanicalTilt > 11.1 && this.verticalPatternMechanicalTiltOrientation <= 11.1) {
            sourceEditData.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTiltOrientation;
            sourceEditData.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTilt;
            errorReporter.logMessage(CDBSRecord.makeMessage(this, "Transposed mechanical tilt parameters."));
        }
        if (this.verticalPatternElectricalTilt < -10.0 || this.verticalPatternElectricalTilt > 11.1) {
            sourceEditData.verticalPatternElectricalTilt = 0.0;
            errorReporter.logMessage(CDBSRecord.makeMessage(this, "Ignored out-of-range electrical tilt."));
        }
        if (this.verticalPatternMechanicalTilt < -10.0 || this.verticalPatternMechanicalTilt > 11.1) {
            sourceEditData.verticalPatternMechanicalTilt = 0.0;
            errorReporter.logMessage(CDBSRecord.makeMessage(this, "Ignored out-of-range mechanical tilt."));
        }
        if (this.verticalPatternMechanicalTilt != 0.0 && 0.0 == this.verticalPatternMechanicalTiltOrientation) {
            errorReporter.logMessage(CDBSRecord.makeMessage(this, "Used 0 for missing mechanical tilt orientation."));
        }
        if (1 == this.country.key && 1 != this.service.serviceType.key && 2 != this.service.serviceType.key && this.alternateERP > this.peakERP) {
            sourceEditData.peakERP = this.alternateERP;
            errorReporter.logMessage(CDBSRecord.makeMessage(this, "Using ERP value from max_erp_any_angle."));
        }
        return sourceEditData;
    }

    public static ArrayList<Source.PatternPoint> getAntennaPattern(DbConnection dbConnection, int n, int n2, ErrorReporter errorReporter) {
        return CDBSRecord.getAntennaPattern(dbConnection, n, n2, errorReporter, null);
    }

    public static ArrayList<Source.PatternPoint> getAntennaPattern(DbConnection dbConnection, int n, int n2, ErrorReporter errorReporter, CDBSRecord cDBSRecord) {
        ArrayList<Source.PatternPoint> arrayList = null;
        boolean bl = false;
        String string = null;
        if (dbConnection.connect(errorReporter)) {
            try {
                dbConnection.query("SELECT azimuth, field_value FROM tvstudy_cdbs_" + n + ".ant_pattern " + "WHERE " + "antenna_id = " + n2 + " " + "ORDER BY 1");
                arrayList = new ArrayList<Source.PatternPoint>();
                double d = -1.0;
                double d2 = 0.001;
                while (dbConnection.next()) {
                    double d3 = Math.rint(dbConnection.getDouble(1) * 1000.0) / 1000.0;
                    if (d3 < 0.0 || d3 > 359.999) {
                        bl = true;
                        string = "azimuth out of range";
                        break;
                    }
                    if (d3 <= d) {
                        bl = true;
                        string = "duplicate azimuths";
                        break;
                    }
                    d = d3;
                    double d4 = Math.rint(dbConnection.getDouble(2) * 1000.0) / 1000.0;
                    if (d4 < 0.001) {
                        d4 = 0.001;
                    }
                    if (d4 > 1.0) {
                        bl = true;
                        string = "relative field out of range";
                        break;
                    }
                    if (d4 > d2) {
                        d2 = d4;
                    }
                    arrayList.add(new Source.PatternPoint(d3, d4));
                }
                if (!arrayList.isEmpty()) {
                    if (!bl && arrayList.size() < 2) {
                        bl = true;
                        string = "not enough points";
                    }
                    if (!bl && d2 < 0.977) {
                        String string2 = "Pattern for antenna ID " + n2 + " does not have a 1.";
                        if (null != cDBSRecord) {
                            string2 = CDBSRecord.makeMessage(cDBSRecord, string2);
                        }
                        errorReporter.logMessage(string2);
                    }
                }
            }
            catch (SQLException sQLException) {
                arrayList = null;
                dbConnection.reportError(errorReporter, sQLException);
            }
            dbConnection.close();
        }
        if (bl) {
            String string3 = "Pattern for antenna ID " + n2 + " is bad, " + string;
            if (null != cDBSRecord) {
                errorReporter.logMessage(CDBSRecord.makeMessage(cDBSRecord, string3 + "."));
            } else {
                errorReporter.reportError(string3 + ".");
            }
            arrayList = null;
        }
        return arrayList;
    }

    public static ArrayList<Source.PatternPoint> getElevationPattern(DbConnection dbConnection, int n, int n2, ErrorReporter errorReporter) {
        return CDBSRecord.getElevationPattern(dbConnection, n, n2, "", errorReporter, null);
    }

    public static ArrayList<Source.PatternPoint> getElevationPattern(DbConnection dbConnection, int n, int n2, ErrorReporter errorReporter, CDBSRecord cDBSRecord) {
        return CDBSRecord.getElevationPattern(dbConnection, n, n2, "", errorReporter, cDBSRecord);
    }

    private static ArrayList<Source.PatternPoint> getElevationPattern(DbConnection dbConnection, int n, int n2, String string, ErrorReporter errorReporter, CDBSRecord cDBSRecord) {
        ArrayList<Source.PatternPoint> arrayList = null;
        boolean bl = false;
        boolean bl2 = true;
        String string2 = null;
        if (dbConnection.connect(errorReporter)) {
            try {
                dbConnection.query("SELECT depression_angle,field_value" + string + " " + "FROM " + "tvstudy_cdbs_" + n + ".elevation_pattern " + "WHERE " + "elevation_antenna_id = " + n2 + " " + "ORDER BY 1");
                arrayList = new ArrayList<Source.PatternPoint>();
                double d = -91.0;
                double d2 = 0.001;
                while (dbConnection.next()) {
                    double d3 = Math.rint(dbConnection.getDouble(1) * 1000.0) / 1000.0;
                    if (d3 < -90.0 || d3 > 90.0) {
                        bl = true;
                        string2 = "depression angle out of range";
                        break;
                    }
                    if (d3 <= d) {
                        bl = true;
                        string2 = "duplicate depression angles";
                        break;
                    }
                    d = d3;
                    double d4 = Math.rint(dbConnection.getDouble(2) * 1000.0) / 1000.0;
                    if (d4 < 0.001) {
                        d4 = 0.001;
                    } else {
                        bl2 = false;
                    }
                    if (d4 > 1.0) {
                        bl = true;
                        break;
                    }
                    if (d4 > d2) {
                        d2 = d4;
                    }
                    arrayList.add(new Source.PatternPoint(d3, d4));
                }
                if (!bl && (arrayList.isEmpty() || bl2)) {
                    bl = true;
                    string2 = "pattern data not found";
                }
                if (!bl && arrayList.size() < 2) {
                    bl = true;
                    string2 = "not enough points";
                }
                if (!bl && string.equals("") && d2 < 0.977) {
                    String string3 = "Pattern for elevation antenna ID " + n2 + " does not have a 1.";
                    if (null != cDBSRecord) {
                        string3 = CDBSRecord.makeMessage(cDBSRecord, string3);
                    }
                    errorReporter.logMessage(string3);
                }
            }
            catch (SQLException sQLException) {
                arrayList = null;
                dbConnection.reportError(errorReporter, sQLException);
            }
            dbConnection.close();
        }
        if (bl) {
            String string4 = "Pattern for elevation antenna ID " + n2 + " is bad, " + string2;
            if (null != cDBSRecord) {
                errorReporter.logMessage(CDBSRecord.makeMessage(cDBSRecord, string4 + "."));
            } else {
                errorReporter.reportError(string4 + ".");
            }
            arrayList = null;
        }
        return arrayList;
    }

    public static ArrayList<Source.PatternSlice> getMatrixPattern(DbConnection dbConnection, int n, int n2, ErrorReporter errorReporter) {
        return CDBSRecord.getMatrixPattern(dbConnection, n, n2, errorReporter, null);
    }

    public static ArrayList<Source.PatternSlice> getMatrixPattern(DbConnection dbConnection, int n, int n2, ErrorReporter errorReporter, CDBSRecord cDBSRecord) {
        int n3;
        ArrayList<Source.PatternSlice> arrayList = new ArrayList<Source.PatternSlice>();
        Source.PatternSlice patternSlice = null;
        ArrayList<Source.PatternPoint> arrayList2 = null;
        double d = 0.001;
        for (n3 = 0; n3 < 360; n3 += 10) {
            arrayList2 = CDBSRecord.getElevationPattern(dbConnection, n, n2, String.valueOf(n3), errorReporter, cDBSRecord);
            if (null == arrayList2) {
                return null;
            }
            for (Source.PatternPoint patternPoint2 : arrayList2) {
                if (!(patternPoint2.relativeField > d)) continue;
                d = patternPoint2.relativeField;
            }
            patternSlice = new Source.PatternSlice(n3, arrayList2);
            arrayList.add(patternSlice);
        }
        n3 = 0;
        Object object = null;
        if (dbConnection.connect(errorReporter)) {
            try {
                dbConnection.query("SELECT azimuth,depression_angle,field_value FROM tvstudy_cdbs_" + n + ".elevation_pattern_addl " + "WHERE " + "elevation_antenna_id = " + n2 + " " + "ORDER BY 1, 2");
                arrayList2 = null;
                double d2 = -1.0;
                double d3 = 0.0;
                boolean bl = false;
                while (dbConnection.next()) {
                    double d4;
                    int n4;
                    double d5 = Math.rint(dbConnection.getDouble(1) * 1000.0) / 1000.0;
                    if (d5 < 0.0 || d5 > 359.999) {
                        n3 = 1;
                        object = "azimuth out of range";
                        break;
                    }
                    if (d5 != d2) {
                        if (bl && arrayList2.size() < 2) {
                            n3 = 1;
                            object = "not enough points, at azimuth " + patternSlice.azimuth;
                            break;
                        }
                        bl = true;
                        for (n4 = 0; n4 < arrayList.size(); ++n4) {
                            patternSlice = arrayList.get(n4);
                            if (d5 == patternSlice.azimuth) {
                                bl = false;
                                break;
                            }
                            if (d5 < patternSlice.azimuth) break;
                        }
                        if (bl) {
                            arrayList2 = new ArrayList();
                            patternSlice = new Source.PatternSlice(d5, arrayList2);
                            arrayList.add(n4, patternSlice);
                        } else {
                            arrayList2 = patternSlice.pattern;
                        }
                        d2 = d5;
                        d3 = -91.0;
                    }
                    if ((d4 = Math.rint(dbConnection.getDouble(2) * 1000.0) / 1000.0) < -90.0 || d4 > 90.0) {
                        n3 = 1;
                        object = "depression angle out of range, at azimuth " + patternSlice.azimuth;
                        break;
                    }
                    if (d4 <= d3) {
                        n3 = 1;
                        object = "duplicate depression angles, at azimuth " + patternSlice.azimuth;
                        break;
                    }
                    d3 = d4;
                    double d6 = Math.rint(dbConnection.getDouble(3) * 1000.0) / 1000.0;
                    if (d6 < 0.001) {
                        d6 = 0.001;
                    }
                    if (d6 > 1.0) {
                        n3 = 1;
                        object = "field value greater than 1, at azimuth " + patternSlice.azimuth;
                        break;
                    }
                    if (d6 > d) {
                        d = d6;
                    }
                    Source.PatternPoint patternPoint = new Source.PatternPoint(d4, d6);
                    if (bl) {
                        arrayList2.add(patternPoint);
                        continue;
                    }
                    for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                        Source.PatternPoint patternPoint2;
                        patternPoint2 = arrayList2.get(n4);
                        if (d4 == patternPoint2.azimuthOrDepression) {
                            n3 = 1;
                            object = "duplicate depression angles, at azimuth " + patternSlice.azimuth;
                            break;
                        }
                        if (d4 < patternPoint2.azimuthOrDepression) break;
                    }
                    if (n3 != 0) break;
                    arrayList2.add(n4, patternPoint);
                }
                if (n3 == 0 && bl && arrayList2.size() < 2) {
                    n3 = 1;
                    object = "not enough points, at azimuth " + patternSlice.azimuth;
                }
                if (n3 == 0 && d < 0.977) {
                    String string = "Pattern for elevation antenna ID " + n2 + " does not have a 1.";
                    if (null != cDBSRecord) {
                        string = CDBSRecord.makeMessage(cDBSRecord, string);
                    }
                    errorReporter.logMessage(string);
                }
            }
            catch (SQLException sQLException) {
                arrayList = null;
                dbConnection.reportError(errorReporter, sQLException);
            }
            dbConnection.close();
        }
        if (n3 != 0) {
            String string = "Pattern for elevation antenna ID " + n2 + " is bad, " + object;
            if (null != cDBSRecord) {
                errorReporter.logMessage(CDBSRecord.makeMessage(cDBSRecord, string + "."));
            } else {
                errorReporter.reportError(string + ".");
            }
            arrayList = null;
        }
        return arrayList;
    }

    public static String makeMessage(CDBSRecord cDBSRecord, String string) {
        return CDBSRecord.makeMessage(cDBSRecord.facility_id, cDBSRecord.callSign, cDBSRecord.service, cDBSRecord.channel, cDBSRecord.status, string);
    }

    public static String makeMessage(SourceEditData sourceEditData, String string) {
        return CDBSRecord.makeMessage(sourceEditData.facility_id, sourceEditData.callSign, sourceEditData.service, sourceEditData.channel, sourceEditData.status, string);
    }

    public static String makeMessage(int n, String string, Service service, int n2, String string2, String string3) {
        String string4 = "";
        string4 = service.serviceType.digital ? "D" + n2 : "N" + n2;
        return String.format("%6d %-8.8s %-3.3s %-6.6s: %s", n, string, string4, string2, string3);
    }

    public static boolean areRecordsMX(CDBSRecord cDBSRecord, CDBSRecord cDBSRecord2, double d, double d2) {
        return CDBSRecord.areRecordsMX(cDBSRecord.facility_id, cDBSRecord.channel, cDBSRecord.country.key, cDBSRecord.state, cDBSRecord.city, cDBSRecord.latitude, cDBSRecord.longitude, cDBSRecord2.facility_id, cDBSRecord2.channel, cDBSRecord2.country.key, cDBSRecord2.state, cDBSRecord2.city, cDBSRecord2.latitude, cDBSRecord2.longitude, d, d2);
    }

    public static boolean areRecordsMX(CDBSRecord cDBSRecord, SourceEditData sourceEditData, double d, double d2) {
        return CDBSRecord.areRecordsMX(cDBSRecord.facility_id, cDBSRecord.channel, cDBSRecord.country.key, cDBSRecord.state, cDBSRecord.city, cDBSRecord.latitude, cDBSRecord.longitude, sourceEditData.facility_id, sourceEditData.channel, sourceEditData.country.key, sourceEditData.state, sourceEditData.city, sourceEditData.latitude, sourceEditData.longitude, d, d2);
    }

    public static boolean areRecordsMX(CDBSRecord cDBSRecord, int n, SourceEditData sourceEditData, double d, double d2) {
        return CDBSRecord.areRecordsMX(cDBSRecord.facility_id, n, cDBSRecord.country.key, cDBSRecord.state, cDBSRecord.city, cDBSRecord.latitude, cDBSRecord.longitude, sourceEditData.facility_id, sourceEditData.channel, sourceEditData.country.key, sourceEditData.state, sourceEditData.city, sourceEditData.latitude, sourceEditData.longitude, d, d2);
    }

    public static boolean areRecordsMX(SourceEditData sourceEditData, SourceEditData sourceEditData2, double d, double d2) {
        return CDBSRecord.areRecordsMX(sourceEditData.facility_id, sourceEditData.channel, sourceEditData.country.key, sourceEditData.state, sourceEditData.city, sourceEditData.latitude, sourceEditData.longitude, sourceEditData2.facility_id, sourceEditData2.channel, sourceEditData2.country.key, sourceEditData2.state, sourceEditData2.city, sourceEditData2.latitude, sourceEditData2.longitude, d, d2);
    }

    private static boolean areRecordsMX(int n, int n2, int n3, String string, String string2, double d, double d2, int n4, int n5, int n6, String string3, String string4, double d3, double d4, double d5, double d6) {
        if (n == n4) {
            return true;
        }
        if (n2 != n5) {
            return false;
        }
        if (n3 != n6) {
            return false;
        }
        if (string.equalsIgnoreCase(string3) && string2.equalsIgnoreCase(string4)) {
            return true;
        }
        return d5 > 0.0 && AppManager.computeDistance(d, d2, d3, d4, d6) < d5;
    }

    public boolean isPreferredRecord(CDBSRecord cDBSRecord, boolean bl) {
        if (bl) {
            if (this.isOperating()) {
                if (!cDBSRecord.isOperating()) {
                    return true;
                }
            } else if (cDBSRecord.isOperating()) {
                return false;
            }
        }
        if (this.service.preferenceRank > cDBSRecord.service.preferenceRank) {
            return true;
        }
        if (this.service.preferenceRank < cDBSRecord.service.preferenceRank) {
            return false;
        }
        if (this.statusType < cDBSRecord.statusType) {
            return true;
        }
        if (this.statusType > cDBSRecord.statusType) {
            return false;
        }
        int n = this.appARN.compareTo(cDBSRecord.appARN);
        if (n > 0) {
            return true;
        }
        if (n < 0) {
            return false;
        }
        return this.application_id > cDBSRecord.application_id;
    }

    public boolean isOperating() {
        if (this.operatingStatusSet) {
            return this.isOperatingFacility;
        }
        if (!this.service.isOperating || this.isArchived) {
            this.isOperatingFacility = false;
        } else {
            switch (this.statusType) {
                case 0: 
                case 2: {
                    this.isOperatingFacility = true;
                    break;
                }
                case 1: {
                    if (1 == this.country.key) {
                        this.isOperatingFacility = CDBSRecord.hasLicenseApp(this.dbID, this.cdbsKey, this.facility_id, this.appARN);
                        break;
                    }
                    this.isOperatingFacility = true;
                    break;
                }
                case 4: {
                    if (1 == this.country.key) {
                        this.isOperatingFacility = false;
                        break;
                    }
                    this.isOperatingFacility = true;
                    break;
                }
                default: {
                    this.isOperatingFacility = false;
                }
            }
        }
        this.operatingStatusSet = true;
        return this.isOperatingFacility;
    }

    private static synchronized boolean hasLicenseApp(String string, int n, int n2, String string2) {
        Object object;
        String string3 = string + "_" + n;
        HashMap<Integer, String> hashMap = licenseAppLists.get(string3);
        if (null == hashMap) {
            hashMap = new HashMap();
            object = DbManager.getDb(string).copy();
            if (((DbConnection)object).connect()) {
                try {
                    ((DbConnection)object).query("SELECT facility_id, app_arn FROM tvstudy_cdbs_" + n + ".application " + "WHERE " + "(app_type = 'L') " + "AND (LENGTH(app_arn) = 11) " + "ORDER BY 2");
                    while (((DbConnection)object).next()) {
                        hashMap.put(new Integer(((DbConnection)object).getInt(1)), ((DbConnection)object).getString(2));
                    }
                }
                catch (SQLException sQLException) {
                    ((DbConnection)object).reportError(sQLException);
                }
                ((DbConnection)object).close(false);
            }
            licenseAppLists.put(string3, hashMap);
        }
        if (null == (object = hashMap.get(new Integer(n2)))) {
            return false;
        }
        return ((String)object).compareTo(string2) > 0;
    }
}

