/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.editdata;

import gov.fcc.tvstudy.util.DateCounter;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

public class CDBSDatabase {
    public int key;
    public String name;
    public int useCount;

    public CDBSDatabase(int n, String string, int n2) {
        this.key = n;
        this.name = string;
        this.useCount = n2;
    }

    public static ArrayList<CDBSDatabase> getCDBSDatabases(DbConnection dbConnection, ErrorReporter errorReporter) {
        ArrayList<CDBSDatabase> arrayList = null;
        if (dbConnection.connect(errorReporter)) {
            try {
                dbConnection.query("SELECT cdbs_key, CASE WHEN (LENGTH(name) > 0) THEN name ELSE id END, use_count FROM tvstudy.cdbs ORDER BY 2");
                arrayList = new ArrayList<CDBSDatabase>();
                while (dbConnection.next()) {
                    arrayList.add(new CDBSDatabase(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getInt(3)));
                }
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(errorReporter, sQLException);
                arrayList = null;
            }
            dbConnection.close();
        }
        return arrayList;
    }

    public static Integer createNewDatabase(DbConnection dbConnection, File file, String string, ErrorReporter errorReporter) {
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        BufferedReader bufferedReader3 = null;
        BufferedReader bufferedReader4 = null;
        BufferedReader bufferedReader5 = null;
        BufferedReader bufferedReader6 = null;
        BufferedReader bufferedReader7 = null;
        BufferedReader bufferedReader8 = null;
        BufferedReader bufferedReader9 = null;
        BufferedReader bufferedReader10 = null;
        BufferedReader bufferedReader11 = null;
        boolean bl = false;
        String string2 = "";
        try {
            string2 = "application.dat";
            bufferedReader = new BufferedReader(new FileReader(new File(file, string2)));
            string2 = "facility.dat";
            bufferedReader2 = new BufferedReader(new FileReader(new File(file, string2)));
            string2 = "supp_facility.dat";
            bufferedReader3 = new BufferedReader(new FileReader(new File(file, string2)));
            string2 = "tv_eng_data.dat";
            bufferedReader4 = new BufferedReader(new FileReader(new File(file, string2)));
            string2 = "tv_app_indicators.dat";
            bufferedReader5 = new BufferedReader(new FileReader(new File(file, string2)));
            string2 = "dtv_channel_assignments.dat";
            bufferedReader6 = new BufferedReader(new FileReader(new File(file, string2)));
            string2 = "ant_make.dat";
            bufferedReader7 = new BufferedReader(new FileReader(new File(file, string2)));
            string2 = "ant_pattern.dat";
            bufferedReader8 = new BufferedReader(new FileReader(new File(file, string2)));
            string2 = "elevation_ant_make.dat";
            bufferedReader9 = new BufferedReader(new FileReader(new File(file, string2)));
            string2 = "elevation_pattern.dat";
            bufferedReader10 = new BufferedReader(new FileReader(new File(file, string2)));
            string2 = "elevation_pattern_addl.dat";
            bufferedReader11 = new BufferedReader(new FileReader(new File(file, string2)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = true;
        }
        if (bl) {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null != bufferedReader2) {
                try {
                    bufferedReader2.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null != bufferedReader3) {
                try {
                    bufferedReader3.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null != bufferedReader4) {
                try {
                    bufferedReader4.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null != bufferedReader5) {
                try {
                    bufferedReader5.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null != bufferedReader6) {
                try {
                    bufferedReader6.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null != bufferedReader7) {
                try {
                    bufferedReader7.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null != bufferedReader8) {
                try {
                    bufferedReader8.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null != bufferedReader9) {
                try {
                    bufferedReader9.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null != bufferedReader10) {
                try {
                    bufferedReader10.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null != bufferedReader11) {
                try {
                    bufferedReader11.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            errorReporter.reportError("CDBS data file '" + string2 + "' could not be opened.", 2);
            return null;
        }
        if (!dbConnection.connect(errorReporter)) {
            return null;
        }
        String string3 = "";
        int n = 0;
        try {
            dbConnection.update("LOCK TABLES tvstudy.cdbs_key_sequence WRITE");
            dbConnection.update("UPDATE tvstudy.cdbs_key_sequence SET cdbs_key = cdbs_key + 1");
            dbConnection.query("SELECT cdbs_key FROM tvstudy.cdbs_key_sequence");
            dbConnection.next();
            n = dbConnection.getInt(1);
            dbConnection.update("UNLOCK TABLES");
            dbConnection.update("CREATE DATABASE tvstudy_cdbs_" + n);
            dbConnection.update("USE tvstudy_cdbs_" + n);
            dbConnection.update("CREATE TABLE application (app_arn CHAR(12),app_service CHAR(2),application_id INT,facility_id INT,file_prefix CHAR(10),comm_city CHAR(20),comm_state CHAR(2),fac_frequency FLOAT,station_channel INT,fac_callsign CHAR(12),general_app_service CHAR(2),app_type CHAR(4),paper_filed_ind CHAR(1),dtv_type CHAR(8),frn CHAR(10),shortform_app_arn CHAR(12),shortform_file_prefix CHAR(10),corresp_ind CHAR(1),assoc_facility_id INT,network_affil CHAR(100),sat_tv_ind CHAR(1),comm_county CHAR(20),comm_zip1 CHAR(5),comm_zip2 CHAR(4),last_change_date CHAR(20),INDEX (application_id))");
            boolean[] blArray = new boolean[]{true, true, false, false, true, true, true, false, false, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true};
            dbConnection.update("CREATE TABLE facility (comm_city CHAR(20),comm_state CHAR(2),eeo_rpt_ind CHAR(1),fac_address1 CHAR(40),fac_address2 CHAR(40),fac_callsign CHAR(12),fac_channel INT,fac_city CHAR(20),fac_country CHAR(2),fac_frequency FLOAT,fac_service CHAR(2),fac_state CHAR(2),fac_status_date CHAR(20),fac_type CHAR(3),facility_id INT,lic_expiration_date CHAR(20),fac_status CHAR(5),fac_zip1 CHAR(5),fac_zip2 CHAR(4),station_type CHAR(1),assoc_facility_id INT,callsign_eff_date CHAR(20),tsid_ntsc INT,tsid_dtv INT,digital_status CHAR(1),sat_tv CHAR(1),network_affil CHAR(100),nielsen_dma CHAR(60),tv_virtual_channel INT,last_change_date CHAR(20),INDEX (facility_id))");
            boolean[] blArray2 = new boolean[]{true, true, true, true, true, true, false, true, true, false, true, true, true, true, false, true, true, true, true, true, false, true, false, false, true, true, true, true, false, true};
            dbConnection.update("CREATE TABLE supp_facility (parent_facility_id INT,supp_type CHAR(5),supp_callsign CHAR(12),supp_fac_status CHAR(5),status_date CHAR(20),site_number TINYINT,fac_channel INT,comm_city CHAR(20),comm_state CHAR(2),last_update_date CHAR(20))");
            boolean[] blArray3 = new boolean[]{false, true, true, true, true, false, false, true, true, true};
            dbConnection.update("CREATE TABLE tv_eng_data (ant_input_pwr FLOAT,ant_max_pwr_gain FLOAT,ant_polarization CHAR(1),antenna_id INT,antenna_type CHAR(1),application_id INT,asrn_na_ind CHAR(1),asrn INT,aural_freq FLOAT,avg_horiz_pwr_gain FLOAT,biased_lat FLOAT,biased_long FLOAT,border_code CHAR(1),carrier_freq FLOAT,docket_num CHAR(20),effective_erp FLOAT,electrical_deg FLOAT,elev_amsl FLOAT,elev_bldg_ag FLOAT,eng_record_type CHAR(1),fac_zone CHAR(3),facility_id INT,freq_offset CHAR(1),gain_area FLOAT,haat_rc_mtr FLOAT,hag_overall_mtr FLOAT,hag_rc_mtr FLOAT,horiz_bt_erp FLOAT,lat_deg INT,lat_dir CHAR(1),lat_min INT,lat_sec FLOAT,lon_deg INT,lon_dir CHAR(1),lon_min INT,lon_sec FLOAT,loss_area FLOAT,max_ant_pwr_gain FLOAT,max_erp_dbk FLOAT,max_erp_kw FLOAT,max_haat FLOAT,mechanical_deg FLOAT,multiplexor_loss FLOAT,power_output_vis_dbk FLOAT,power_output_vis_kw FLOAT,predict_coverage_area FLOAT,predict_pop INT,terrain_data_src_other CHAR(255),terrain_data_src CHAR(3),tilt_towards_azimuth FLOAT,true_deg FLOAT,tv_dom_status CHAR(6),upperband_freq FLOAT,vert_bt_erp FLOAT,visual_freq FLOAT,vsd_service CHAR(2),rcamsl_horiz_mtr FLOAT,ant_rotation FLOAT,input_trans_line FLOAT,max_erp_to_hor FLOAT,trans_line_loss FLOAT,lottery_group INT,analog_channel INT,lat_whole_secs INT,lon_whole_secs INT,max_erp_any_angle FLOAT,station_channel INT,lic_ant_make CHAR(3),lic_ant_model_num CHAR(60),dt_emission_mask CHAR(1),site_number TINYINT,elevation_antenna_id INT,last_change_date CHAR(20),INDEX (application_id),INDEX (facility_id))");
            boolean[] blArray4 = new boolean[]{false, false, true, false, true, false, true, false, false, false, false, false, true, false, true, false, false, false, false, true, true, false, true, false, false, false, false, false, false, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, true};
            dbConnection.update("CREATE TABLE tv_app_indicators (ant_struc_reqs_ind CHAR(1),application_id INT,bt_used_ind CHAR(1),da_ind CHAR(1),elec_bt_prop_ind CHAR(1),int_compl_ind CHAR(1),mech_bt_prop_ind CHAR(1),rule_73_1660_ind CHAR(1),rule_73_607_ind CHAR(1),rule_73_610_ind CHAR(1),rule_73_614_ind CHAR(1),rule_73_685ab_ind CHAR(1),coverage_exhibit_ind CHAR(1),rule_73_685dg_ind CHAR(1),dummy_tx_flag CHAR(1),da_exhibit_ind CHAR(1),rule_74_705_ind CHAR(1),rule_74_706_ind CHAR(1),rule_74_707_ind CHAR(1),rule_73_622_ind CHAR(1),ant_5km_ind CHAR(1),rule_73_62_ind CHAR(1),rule_1_1307_ind CHAR(1),rule_73_625_ind CHAR(1),rad_astr_ind CHAR(1),faa_notified_ind CHAR(1),rule_73_623a_ind CHAR(1),no_rotation_ind CHAR(1),rel_field_values_na CHAR(1),studio_in_comm_ind CHAR(1),rule_73_1690c_3_ind CHAR(1),rule_74_786d_ind CHAR(1),no_suitable_incore_ind CHAR(1),rule_74_786e_wirels_ind CHAR(1),rule_74_786e_agr_ind CHAR(1),rule_74_786e_notif_ind CHAR(1),noise_limited_ind CHAR(1),population_match_ind CHAR(1),maximization_ind CHAR(1),site_number TINYINT,interference_prot_ind CHAR(1),dts_covers_all_area_ind CHAR(1),dts_coverage_within_area_flg CHAR(2),dts_coverage_contiguous_ind CHAR(1),dts_principal_comm_cover_flg CHAR(2),dts_combined_interference_ind CHAR(1),dts_trans_within_area_ind CHAR(1),dts_elev_pattern_varies_ind CHAR(1),last_change_date CHAR(20),INDEX (application_id))");
            boolean[] blArray5 = new boolean[]{true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true};
            dbConnection.update("CREATE TABLE dtv_channel_assignments (facility_id INT,state CHAR(2),city CHAR(20),ntsc_channel INT,post_dtv_channel INT,erp FLOAT,haat FLOAT,antenna_id INT,latitude CHAR(10),longitude CHAR(11),rcamsl INT,ref_azimuth INT,da_ind CHAR(1),pre_dtv_channel INT,callsign CHAR(12))");
            boolean[] blArray6 = new boolean[]{false, true, true, false, false, false, false, false, true, true, false, false, true, false, true};
            dbConnection.update("CREATE TABLE ant_make (antenna_id INT,ant_make CHAR(3),ant_model_num CHAR(60),app_service CHAR(2),standard_ind CHAR(1),last_change_date CHAR(20),INDEX (antenna_id))");
            boolean[] blArray7 = new boolean[]{false, true, true, true, true, true};
            dbConnection.update("CREATE TABLE ant_pattern (antenna_id INT,azimuth FLOAT,field_value FLOAT,additional_az_num INT,last_change_date CHAR(20),INDEX (antenna_id))");
            boolean[] blArray8 = new boolean[]{false, false, false, false, true};
            dbConnection.update("CREATE TABLE elevation_ant_make (ant_make CHAR(3),ant_model_num CHAR(60),elevation_antenna_id INT,ant_comment CHAR(255),INDEX (elevation_antenna_id))");
            boolean[] blArray9 = new boolean[]{true, true, false, true};
            dbConnection.update("CREATE TABLE elevation_pattern (depression_angle FLOAT,field_value FLOAT,field_value0 FLOAT,field_value10 FLOAT,field_value20 FLOAT,field_value30 FLOAT,field_value40 FLOAT,field_value50 FLOAT,field_value60 FLOAT,field_value70 FLOAT,field_value80 FLOAT,field_value90 FLOAT,field_value100 FLOAT,field_value110 FLOAT,field_value120 FLOAT,field_value130 FLOAT,field_value140 FLOAT,field_value150 FLOAT,field_value160 FLOAT,field_value170 FLOAT,field_value180 FLOAT,field_value190 FLOAT,field_value200 FLOAT,field_value210 FLOAT,field_value220 FLOAT,field_value230 FLOAT,field_value240 FLOAT,field_value250 FLOAT,field_value260 FLOAT,field_value270 FLOAT,field_value280 FLOAT,field_value290 FLOAT,field_value300 FLOAT,field_value310 FLOAT,field_value320 FLOAT,field_value330 FLOAT,field_value340 FLOAT,field_value350 FLOAT,elevation_antenna_id INT,last_update_date CHAR(20),INDEX (elevation_antenna_id))");
            boolean[] blArray10 = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true};
            dbConnection.update("CREATE TABLE elevation_pattern_addl (depression_angle FLOAT,azimuth FLOAT,field_value FLOAT,elevation_antenna_id INT,last_update_date CHAR(20),INDEX (elevation_antenna_id))");
            boolean[] blArray11 = new boolean[]{false, false, false, false, true};
            String string4 = "";
            DateCounter dateCounter = new DateCounter("MM/dd/yyyy");
            try {
                string4 = "application";
                CDBSDatabase.copyTable(bufferedReader, dbConnection, string4, blArray, dateCounter, 24);
                string4 = "facility";
                CDBSDatabase.copyTable(bufferedReader2, dbConnection, string4, blArray2, dateCounter, 29);
                string4 = "supp_facility";
                CDBSDatabase.copyTable(bufferedReader3, dbConnection, string4, blArray3, dateCounter, 9);
                string4 = "tv_eng_data";
                CDBSDatabase.copyTable(bufferedReader4, dbConnection, string4, blArray4, dateCounter, 72);
                string4 = "tv_app_indicators";
                CDBSDatabase.copyTable(bufferedReader5, dbConnection, string4, blArray5, dateCounter, 48);
                string4 = "dtv_channel_assignments";
                CDBSDatabase.copyTable(bufferedReader6, dbConnection, string4, blArray6, null, -1);
                string4 = "ant_make";
                CDBSDatabase.copyTable(bufferedReader7, dbConnection, string4, blArray7, dateCounter, 5);
                string4 = "ant_pattern";
                CDBSDatabase.copyTable(bufferedReader8, dbConnection, string4, blArray8, dateCounter, 4);
                string4 = "elevation_ant_make";
                CDBSDatabase.copyTable(bufferedReader9, dbConnection, string4, blArray9, null, -1);
                string4 = "elevation_pattern";
                CDBSDatabase.copyTable(bufferedReader10, dbConnection, string4, blArray10, dateCounter, 39);
                string4 = "elevation_pattern_addl";
                CDBSDatabase.copyTable(bufferedReader11, dbConnection, string4, blArray11, dateCounter, 4);
                dbConnection.update("INSERT INTO tvstudy.cdbs (cdbs_key, id, name, use_count) VALUES (" + n + ", " + "'" + dbConnection.clean(dateCounter.toString()) + "', " + "'" + dbConnection.clean(string) + "', " + "0)");
            }
            catch (IOException iOException) {
                bl = true;
                string3 = "A file I/O error occurred on table '" + string4 + "':\n" + iOException.toString();
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
            bl = true;
            string3 = "An operation cannot be completed due to a database error:\n" + sQLException;
        }
        try {
            dbConnection.update("UNLOCK TABLES");
            if (bl && n > 0) {
                dbConnection.update("DROP DATABASE IF EXISTS tvstudy_cdbs_" + n);
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
        }
        dbConnection.close();
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedReader2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedReader3.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedReader4.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedReader5.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedReader6.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedReader7.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedReader8.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedReader9.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedReader10.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedReader11.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            errorReporter.reportError("Could not create CDBS database:\n" + string3, 0);
            return null;
        }
        return new Integer(n);
    }

    private static void copyTable(BufferedReader bufferedReader, DbConnection dbConnection, String string, boolean[] blArray, DateCounter dateCounter, int n) throws IOException, SQLException {
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO " + string + " VALUES (");
        int n2 = stringBuilder.length();
        int n3 = blArray.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        char c = '\u0000';
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = null;
        if (null != dateCounter && n >= 0 && n < n3) {
            stringBuilder3 = new StringBuilder();
        } else {
            n = -1;
        }
        do {
            n6 = bufferedReader.read();
            c = (char)n6;
            if (n6 < 0 || '\n' == c || '\r' == c) {
                if (n3 + 1 == n4) {
                    if (stringBuilder.length() > n2) {
                        stringBuilder.append(",(");
                    }
                    stringBuilder.append((CharSequence)stringBuilder2);
                    stringBuilder.append(')');
                }
                if (stringBuilder.length() > 100000 || n6 < 0) {
                    dbConnection.update(stringBuilder.toString());
                    stringBuilder.setLength(n2);
                }
                n4 = 0;
                n5 = 0;
                stringBuilder2.setLength(0);
                continue;
            }
            if ('|' == c) {
                if (n4 < n3) {
                    if (0 == n5) {
                        if (blArray[n4]) {
                            stringBuilder2.append("''");
                        } else {
                            stringBuilder2.append('0');
                        }
                    } else if (blArray[n4]) {
                        stringBuilder2.append('\'');
                    }
                    if (n4 < n3 - 1) {
                        stringBuilder2.append(',');
                    }
                    if (n == n4) {
                        dateCounter.add(stringBuilder3.toString());
                        stringBuilder3.setLength(0);
                    }
                }
                ++n4;
                n5 = 0;
                continue;
            }
            if (n4 < n3) {
                if (0 == n5 && blArray[n4]) {
                    stringBuilder2.append('\'');
                }
                switch (c) {
                    case '\'': {
                        stringBuilder2.append("''");
                        break;
                    }
                    case '\\': {
                        stringBuilder2.append("\\\\");
                        break;
                    }
                    default: {
                        stringBuilder2.append(c);
                    }
                }
                if (n == n4) {
                    stringBuilder3.append(c);
                }
            }
            ++n5;
        } while (n6 >= 0);
    }

    public static boolean deleteDatabase(DbConnection dbConnection, ErrorReporter errorReporter, int n) {
        if (!dbConnection.connect(errorReporter)) {
            return false;
        }
        boolean bl = false;
        String string = "";
        try {
            dbConnection.update("LOCK TABLES tvstudy.cdbs WRITE");
            dbConnection.query("SELECT use_count FROM tvstudy.cdbs WHERE cdbs_key = " + n);
            if (dbConnection.next()) {
                if (0 == dbConnection.getInt(1)) {
                    dbConnection.update("DELETE FROM tvstudy.cdbs WHERE cdbs_key = " + n);
                    dbConnection.update("UNLOCK TABLES");
                    dbConnection.update("DROP DATABASE IF EXISTS tvstudy_cdbs_" + n);
                } else {
                    bl = true;
                    string = "The CDBS database is in use by existing studies.";
                }
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
            bl = true;
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
        }
        dbConnection.close();
        if (bl) {
            errorReporter.reportError(string);
        }
        return !bl;
    }
}

