/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.util.DbConnection;
import java.sql.SQLException;
import java.util.ArrayList;

public class Zone
extends KeyedRecord {
    public final String zoneCode;
    private static Zone nullObject = null;
    private static Zone invalidObject = null;
    private static ArrayList<Zone> recordCache = null;

    public Zone(int n, String string, String string2) {
        super(n, string);
        this.zoneCode = string2;
    }

    public static Zone getZone(DbConnection dbConnection, int n) {
        if (0 == n) {
            return Zone.getNullObject();
        }
        if (Zone.fillCache(dbConnection)) {
            for (Zone zone : recordCache) {
                if (n != zone.key) continue;
                return zone;
            }
        }
        return Zone.getNullObject();
    }

    public static Zone getZone(DbConnection dbConnection, String string) {
        if (Zone.fillCache(dbConnection)) {
            for (Zone zone : recordCache) {
                if (!zone.zoneCode.equalsIgnoreCase(string)) continue;
                return zone;
            }
        }
        return Zone.getNullObject();
    }

    public static Zone getNullObject() {
        if (null == nullObject) {
            nullObject = new Zone(0, "(n/a)", " ");
        }
        return nullObject;
    }

    public static Zone getInvalidObject() {
        if (null == invalidObject) {
            invalidObject = new Zone(-1, "???", "?");
        }
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getZones(DbConnection dbConnection) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        if (Zone.fillCache(dbConnection)) {
            for (Zone zone : recordCache) {
                arrayList.add(zone);
            }
        }
        return arrayList;
    }

    public static ArrayList<KeyedRecord> getZonesWithNull(DbConnection dbConnection) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        arrayList.add(Zone.getNullObject());
        if (Zone.fillCache(dbConnection)) {
            for (Zone zone : recordCache) {
                arrayList.add(zone);
            }
        }
        return arrayList;
    }

    private static synchronized boolean fillCache(DbConnection dbConnection) {
        if (null != recordCache) {
            return true;
        }
        ArrayList<Zone> arrayList = new ArrayList<Zone>();
        boolean bl = false;
        if (dbConnection.connect()) {
            try {
                dbConnection.query("SELECT zone_key, name, zone_code FROM tvstudy.zone ORDER BY 1");
                while (dbConnection.next()) {
                    arrayList.add(new Zone(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3)));
                }
                recordCache = arrayList;
                bl = true;
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close();
        }
        return bl;
    }
}

