/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.AppManager;
import gov.fcc.tvstudy.data.IxRule;
import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.data.Parameter;
import gov.fcc.tvstudy.data.Scenario;
import gov.fcc.tvstudy.data.Source;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;

public class Study
extends KeyedRecord {
    public static final int LOCK_NONE = 0;
    public static final int LOCK_EDIT = 1;
    public static final int LOCK_RUN_EXCL = 2;
    public static final int LOCK_RUN_SHARE = 3;
    public static final int LOCK_ADMIN = 4;
    public final String description;
    public final boolean newStudy;
    public final boolean needsUpdate;
    public final int templateKey;
    public final String templateName;
    public final boolean templateLocked;
    public final int cdbsKey;
    public final String cdbsName;
    public final ArrayList<Parameter> parameters;
    public final ArrayList<IxRule> ixRules;
    public final ArrayList<Scenario> scenarios;
    public final ArrayList<Source> sources;
    public int studyLock;
    public int lockCount;

    public Study(int n, String string, String string2, int n2, int n3, boolean bl, boolean bl2, int n4, String string3, boolean bl3, int n5, String string4, ArrayList<Parameter> arrayList, ArrayList<IxRule> arrayList2, ArrayList<Source> arrayList3, ArrayList<Scenario> arrayList4) {
        super(n, string);
        this.description = string2;
        this.studyLock = n2;
        this.lockCount = n3;
        this.newStudy = bl;
        this.needsUpdate = bl2;
        this.templateKey = n4;
        this.templateName = string3;
        this.templateLocked = bl3;
        this.cdbsKey = n5;
        this.cdbsName = string4;
        this.parameters = arrayList;
        this.ixRules = arrayList2;
        this.sources = arrayList3;
        this.scenarios = arrayList4;
    }

    public static Study getStudy(DbConnection dbConnection, int n) {
        return Study.getStudy(dbConnection, null, n);
    }

    public static Study getStudy(DbConnection dbConnection, ErrorReporter errorReporter, int n) {
        if (!dbConnection.connect(errorReporter)) {
            return null;
        }
        Study study = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = "";
        String string2 = String.valueOf(n);
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            dbConnection.update("LOCK TABLES tvstudy.study WRITE, tvstudy.version WRITE, tvstudy.template WRITE, tvstudy.cdbs WRITE");
            dbConnection.query("SELECT study.name, version.version, study.study_lock, study.lock_count, study.description, study.new_study, study.needs_update, study.template_key, template.name, template.locked_in_study, study.cdbs_key, CASE WHEN (LENGTH(cdbs.name) > 0) THEN cdbs.name ELSE cdbs.id END FROM tvstudy.study JOIN tvstudy.version JOIN tvstudy.template USING (template_key) JOIN tvstudy.cdbs USING (cdbs_key) WHERE study_key = " + n);
            if (dbConnection.next()) {
                string3 = dbConnection.getString(1);
                string2 = "'" + string3 + "'";
                if (103000 == dbConnection.getInt(2)) {
                    if (0 == dbConnection.getInt(3)) {
                        n2 = dbConnection.getInt(4);
                        string4 = dbConnection.getString(5);
                        bl3 = dbConnection.getBoolean(6);
                        bl4 = dbConnection.getBoolean(7);
                        n3 = dbConnection.getInt(8);
                        string5 = dbConnection.getString(9);
                        bl5 = dbConnection.getBoolean(10);
                        n4 = dbConnection.getInt(11);
                        string6 = dbConnection.getString(12);
                        dbConnection.update("UPDATE tvstudy.study SET study_lock = 1, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
                        bl2 = true;
                        dbConnection.update("UNLOCK TABLES");
                        study = new Study(n, string3, string4, 1, ++n2, bl3, bl4, n3, string5, bl5, n4, string6, Parameter.getParameters(dbConnection, n, n3), IxRule.getIxRules(dbConnection, n), Source.getSources(dbConnection, n), Scenario.getScenarios(dbConnection, n));
                    } else {
                        bl = true;
                        string = "The study is in use by another application.";
                        n5 = 2;
                    }
                } else {
                    bl = true;
                    string = "The database version is incorrect.";
                }
            } else {
                bl = true;
                string = "The study does not exist.";
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
            bl = true;
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
        }
        try {
            if (bl && bl2) {
                dbConnection.update("UPDATE tvstudy.study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
            }
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
        }
        dbConnection.close();
        if (bl) {
            if (null != errorReporter) {
                errorReporter.reportError("Could not open study " + string2 + ":\n" + string, n5);
            }
            return null;
        }
        return study;
    }

    public static Integer createNewStudy(DbConnection dbConnection, String string, int n, int n2) {
        return Study.createNewStudy(dbConnection, null, string, n, n2);
    }

    public static Integer createNewStudy(DbConnection dbConnection, ErrorReporter errorReporter, String string, int n, int n2) {
        if (!dbConnection.connect(errorReporter)) {
            return null;
        }
        boolean bl = false;
        String string2 = "";
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        try {
            dbConnection.update("LOCK TABLES tvstudy.study WRITE, tvstudy.template WRITE, tvstudy.cdbs WRITE, tvstudy.study_key_sequence WRITE");
            n4 = dbConnection.update("UPDATE tvstudy.template SET use_count = use_count + 1 WHERE template_key = " + n);
            if (n4 > 0) {
                n5 = dbConnection.update("UPDATE tvstudy.cdbs SET use_count = use_count + 1 WHERE cdbs_key = " + n2);
                if (n5 > 0) {
                    dbConnection.update("UPDATE tvstudy.study_key_sequence SET study_key = study_key + 1");
                    dbConnection.query("SELECT study_key FROM tvstudy.study_key_sequence");
                    dbConnection.next();
                    n3 = dbConnection.getInt(1);
                    dbConnection.update("UNLOCK TABLES");
                    dbConnection.update("CREATE DATABASE tvstudy_" + n3);
                    dbConnection.update("USE tvstudy_" + n3);
                    Parameter.createStudyTables(dbConnection, n);
                    IxRule.createStudyTables(dbConnection, n);
                    Source.createStudyTables(dbConnection);
                    Scenario.createStudyTables(dbConnection);
                    dbConnection.update("LOCK TABLES tvstudy.study WRITE");
                    dbConnection.query("SELECT study_key FROM tvstudy.study WHERE UPPER(name) = '" + dbConnection.clean(string.toUpperCase()) + "'");
                    if (!dbConnection.next()) {
                        dbConnection.update("INSERT INTO tvstudy.study (study_key, name, description, study_lock, lock_count, share_count, new_study, needs_update, template_key, cdbs_key, parameter_summary) VALUES (" + n3 + ", " + "'" + dbConnection.clean(string) + "', " + "'New study', " + 0 + ", " + "0, " + "0, " + "true, " + "true, " + n + ", " + n2 + ", " + "'Parameter list not available.\n')");
                    } else {
                        bl = true;
                        string2 = "Study name '" + string + "' already exists.";
                        n6 = 2;
                    }
                } else {
                    bl = true;
                    string2 = "CDBS database key " + n2 + " does not exist.";
                }
            } else {
                bl = true;
                string2 = "Template key " + n + " does not exist.";
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
            bl = true;
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
        }
        try {
            dbConnection.update("UNLOCK TABLES");
            if (bl) {
                if (n3 > 0) {
                    dbConnection.update("DROP DATABASE IF EXISTS tvstudy_" + n3);
                }
                if (n4 > 0) {
                    dbConnection.update("UPDATE tvstudy.template SET use_count = use_count - 1 WHERE template_key = " + n);
                }
                if (n5 > 0) {
                    dbConnection.update("UPDATE tvstudy.cdbs SET use_count = use_count - 1 WHERE cdbs_key = " + n2);
                }
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
        }
        dbConnection.close();
        if (bl) {
            if (null != errorReporter) {
                errorReporter.reportError("Could not create new study:\n" + string2, n6);
            }
            return null;
        }
        return new Integer(n3);
    }

    public static Integer duplicateStudy(DbConnection dbConnection, int n, String string) {
        return Study.duplicateStudy(dbConnection, null, n, string);
    }

    public static Integer duplicateStudy(DbConnection dbConnection, ErrorReporter errorReporter, int n, String string) {
        if (!dbConnection.connect(errorReporter)) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        String string3 = String.valueOf(n);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            dbConnection.update("LOCK TABLES tvstudy.study WRITE, tvstudy.version WRITE, tvstudy.template WRITE, tvstudy.cdbs WRITE, tvstudy.study_key_sequence WRITE");
            dbConnection.query("SELECT study.name, version.version, study.study_lock, study.needs_update, study.lock_count, study.description, study.new_study, study.template_key, study.cdbs_key, study.parameter_summary FROM tvstudy.study JOIN tvstudy.version WHERE study_key = " + n);
            if (dbConnection.next()) {
                string3 = "'" + dbConnection.getString(1) + "'";
                if (103000 == dbConnection.getInt(2)) {
                    if (0 == dbConnection.getInt(3)) {
                        if (!dbConnection.getBoolean(4)) {
                            int n8 = dbConnection.getInt(5);
                            String string4 = dbConnection.getString(6);
                            boolean bl3 = dbConnection.getBoolean(7);
                            n3 = dbConnection.getInt(8);
                            n5 = dbConnection.getInt(9);
                            String string5 = dbConnection.getString(10);
                            n4 = dbConnection.update("UPDATE tvstudy.template SET use_count = use_count + 1 WHERE template_key = " + n3);
                            if (n4 > 0) {
                                n6 = dbConnection.update("UPDATE tvstudy.cdbs SET use_count = use_count + 1 WHERE cdbs_key = " + n5);
                                if (n6 > 0) {
                                    dbConnection.update("UPDATE tvstudy.study SET study_lock = 4, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
                                    bl2 = true;
                                    ++n8;
                                    dbConnection.update("UPDATE tvstudy.study_key_sequence SET study_key = study_key + 1");
                                    dbConnection.query("SELECT study_key FROM tvstudy.study_key_sequence");
                                    dbConnection.next();
                                    n2 = dbConnection.getInt(1);
                                    dbConnection.update("UNLOCK TABLES");
                                    dbConnection.update("CREATE DATABASE tvstudy_" + n2);
                                    dbConnection.update("USE tvstudy_" + n2);
                                    Parameter.copyStudyTables(dbConnection, n);
                                    IxRule.copyStudyTables(dbConnection, n);
                                    Source.copyStudyTables(dbConnection, n);
                                    Scenario.copyStudyTables(dbConnection, n);
                                    dbConnection.update("LOCK TABLES tvstudy.study WRITE");
                                    dbConnection.query("SELECT study_lock, lock_count FROM tvstudy.study WHERE study_key = " + n);
                                    if (dbConnection.next()) {
                                        if (dbConnection.getInt(1) == 4 && dbConnection.getInt(2) == n8) {
                                            dbConnection.query("SELECT study_key FROM tvstudy.study WHERE UPPER(name) = '" + dbConnection.clean(string.toUpperCase()) + "'");
                                            if (!dbConnection.next()) {
                                                dbConnection.update("INSERT INTO tvstudy.study (study_key, name, description, study_lock, lock_count, share_count, new_study, needs_update, template_key, cdbs_key, parameter_summary) VALUES (" + n2 + ", " + "'" + dbConnection.clean(string) + "', " + "'" + dbConnection.clean(string4) + "', " + 0 + ", " + "0, " + "0, " + bl3 + ", " + "false, " + n3 + ", " + n5 + ", " + "'" + dbConnection.clean(string5) + "')");
                                            } else {
                                                bl = true;
                                                string2 = "Study name '" + string + "' already exists.";
                                                n7 = 2;
                                            }
                                        } else {
                                            bl2 = false;
                                            bl = true;
                                            string2 = "The study lock was modified.";
                                        }
                                    } else {
                                        bl2 = false;
                                        bl = true;
                                        string2 = "The study was deleted.";
                                    }
                                } else {
                                    bl = true;
                                    string2 = "CDBS database key " + n5 + " does not exist.";
                                }
                            } else {
                                bl = true;
                                string2 = "Template key " + n3 + " does not exist.";
                            }
                        } else {
                            bl = true;
                            string2 = "The study needs update, it must be opened and saved.";
                            n7 = 2;
                        }
                    } else {
                        bl = true;
                        string2 = "The study is in use by another application.";
                        n7 = 2;
                    }
                } else {
                    bl = true;
                    string2 = "The database version is incorrect.";
                }
            } else {
                bl = true;
                string2 = "The study does not exist.";
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
            bl = true;
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
        }
        try {
            if (bl2) {
                dbConnection.update("UPDATE tvstudy.study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
            }
            dbConnection.update("UNLOCK TABLES");
            if (bl) {
                if (n2 > 0) {
                    dbConnection.update("DROP DATABASE IF EXISTS tvstudy_" + n2);
                }
                if (n4 > 0) {
                    dbConnection.update("UPDATE tvstudy.template SET use_count = use_count - 1 WHERE template_key = " + n3);
                }
                if (n6 > 0) {
                    dbConnection.update("UPDATE tvstudy.cdbs SET use_count = use_count - 1 WHERE cdbs_key = " + n5);
                }
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
        }
        dbConnection.close();
        if (bl) {
            if (null != errorReporter) {
                errorReporter.reportError("Could not duplicate study " + string3 + ":\n" + string2, n7);
            }
            return null;
        }
        return new Integer(n2);
    }

    public static boolean deleteStudy(DbConnection dbConnection, String string, int n) {
        return Study.deleteStudy(dbConnection, null, string, n);
    }

    public static boolean deleteStudy(DbConnection dbConnection, ErrorReporter errorReporter, String string, int n) {
        if (!dbConnection.connect(errorReporter)) {
            return false;
        }
        boolean bl = false;
        String string2 = "";
        String string3 = String.valueOf(n);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            dbConnection.update("LOCK TABLES tvstudy.study WRITE, tvstudy.template WRITE, tvstudy.cdbs WRITE");
            dbConnection.query("SELECT name, study_lock, template_key, cdbs_key FROM tvstudy.study WHERE study_key = " + n);
            if (dbConnection.next()) {
                string3 = "'" + dbConnection.getString(1) + "'";
                if (0 == dbConnection.getInt(2)) {
                    n2 = dbConnection.getInt(3);
                    n3 = dbConnection.getInt(4);
                    dbConnection.update("DELETE FROM tvstudy.study WHERE study_key = " + n);
                    dbConnection.update("UPDATE tvstudy.template SET use_count = use_count - 1 WHERE template_key = " + n2);
                    dbConnection.update("UPDATE tvstudy.cdbs SET use_count = use_count - 1 WHERE cdbs_key = " + n3);
                    dbConnection.update("UNLOCK TABLES");
                    dbConnection.update("DROP DATABASE IF EXISTS tvstudy_" + n);
                } else {
                    bl = true;
                    string2 = "The study is in use by another application.";
                    n4 = 2;
                }
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
            bl = true;
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
        }
        dbConnection.close();
        if (bl) {
            if (null != errorReporter) {
                errorReporter.reportError("Could not delete study " + string3 + ":\n" + string2, n4);
            }
            return false;
        }
        Study.deleteStudyCache(string, n);
        return true;
    }

    public static boolean unlockStudy(DbConnection dbConnection, int n, int n2) {
        return Study.unlockStudy(dbConnection, null, n, n2);
    }

    public static boolean unlockStudy(DbConnection dbConnection, ErrorReporter errorReporter, int n, int n2) {
        if (!dbConnection.connect(errorReporter)) {
            return false;
        }
        boolean bl = false;
        String string = "";
        String string2 = String.valueOf(n);
        int n3 = 0;
        try {
            dbConnection.update("LOCK TABLES tvstudy.study WRITE");
            dbConnection.query("SELECT name, lock_count FROM tvstudy.study WHERE study_key = " + n);
            if (dbConnection.next()) {
                string2 = "'" + dbConnection.getString(1) + "'";
                if (0 == n2 || dbConnection.getInt(2) == n2) {
                    dbConnection.update("UPDATE tvstudy.study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
                } else {
                    bl = true;
                    string = "The study lock was modified.";
                }
            } else {
                bl = true;
                string = "The study does not exist.";
            }
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
            bl = true;
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            dbConnection.reportError(sQLException);
        }
        dbConnection.close();
        if (bl) {
            if (null != errorReporter) {
                errorReporter.reportError("Could not unlock study " + string2 + ":\n" + string, n3);
            }
            return false;
        }
        return true;
    }

    public static int getStudyKeyForName(DbConnection dbConnection, String string) {
        return Study.getStudyKeyForName(dbConnection, null, string);
    }

    public static int getStudyKeyForName(DbConnection dbConnection, ErrorReporter errorReporter, String string) {
        int n = -1;
        if (dbConnection.connect(errorReporter)) {
            try {
                dbConnection.query("SELECT study_key FROM tvstudy.study WHERE UPPER(name) = '" + dbConnection.clean(string.toUpperCase()) + "'");
                n = dbConnection.next() ? dbConnection.getInt(1) : 0;
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(errorReporter, sQLException);
            }
            dbConnection.close();
        }
        return n;
    }

    public static long getStudyCacheSize(String string, int n) {
        long l = -1L;
        File file = n > 0 ? new File("cache" + File.separator + string + File.separator + n) : new File("cache" + File.separator + string);
        if (file.exists() && file.isDirectory()) {
            l = AppManager.sizeOfDirectoryContents(file);
        }
        return l;
    }

    public static boolean deleteStudyCache(String string, int n) {
        boolean bl = false;
        File file = n > 0 ? new File("cache" + File.separator + string + File.separator + n) : new File("cache" + File.separator + string);
        if (file.exists() && file.isDirectory()) {
            bl = AppManager.deleteDirectoryAndContents(file);
        }
        return bl;
    }

    public static boolean purgeStudyCache(String string, int n, boolean[] blArray) {
        boolean bl = false;
        File file = new File("cache" + File.separator + string + File.separator + n);
        if (file.exists() && file.isDirectory()) {
            bl = Study.deleteUnusedCacheFiles(file, blArray);
        }
        return bl;
    }

    private static boolean deleteUnusedCacheFiles(File file, boolean[] blArray) {
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                if (Study.deleteUnusedCacheFiles(fileArray[i], blArray)) continue;
                bl = false;
                continue;
            }
            String string = fileArray[i].getName();
            int n = string.indexOf(95);
            if (n > 0) {
                string = string.substring(0, n);
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 <= 0 || n2 < blArray.length && blArray[n2] || fileArray[i].delete()) continue;
            bl = false;
        }
        return bl;
    }

    public String getStringParameter(int n) {
        Parameter parameter = this.findParameter(n);
        if (null == parameter) {
            return null;
        }
        if (null == parameter.value) {
            return parameter.defaultValue;
        }
        return parameter.value;
    }

    public Integer getIntegerParameter(int n) {
        Parameter parameter = this.findParameter(n);
        if (null == parameter || parameter.type != 2 && parameter.type != 5) {
            return null;
        }
        return new Integer(parameter.integerValue);
    }

    public Double getDecimalParameter(int n) {
        Parameter parameter = this.findParameter(n);
        if (null == parameter || parameter.type != 3) {
            return null;
        }
        return new Double(parameter.decimalValue);
    }

    public Boolean getOptionParameter(int n) {
        Parameter parameter = this.findParameter(n);
        if (null == parameter || parameter.type != 4) {
            return null;
        }
        return new Boolean(parameter.optionValue);
    }

    private Parameter findParameter(int n) {
        for (Parameter parameter : this.parameters) {
            if (n != parameter.key) continue;
            return parameter;
        }
        return null;
    }
}

