/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.data.Country;
import gov.fcc.tvstudy.data.EmissionMask;
import gov.fcc.tvstudy.data.FrequencyOffset;
import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.data.Service;
import gov.fcc.tvstudy.data.Zone;
import gov.fcc.tvstudy.util.DbConnection;
import gov.fcc.tvstudy.util.ErrorReporter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class Source
extends KeyedRecord {
    public static final int CHANNEL_MIN = 2;
    public static final int CHANNEL_MAX = 69;
    public static final double LATITUDE_MIN = -73.0;
    public static final double LATITUDE_MAX = 73.0;
    public static final double LONGITUDE_MIN = -180.0;
    public static final double LONGITUDE_MAX = 180.0;
    public static final double DISTANCE_MIN = 50.0;
    public static final double DISTANCE_MAX = 200.0;
    public static final double HEIGHT_MIN = -1000.0;
    public static final double HEIGHT_MAX = 10000.0;
    public static final double HEIGHT_DERIVE = -999.0;
    public static final String HEIGHT_DERIVE_LABEL = "(derive)";
    public static final double ERP_MIN = 1.0E-5;
    public static final double ERP_MAX = 5000.0;
    public static final double ORIENTATION_MIN = -360.0;
    public static final double ORIENTATION_MAX = 360.0;
    public static final double TILT_MIN = -10.0;
    public static final double TILT_MAX = 11.1;
    public static final double AZIMUTH_MIN = 0.0;
    public static final double AZIMUTH_MAX = 359.999;
    public static final double AZIMUTH_ROUND = 1000.0;
    public static final double DEPRESSION_MIN = -90.0;
    public static final double DEPRESSION_MAX = 90.0;
    public static final double DEPRESSION_ROUND = 1000.0;
    public static final double FIELD_MIN = 0.001;
    public static final double FIELD_MAX = 1.0;
    public static final double FIELD_ROUND = 1000.0;
    public static final double FIELD_MAX_CHECK = 0.977;
    public static final int PATTERN_REQUIRED_POINTS = 2;
    public final int facility_id;
    public final Service service;
    public final String callSign;
    public final int channel;
    public final String city;
    public final String state;
    public final Country country;
    public final Zone zone;
    public final String status;
    public final String fileNumber;
    public final FrequencyOffset frequencyOffset;
    public final EmissionMask emissionMask;
    public final double latitude;
    public final double longitude;
    public final double dtsMaximumDistance;
    public final double heightAMSL;
    public final double actualHeightAMSL;
    public final double overallHAAT;
    public final double peakERP;
    public final int antenna_id;
    public final boolean hasHorizontalPattern;
    public final String horizontalPatternName;
    public final double horizontalPatternOrientation;
    public final boolean hasVerticalPattern;
    public final String verticalPatternName;
    public final double verticalPatternElectricalTilt;
    public final double verticalPatternMechanicalTilt;
    public final double verticalPatternMechanicalTiltOrientation;
    public final boolean hasMatrixPattern;
    public final String matrixPatternName;
    public final boolean useGenericVerticalPattern;
    public final boolean isLocked;
    public final Integer application_id;
    public final int siteNumber;
    public final Integer originalSourceKey;
    public final Integer parentSourceKey;
    public final ArrayList<Source> dtsSources;
    public final boolean isParent;
    public final int studyKey;
    public final int modCount;

    public Source(int n, int n2, Service service, String string, int n3, String string2, String string3, Country country, Zone zone, String string4, String string5, FrequencyOffset frequencyOffset, EmissionMask emissionMask, double d, double d2, double d3, double d4, double d5, double d6, double d7, int n4, boolean bl, String string6, double d8, boolean bl2, String string7, double d9, double d10, double d11, boolean bl3, String string8, boolean bl4, boolean bl5, Integer n5, int n6, Integer n7, Integer n8, ArrayList<Source> arrayList, int n9, int n10) {
        super(n, string + " " + n3 + " " + string4);
        this.facility_id = n2;
        this.service = service;
        this.callSign = string;
        this.channel = n3;
        this.city = string2;
        this.state = string3;
        this.country = country;
        this.zone = zone;
        this.status = string4;
        this.fileNumber = string5;
        this.frequencyOffset = frequencyOffset;
        this.emissionMask = emissionMask;
        this.latitude = d;
        this.longitude = d2;
        this.dtsMaximumDistance = d3;
        this.heightAMSL = d4;
        this.actualHeightAMSL = d5;
        this.overallHAAT = d6;
        this.peakERP = d7;
        this.antenna_id = n4;
        this.hasHorizontalPattern = bl;
        this.horizontalPatternName = string6;
        this.horizontalPatternOrientation = d8;
        this.hasVerticalPattern = bl2;
        this.verticalPatternName = string7;
        this.verticalPatternElectricalTilt = d9;
        this.verticalPatternMechanicalTilt = d10;
        this.verticalPatternMechanicalTiltOrientation = d11;
        this.hasMatrixPattern = bl3;
        this.matrixPatternName = string8;
        this.useGenericVerticalPattern = bl4;
        this.isLocked = bl5;
        this.application_id = n5;
        this.siteNumber = n6;
        this.originalSourceKey = n7;
        this.parentSourceKey = n8;
        this.dtsSources = arrayList;
        this.isParent = null != this.dtsSources;
        this.studyKey = n9;
        this.modCount = n10;
    }

    public static ArrayList<Source> getSources(DbConnection dbConnection, int n) throws SQLException {
        Integer n2;
        Integer n3;
        int n4;
        Country country;
        Service service;
        DbConnection dbConnection2 = dbConnection.copy();
        int n5 = 0;
        ArrayList arrayList = null;
        HashMap<Integer, ArrayList> hashMap = new HashMap<Integer, ArrayList>();
        dbConnection.query("SELECT source_key, facility_id, service_key, call_sign, channel, city, state, country_key, zone_key, status, file_number, frequency_offset_key, emission_mask_key, latitude, longitude, height_amsl, actual_height_amsl, overall_haat, peak_erp, antenna_id, has_horizontal_pattern, horizontal_pattern_name, horizontal_pattern_orientation, has_vertical_pattern, vertical_pattern_name, vertical_pattern_electrical_tilt, vertical_pattern_mechanical_tilt, vertical_pattern_mechanical_tilt_orientation, has_matrix_pattern, matrix_pattern_name, use_generic_vertical_pattern, locked, application_id, site_number, original_source_key, parent_source_key FROM tvstudy_" + n + ".source " + "JOIN tvstudy.service USING (service_key) " + "WHERE " + "(parent_source_key > 0) " + "ORDER BY " + "parent_source_key, site_number, source_key");
        while (dbConnection.next()) {
            service = Service.getService(dbConnection2, dbConnection.getInt(3));
            if (null == service || null == (country = Country.getCountry(dbConnection2, dbConnection.getInt(8)))) continue;
            n4 = dbConnection.getInt(33);
            n3 = 0 == n4 ? null : new Integer(n4);
            n4 = dbConnection.getInt(35);
            n2 = 0 == n4 ? null : new Integer(n4);
            n4 = dbConnection.getInt(36);
            Integer n6 = new Integer(n4);
            if (n4 != n5) {
                arrayList = new ArrayList();
                hashMap.put(n6, arrayList);
                n5 = n4;
            }
            arrayList.add(new Source(dbConnection.getInt(1), dbConnection.getInt(2), service, dbConnection.getString(4), dbConnection.getInt(5), dbConnection.getString(6), dbConnection.getString(7), country, Zone.getZone(dbConnection2, dbConnection.getInt(9)), dbConnection.getString(10), dbConnection.getString(11), FrequencyOffset.getFrequencyOffset(dbConnection2, dbConnection.getInt(12)), EmissionMask.getEmissionMask(dbConnection2, dbConnection.getInt(13)), dbConnection.getDouble(14), dbConnection.getDouble(15), 0.0, dbConnection.getDouble(16), dbConnection.getDouble(17), dbConnection.getDouble(18), dbConnection.getDouble(19), dbConnection.getInt(20), dbConnection.getBoolean(21), dbConnection.getString(22), dbConnection.getDouble(23), dbConnection.getBoolean(24), dbConnection.getString(25), dbConnection.getDouble(26), dbConnection.getDouble(27), dbConnection.getDouble(28), dbConnection.getBoolean(29), dbConnection.getString(30), dbConnection.getBoolean(31), dbConnection.getBoolean(32), n3, dbConnection.getInt(34), n2, n6, null, n, 0));
        }
        ArrayList<Source> arrayList2 = new ArrayList<Source>();
        dbConnection.query("SELECT source_key, facility_id, service_key, call_sign, channel, city, state, country_key, zone_key, status, file_number, frequency_offset_key, emission_mask_key, latitude, longitude, dts_maximum_distance, height_amsl, actual_height_amsl, overall_haat, peak_erp, antenna_id, has_horizontal_pattern, horizontal_pattern_name, horizontal_pattern_orientation, has_vertical_pattern, vertical_pattern_name, vertical_pattern_electrical_tilt, vertical_pattern_mechanical_tilt, vertical_pattern_mechanical_tilt_orientation, has_matrix_pattern, matrix_pattern_name, use_generic_vertical_pattern, locked, application_id, site_number, original_source_key, mod_count FROM tvstudy_" + n + ".source " + "WHERE " + "parent_source_key = 0 " + "ORDER BY " + "source_key");
        while (dbConnection.next()) {
            int n7 = dbConnection.getInt(1);
            service = Service.getService(dbConnection2, dbConnection.getInt(3));
            if (null == service || null == (country = Country.getCountry(dbConnection2, dbConnection.getInt(8)))) continue;
            if (service.isDTS) {
                arrayList = (ArrayList)hashMap.remove(new Integer(n7));
                if (null == arrayList) {
                    throw new SQLException("DTS structure is invalid, no records found for parent sourceKey = " + n7);
                }
            } else {
                arrayList = null;
            }
            n3 = 0 == (n4 = dbConnection.getInt(34)) ? null : new Integer(n4);
            n4 = dbConnection.getInt(36);
            n2 = 0 == n4 ? null : new Integer(n4);
            arrayList2.add(new Source(n7, dbConnection.getInt(2), service, dbConnection.getString(4), dbConnection.getInt(5), dbConnection.getString(6), dbConnection.getString(7), country, Zone.getZone(dbConnection2, dbConnection.getInt(9)), dbConnection.getString(10), dbConnection.getString(11), FrequencyOffset.getFrequencyOffset(dbConnection2, dbConnection.getInt(12)), EmissionMask.getEmissionMask(dbConnection2, dbConnection.getInt(13)), dbConnection.getDouble(14), dbConnection.getDouble(15), dbConnection.getDouble(16), dbConnection.getDouble(17), dbConnection.getDouble(18), dbConnection.getDouble(19), dbConnection.getDouble(20), dbConnection.getInt(21), dbConnection.getBoolean(22), dbConnection.getString(23), dbConnection.getDouble(24), dbConnection.getBoolean(25), dbConnection.getString(26), dbConnection.getDouble(27), dbConnection.getDouble(28), dbConnection.getDouble(29), dbConnection.getBoolean(30), dbConnection.getString(31), dbConnection.getBoolean(32), dbConnection.getBoolean(33), n3, dbConnection.getInt(35), n2, null, arrayList, n, dbConnection.getInt(37)));
        }
        if (!hashMap.isEmpty()) {
            throw new SQLException("DTS structure is invalid, some records have no parent");
        }
        return arrayList2;
    }

    public ArrayList<PatternPoint> getHorizontalPattern(DbConnection dbConnection) {
        return this.getHorizontalPattern(dbConnection, null);
    }

    public ArrayList<PatternPoint> getHorizontalPattern(DbConnection dbConnection, ErrorReporter errorReporter) {
        if (!this.hasHorizontalPattern) {
            return null;
        }
        ArrayList<PatternPoint> arrayList = null;
        if (dbConnection.connect(errorReporter)) {
            try {
                dbConnection.query("SELECT azimuth, relative_field FROM tvstudy_" + this.studyKey + ".source_horizontal_pattern " + "WHERE " + "source_key = " + this.key + " " + "ORDER BY 1");
                arrayList = new ArrayList<PatternPoint>();
                while (dbConnection.next()) {
                    arrayList.add(new PatternPoint(dbConnection.getDouble(1), dbConnection.getDouble(2)));
                }
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(errorReporter, sQLException);
                arrayList = null;
            }
            dbConnection.close();
        }
        return arrayList;
    }

    public ArrayList<PatternPoint> getVerticalPattern(DbConnection dbConnection) {
        return this.getVerticalPattern(dbConnection, null);
    }

    public ArrayList<PatternPoint> getVerticalPattern(DbConnection dbConnection, ErrorReporter errorReporter) {
        if (!this.hasVerticalPattern) {
            return null;
        }
        ArrayList<PatternPoint> arrayList = null;
        if (dbConnection.connect(errorReporter)) {
            try {
                dbConnection.query("SELECT depression_angle, relative_field FROM tvstudy_" + this.studyKey + ".source_vertical_pattern " + "WHERE " + "source_key = " + this.key + " " + "ORDER BY 1");
                arrayList = new ArrayList<PatternPoint>();
                while (dbConnection.next()) {
                    arrayList.add(new PatternPoint(dbConnection.getDouble(1), dbConnection.getDouble(2)));
                }
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(errorReporter, sQLException);
                arrayList = null;
            }
            dbConnection.close();
        }
        return arrayList;
    }

    public ArrayList<PatternSlice> getMatrixPattern(DbConnection dbConnection) {
        return this.getMatrixPattern(dbConnection, null);
    }

    public ArrayList<PatternSlice> getMatrixPattern(DbConnection dbConnection, ErrorReporter errorReporter) {
        if (!this.hasMatrixPattern) {
            return null;
        }
        ArrayList<PatternSlice> arrayList = null;
        if (dbConnection.connect(errorReporter)) {
            try {
                dbConnection.query("SELECT azimuth, depression_angle, relative_field FROM tvstudy_" + this.studyKey + ".source_matrix_pattern " + "WHERE " + "source_key = " + this.key + " " + "ORDER BY 1, 2");
                arrayList = new ArrayList<PatternSlice>();
                ArrayList<PatternPoint> arrayList2 = null;
                double d = -1.0;
                while (dbConnection.next()) {
                    double d2 = dbConnection.getDouble(1);
                    if (d2 != d) {
                        arrayList2 = new ArrayList<PatternPoint>();
                        arrayList.add(new PatternSlice(d2, arrayList2));
                        d = d2;
                    }
                    arrayList2.add(new PatternPoint(dbConnection.getDouble(2), dbConnection.getDouble(3)));
                }
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(errorReporter, sQLException);
                arrayList = null;
            }
            dbConnection.close();
        }
        return arrayList;
    }

    public static void createStudyTables(DbConnection dbConnection) throws SQLException {
        dbConnection.update("CREATE TABLE source (source_key INT NOT NULL PRIMARY KEY,needs_update BOOLEAN NOT NULL,mod_count INT NOT NULL,facility_id INT NOT NULL,service_key INT NOT NULL,call_sign CHAR(12) NOT NULL,channel INT NOT NULL,city CHAR(20) NOT NULL,state CHAR(2) NOT NULL,country_key INT NOT NULL,zone_key INT NOT NULL,status CHAR(6) NOT NULL,file_number CHAR(22) NOT NULL,frequency_offset_key INT NOT NULL,emission_mask_key INT NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,dts_maximum_distance DOUBLE NOT NULL,height_amsl FLOAT NOT NULL,actual_height_amsl DOUBLE NOT NULL,height_agl DOUBLE NOT NULL,overall_haat FLOAT NOT NULL,peak_erp FLOAT NOT NULL,contour_erp DOUBLE NOT NULL,antenna_id INT NOT NULL,has_horizontal_pattern BOOLEAN NOT NULL,horizontal_pattern_name VARCHAR(255) NOT NULL,horizontal_pattern_orientation FLOAT NOT NULL,has_vertical_pattern BOOLEAN NOT NULL,vertical_pattern_name VARCHAR(255) NOT NULL,vertical_pattern_electrical_tilt FLOAT NOT NULL,vertical_pattern_mechanical_tilt FLOAT NOT NULL,vertical_pattern_mechanical_tilt_orientation FLOAT NOT NULL,has_matrix_pattern BOOLEAN NOT NULL,matrix_pattern_name VARCHAR(255) NOT NULL,use_generic_vertical_pattern BOOLEAN NOT NULL,locked BOOLEAN NOT NULL,application_id INT NOT NULL,site_number INT NOT NULL,original_source_key INT NOT NULL,parent_source_key INT NOT NULL)");
        dbConnection.update("CREATE TABLE source_horizontal_pattern (source_key INT NOT NULL,azimuth FLOAT NOT NULL,relative_field FLOAT NOT NULL,INDEX (source_key))");
        dbConnection.update("CREATE TABLE source_vertical_pattern (source_key INT NOT NULL,depression_angle FLOAT NOT NULL,relative_field FLOAT NOT NULL,INDEX (source_key))");
        dbConnection.update("CREATE TABLE source_matrix_pattern (source_key INT NOT NULL,azimuth FLOAT NOT NULL,depression_angle FLOAT NOT NULL,relative_field FLOAT NOT NULL,INDEX (source_key))");
    }

    public static void copyStudyTables(DbConnection dbConnection, int n) throws SQLException {
        Source.createStudyTables(dbConnection);
        dbConnection.update("INSERT INTO source (source_key,needs_update,mod_count,facility_id,service_key,call_sign,channel,city,state,country_key,zone_key,status,file_number,frequency_offset_key,emission_mask_key,latitude,longitude,dts_maximum_distance,height_amsl,actual_height_amsl,height_agl,overall_haat,peak_erp,contour_erp,antenna_id,has_horizontal_pattern,horizontal_pattern_name,horizontal_pattern_orientation,has_vertical_pattern,vertical_pattern_name,vertical_pattern_electrical_tilt,vertical_pattern_mechanical_tilt,vertical_pattern_mechanical_tilt_orientation,has_matrix_pattern,matrix_pattern_name,use_generic_vertical_pattern,locked,application_id,site_number,original_source_key,parent_source_key) SELECT source_key,needs_update,mod_count,facility_id,service_key,call_sign,channel,city,state,country_key,zone_key,status,file_number,frequency_offset_key,emission_mask_key,latitude,longitude,dts_maximum_distance,height_amsl,actual_height_amsl,height_agl,overall_haat,peak_erp,contour_erp,antenna_id,has_horizontal_pattern,horizontal_pattern_name,horizontal_pattern_orientation,has_vertical_pattern,vertical_pattern_name,vertical_pattern_electrical_tilt,vertical_pattern_mechanical_tilt,vertical_pattern_mechanical_tilt_orientation,has_matrix_pattern,matrix_pattern_name,use_generic_vertical_pattern,locked,application_id,site_number,original_source_key,parent_source_key FROM tvstudy_" + n + ".source");
        dbConnection.update("INSERT INTO source_horizontal_pattern (source_key,azimuth,relative_field) SELECT source_key,azimuth,relative_field FROM tvstudy_" + n + ".source_horizontal_pattern");
        dbConnection.update("INSERT INTO source_vertical_pattern (source_key,depression_angle,relative_field) SELECT source_key,depression_angle,relative_field FROM tvstudy_" + n + ".source_vertical_pattern");
        dbConnection.update("INSERT INTO source_matrix_pattern (source_key,azimuth,depression_angle,relative_field) SELECT source_key,azimuth,depression_angle,relative_field FROM tvstudy_" + n + ".source_matrix_pattern");
    }

    public static class PatternSlice {
        public double azimuth;
        public ArrayList<PatternPoint> pattern;

        public PatternSlice(double d, ArrayList<PatternPoint> arrayList) {
            this.azimuth = d;
            this.pattern = arrayList;
        }

        public PatternSlice copy() {
            ArrayList<PatternPoint> arrayList = new ArrayList<PatternPoint>();
            for (PatternPoint patternPoint : this.pattern) {
                arrayList.add(patternPoint.copy());
            }
            return new PatternSlice(this.azimuth, arrayList);
        }
    }

    public static class PatternPoint {
        public double azimuthOrDepression;
        public double relativeField;

        public PatternPoint(double d, double d2) {
            this.azimuthOrDepression = d;
            this.relativeField = d2;
        }

        public PatternPoint copy() {
            return new PatternPoint(this.azimuthOrDepression, this.relativeField);
        }
    }
}

