/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.util.DbConnection;
import java.sql.SQLException;
import java.util.ArrayList;

public class ServiceType
extends KeyedRecord {
    public final boolean digital;
    public final boolean needsEmissionMask;
    private static ServiceType invalidObject = null;
    private static ArrayList<ServiceType> recordCache = null;

    public ServiceType(int n, String string, boolean bl, boolean bl2) {
        super(n, string);
        this.digital = bl;
        this.needsEmissionMask = bl2;
    }

    public static ServiceType getServiceType(DbConnection dbConnection, int n) {
        if (ServiceType.fillCache(dbConnection)) {
            for (ServiceType serviceType : recordCache) {
                if (n != serviceType.key) continue;
                return serviceType;
            }
        }
        return null;
    }

    public static synchronized ServiceType getInvalidObject() {
        if (null == invalidObject) {
            invalidObject = new ServiceType(-1, "???", false, false);
        }
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getServiceTypes(DbConnection dbConnection) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        if (ServiceType.fillCache(dbConnection)) {
            for (ServiceType serviceType : recordCache) {
                arrayList.add(serviceType);
            }
        }
        return arrayList;
    }

    private static synchronized boolean fillCache(DbConnection dbConnection) {
        if (null != recordCache) {
            return true;
        }
        ArrayList<ServiceType> arrayList = new ArrayList<ServiceType>();
        boolean bl = false;
        if (dbConnection.connect()) {
            try {
                dbConnection.query("SELECT service_type_key, name, digital, needs_emission_mask FROM tvstudy.service_type ORDER BY 1");
                while (dbConnection.next()) {
                    arrayList.add(new ServiceType(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getBoolean(3), dbConnection.getBoolean(4)));
                }
                recordCache = arrayList;
                bl = true;
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close();
        }
        return bl;
    }
}

