/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.data.ServiceType;
import gov.fcc.tvstudy.util.DbConnection;
import java.sql.SQLException;
import java.util.ArrayList;

public class Service
extends KeyedRecord {
    public final String serviceCode;
    public final ServiceType serviceType;
    public final boolean isDTS;
    public final boolean isOperating;
    public final int preferenceRank;
    public final Service digitalService;
    private static Service invalidObject = null;
    private static ArrayList<Service> recordCache = null;

    public Service(int n, String string, String string2, ServiceType serviceType, boolean bl, boolean bl2, int n2, Service service) {
        super(n, string);
        this.serviceCode = string2;
        this.serviceType = serviceType;
        this.isDTS = bl;
        this.isOperating = bl2;
        this.preferenceRank = n2;
        this.digitalService = service;
    }

    public static Service getService(DbConnection dbConnection, int n) {
        if (Service.fillCache(dbConnection)) {
            for (Service service : recordCache) {
                if (n != service.key) continue;
                return service;
            }
        }
        return null;
    }

    public static Service getService(DbConnection dbConnection, String string) {
        if (Service.fillCache(dbConnection)) {
            for (Service service : recordCache) {
                if (!service.serviceCode.equalsIgnoreCase(string)) continue;
                return service;
            }
        }
        return null;
    }

    public static synchronized Service getInvalidObject() {
        if (null == invalidObject) {
            invalidObject = new Service(-1, "???", "??", ServiceType.getInvalidObject(), false, false, 0, null);
        }
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getServices(DbConnection dbConnection) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        if (Service.fillCache(dbConnection)) {
            for (Service service : recordCache) {
                arrayList.add(service);
            }
        }
        return arrayList;
    }

    public static ArrayList<Service> getAllServices(DbConnection dbConnection) {
        ArrayList<Service> arrayList = new ArrayList<Service>();
        if (Service.fillCache(dbConnection)) {
            arrayList.addAll(recordCache);
        }
        return arrayList;
    }

    private static synchronized boolean fillCache(DbConnection dbConnection) {
        if (null != recordCache) {
            return true;
        }
        DbConnection dbConnection2 = dbConnection.copy();
        ArrayList<Service> arrayList = new ArrayList<Service>();
        boolean bl = false;
        if (dbConnection.connect()) {
            try {
                dbConnection.query("SELECT service.service_key, service.name, service.service_code, service.service_type_key, service.is_dts, service.is_operating, service.preference_rank FROM tvstudy.service JOIN tvstudy.service_type USING (service_type_key) WHERE service_type.digital ORDER BY 1");
                while (dbConnection.next()) {
                    arrayList.add(new Service(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3), ServiceType.getServiceType(dbConnection2, dbConnection.getInt(4)), dbConnection.getBoolean(5), dbConnection.getBoolean(6), dbConnection.getInt(7), null));
                }
                dbConnection.query("SELECT service.service_key, service.name, service.service_code, service.service_type_key, service.is_dts, service.is_operating, service.preference_rank, service.digital_service_key FROM tvstudy.service JOIN tvstudy.service_type USING (service_type_key) WHERE NOT service_type.digital ORDER BY 1");
                int n = arrayList.size();
                Service service = null;
                while (dbConnection.next()) {
                    int n2 = dbConnection.getInt(8);
                    for (int i = 0; i < n; ++i) {
                        service = (Service)arrayList.get(i);
                        if (service.key == n2) break;
                        service = null;
                    }
                    arrayList.add(new Service(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3), ServiceType.getServiceType(dbConnection2, dbConnection.getInt(4)), dbConnection.getBoolean(5), dbConnection.getBoolean(6), dbConnection.getInt(7), service));
                }
                recordCache = arrayList;
                bl = true;
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close();
        }
        return bl;
    }
}

