/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.util.DbConnection;
import java.sql.SQLException;
import java.util.ArrayList;

public class Scenario
extends KeyedRecord {
    public final String description;
    public final ArrayList<SourceListItem> sourceList;

    public Scenario(int n, String string, String string2, ArrayList<SourceListItem> arrayList) {
        super(n, string);
        this.description = string2;
        this.sourceList = arrayList;
    }

    public static ArrayList<Scenario> getScenarios(DbConnection dbConnection, int n) throws SQLException {
        ArrayList<Scenario> arrayList = new ArrayList<Scenario>();
        String string = "tvstudy_" + n;
        dbConnection.query("SELECT scenario_key, name, description FROM " + string + ".scenario " + "ORDER BY 1");
        while (dbConnection.next()) {
            arrayList.add(new Scenario(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3), new ArrayList<SourceListItem>()));
        }
        for (Scenario scenario : arrayList) {
            dbConnection.query("SELECT source_key, is_desired, is_undesired FROM " + string + ".scenario_source " + "WHERE " + "scenario_key = " + scenario.key);
            while (dbConnection.next()) {
                scenario.sourceList.add(new SourceListItem(dbConnection.getInt(1), dbConnection.getBoolean(2), dbConnection.getBoolean(3)));
            }
        }
        return arrayList;
    }

    public static void createStudyTables(DbConnection dbConnection) throws SQLException {
        dbConnection.update("CREATE TABLE scenario (scenario_key INT NOT NULL PRIMARY KEY, name VARCHAR(255) NOT NULL, description TEXT NOT NULL)");
        dbConnection.update("CREATE TABLE scenario_source (scenario_key INT NOT NULL, source_key INT NOT NULL, is_desired BOOLEAN NOT NULL, is_undesired BOOLEAN NOT NULL, PRIMARY KEY (scenario_key, source_key))");
    }

    public static void copyStudyTables(DbConnection dbConnection, int n) throws SQLException {
        Scenario.createStudyTables(dbConnection);
        dbConnection.update("INSERT INTO scenario (scenario_key, name, description) SELECT scenario_key, name, description FROM tvstudy_" + n + ".scenario");
        dbConnection.update("INSERT INTO scenario_source (scenario_key, source_key, is_desired, is_undesired) SELECT scenario_key, source_key, is_desired, is_undesired FROM tvstudy_" + n + ".scenario_source");
    }

    public static class SourceListItem {
        public final int key;
        public final boolean isDesired;
        public final boolean isUndesired;

        public SourceListItem(int n, boolean bl, boolean bl2) {
            this.key = n;
            this.isDesired = bl;
            this.isUndesired = bl2;
        }
    }
}

