/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.util.DbConnection;
import java.sql.SQLException;
import java.util.ArrayList;

public class Parameter
extends KeyedRecord {
    public static final int PARAM_GRID_TYPE = 2;
    public static final int PARAM_CELL_SIZE = 4;
    public static final int PARAM_TRUST_DA_FLAG = 18;
    public static final int PARAM_EARTH_SPH_DIST = 200;
    public static final int PARAM_RULE_EXTRA_DIST = 210;
    public static final int PARAM_CO_CHAN_MX_DIST = 212;
    public static final int PARAM_CAN_GEN_VPAT = 219;
    public static final int PARAM_MEX_ERP_D_VLO = 220;
    public static final int PARAM_MEX_HAAT_D_VLO = 221;
    public static final int PARAM_MEX_ERP_D_VHI = 222;
    public static final int PARAM_MEX_HAAT_D_VHI = 223;
    public static final int PARAM_MEX_ERP_D_UHF = 224;
    public static final int PARAM_MEX_HAAT_D_UHF = 225;
    public static final int PARAM_MEX_ERP_N_VLO = 226;
    public static final int PARAM_MEX_HAAT_N_VLO = 227;
    public static final int PARAM_MEX_ERP_N_VHI = 228;
    public static final int PARAM_MEX_HAAT_N_VHI = 229;
    public static final int PARAM_MEX_ERP_N_UHF = 230;
    public static final int PARAM_MEX_HAAT_N_UHF = 231;
    public static final int PARAM_MIN_CHANNEL = 324;
    public static final int PARAM_MAX_CHANNEL = 325;
    public static final int PARAM_DTS_DIST_CHECK = 326;
    public static final int GRID_TYPE_LOCAL = 1;
    public static final int GRID_TYPE_GLOBAL = 2;
    public static final int SERV_DTV_FULL = 1;
    public static final int SERV_NTSC_FULL = 2;
    public final String value;
    public final String defaultValue;
    public final String description;
    public final boolean studyFixed;
    public final String groupName;
    public final boolean enablesGroup;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_DECIMAL = 3;
    public static final int TYPE_OPTION = 4;
    public static final int TYPE_PICKFROM = 5;
    public final int type;
    public final int integerValue;
    public final int minIntegerValue;
    public final int maxIntegerValue;
    public final double decimalValue;
    public final double minDecimalValue;
    public final double maxDecimalValue;
    public final boolean optionValue;
    public final int pickfromIndex;
    public final ArrayList<KeyedRecord> pickfromItems;

    public Parameter(int n, String string, String string2, String string3, String string4, boolean bl, String string5, boolean bl2, int n2, int n3, int n4, int n5, double d, double d2, double d3, boolean bl3, int n6, ArrayList<KeyedRecord> arrayList) {
        super(n, string);
        this.value = string2;
        this.defaultValue = string3;
        this.description = string4;
        this.studyFixed = bl;
        this.groupName = string5;
        this.enablesGroup = bl2;
        this.type = n2;
        this.integerValue = n3;
        this.minIntegerValue = n4;
        this.maxIntegerValue = n5;
        this.decimalValue = d;
        this.minDecimalValue = d2;
        this.maxDecimalValue = d3;
        this.optionValue = bl3;
        this.pickfromIndex = n6;
        this.pickfromItems = arrayList;
    }

    public Parameter(int n, String string, String string2, String string3, String string4, boolean bl, String string5, int n2, String string6) {
        super(n, string);
        this.value = string2;
        this.defaultValue = string3;
        this.description = string4;
        this.studyFixed = bl;
        this.groupName = string5;
        if (null == string2) {
            string2 = string3;
        }
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl2 = false;
        int n7 = 0;
        ArrayList<KeyedRecord> arrayList = null;
        String[] stringArray = string6.trim().split(":");
        int n8 = stringArray.length;
        String string7 = stringArray[0].trim().toLowerCase();
        if (string7.equals("integer")) {
            n3 = 2;
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n4 = 0;
            }
            if (n8 > 1 && stringArray[1].length() > 0) {
                try {
                    n5 = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    n5 = Integer.MIN_VALUE;
                }
            } else {
                n5 = Integer.MIN_VALUE;
            }
            if (n8 > 2 && stringArray[2].length() > 0) {
                try {
                    n6 = Integer.parseInt(stringArray[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    n6 = Integer.MAX_VALUE;
                }
            } else {
                n6 = Integer.MAX_VALUE;
            }
        }
        if (string7.equals("decimal")) {
            n3 = 3;
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
            }
            if (n8 > 1 && stringArray[1].length() > 0) {
                try {
                    d2 = Double.parseDouble(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    d2 = Double.MIN_VALUE;
                }
            } else {
                d2 = Double.MIN_VALUE;
            }
            if (n8 > 2 && stringArray[2].length() > 0) {
                try {
                    d3 = Double.parseDouble(stringArray[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    d3 = Double.MAX_VALUE;
                }
            } else {
                d3 = Double.MAX_VALUE;
            }
        }
        if (string7.equals("option")) {
            n3 = 4;
            bl2 = string2.equals("1");
        }
        if (string7.equals("pickfrom")) {
            n3 = 5;
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n4 = 0;
            }
            arrayList = new ArrayList<KeyedRecord>();
            n7 = -1;
            int n9 = 1;
            int n10 = 0;
            int n11 = 0;
            while (n9 + 1 < n8) {
                try {
                    n11 = Integer.parseInt(stringArray[n9]);
                }
                catch (NumberFormatException numberFormatException) {
                    n9 += 2;
                    continue;
                }
                arrayList.add(new KeyedRecord(n11, stringArray[n9 + 1]));
                if (n11 == n4) {
                    n7 = n10;
                }
                n9 += 2;
                ++n10;
            }
            if (n7 < 0) {
                arrayList.add(new KeyedRecord(n4, "(unknown)"));
                n7 = n10;
            }
        }
        this.enablesGroup = 4 == n3 && this.key == n2;
        this.type = n3;
        this.integerValue = n4;
        this.minIntegerValue = n5;
        this.maxIntegerValue = n6;
        this.decimalValue = d;
        this.minDecimalValue = d2;
        this.maxDecimalValue = d3;
        this.optionValue = bl2;
        this.pickfromIndex = n7;
        this.pickfromItems = arrayList;
    }

    public static ArrayList<Parameter> getParameters(DbConnection dbConnection, int n, int n2) throws SQLException {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        dbConnection.query("SELECT parameter.parameter_key, parameter.name, parameter_data.value, COALESCE((SELECT value FROM tvstudy.template_parameter_data AS template WHERE (template.parameter_key = parameter.parameter_key) AND (template.template_key = " + n2 + ")), " + "def_template.value) AS def_value, " + "parameter.description, " + "parameter.study_fixed, " + "parameter_group.name, " + "parameter_group.enabling_parameter_key, " + "parameter.type " + "FROM " + "tvstudy.parameter " + "JOIN tvstudy.parameter_group USING (group_key) " + "JOIN tvstudy.template_parameter_data AS def_template USING (parameter_key) " + "LEFT JOIN tvstudy_" + n + ".parameter_data USING (parameter_key) " + "WHERE " + "def_template.template_key = 1 " + "ORDER BY " + "parameter_group.list_order, " + "parameter.list_order");
        while (dbConnection.next()) {
            arrayList.add(new Parameter(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3), dbConnection.getString(4), dbConnection.getString(5), dbConnection.getBoolean(6), dbConnection.getString(7), dbConnection.getInt(8), dbConnection.getString(9)));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static String makeParameterSummary(ArrayList<Parameter> arrayList) {
        int n;
        int n2 = 0;
        for (Parameter object2 : arrayList) {
            n = object2.name.length();
            if (n <= n2) continue;
            n2 = n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        boolean bl = false;
        for (Parameter parameter : arrayList) {
            void var5_6;
            if (!parameter.groupName.equals(var5_6)) {
                stringBuilder.append('\n');
                stringBuilder.append(parameter.groupName);
                stringBuilder.append('\n');
                String string2 = parameter.groupName;
                bl = false;
            }
            if (bl) continue;
            for (int i = n = parameter.name.length(); i < n2; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(parameter.name);
            stringBuilder.append(" = ");
            switch (parameter.type) {
                default: {
                    stringBuilder.append(parameter.value);
                    break;
                }
                case 4: {
                    if (parameter.optionValue) {
                        stringBuilder.append("Yes");
                        break;
                    }
                    stringBuilder.append("No");
                    if (!parameter.enablesGroup) break;
                    bl = true;
                    break;
                }
                case 5: {
                    stringBuilder.append(parameter.pickfromItems.get((int)parameter.pickfromIndex).name);
                }
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static void createStudyTables(DbConnection dbConnection, int n) throws SQLException {
        dbConnection.update("CREATE TABLE parameter_data (parameter_key INT NOT NULL PRIMARY KEY, value VARCHAR(255) NOT NULL)");
        if (n > 0) {
            dbConnection.update("INSERT INTO parameter_data (parameter_key, value) SELECT parameter_key, value FROM tvstudy.template_parameter_data WHERE template_key = " + n);
        }
    }

    public static void copyStudyTables(DbConnection dbConnection, int n) throws SQLException {
        Parameter.createStudyTables(dbConnection, 0);
        dbConnection.update("INSERT INTO parameter_data (parameter_key, value) SELECT parameter_key, value FROM tvstudy_" + n + ".parameter_data");
    }
}

