/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.data.ChannelBand;
import gov.fcc.tvstudy.data.ChannelDelta;
import gov.fcc.tvstudy.data.Country;
import gov.fcc.tvstudy.data.EmissionMask;
import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.data.ServiceType;
import gov.fcc.tvstudy.util.DbConnection;
import java.sql.SQLException;
import java.util.ArrayList;

public class IxRule
extends KeyedRecord {
    public static final int FREQUENCY_OFFSET_WITHOUT = 1;
    public static final int FREQUENCY_OFFSET_WITH = 2;
    public static final double DISTANCE_MIN = 1.0;
    public static final double DU_MIN = -60.0;
    public static final double DU_MAX = 60.0;
    public static final int PERCENT_TIME_MIN = 1;
    public static final int PERCENT_TIME_MAX = 99;
    public final Country country;
    public final ServiceType serviceType;
    public final ServiceType undesiredServiceType;
    public final ChannelDelta channelDelta;
    public final ChannelBand channelBand;
    public final int frequencyOffset;
    public final EmissionMask emissionMask;
    public final double distance;
    public final double requiredDU;
    public final int undesiredTime;
    public final boolean isActive;

    public IxRule(int n, Country country, ServiceType serviceType, ServiceType serviceType2, ChannelDelta channelDelta, ChannelBand channelBand, int n2, EmissionMask emissionMask, double d, double d2, int n3, boolean bl) {
        super(n, country.name + " " + serviceType.name + " from " + serviceType2.name + " " + channelDelta.name);
        this.country = country;
        this.serviceType = serviceType;
        this.undesiredServiceType = serviceType2;
        this.channelDelta = channelDelta;
        this.channelBand = channelBand;
        this.frequencyOffset = n2;
        this.emissionMask = emissionMask;
        this.distance = d;
        this.requiredDU = d2;
        this.undesiredTime = n3;
        this.isActive = bl;
    }

    public static ArrayList<IxRule> getIxRules(DbConnection dbConnection, int n) throws SQLException {
        ArrayList<IxRule> arrayList = new ArrayList<IxRule>();
        dbConnection.query("SELECT ix_rule_key, country_key, service_type_key, undesired_service_type_key, channel_delta_key, channel_band_key, frequency_offset, emission_mask_key, distance, required_du, undesired_time, is_active FROM tvstudy_" + n + ".ix_rule " + "ORDER BY 2, 3, 4, 5, 10");
        DbConnection dbConnection2 = dbConnection.copy();
        while (dbConnection.next()) {
            ChannelDelta channelDelta;
            ServiceType serviceType;
            ServiceType serviceType2;
            Country country = Country.getCountry(dbConnection2, dbConnection.getInt(2));
            if (null == country || null == (serviceType2 = ServiceType.getServiceType(dbConnection2, dbConnection.getInt(3))) || null == (serviceType = ServiceType.getServiceType(dbConnection2, dbConnection.getInt(4))) || null == (channelDelta = ChannelDelta.getChannelDelta(dbConnection2, dbConnection.getInt(5)))) continue;
            arrayList.add(new IxRule(dbConnection.getInt(1), country, serviceType2, serviceType, channelDelta, ChannelBand.getChannelBand(dbConnection2, dbConnection.getInt(6)), dbConnection.getInt(7), EmissionMask.getEmissionMask(dbConnection2, dbConnection.getInt(8)), dbConnection.getDouble(9), dbConnection.getDouble(10), dbConnection.getInt(11), dbConnection.getBoolean(12)));
        }
        return arrayList;
    }

    public static void createStudyTables(DbConnection dbConnection, int n) throws SQLException {
        dbConnection.update("CREATE TABLE ix_rule (ix_rule_key INT NOT NULL PRIMARY KEY,country_key INT NOT NULL,service_type_key INT NOT NULL,undesired_service_type_key INT NOT NULL,channel_delta_key INT NOT NULL,channel_band_key INT NOT NULL,frequency_offset INT NOT NULL,emission_mask_key INT NOT NULL,distance FLOAT NOT NULL,required_du FLOAT NOT NULL,undesired_time INT NOT NULL,is_active BOOLEAN NOT NULL)");
        if (n > 0) {
            dbConnection.update("INSERT INTO ix_rule (ix_rule_key,country_key,service_type_key,undesired_service_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time,is_active) SELECT ix_rule_key,country_key,service_type_key,undesired_service_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time,true AS is_active FROM tvstudy.template_ix_rule WHERE template_key = " + n);
        }
    }

    public static void copyStudyTables(DbConnection dbConnection, int n) throws SQLException {
        IxRule.createStudyTables(dbConnection, 0);
        dbConnection.update("INSERT INTO ix_rule (ix_rule_key,country_key,service_type_key,undesired_service_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time,is_active) SELECT ix_rule_key,country_key,service_type_key,undesired_service_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time,is_active FROM tvstudy_" + n + ".ix_rule");
    }
}

