/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.util.DbConnection;
import java.sql.SQLException;
import java.util.ArrayList;

public class FrequencyOffset
extends KeyedRecord {
    public final String frequencyOffsetCode;
    private static FrequencyOffset nullObject = null;
    private static FrequencyOffset invalidObject = null;
    private static ArrayList<FrequencyOffset> recordCache = null;

    public FrequencyOffset(int n, String string, String string2) {
        super(n, string);
        this.frequencyOffsetCode = string2;
    }

    public static FrequencyOffset getFrequencyOffset(DbConnection dbConnection, int n) {
        if (0 == n) {
            return FrequencyOffset.getNullObject();
        }
        if (FrequencyOffset.fillCache(dbConnection)) {
            for (FrequencyOffset frequencyOffset : recordCache) {
                if (n != frequencyOffset.key) continue;
                return frequencyOffset;
            }
        }
        return FrequencyOffset.getNullObject();
    }

    public static FrequencyOffset getFrequencyOffset(DbConnection dbConnection, String string) {
        if (FrequencyOffset.fillCache(dbConnection)) {
            for (FrequencyOffset frequencyOffset : recordCache) {
                if (!frequencyOffset.frequencyOffsetCode.equalsIgnoreCase(string)) continue;
                return frequencyOffset;
            }
        }
        return FrequencyOffset.getNullObject();
    }

    public static synchronized FrequencyOffset getNullObject() {
        if (null == nullObject) {
            nullObject = new FrequencyOffset(0, "(none)", " ");
        }
        return nullObject;
    }

    public static synchronized FrequencyOffset getInvalidObject() {
        if (null == invalidObject) {
            invalidObject = new FrequencyOffset(-1, "???", "?");
        }
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getFrequencyOffsets(DbConnection dbConnection) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        if (FrequencyOffset.fillCache(dbConnection)) {
            for (FrequencyOffset frequencyOffset : recordCache) {
                arrayList.add(frequencyOffset);
            }
        }
        return arrayList;
    }

    public static ArrayList<KeyedRecord> getFrequencyOffsetsWithNull(DbConnection dbConnection) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        arrayList.add(FrequencyOffset.getNullObject());
        if (FrequencyOffset.fillCache(dbConnection)) {
            for (FrequencyOffset frequencyOffset : recordCache) {
                arrayList.add(frequencyOffset);
            }
        }
        return arrayList;
    }

    private static synchronized boolean fillCache(DbConnection dbConnection) {
        if (null != recordCache) {
            return true;
        }
        ArrayList<FrequencyOffset> arrayList = new ArrayList<FrequencyOffset>();
        boolean bl = false;
        if (dbConnection.connect()) {
            try {
                dbConnection.query("SELECT frequency_offset_key, name, offset_code FROM tvstudy.frequency_offset ORDER BY 1");
                while (dbConnection.next()) {
                    arrayList.add(new FrequencyOffset(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3)));
                }
                recordCache = arrayList;
                bl = true;
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close();
        }
        return bl;
    }
}

