/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.util.DbConnection;
import java.sql.SQLException;
import java.util.ArrayList;

public class EmissionMask
extends KeyedRecord {
    public final String emissionMaskCode;
    private static EmissionMask nullObject = null;
    private static EmissionMask invalidObject = null;
    private static EmissionMask defaultObject = null;
    private static ArrayList<EmissionMask> recordCache = null;

    public EmissionMask(int n, String string, String string2) {
        super(n, string);
        this.emissionMaskCode = string2;
    }

    public static EmissionMask getEmissionMask(DbConnection dbConnection, int n) {
        if (0 == n) {
            return EmissionMask.getNullObject();
        }
        if (EmissionMask.fillCache(dbConnection)) {
            for (EmissionMask emissionMask : recordCache) {
                if (n != emissionMask.key) continue;
                return emissionMask;
            }
        }
        return EmissionMask.getNullObject();
    }

    public static EmissionMask getEmissionMask(DbConnection dbConnection, String string) {
        if (EmissionMask.fillCache(dbConnection)) {
            for (EmissionMask emissionMask : recordCache) {
                if (!emissionMask.emissionMaskCode.equalsIgnoreCase(string)) continue;
                return emissionMask;
            }
        }
        return EmissionMask.getNullObject();
    }

    public static synchronized EmissionMask getNullObject() {
        if (null == nullObject) {
            nullObject = new EmissionMask(0, "(n/a)", " ");
        }
        return nullObject;
    }

    public static synchronized EmissionMask getInvalidObject() {
        if (null == invalidObject) {
            invalidObject = new EmissionMask(-1, "???", "?");
        }
        return invalidObject;
    }

    public static synchronized EmissionMask getDefaultObject(DbConnection dbConnection) {
        EmissionMask.fillCache(dbConnection);
        if (null == defaultObject) {
            defaultObject = EmissionMask.getNullObject();
        }
        return defaultObject;
    }

    public static ArrayList<KeyedRecord> getEmissionMasks(DbConnection dbConnection) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        if (EmissionMask.fillCache(dbConnection)) {
            for (EmissionMask emissionMask : recordCache) {
                arrayList.add(emissionMask);
            }
        }
        return arrayList;
    }

    public static ArrayList<KeyedRecord> getEmissionMasksWithNull(DbConnection dbConnection) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        arrayList.add(EmissionMask.getNullObject());
        if (EmissionMask.fillCache(dbConnection)) {
            for (EmissionMask emissionMask : recordCache) {
                arrayList.add(emissionMask);
            }
        }
        return arrayList;
    }

    private static synchronized boolean fillCache(DbConnection dbConnection) {
        if (null != recordCache) {
            return true;
        }
        ArrayList<EmissionMask> arrayList = new ArrayList<EmissionMask>();
        boolean bl = false;
        if (dbConnection.connect()) {
            try {
                dbConnection.query("SELECT emission_mask_key, name, emission_mask_code, is_default FROM tvstudy.emission_mask ORDER BY 1");
                while (dbConnection.next()) {
                    EmissionMask emissionMask = new EmissionMask(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3));
                    if (dbConnection.getBoolean(4)) {
                        defaultObject = emissionMask;
                    }
                    arrayList.add(emissionMask);
                }
                recordCache = arrayList;
                bl = true;
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close();
        }
        return bl;
    }
}

