/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.util.DbConnection;
import java.sql.SQLException;
import java.util.ArrayList;

public class Country
extends KeyedRecord {
    public static final int US = 1;
    public static final int CA = 2;
    public static final int MX = 3;
    public final String countryCode;
    private static Country invalidObject = null;
    private static ArrayList<Country> recordCache = null;

    public Country(int n, String string, String string2) {
        super(n, string);
        this.countryCode = string2;
    }

    public static Country getCountry(DbConnection dbConnection, int n) {
        if (Country.fillCache(dbConnection)) {
            for (Country country : recordCache) {
                if (n != country.key) continue;
                return country;
            }
        }
        return null;
    }

    public static Country getCountry(DbConnection dbConnection, String string) {
        if (Country.fillCache(dbConnection)) {
            for (Country country : recordCache) {
                if (!country.countryCode.equalsIgnoreCase(string)) continue;
                return country;
            }
        }
        return null;
    }

    public static synchronized Country getInvalidObject() {
        if (null == invalidObject) {
            invalidObject = new Country(-1, "???", "??");
        }
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getCountries(DbConnection dbConnection) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        if (Country.fillCache(dbConnection)) {
            for (Country country : recordCache) {
                arrayList.add(country);
            }
        }
        return arrayList;
    }

    public static ArrayList<Country> getAllCountries(DbConnection dbConnection) {
        ArrayList<Country> arrayList = new ArrayList<Country>();
        if (Country.fillCache(dbConnection)) {
            arrayList.addAll(recordCache);
        }
        return arrayList;
    }

    private static synchronized boolean fillCache(DbConnection dbConnection) {
        if (null != recordCache) {
            return true;
        }
        ArrayList<Country> arrayList = new ArrayList<Country>();
        boolean bl = false;
        if (dbConnection.connect()) {
            try {
                dbConnection.query("SELECT country_key, name, country_code FROM tvstudy.country ORDER BY 1");
                while (dbConnection.next()) {
                    arrayList.add(new Country(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3)));
                }
                recordCache = arrayList;
                bl = true;
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close();
        }
        return bl;
    }
}

