/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.util.DbConnection;
import java.sql.SQLException;
import java.util.ArrayList;

public class ChannelDelta
extends KeyedRecord {
    public final int delta;
    public final boolean analogOnly;
    public final double maximumDistance;
    private static ChannelDelta invalidObject = null;
    private static ArrayList<ChannelDelta> recordCache = null;

    public ChannelDelta(int n, String string, int n2, boolean bl, double d) {
        super(n, string);
        this.delta = n2;
        this.analogOnly = bl;
        this.maximumDistance = d;
    }

    public static ChannelDelta getChannelDelta(DbConnection dbConnection, int n) {
        if (ChannelDelta.fillCache(dbConnection)) {
            for (ChannelDelta channelDelta : recordCache) {
                if (n != channelDelta.key) continue;
                return channelDelta;
            }
        }
        return null;
    }

    public static ChannelDelta getChannelDeltaByDelta(DbConnection dbConnection, int n) {
        if (ChannelDelta.fillCache(dbConnection)) {
            for (ChannelDelta channelDelta : recordCache) {
                if (n != channelDelta.delta) continue;
                return channelDelta;
            }
        }
        return null;
    }

    public static synchronized ChannelDelta getInvalidObject() {
        if (null == invalidObject) {
            invalidObject = new ChannelDelta(-1, "???", 0, false, 0.0);
        }
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getChannelDeltas(DbConnection dbConnection) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        if (ChannelDelta.fillCache(dbConnection)) {
            for (ChannelDelta channelDelta : recordCache) {
                arrayList.add(channelDelta);
            }
        }
        return arrayList;
    }

    public static ArrayList<ChannelDelta> getAllChannelDeltas(DbConnection dbConnection) {
        ArrayList<ChannelDelta> arrayList = new ArrayList<ChannelDelta>();
        if (ChannelDelta.fillCache(dbConnection)) {
            arrayList.addAll(recordCache);
        }
        return arrayList;
    }

    private static synchronized boolean fillCache(DbConnection dbConnection) {
        if (null != recordCache) {
            return true;
        }
        ArrayList<ChannelDelta> arrayList = new ArrayList<ChannelDelta>();
        boolean bl = false;
        if (dbConnection.connect()) {
            try {
                dbConnection.query("SELECT channel_delta_key, name, delta, analog_only, maximum_distance FROM tvstudy.channel_delta ORDER BY 1");
                while (dbConnection.next()) {
                    arrayList.add(new ChannelDelta(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getInt(3), dbConnection.getBoolean(4), dbConnection.getDouble(5)));
                }
                recordCache = arrayList;
                bl = true;
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close();
        }
        return bl;
    }
}

