/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.data;

import gov.fcc.tvstudy.data.KeyedRecord;
import gov.fcc.tvstudy.util.DbConnection;
import java.sql.SQLException;
import java.util.ArrayList;

public class ChannelBand
extends KeyedRecord {
    public final int firstChannel;
    public final int lastChannel;
    private static ChannelBand nullObject = null;
    private static ChannelBand invalidObject = null;
    private static ArrayList<ChannelBand> recordCache = null;

    public ChannelBand(int n, String string, int n2, int n3) {
        super(n, string);
        this.firstChannel = n2;
        this.lastChannel = n3;
    }

    public static ChannelBand getChannelBand(DbConnection dbConnection, int n) {
        if (0 == n) {
            return ChannelBand.getNullObject();
        }
        if (ChannelBand.fillCache(dbConnection)) {
            for (ChannelBand channelBand : recordCache) {
                if (n != channelBand.key) continue;
                return channelBand;
            }
        }
        return ChannelBand.getNullObject();
    }

    public static synchronized ChannelBand getNullObject() {
        if (null == nullObject) {
            nullObject = new ChannelBand(0, "(any)", 0, 9999);
        }
        return nullObject;
    }

    public static synchronized ChannelBand getInvalidObject() {
        if (null == invalidObject) {
            invalidObject = new ChannelBand(-1, "???", 0, 0);
        }
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getChannelBands(DbConnection dbConnection) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        if (ChannelBand.fillCache(dbConnection)) {
            for (ChannelBand channelBand : recordCache) {
                arrayList.add(channelBand);
            }
        }
        return arrayList;
    }

    public static ArrayList<KeyedRecord> getChannelBandsWithNull(DbConnection dbConnection) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        arrayList.add(ChannelBand.getNullObject());
        if (ChannelBand.fillCache(dbConnection)) {
            for (ChannelBand channelBand : recordCache) {
                arrayList.add(channelBand);
            }
        }
        return arrayList;
    }

    private static synchronized boolean fillCache(DbConnection dbConnection) {
        if (null != recordCache) {
            return true;
        }
        ArrayList<ChannelBand> arrayList = new ArrayList<ChannelBand>();
        boolean bl = false;
        if (dbConnection.connect()) {
            try {
                dbConnection.query("SELECT channel_band_key, name, first_channel, last_channel FROM tvstudy.channel_band ORDER BY 1");
                while (dbConnection.next()) {
                    arrayList.add(new ChannelBand(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getInt(3), dbConnection.getInt(4)));
                }
                recordCache = arrayList;
                bl = true;
            }
            catch (SQLException sQLException) {
                dbConnection.reportError(sQLException);
            }
            dbConnection.close();
        }
        return bl;
    }
}

